# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'CertificatesResult',
    'AwaitableCertificatesResult',
    'certificates',
    'certificates_output',
]

@pulumi.output_type
class CertificatesResult:
    """
    A collection of values returned by Certificates.
    """
    def __init__(__self__, certificate_name=None, certificates=None, id=None, ids=None, output_file=None, total_count=None):
        if certificate_name and not isinstance(certificate_name, str):
            raise TypeError("Expected argument 'certificate_name' to be a str")
        pulumi.set(__self__, "certificate_name", certificate_name)
        if certificates and not isinstance(certificates, list):
            raise TypeError("Expected argument 'certificates' to be a list")
        pulumi.set(__self__, "certificates", certificates)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if total_count and not isinstance(total_count, int):
            raise TypeError("Expected argument 'total_count' to be a int")
        pulumi.set(__self__, "total_count", total_count)

    @property
    @pulumi.getter(name="certificateName")
    def certificate_name(self) -> Optional[str]:
        """
        The name of the Certificate.
        """
        return pulumi.get(self, "certificate_name")

    @property
    @pulumi.getter
    def certificates(self) -> Sequence['outputs.CertificatesCertificateResult']:
        """
        The collection of Certificate query.
        """
        return pulumi.get(self, "certificates")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def ids(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "ids")

    @property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[str]:
        return pulumi.get(self, "output_file")

    @property
    @pulumi.getter(name="totalCount")
    def total_count(self) -> int:
        """
        The total count of Certificate query.
        """
        return pulumi.get(self, "total_count")


class AwaitableCertificatesResult(CertificatesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return CertificatesResult(
            certificate_name=self.certificate_name,
            certificates=self.certificates,
            id=self.id,
            ids=self.ids,
            output_file=self.output_file,
            total_count=self.total_count)


def certificates(certificate_name: Optional[str] = None,
                 ids: Optional[Sequence[str]] = None,
                 output_file: Optional[str] = None,
                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableCertificatesResult:
    """
    Use this data source to query detailed information of alb certificates
    ## Example Usage

    ```python
    import pulumi
    import pulumi_volcengine as volcengine

    default = volcengine.alb.certificates(certificate_name="tf-test")
    ```


    :param str certificate_name: The Name of Certificate.
    :param Sequence[str] ids: The list of Certificate IDs.
    :param str output_file: File name where to save data source results.
    """
    __args__ = dict()
    __args__['certificateName'] = certificate_name
    __args__['ids'] = ids
    __args__['outputFile'] = output_file
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('volcengine:alb/certificates:Certificates', __args__, opts=opts, typ=CertificatesResult).value

    return AwaitableCertificatesResult(
        certificate_name=pulumi.get(__ret__, 'certificate_name'),
        certificates=pulumi.get(__ret__, 'certificates'),
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        output_file=pulumi.get(__ret__, 'output_file'),
        total_count=pulumi.get(__ret__, 'total_count'))


@_utilities.lift_output_func(certificates)
def certificates_output(certificate_name: Optional[pulumi.Input[Optional[str]]] = None,
                        ids: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                        output_file: Optional[pulumi.Input[Optional[str]]] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[CertificatesResult]:
    """
    Use this data source to query detailed information of alb certificates
    ## Example Usage

    ```python
    import pulumi
    import pulumi_volcengine as volcengine

    default = volcengine.alb.certificates(certificate_name="tf-test")
    ```


    :param str certificate_name: The Name of Certificate.
    :param Sequence[str] ids: The list of Certificate IDs.
    :param str output_file: File name where to save data source results.
    """
    ...
