# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['CustomizedCfgArgs', 'CustomizedCfg']

@pulumi.input_type
class CustomizedCfgArgs:
    def __init__(__self__, *,
                 customized_cfg_content: pulumi.Input[str],
                 customized_cfg_name: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None,
                 project_name: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a CustomizedCfg resource.
        :param pulumi.Input[str] customized_cfg_content: The content of CustomizedCfg. The length cannot exceed 4096 characters. Spaces and semicolons need to be escaped. Currently supported configuration items are `ssl_protocols`, `ssl_ciphers`, `client_max_body_size`, `keepalive_timeout`, `proxy_request_buffering` and `proxy_connect_timeout`.
        :param pulumi.Input[str] customized_cfg_name: The name of CustomizedCfg.
        :param pulumi.Input[str] description: The description of CustomizedCfg.
        :param pulumi.Input[str] project_name: The project name of the CustomizedCfg.
        """
        pulumi.set(__self__, "customized_cfg_content", customized_cfg_content)
        pulumi.set(__self__, "customized_cfg_name", customized_cfg_name)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if project_name is not None:
            pulumi.set(__self__, "project_name", project_name)

    @property
    @pulumi.getter(name="customizedCfgContent")
    def customized_cfg_content(self) -> pulumi.Input[str]:
        """
        The content of CustomizedCfg. The length cannot exceed 4096 characters. Spaces and semicolons need to be escaped. Currently supported configuration items are `ssl_protocols`, `ssl_ciphers`, `client_max_body_size`, `keepalive_timeout`, `proxy_request_buffering` and `proxy_connect_timeout`.
        """
        return pulumi.get(self, "customized_cfg_content")

    @customized_cfg_content.setter
    def customized_cfg_content(self, value: pulumi.Input[str]):
        pulumi.set(self, "customized_cfg_content", value)

    @property
    @pulumi.getter(name="customizedCfgName")
    def customized_cfg_name(self) -> pulumi.Input[str]:
        """
        The name of CustomizedCfg.
        """
        return pulumi.get(self, "customized_cfg_name")

    @customized_cfg_name.setter
    def customized_cfg_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "customized_cfg_name", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of CustomizedCfg.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="projectName")
    def project_name(self) -> Optional[pulumi.Input[str]]:
        """
        The project name of the CustomizedCfg.
        """
        return pulumi.get(self, "project_name")

    @project_name.setter
    def project_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_name", value)


@pulumi.input_type
class _CustomizedCfgState:
    def __init__(__self__, *,
                 customized_cfg_content: Optional[pulumi.Input[str]] = None,
                 customized_cfg_name: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 project_name: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering CustomizedCfg resources.
        :param pulumi.Input[str] customized_cfg_content: The content of CustomizedCfg. The length cannot exceed 4096 characters. Spaces and semicolons need to be escaped. Currently supported configuration items are `ssl_protocols`, `ssl_ciphers`, `client_max_body_size`, `keepalive_timeout`, `proxy_request_buffering` and `proxy_connect_timeout`.
        :param pulumi.Input[str] customized_cfg_name: The name of CustomizedCfg.
        :param pulumi.Input[str] description: The description of CustomizedCfg.
        :param pulumi.Input[str] project_name: The project name of the CustomizedCfg.
        """
        if customized_cfg_content is not None:
            pulumi.set(__self__, "customized_cfg_content", customized_cfg_content)
        if customized_cfg_name is not None:
            pulumi.set(__self__, "customized_cfg_name", customized_cfg_name)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if project_name is not None:
            pulumi.set(__self__, "project_name", project_name)

    @property
    @pulumi.getter(name="customizedCfgContent")
    def customized_cfg_content(self) -> Optional[pulumi.Input[str]]:
        """
        The content of CustomizedCfg. The length cannot exceed 4096 characters. Spaces and semicolons need to be escaped. Currently supported configuration items are `ssl_protocols`, `ssl_ciphers`, `client_max_body_size`, `keepalive_timeout`, `proxy_request_buffering` and `proxy_connect_timeout`.
        """
        return pulumi.get(self, "customized_cfg_content")

    @customized_cfg_content.setter
    def customized_cfg_content(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "customized_cfg_content", value)

    @property
    @pulumi.getter(name="customizedCfgName")
    def customized_cfg_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of CustomizedCfg.
        """
        return pulumi.get(self, "customized_cfg_name")

    @customized_cfg_name.setter
    def customized_cfg_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "customized_cfg_name", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of CustomizedCfg.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="projectName")
    def project_name(self) -> Optional[pulumi.Input[str]]:
        """
        The project name of the CustomizedCfg.
        """
        return pulumi.get(self, "project_name")

    @project_name.setter
    def project_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_name", value)


class CustomizedCfg(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 customized_cfg_content: Optional[pulumi.Input[str]] = None,
                 customized_cfg_name: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 project_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a resource to manage alb customized cfg
        ## Example Usage

        ```python
        import pulumi
        import pulumi_volcengine as volcengine

        foo = volcengine.alb.CustomizedCfg("foo",
            customized_cfg_content="proxy_connect_timeout 4s;proxy_request_buffering on;",
            customized_cfg_name="acc-test-cfg1",
            description="This is a test modify",
            project_name="default")
        ```

        ## Import

        AlbCustomizedCfg can be imported using the id, e.g.

        ```sh
         $ pulumi import volcengine:alb/customizedCfg:CustomizedCfg default ccfg-3cj44nv0jhhxc6c6rrtet****
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] customized_cfg_content: The content of CustomizedCfg. The length cannot exceed 4096 characters. Spaces and semicolons need to be escaped. Currently supported configuration items are `ssl_protocols`, `ssl_ciphers`, `client_max_body_size`, `keepalive_timeout`, `proxy_request_buffering` and `proxy_connect_timeout`.
        :param pulumi.Input[str] customized_cfg_name: The name of CustomizedCfg.
        :param pulumi.Input[str] description: The description of CustomizedCfg.
        :param pulumi.Input[str] project_name: The project name of the CustomizedCfg.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CustomizedCfgArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a resource to manage alb customized cfg
        ## Example Usage

        ```python
        import pulumi
        import pulumi_volcengine as volcengine

        foo = volcengine.alb.CustomizedCfg("foo",
            customized_cfg_content="proxy_connect_timeout 4s;proxy_request_buffering on;",
            customized_cfg_name="acc-test-cfg1",
            description="This is a test modify",
            project_name="default")
        ```

        ## Import

        AlbCustomizedCfg can be imported using the id, e.g.

        ```sh
         $ pulumi import volcengine:alb/customizedCfg:CustomizedCfg default ccfg-3cj44nv0jhhxc6c6rrtet****
        ```

        :param str resource_name: The name of the resource.
        :param CustomizedCfgArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CustomizedCfgArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 customized_cfg_content: Optional[pulumi.Input[str]] = None,
                 customized_cfg_name: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 project_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CustomizedCfgArgs.__new__(CustomizedCfgArgs)

            if customized_cfg_content is None and not opts.urn:
                raise TypeError("Missing required property 'customized_cfg_content'")
            __props__.__dict__["customized_cfg_content"] = customized_cfg_content
            if customized_cfg_name is None and not opts.urn:
                raise TypeError("Missing required property 'customized_cfg_name'")
            __props__.__dict__["customized_cfg_name"] = customized_cfg_name
            __props__.__dict__["description"] = description
            __props__.__dict__["project_name"] = project_name
        super(CustomizedCfg, __self__).__init__(
            'volcengine:alb/customizedCfg:CustomizedCfg',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            customized_cfg_content: Optional[pulumi.Input[str]] = None,
            customized_cfg_name: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            project_name: Optional[pulumi.Input[str]] = None) -> 'CustomizedCfg':
        """
        Get an existing CustomizedCfg resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] customized_cfg_content: The content of CustomizedCfg. The length cannot exceed 4096 characters. Spaces and semicolons need to be escaped. Currently supported configuration items are `ssl_protocols`, `ssl_ciphers`, `client_max_body_size`, `keepalive_timeout`, `proxy_request_buffering` and `proxy_connect_timeout`.
        :param pulumi.Input[str] customized_cfg_name: The name of CustomizedCfg.
        :param pulumi.Input[str] description: The description of CustomizedCfg.
        :param pulumi.Input[str] project_name: The project name of the CustomizedCfg.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CustomizedCfgState.__new__(_CustomizedCfgState)

        __props__.__dict__["customized_cfg_content"] = customized_cfg_content
        __props__.__dict__["customized_cfg_name"] = customized_cfg_name
        __props__.__dict__["description"] = description
        __props__.__dict__["project_name"] = project_name
        return CustomizedCfg(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="customizedCfgContent")
    def customized_cfg_content(self) -> pulumi.Output[str]:
        """
        The content of CustomizedCfg. The length cannot exceed 4096 characters. Spaces and semicolons need to be escaped. Currently supported configuration items are `ssl_protocols`, `ssl_ciphers`, `client_max_body_size`, `keepalive_timeout`, `proxy_request_buffering` and `proxy_connect_timeout`.
        """
        return pulumi.get(self, "customized_cfg_content")

    @property
    @pulumi.getter(name="customizedCfgName")
    def customized_cfg_name(self) -> pulumi.Output[str]:
        """
        The name of CustomizedCfg.
        """
        return pulumi.get(self, "customized_cfg_name")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        The description of CustomizedCfg.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="projectName")
    def project_name(self) -> pulumi.Output[str]:
        """
        The project name of the CustomizedCfg.
        """
        return pulumi.get(self, "project_name")

