# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'CustomizedCfgsResult',
    'AwaitableCustomizedCfgsResult',
    'customized_cfgs',
    'customized_cfgs_output',
]

@pulumi.output_type
class CustomizedCfgsResult:
    """
    A collection of values returned by CustomizedCfgs.
    """
    def __init__(__self__, cfgs=None, customized_cfg_name=None, id=None, ids=None, listener_id=None, name_regex=None, output_file=None, project_name=None, total_count=None):
        if cfgs and not isinstance(cfgs, list):
            raise TypeError("Expected argument 'cfgs' to be a list")
        pulumi.set(__self__, "cfgs", cfgs)
        if customized_cfg_name and not isinstance(customized_cfg_name, str):
            raise TypeError("Expected argument 'customized_cfg_name' to be a str")
        pulumi.set(__self__, "customized_cfg_name", customized_cfg_name)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if listener_id and not isinstance(listener_id, str):
            raise TypeError("Expected argument 'listener_id' to be a str")
        pulumi.set(__self__, "listener_id", listener_id)
        if name_regex and not isinstance(name_regex, str):
            raise TypeError("Expected argument 'name_regex' to be a str")
        pulumi.set(__self__, "name_regex", name_regex)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if project_name and not isinstance(project_name, str):
            raise TypeError("Expected argument 'project_name' to be a str")
        pulumi.set(__self__, "project_name", project_name)
        if total_count and not isinstance(total_count, int):
            raise TypeError("Expected argument 'total_count' to be a int")
        pulumi.set(__self__, "total_count", total_count)

    @property
    @pulumi.getter
    def cfgs(self) -> Sequence['outputs.CustomizedCfgsCfgResult']:
        """
        The collection of CustomizedCfg query.
        """
        return pulumi.get(self, "cfgs")

    @property
    @pulumi.getter(name="customizedCfgName")
    def customized_cfg_name(self) -> Optional[str]:
        """
        The name of CustomizedCfg.
        """
        return pulumi.get(self, "customized_cfg_name")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def ids(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "ids")

    @property
    @pulumi.getter(name="listenerId")
    def listener_id(self) -> Optional[str]:
        """
        The ID of Listener.
        """
        return pulumi.get(self, "listener_id")

    @property
    @pulumi.getter(name="nameRegex")
    def name_regex(self) -> Optional[str]:
        return pulumi.get(self, "name_regex")

    @property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[str]:
        return pulumi.get(self, "output_file")

    @property
    @pulumi.getter(name="projectName")
    def project_name(self) -> Optional[str]:
        """
        The project name of CustomizedCfg.
        """
        return pulumi.get(self, "project_name")

    @property
    @pulumi.getter(name="totalCount")
    def total_count(self) -> int:
        """
        The total count of CustomizedCfg query.
        """
        return pulumi.get(self, "total_count")


class AwaitableCustomizedCfgsResult(CustomizedCfgsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return CustomizedCfgsResult(
            cfgs=self.cfgs,
            customized_cfg_name=self.customized_cfg_name,
            id=self.id,
            ids=self.ids,
            listener_id=self.listener_id,
            name_regex=self.name_regex,
            output_file=self.output_file,
            project_name=self.project_name,
            total_count=self.total_count)


def customized_cfgs(customized_cfg_name: Optional[str] = None,
                    ids: Optional[Sequence[str]] = None,
                    listener_id: Optional[str] = None,
                    name_regex: Optional[str] = None,
                    output_file: Optional[str] = None,
                    project_name: Optional[str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableCustomizedCfgsResult:
    """
    Use this data source to query detailed information of alb customized cfgs
    ## Example Usage

    ```python
    import pulumi
    import pulumi_volcengine as volcengine

    foo = volcengine.alb.customized_cfgs()
    ```


    :param str customized_cfg_name: The name of the CustomizedCfg.
    :param Sequence[str] ids: A list of CustomizedCfg IDs.
    :param str listener_id: The id of the listener.
    :param str name_regex: A Name Regex of CustomizedCfg.
    :param str output_file: File name where to save data source results.
    :param str project_name: The project name of the CustomizedCfg.
    """
    __args__ = dict()
    __args__['customizedCfgName'] = customized_cfg_name
    __args__['ids'] = ids
    __args__['listenerId'] = listener_id
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    __args__['projectName'] = project_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('volcengine:alb/customizedCfgs:CustomizedCfgs', __args__, opts=opts, typ=CustomizedCfgsResult).value

    return AwaitableCustomizedCfgsResult(
        cfgs=pulumi.get(__ret__, 'cfgs'),
        customized_cfg_name=pulumi.get(__ret__, 'customized_cfg_name'),
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        listener_id=pulumi.get(__ret__, 'listener_id'),
        name_regex=pulumi.get(__ret__, 'name_regex'),
        output_file=pulumi.get(__ret__, 'output_file'),
        project_name=pulumi.get(__ret__, 'project_name'),
        total_count=pulumi.get(__ret__, 'total_count'))


@_utilities.lift_output_func(customized_cfgs)
def customized_cfgs_output(customized_cfg_name: Optional[pulumi.Input[Optional[str]]] = None,
                           ids: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                           listener_id: Optional[pulumi.Input[Optional[str]]] = None,
                           name_regex: Optional[pulumi.Input[Optional[str]]] = None,
                           output_file: Optional[pulumi.Input[Optional[str]]] = None,
                           project_name: Optional[pulumi.Input[Optional[str]]] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[CustomizedCfgsResult]:
    """
    Use this data source to query detailed information of alb customized cfgs
    ## Example Usage

    ```python
    import pulumi
    import pulumi_volcengine as volcengine

    foo = volcengine.alb.customized_cfgs()
    ```


    :param str customized_cfg_name: The name of the CustomizedCfg.
    :param Sequence[str] ids: A list of CustomizedCfg IDs.
    :param str listener_id: The id of the listener.
    :param str name_regex: A Name Regex of CustomizedCfg.
    :param str output_file: File name where to save data source results.
    :param str project_name: The project name of the CustomizedCfg.
    """
    ...
