# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['HealthCheckTemplateArgs', 'HealthCheckTemplate']

@pulumi.input_type
class HealthCheckTemplateArgs:
    def __init__(__self__, *,
                 health_check_template_name: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None,
                 health_check_domain: Optional[pulumi.Input[str]] = None,
                 health_check_http_code: Optional[pulumi.Input[str]] = None,
                 health_check_http_version: Optional[pulumi.Input[str]] = None,
                 health_check_interval: Optional[pulumi.Input[int]] = None,
                 health_check_method: Optional[pulumi.Input[str]] = None,
                 health_check_protocol: Optional[pulumi.Input[str]] = None,
                 health_check_timeout: Optional[pulumi.Input[int]] = None,
                 health_check_uri: Optional[pulumi.Input[str]] = None,
                 healthy_threshold: Optional[pulumi.Input[int]] = None,
                 unhealthy_threshold: Optional[pulumi.Input[int]] = None):
        """
        The set of arguments for constructing a HealthCheckTemplate resource.
        :param pulumi.Input[str] health_check_template_name: The health check template name.
        :param pulumi.Input[str] description: The description of health check template.
        :param pulumi.Input[str] health_check_domain: The domain name to health check.
        :param pulumi.Input[str] health_check_http_code: The normal HTTP status code for health check, the default is http_2xx, http_3xx, separated by commas.
        :param pulumi.Input[str] health_check_http_version: The HTTP version of health check.
        :param pulumi.Input[int] health_check_interval: The interval for performing health checks, the default value is 2, and the value is 1-300.
        :param pulumi.Input[str] health_check_method: The health check method,default is `GET`, support `GET` and `HEAD`.
        :param pulumi.Input[str] health_check_protocol: THe protocol of health check,only support HTTP.
        :param pulumi.Input[int] health_check_timeout: The timeout of health check response,the default value is 2, and the value is 1-60.
        :param pulumi.Input[str] health_check_uri: The uri to health check,default is `/`.
        :param pulumi.Input[int] healthy_threshold: The healthy threshold of the health check, the default is 3, the value is 2-10.
        :param pulumi.Input[int] unhealthy_threshold: The unhealthy threshold of the health check, the default is 3, the value is 2-10.
        """
        pulumi.set(__self__, "health_check_template_name", health_check_template_name)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if health_check_domain is not None:
            pulumi.set(__self__, "health_check_domain", health_check_domain)
        if health_check_http_code is not None:
            pulumi.set(__self__, "health_check_http_code", health_check_http_code)
        if health_check_http_version is not None:
            pulumi.set(__self__, "health_check_http_version", health_check_http_version)
        if health_check_interval is not None:
            pulumi.set(__self__, "health_check_interval", health_check_interval)
        if health_check_method is not None:
            pulumi.set(__self__, "health_check_method", health_check_method)
        if health_check_protocol is not None:
            pulumi.set(__self__, "health_check_protocol", health_check_protocol)
        if health_check_timeout is not None:
            pulumi.set(__self__, "health_check_timeout", health_check_timeout)
        if health_check_uri is not None:
            pulumi.set(__self__, "health_check_uri", health_check_uri)
        if healthy_threshold is not None:
            pulumi.set(__self__, "healthy_threshold", healthy_threshold)
        if unhealthy_threshold is not None:
            pulumi.set(__self__, "unhealthy_threshold", unhealthy_threshold)

    @property
    @pulumi.getter(name="healthCheckTemplateName")
    def health_check_template_name(self) -> pulumi.Input[str]:
        """
        The health check template name.
        """
        return pulumi.get(self, "health_check_template_name")

    @health_check_template_name.setter
    def health_check_template_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "health_check_template_name", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of health check template.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="healthCheckDomain")
    def health_check_domain(self) -> Optional[pulumi.Input[str]]:
        """
        The domain name to health check.
        """
        return pulumi.get(self, "health_check_domain")

    @health_check_domain.setter
    def health_check_domain(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "health_check_domain", value)

    @property
    @pulumi.getter(name="healthCheckHttpCode")
    def health_check_http_code(self) -> Optional[pulumi.Input[str]]:
        """
        The normal HTTP status code for health check, the default is http_2xx, http_3xx, separated by commas.
        """
        return pulumi.get(self, "health_check_http_code")

    @health_check_http_code.setter
    def health_check_http_code(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "health_check_http_code", value)

    @property
    @pulumi.getter(name="healthCheckHttpVersion")
    def health_check_http_version(self) -> Optional[pulumi.Input[str]]:
        """
        The HTTP version of health check.
        """
        return pulumi.get(self, "health_check_http_version")

    @health_check_http_version.setter
    def health_check_http_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "health_check_http_version", value)

    @property
    @pulumi.getter(name="healthCheckInterval")
    def health_check_interval(self) -> Optional[pulumi.Input[int]]:
        """
        The interval for performing health checks, the default value is 2, and the value is 1-300.
        """
        return pulumi.get(self, "health_check_interval")

    @health_check_interval.setter
    def health_check_interval(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "health_check_interval", value)

    @property
    @pulumi.getter(name="healthCheckMethod")
    def health_check_method(self) -> Optional[pulumi.Input[str]]:
        """
        The health check method,default is `GET`, support `GET` and `HEAD`.
        """
        return pulumi.get(self, "health_check_method")

    @health_check_method.setter
    def health_check_method(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "health_check_method", value)

    @property
    @pulumi.getter(name="healthCheckProtocol")
    def health_check_protocol(self) -> Optional[pulumi.Input[str]]:
        """
        THe protocol of health check,only support HTTP.
        """
        return pulumi.get(self, "health_check_protocol")

    @health_check_protocol.setter
    def health_check_protocol(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "health_check_protocol", value)

    @property
    @pulumi.getter(name="healthCheckTimeout")
    def health_check_timeout(self) -> Optional[pulumi.Input[int]]:
        """
        The timeout of health check response,the default value is 2, and the value is 1-60.
        """
        return pulumi.get(self, "health_check_timeout")

    @health_check_timeout.setter
    def health_check_timeout(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "health_check_timeout", value)

    @property
    @pulumi.getter(name="healthCheckUri")
    def health_check_uri(self) -> Optional[pulumi.Input[str]]:
        """
        The uri to health check,default is `/`.
        """
        return pulumi.get(self, "health_check_uri")

    @health_check_uri.setter
    def health_check_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "health_check_uri", value)

    @property
    @pulumi.getter(name="healthyThreshold")
    def healthy_threshold(self) -> Optional[pulumi.Input[int]]:
        """
        The healthy threshold of the health check, the default is 3, the value is 2-10.
        """
        return pulumi.get(self, "healthy_threshold")

    @healthy_threshold.setter
    def healthy_threshold(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "healthy_threshold", value)

    @property
    @pulumi.getter(name="unhealthyThreshold")
    def unhealthy_threshold(self) -> Optional[pulumi.Input[int]]:
        """
        The unhealthy threshold of the health check, the default is 3, the value is 2-10.
        """
        return pulumi.get(self, "unhealthy_threshold")

    @unhealthy_threshold.setter
    def unhealthy_threshold(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "unhealthy_threshold", value)


@pulumi.input_type
class _HealthCheckTemplateState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 health_check_domain: Optional[pulumi.Input[str]] = None,
                 health_check_http_code: Optional[pulumi.Input[str]] = None,
                 health_check_http_version: Optional[pulumi.Input[str]] = None,
                 health_check_interval: Optional[pulumi.Input[int]] = None,
                 health_check_method: Optional[pulumi.Input[str]] = None,
                 health_check_protocol: Optional[pulumi.Input[str]] = None,
                 health_check_template_name: Optional[pulumi.Input[str]] = None,
                 health_check_timeout: Optional[pulumi.Input[int]] = None,
                 health_check_uri: Optional[pulumi.Input[str]] = None,
                 healthy_threshold: Optional[pulumi.Input[int]] = None,
                 unhealthy_threshold: Optional[pulumi.Input[int]] = None):
        """
        Input properties used for looking up and filtering HealthCheckTemplate resources.
        :param pulumi.Input[str] description: The description of health check template.
        :param pulumi.Input[str] health_check_domain: The domain name to health check.
        :param pulumi.Input[str] health_check_http_code: The normal HTTP status code for health check, the default is http_2xx, http_3xx, separated by commas.
        :param pulumi.Input[str] health_check_http_version: The HTTP version of health check.
        :param pulumi.Input[int] health_check_interval: The interval for performing health checks, the default value is 2, and the value is 1-300.
        :param pulumi.Input[str] health_check_method: The health check method,default is `GET`, support `GET` and `HEAD`.
        :param pulumi.Input[str] health_check_protocol: THe protocol of health check,only support HTTP.
        :param pulumi.Input[str] health_check_template_name: The health check template name.
        :param pulumi.Input[int] health_check_timeout: The timeout of health check response,the default value is 2, and the value is 1-60.
        :param pulumi.Input[str] health_check_uri: The uri to health check,default is `/`.
        :param pulumi.Input[int] healthy_threshold: The healthy threshold of the health check, the default is 3, the value is 2-10.
        :param pulumi.Input[int] unhealthy_threshold: The unhealthy threshold of the health check, the default is 3, the value is 2-10.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if health_check_domain is not None:
            pulumi.set(__self__, "health_check_domain", health_check_domain)
        if health_check_http_code is not None:
            pulumi.set(__self__, "health_check_http_code", health_check_http_code)
        if health_check_http_version is not None:
            pulumi.set(__self__, "health_check_http_version", health_check_http_version)
        if health_check_interval is not None:
            pulumi.set(__self__, "health_check_interval", health_check_interval)
        if health_check_method is not None:
            pulumi.set(__self__, "health_check_method", health_check_method)
        if health_check_protocol is not None:
            pulumi.set(__self__, "health_check_protocol", health_check_protocol)
        if health_check_template_name is not None:
            pulumi.set(__self__, "health_check_template_name", health_check_template_name)
        if health_check_timeout is not None:
            pulumi.set(__self__, "health_check_timeout", health_check_timeout)
        if health_check_uri is not None:
            pulumi.set(__self__, "health_check_uri", health_check_uri)
        if healthy_threshold is not None:
            pulumi.set(__self__, "healthy_threshold", healthy_threshold)
        if unhealthy_threshold is not None:
            pulumi.set(__self__, "unhealthy_threshold", unhealthy_threshold)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of health check template.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="healthCheckDomain")
    def health_check_domain(self) -> Optional[pulumi.Input[str]]:
        """
        The domain name to health check.
        """
        return pulumi.get(self, "health_check_domain")

    @health_check_domain.setter
    def health_check_domain(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "health_check_domain", value)

    @property
    @pulumi.getter(name="healthCheckHttpCode")
    def health_check_http_code(self) -> Optional[pulumi.Input[str]]:
        """
        The normal HTTP status code for health check, the default is http_2xx, http_3xx, separated by commas.
        """
        return pulumi.get(self, "health_check_http_code")

    @health_check_http_code.setter
    def health_check_http_code(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "health_check_http_code", value)

    @property
    @pulumi.getter(name="healthCheckHttpVersion")
    def health_check_http_version(self) -> Optional[pulumi.Input[str]]:
        """
        The HTTP version of health check.
        """
        return pulumi.get(self, "health_check_http_version")

    @health_check_http_version.setter
    def health_check_http_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "health_check_http_version", value)

    @property
    @pulumi.getter(name="healthCheckInterval")
    def health_check_interval(self) -> Optional[pulumi.Input[int]]:
        """
        The interval for performing health checks, the default value is 2, and the value is 1-300.
        """
        return pulumi.get(self, "health_check_interval")

    @health_check_interval.setter
    def health_check_interval(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "health_check_interval", value)

    @property
    @pulumi.getter(name="healthCheckMethod")
    def health_check_method(self) -> Optional[pulumi.Input[str]]:
        """
        The health check method,default is `GET`, support `GET` and `HEAD`.
        """
        return pulumi.get(self, "health_check_method")

    @health_check_method.setter
    def health_check_method(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "health_check_method", value)

    @property
    @pulumi.getter(name="healthCheckProtocol")
    def health_check_protocol(self) -> Optional[pulumi.Input[str]]:
        """
        THe protocol of health check,only support HTTP.
        """
        return pulumi.get(self, "health_check_protocol")

    @health_check_protocol.setter
    def health_check_protocol(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "health_check_protocol", value)

    @property
    @pulumi.getter(name="healthCheckTemplateName")
    def health_check_template_name(self) -> Optional[pulumi.Input[str]]:
        """
        The health check template name.
        """
        return pulumi.get(self, "health_check_template_name")

    @health_check_template_name.setter
    def health_check_template_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "health_check_template_name", value)

    @property
    @pulumi.getter(name="healthCheckTimeout")
    def health_check_timeout(self) -> Optional[pulumi.Input[int]]:
        """
        The timeout of health check response,the default value is 2, and the value is 1-60.
        """
        return pulumi.get(self, "health_check_timeout")

    @health_check_timeout.setter
    def health_check_timeout(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "health_check_timeout", value)

    @property
    @pulumi.getter(name="healthCheckUri")
    def health_check_uri(self) -> Optional[pulumi.Input[str]]:
        """
        The uri to health check,default is `/`.
        """
        return pulumi.get(self, "health_check_uri")

    @health_check_uri.setter
    def health_check_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "health_check_uri", value)

    @property
    @pulumi.getter(name="healthyThreshold")
    def healthy_threshold(self) -> Optional[pulumi.Input[int]]:
        """
        The healthy threshold of the health check, the default is 3, the value is 2-10.
        """
        return pulumi.get(self, "healthy_threshold")

    @healthy_threshold.setter
    def healthy_threshold(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "healthy_threshold", value)

    @property
    @pulumi.getter(name="unhealthyThreshold")
    def unhealthy_threshold(self) -> Optional[pulumi.Input[int]]:
        """
        The unhealthy threshold of the health check, the default is 3, the value is 2-10.
        """
        return pulumi.get(self, "unhealthy_threshold")

    @unhealthy_threshold.setter
    def unhealthy_threshold(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "unhealthy_threshold", value)


class HealthCheckTemplate(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 health_check_domain: Optional[pulumi.Input[str]] = None,
                 health_check_http_code: Optional[pulumi.Input[str]] = None,
                 health_check_http_version: Optional[pulumi.Input[str]] = None,
                 health_check_interval: Optional[pulumi.Input[int]] = None,
                 health_check_method: Optional[pulumi.Input[str]] = None,
                 health_check_protocol: Optional[pulumi.Input[str]] = None,
                 health_check_template_name: Optional[pulumi.Input[str]] = None,
                 health_check_timeout: Optional[pulumi.Input[int]] = None,
                 health_check_uri: Optional[pulumi.Input[str]] = None,
                 healthy_threshold: Optional[pulumi.Input[int]] = None,
                 unhealthy_threshold: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        """
        Provides a resource to manage alb health check template
        ## Example Usage

        ```python
        import pulumi
        import pulumi_volcengine as volcengine

        foo = volcengine.alb.HealthCheckTemplate("foo",
            description="acc-test3",
            health_check_domain="test.com",
            health_check_http_code="http_2xx",
            health_check_http_version="HTTP1.1",
            health_check_interval=8,
            health_check_method="HEAD",
            health_check_protocol="HTTP",
            health_check_template_name="acc-test-template-1",
            health_check_timeout=11,
            health_check_uri="/",
            healthy_threshold=2,
            unhealthy_threshold=3)
        ```

        ## Import

        AlbHealthCheckTemplate can be imported using the id, e.g.

        ```sh
         $ pulumi import volcengine:alb/healthCheckTemplate:HealthCheckTemplate default hctpl-123*****432
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: The description of health check template.
        :param pulumi.Input[str] health_check_domain: The domain name to health check.
        :param pulumi.Input[str] health_check_http_code: The normal HTTP status code for health check, the default is http_2xx, http_3xx, separated by commas.
        :param pulumi.Input[str] health_check_http_version: The HTTP version of health check.
        :param pulumi.Input[int] health_check_interval: The interval for performing health checks, the default value is 2, and the value is 1-300.
        :param pulumi.Input[str] health_check_method: The health check method,default is `GET`, support `GET` and `HEAD`.
        :param pulumi.Input[str] health_check_protocol: THe protocol of health check,only support HTTP.
        :param pulumi.Input[str] health_check_template_name: The health check template name.
        :param pulumi.Input[int] health_check_timeout: The timeout of health check response,the default value is 2, and the value is 1-60.
        :param pulumi.Input[str] health_check_uri: The uri to health check,default is `/`.
        :param pulumi.Input[int] healthy_threshold: The healthy threshold of the health check, the default is 3, the value is 2-10.
        :param pulumi.Input[int] unhealthy_threshold: The unhealthy threshold of the health check, the default is 3, the value is 2-10.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: HealthCheckTemplateArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a resource to manage alb health check template
        ## Example Usage

        ```python
        import pulumi
        import pulumi_volcengine as volcengine

        foo = volcengine.alb.HealthCheckTemplate("foo",
            description="acc-test3",
            health_check_domain="test.com",
            health_check_http_code="http_2xx",
            health_check_http_version="HTTP1.1",
            health_check_interval=8,
            health_check_method="HEAD",
            health_check_protocol="HTTP",
            health_check_template_name="acc-test-template-1",
            health_check_timeout=11,
            health_check_uri="/",
            healthy_threshold=2,
            unhealthy_threshold=3)
        ```

        ## Import

        AlbHealthCheckTemplate can be imported using the id, e.g.

        ```sh
         $ pulumi import volcengine:alb/healthCheckTemplate:HealthCheckTemplate default hctpl-123*****432
        ```

        :param str resource_name: The name of the resource.
        :param HealthCheckTemplateArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(HealthCheckTemplateArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 health_check_domain: Optional[pulumi.Input[str]] = None,
                 health_check_http_code: Optional[pulumi.Input[str]] = None,
                 health_check_http_version: Optional[pulumi.Input[str]] = None,
                 health_check_interval: Optional[pulumi.Input[int]] = None,
                 health_check_method: Optional[pulumi.Input[str]] = None,
                 health_check_protocol: Optional[pulumi.Input[str]] = None,
                 health_check_template_name: Optional[pulumi.Input[str]] = None,
                 health_check_timeout: Optional[pulumi.Input[int]] = None,
                 health_check_uri: Optional[pulumi.Input[str]] = None,
                 healthy_threshold: Optional[pulumi.Input[int]] = None,
                 unhealthy_threshold: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = HealthCheckTemplateArgs.__new__(HealthCheckTemplateArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["health_check_domain"] = health_check_domain
            __props__.__dict__["health_check_http_code"] = health_check_http_code
            __props__.__dict__["health_check_http_version"] = health_check_http_version
            __props__.__dict__["health_check_interval"] = health_check_interval
            __props__.__dict__["health_check_method"] = health_check_method
            __props__.__dict__["health_check_protocol"] = health_check_protocol
            if health_check_template_name is None and not opts.urn:
                raise TypeError("Missing required property 'health_check_template_name'")
            __props__.__dict__["health_check_template_name"] = health_check_template_name
            __props__.__dict__["health_check_timeout"] = health_check_timeout
            __props__.__dict__["health_check_uri"] = health_check_uri
            __props__.__dict__["healthy_threshold"] = healthy_threshold
            __props__.__dict__["unhealthy_threshold"] = unhealthy_threshold
        super(HealthCheckTemplate, __self__).__init__(
            'volcengine:alb/healthCheckTemplate:HealthCheckTemplate',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[str]] = None,
            health_check_domain: Optional[pulumi.Input[str]] = None,
            health_check_http_code: Optional[pulumi.Input[str]] = None,
            health_check_http_version: Optional[pulumi.Input[str]] = None,
            health_check_interval: Optional[pulumi.Input[int]] = None,
            health_check_method: Optional[pulumi.Input[str]] = None,
            health_check_protocol: Optional[pulumi.Input[str]] = None,
            health_check_template_name: Optional[pulumi.Input[str]] = None,
            health_check_timeout: Optional[pulumi.Input[int]] = None,
            health_check_uri: Optional[pulumi.Input[str]] = None,
            healthy_threshold: Optional[pulumi.Input[int]] = None,
            unhealthy_threshold: Optional[pulumi.Input[int]] = None) -> 'HealthCheckTemplate':
        """
        Get an existing HealthCheckTemplate resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: The description of health check template.
        :param pulumi.Input[str] health_check_domain: The domain name to health check.
        :param pulumi.Input[str] health_check_http_code: The normal HTTP status code for health check, the default is http_2xx, http_3xx, separated by commas.
        :param pulumi.Input[str] health_check_http_version: The HTTP version of health check.
        :param pulumi.Input[int] health_check_interval: The interval for performing health checks, the default value is 2, and the value is 1-300.
        :param pulumi.Input[str] health_check_method: The health check method,default is `GET`, support `GET` and `HEAD`.
        :param pulumi.Input[str] health_check_protocol: THe protocol of health check,only support HTTP.
        :param pulumi.Input[str] health_check_template_name: The health check template name.
        :param pulumi.Input[int] health_check_timeout: The timeout of health check response,the default value is 2, and the value is 1-60.
        :param pulumi.Input[str] health_check_uri: The uri to health check,default is `/`.
        :param pulumi.Input[int] healthy_threshold: The healthy threshold of the health check, the default is 3, the value is 2-10.
        :param pulumi.Input[int] unhealthy_threshold: The unhealthy threshold of the health check, the default is 3, the value is 2-10.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _HealthCheckTemplateState.__new__(_HealthCheckTemplateState)

        __props__.__dict__["description"] = description
        __props__.__dict__["health_check_domain"] = health_check_domain
        __props__.__dict__["health_check_http_code"] = health_check_http_code
        __props__.__dict__["health_check_http_version"] = health_check_http_version
        __props__.__dict__["health_check_interval"] = health_check_interval
        __props__.__dict__["health_check_method"] = health_check_method
        __props__.__dict__["health_check_protocol"] = health_check_protocol
        __props__.__dict__["health_check_template_name"] = health_check_template_name
        __props__.__dict__["health_check_timeout"] = health_check_timeout
        __props__.__dict__["health_check_uri"] = health_check_uri
        __props__.__dict__["healthy_threshold"] = healthy_threshold
        __props__.__dict__["unhealthy_threshold"] = unhealthy_threshold
        return HealthCheckTemplate(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        The description of health check template.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="healthCheckDomain")
    def health_check_domain(self) -> pulumi.Output[str]:
        """
        The domain name to health check.
        """
        return pulumi.get(self, "health_check_domain")

    @property
    @pulumi.getter(name="healthCheckHttpCode")
    def health_check_http_code(self) -> pulumi.Output[str]:
        """
        The normal HTTP status code for health check, the default is http_2xx, http_3xx, separated by commas.
        """
        return pulumi.get(self, "health_check_http_code")

    @property
    @pulumi.getter(name="healthCheckHttpVersion")
    def health_check_http_version(self) -> pulumi.Output[str]:
        """
        The HTTP version of health check.
        """
        return pulumi.get(self, "health_check_http_version")

    @property
    @pulumi.getter(name="healthCheckInterval")
    def health_check_interval(self) -> pulumi.Output[int]:
        """
        The interval for performing health checks, the default value is 2, and the value is 1-300.
        """
        return pulumi.get(self, "health_check_interval")

    @property
    @pulumi.getter(name="healthCheckMethod")
    def health_check_method(self) -> pulumi.Output[str]:
        """
        The health check method,default is `GET`, support `GET` and `HEAD`.
        """
        return pulumi.get(self, "health_check_method")

    @property
    @pulumi.getter(name="healthCheckProtocol")
    def health_check_protocol(self) -> pulumi.Output[str]:
        """
        THe protocol of health check,only support HTTP.
        """
        return pulumi.get(self, "health_check_protocol")

    @property
    @pulumi.getter(name="healthCheckTemplateName")
    def health_check_template_name(self) -> pulumi.Output[str]:
        """
        The health check template name.
        """
        return pulumi.get(self, "health_check_template_name")

    @property
    @pulumi.getter(name="healthCheckTimeout")
    def health_check_timeout(self) -> pulumi.Output[int]:
        """
        The timeout of health check response,the default value is 2, and the value is 1-60.
        """
        return pulumi.get(self, "health_check_timeout")

    @property
    @pulumi.getter(name="healthCheckUri")
    def health_check_uri(self) -> pulumi.Output[str]:
        """
        The uri to health check,default is `/`.
        """
        return pulumi.get(self, "health_check_uri")

    @property
    @pulumi.getter(name="healthyThreshold")
    def healthy_threshold(self) -> pulumi.Output[int]:
        """
        The healthy threshold of the health check, the default is 3, the value is 2-10.
        """
        return pulumi.get(self, "healthy_threshold")

    @property
    @pulumi.getter(name="unhealthyThreshold")
    def unhealthy_threshold(self) -> pulumi.Output[int]:
        """
        The unhealthy threshold of the health check, the default is 3, the value is 2-10.
        """
        return pulumi.get(self, "unhealthy_threshold")

