# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'HealthCheckTemplatesResult',
    'AwaitableHealthCheckTemplatesResult',
    'health_check_templates',
    'health_check_templates_output',
]

@pulumi.output_type
class HealthCheckTemplatesResult:
    """
    A collection of values returned by HealthCheckTemplates.
    """
    def __init__(__self__, health_check_template_name=None, health_check_templates=None, id=None, ids=None, name_regex=None, output_file=None, total_count=None):
        if health_check_template_name and not isinstance(health_check_template_name, str):
            raise TypeError("Expected argument 'health_check_template_name' to be a str")
        pulumi.set(__self__, "health_check_template_name", health_check_template_name)
        if health_check_templates and not isinstance(health_check_templates, list):
            raise TypeError("Expected argument 'health_check_templates' to be a list")
        pulumi.set(__self__, "health_check_templates", health_check_templates)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if name_regex and not isinstance(name_regex, str):
            raise TypeError("Expected argument 'name_regex' to be a str")
        pulumi.set(__self__, "name_regex", name_regex)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if total_count and not isinstance(total_count, int):
            raise TypeError("Expected argument 'total_count' to be a int")
        pulumi.set(__self__, "total_count", total_count)

    @property
    @pulumi.getter(name="healthCheckTemplateName")
    def health_check_template_name(self) -> Optional[str]:
        """
        The name of health check template.
        """
        return pulumi.get(self, "health_check_template_name")

    @property
    @pulumi.getter(name="healthCheckTemplates")
    def health_check_templates(self) -> Sequence['outputs.HealthCheckTemplatesHealthCheckTemplateResult']:
        """
        The collection of health check template query.
        """
        return pulumi.get(self, "health_check_templates")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def ids(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "ids")

    @property
    @pulumi.getter(name="nameRegex")
    def name_regex(self) -> Optional[str]:
        return pulumi.get(self, "name_regex")

    @property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[str]:
        return pulumi.get(self, "output_file")

    @property
    @pulumi.getter(name="totalCount")
    def total_count(self) -> int:
        """
        The total count of health check template query.
        """
        return pulumi.get(self, "total_count")


class AwaitableHealthCheckTemplatesResult(HealthCheckTemplatesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return HealthCheckTemplatesResult(
            health_check_template_name=self.health_check_template_name,
            health_check_templates=self.health_check_templates,
            id=self.id,
            ids=self.ids,
            name_regex=self.name_regex,
            output_file=self.output_file,
            total_count=self.total_count)


def health_check_templates(health_check_template_name: Optional[str] = None,
                           ids: Optional[Sequence[str]] = None,
                           name_regex: Optional[str] = None,
                           output_file: Optional[str] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableHealthCheckTemplatesResult:
    """
    Use this data source to query detailed information of alb health check templates
    ## Example Usage

    ```python
    import pulumi
    import pulumi_volcengine as volcengine

    foo = volcengine.alb.health_check_templates(ids=["hctpl-1iidd1tobnim874adhf708uwf"])
    ```


    :param str health_check_template_name: The name of health check template to query.
    :param Sequence[str] ids: The list of health check templates to query.
    :param str name_regex: A Name Regex of health check template.
    :param str output_file: File name where to save data source results.
    """
    __args__ = dict()
    __args__['healthCheckTemplateName'] = health_check_template_name
    __args__['ids'] = ids
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('volcengine:alb/healthCheckTemplates:HealthCheckTemplates', __args__, opts=opts, typ=HealthCheckTemplatesResult).value

    return AwaitableHealthCheckTemplatesResult(
        health_check_template_name=pulumi.get(__ret__, 'health_check_template_name'),
        health_check_templates=pulumi.get(__ret__, 'health_check_templates'),
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        name_regex=pulumi.get(__ret__, 'name_regex'),
        output_file=pulumi.get(__ret__, 'output_file'),
        total_count=pulumi.get(__ret__, 'total_count'))


@_utilities.lift_output_func(health_check_templates)
def health_check_templates_output(health_check_template_name: Optional[pulumi.Input[Optional[str]]] = None,
                                  ids: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                                  name_regex: Optional[pulumi.Input[Optional[str]]] = None,
                                  output_file: Optional[pulumi.Input[Optional[str]]] = None,
                                  opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[HealthCheckTemplatesResult]:
    """
    Use this data source to query detailed information of alb health check templates
    ## Example Usage

    ```python
    import pulumi
    import pulumi_volcengine as volcengine

    foo = volcengine.alb.health_check_templates(ids=["hctpl-1iidd1tobnim874adhf708uwf"])
    ```


    :param str health_check_template_name: The name of health check template to query.
    :param Sequence[str] ids: The list of health check templates to query.
    :param str name_regex: A Name Regex of health check template.
    :param str output_file: File name where to save data source results.
    """
    ...
