# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['ListenerArgs', 'Listener']

@pulumi.input_type
class ListenerArgs:
    def __init__(__self__, *,
                 load_balancer_id: pulumi.Input[str],
                 port: pulumi.Input[int],
                 protocol: pulumi.Input[str],
                 server_group_id: pulumi.Input[str],
                 acl_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 acl_status: Optional[pulumi.Input[str]] = None,
                 acl_type: Optional[pulumi.Input[str]] = None,
                 ca_certificate_id: Optional[pulumi.Input[str]] = None,
                 certificate_id: Optional[pulumi.Input[str]] = None,
                 customized_cfg_id: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 enable_http2: Optional[pulumi.Input[str]] = None,
                 enable_quic: Optional[pulumi.Input[str]] = None,
                 enabled: Optional[pulumi.Input[str]] = None,
                 listener_name: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Listener resource.
        :param pulumi.Input[str] load_balancer_id: The Id of the load balancer.
        :param pulumi.Input[int] port: The port receiving request of the Listener, the value range in 1~65535.
        :param pulumi.Input[str] protocol: The protocol of the Listener. Optional choice contains `HTTP`, `HTTPS`.
        :param pulumi.Input[str] server_group_id: The server group id associated with the listener.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] acl_ids: The id list of the Acl. When the AclStatus parameter is configured as on, AclType and AclIds.N are required.
        :param pulumi.Input[str] acl_status: The enable status of Acl. Optional choice contains `on`, `off`. Default is `off`.
        :param pulumi.Input[str] acl_type: The type of the Acl. Optional choice contains `white`, `black`. When the AclStatus parameter is configured as on, AclType and AclIds.N are required.
        :param pulumi.Input[str] ca_certificate_id: The CA certificate id associated with the listener.
        :param pulumi.Input[str] certificate_id: The certificate id associated with the listener.
        :param pulumi.Input[str] customized_cfg_id: Personalized configuration ID, with a value of " " when not bound.
        :param pulumi.Input[str] description: The description of the Listener.
        :param pulumi.Input[str] enable_http2: The HTTP2 feature switch,valid value is on or off. Default is `off`.
        :param pulumi.Input[str] enable_quic: The QUIC feature switch,valid value is on or off. Default is `off`.
        :param pulumi.Input[str] enabled: The enable status of the Listener. Optional choice contains `on`, `off`. Default is `on`.
        :param pulumi.Input[str] listener_name: The name of the Listener.
        """
        pulumi.set(__self__, "load_balancer_id", load_balancer_id)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "protocol", protocol)
        pulumi.set(__self__, "server_group_id", server_group_id)
        if acl_ids is not None:
            pulumi.set(__self__, "acl_ids", acl_ids)
        if acl_status is not None:
            pulumi.set(__self__, "acl_status", acl_status)
        if acl_type is not None:
            pulumi.set(__self__, "acl_type", acl_type)
        if ca_certificate_id is not None:
            pulumi.set(__self__, "ca_certificate_id", ca_certificate_id)
        if certificate_id is not None:
            pulumi.set(__self__, "certificate_id", certificate_id)
        if customized_cfg_id is not None:
            pulumi.set(__self__, "customized_cfg_id", customized_cfg_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enable_http2 is not None:
            pulumi.set(__self__, "enable_http2", enable_http2)
        if enable_quic is not None:
            pulumi.set(__self__, "enable_quic", enable_quic)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if listener_name is not None:
            pulumi.set(__self__, "listener_name", listener_name)

    @property
    @pulumi.getter(name="loadBalancerId")
    def load_balancer_id(self) -> pulumi.Input[str]:
        """
        The Id of the load balancer.
        """
        return pulumi.get(self, "load_balancer_id")

    @load_balancer_id.setter
    def load_balancer_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "load_balancer_id", value)

    @property
    @pulumi.getter
    def port(self) -> pulumi.Input[int]:
        """
        The port receiving request of the Listener, the value range in 1~65535.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: pulumi.Input[int]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter
    def protocol(self) -> pulumi.Input[str]:
        """
        The protocol of the Listener. Optional choice contains `HTTP`, `HTTPS`.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: pulumi.Input[str]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter(name="serverGroupId")
    def server_group_id(self) -> pulumi.Input[str]:
        """
        The server group id associated with the listener.
        """
        return pulumi.get(self, "server_group_id")

    @server_group_id.setter
    def server_group_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "server_group_id", value)

    @property
    @pulumi.getter(name="aclIds")
    def acl_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The id list of the Acl. When the AclStatus parameter is configured as on, AclType and AclIds.N are required.
        """
        return pulumi.get(self, "acl_ids")

    @acl_ids.setter
    def acl_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "acl_ids", value)

    @property
    @pulumi.getter(name="aclStatus")
    def acl_status(self) -> Optional[pulumi.Input[str]]:
        """
        The enable status of Acl. Optional choice contains `on`, `off`. Default is `off`.
        """
        return pulumi.get(self, "acl_status")

    @acl_status.setter
    def acl_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "acl_status", value)

    @property
    @pulumi.getter(name="aclType")
    def acl_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of the Acl. Optional choice contains `white`, `black`. When the AclStatus parameter is configured as on, AclType and AclIds.N are required.
        """
        return pulumi.get(self, "acl_type")

    @acl_type.setter
    def acl_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "acl_type", value)

    @property
    @pulumi.getter(name="caCertificateId")
    def ca_certificate_id(self) -> Optional[pulumi.Input[str]]:
        """
        The CA certificate id associated with the listener.
        """
        return pulumi.get(self, "ca_certificate_id")

    @ca_certificate_id.setter
    def ca_certificate_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ca_certificate_id", value)

    @property
    @pulumi.getter(name="certificateId")
    def certificate_id(self) -> Optional[pulumi.Input[str]]:
        """
        The certificate id associated with the listener.
        """
        return pulumi.get(self, "certificate_id")

    @certificate_id.setter
    def certificate_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "certificate_id", value)

    @property
    @pulumi.getter(name="customizedCfgId")
    def customized_cfg_id(self) -> Optional[pulumi.Input[str]]:
        """
        Personalized configuration ID, with a value of " " when not bound.
        """
        return pulumi.get(self, "customized_cfg_id")

    @customized_cfg_id.setter
    def customized_cfg_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "customized_cfg_id", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the Listener.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="enableHttp2")
    def enable_http2(self) -> Optional[pulumi.Input[str]]:
        """
        The HTTP2 feature switch,valid value is on or off. Default is `off`.
        """
        return pulumi.get(self, "enable_http2")

    @enable_http2.setter
    def enable_http2(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "enable_http2", value)

    @property
    @pulumi.getter(name="enableQuic")
    def enable_quic(self) -> Optional[pulumi.Input[str]]:
        """
        The QUIC feature switch,valid value is on or off. Default is `off`.
        """
        return pulumi.get(self, "enable_quic")

    @enable_quic.setter
    def enable_quic(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "enable_quic", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[str]]:
        """
        The enable status of the Listener. Optional choice contains `on`, `off`. Default is `on`.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="listenerName")
    def listener_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Listener.
        """
        return pulumi.get(self, "listener_name")

    @listener_name.setter
    def listener_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "listener_name", value)


@pulumi.input_type
class _ListenerState:
    def __init__(__self__, *,
                 acl_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 acl_status: Optional[pulumi.Input[str]] = None,
                 acl_type: Optional[pulumi.Input[str]] = None,
                 ca_certificate_id: Optional[pulumi.Input[str]] = None,
                 certificate_id: Optional[pulumi.Input[str]] = None,
                 customized_cfg_id: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 enable_http2: Optional[pulumi.Input[str]] = None,
                 enable_quic: Optional[pulumi.Input[str]] = None,
                 enabled: Optional[pulumi.Input[str]] = None,
                 listener_id: Optional[pulumi.Input[str]] = None,
                 listener_name: Optional[pulumi.Input[str]] = None,
                 load_balancer_id: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 protocol: Optional[pulumi.Input[str]] = None,
                 server_group_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Listener resources.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] acl_ids: The id list of the Acl. When the AclStatus parameter is configured as on, AclType and AclIds.N are required.
        :param pulumi.Input[str] acl_status: The enable status of Acl. Optional choice contains `on`, `off`. Default is `off`.
        :param pulumi.Input[str] acl_type: The type of the Acl. Optional choice contains `white`, `black`. When the AclStatus parameter is configured as on, AclType and AclIds.N are required.
        :param pulumi.Input[str] ca_certificate_id: The CA certificate id associated with the listener.
        :param pulumi.Input[str] certificate_id: The certificate id associated with the listener.
        :param pulumi.Input[str] customized_cfg_id: Personalized configuration ID, with a value of " " when not bound.
        :param pulumi.Input[str] description: The description of the Listener.
        :param pulumi.Input[str] enable_http2: The HTTP2 feature switch,valid value is on or off. Default is `off`.
        :param pulumi.Input[str] enable_quic: The QUIC feature switch,valid value is on or off. Default is `off`.
        :param pulumi.Input[str] enabled: The enable status of the Listener. Optional choice contains `on`, `off`. Default is `on`.
        :param pulumi.Input[str] listener_id: The ID of the Listener.
        :param pulumi.Input[str] listener_name: The name of the Listener.
        :param pulumi.Input[str] load_balancer_id: The Id of the load balancer.
        :param pulumi.Input[int] port: The port receiving request of the Listener, the value range in 1~65535.
        :param pulumi.Input[str] protocol: The protocol of the Listener. Optional choice contains `HTTP`, `HTTPS`.
        :param pulumi.Input[str] server_group_id: The server group id associated with the listener.
        """
        if acl_ids is not None:
            pulumi.set(__self__, "acl_ids", acl_ids)
        if acl_status is not None:
            pulumi.set(__self__, "acl_status", acl_status)
        if acl_type is not None:
            pulumi.set(__self__, "acl_type", acl_type)
        if ca_certificate_id is not None:
            pulumi.set(__self__, "ca_certificate_id", ca_certificate_id)
        if certificate_id is not None:
            pulumi.set(__self__, "certificate_id", certificate_id)
        if customized_cfg_id is not None:
            pulumi.set(__self__, "customized_cfg_id", customized_cfg_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enable_http2 is not None:
            pulumi.set(__self__, "enable_http2", enable_http2)
        if enable_quic is not None:
            pulumi.set(__self__, "enable_quic", enable_quic)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if listener_id is not None:
            pulumi.set(__self__, "listener_id", listener_id)
        if listener_name is not None:
            pulumi.set(__self__, "listener_name", listener_name)
        if load_balancer_id is not None:
            pulumi.set(__self__, "load_balancer_id", load_balancer_id)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if server_group_id is not None:
            pulumi.set(__self__, "server_group_id", server_group_id)

    @property
    @pulumi.getter(name="aclIds")
    def acl_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The id list of the Acl. When the AclStatus parameter is configured as on, AclType and AclIds.N are required.
        """
        return pulumi.get(self, "acl_ids")

    @acl_ids.setter
    def acl_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "acl_ids", value)

    @property
    @pulumi.getter(name="aclStatus")
    def acl_status(self) -> Optional[pulumi.Input[str]]:
        """
        The enable status of Acl. Optional choice contains `on`, `off`. Default is `off`.
        """
        return pulumi.get(self, "acl_status")

    @acl_status.setter
    def acl_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "acl_status", value)

    @property
    @pulumi.getter(name="aclType")
    def acl_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of the Acl. Optional choice contains `white`, `black`. When the AclStatus parameter is configured as on, AclType and AclIds.N are required.
        """
        return pulumi.get(self, "acl_type")

    @acl_type.setter
    def acl_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "acl_type", value)

    @property
    @pulumi.getter(name="caCertificateId")
    def ca_certificate_id(self) -> Optional[pulumi.Input[str]]:
        """
        The CA certificate id associated with the listener.
        """
        return pulumi.get(self, "ca_certificate_id")

    @ca_certificate_id.setter
    def ca_certificate_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ca_certificate_id", value)

    @property
    @pulumi.getter(name="certificateId")
    def certificate_id(self) -> Optional[pulumi.Input[str]]:
        """
        The certificate id associated with the listener.
        """
        return pulumi.get(self, "certificate_id")

    @certificate_id.setter
    def certificate_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "certificate_id", value)

    @property
    @pulumi.getter(name="customizedCfgId")
    def customized_cfg_id(self) -> Optional[pulumi.Input[str]]:
        """
        Personalized configuration ID, with a value of " " when not bound.
        """
        return pulumi.get(self, "customized_cfg_id")

    @customized_cfg_id.setter
    def customized_cfg_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "customized_cfg_id", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the Listener.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="enableHttp2")
    def enable_http2(self) -> Optional[pulumi.Input[str]]:
        """
        The HTTP2 feature switch,valid value is on or off. Default is `off`.
        """
        return pulumi.get(self, "enable_http2")

    @enable_http2.setter
    def enable_http2(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "enable_http2", value)

    @property
    @pulumi.getter(name="enableQuic")
    def enable_quic(self) -> Optional[pulumi.Input[str]]:
        """
        The QUIC feature switch,valid value is on or off. Default is `off`.
        """
        return pulumi.get(self, "enable_quic")

    @enable_quic.setter
    def enable_quic(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "enable_quic", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[str]]:
        """
        The enable status of the Listener. Optional choice contains `on`, `off`. Default is `on`.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="listenerId")
    def listener_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the Listener.
        """
        return pulumi.get(self, "listener_id")

    @listener_id.setter
    def listener_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "listener_id", value)

    @property
    @pulumi.getter(name="listenerName")
    def listener_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Listener.
        """
        return pulumi.get(self, "listener_name")

    @listener_name.setter
    def listener_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "listener_name", value)

    @property
    @pulumi.getter(name="loadBalancerId")
    def load_balancer_id(self) -> Optional[pulumi.Input[str]]:
        """
        The Id of the load balancer.
        """
        return pulumi.get(self, "load_balancer_id")

    @load_balancer_id.setter
    def load_balancer_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "load_balancer_id", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        The port receiving request of the Listener, the value range in 1~65535.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[str]]:
        """
        The protocol of the Listener. Optional choice contains `HTTP`, `HTTPS`.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter(name="serverGroupId")
    def server_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        The server group id associated with the listener.
        """
        return pulumi.get(self, "server_group_id")

    @server_group_id.setter
    def server_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "server_group_id", value)


class Listener(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 acl_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 acl_status: Optional[pulumi.Input[str]] = None,
                 acl_type: Optional[pulumi.Input[str]] = None,
                 ca_certificate_id: Optional[pulumi.Input[str]] = None,
                 certificate_id: Optional[pulumi.Input[str]] = None,
                 customized_cfg_id: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 enable_http2: Optional[pulumi.Input[str]] = None,
                 enable_quic: Optional[pulumi.Input[str]] = None,
                 enabled: Optional[pulumi.Input[str]] = None,
                 listener_name: Optional[pulumi.Input[str]] = None,
                 load_balancer_id: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 protocol: Optional[pulumi.Input[str]] = None,
                 server_group_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a resource to manage alb listener
        ## Example Usage

        ```python
        import pulumi
        import pulumi_volcengine as volcengine

        foo_customized_cfg = volcengine.alb.CustomizedCfg("fooCustomizedCfg",
            customized_cfg_name="acc-test-cfg1",
            description="This is a test modify",
            customized_cfg_content="proxy_connect_timeout 4s;proxy_request_buffering on;",
            project_name="default")
        foo_listener = volcengine.alb.Listener("fooListener",
            load_balancer_id="alb-1iidd17v3klj474adhfrunyz9",
            listener_name="acc-test-listener-1",
            protocol="HTTPS",
            port=6666,
            enabled="on",
            certificate_id="cert-1iidd2pahdyio74adhfr9ajwg",
            ca_certificate_id="cert-1iidd2r9ii0hs74adhfeodxo1",
            server_group_id="rsp-1g72w74y4umf42zbhq4k4hnln",
            enable_http2="on",
            enable_quic="off",
            acl_status="on",
            acl_type="white",
            acl_ids=[
                "acl-1g72w6z11ighs2zbhq4v3rvh4",
                "acl-1g72xvtt7kg002zbhq5diim3s",
            ],
            description="acc test listener",
            customized_cfg_id=foo_customized_cfg.id)
        ```

        ## Import

        AlbListener can be imported using the id, e.g.

        ```sh
         $ pulumi import volcengine:alb/listener:Listener default lsn-273yv0mhs5xj47fap8sehiiso
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] acl_ids: The id list of the Acl. When the AclStatus parameter is configured as on, AclType and AclIds.N are required.
        :param pulumi.Input[str] acl_status: The enable status of Acl. Optional choice contains `on`, `off`. Default is `off`.
        :param pulumi.Input[str] acl_type: The type of the Acl. Optional choice contains `white`, `black`. When the AclStatus parameter is configured as on, AclType and AclIds.N are required.
        :param pulumi.Input[str] ca_certificate_id: The CA certificate id associated with the listener.
        :param pulumi.Input[str] certificate_id: The certificate id associated with the listener.
        :param pulumi.Input[str] customized_cfg_id: Personalized configuration ID, with a value of " " when not bound.
        :param pulumi.Input[str] description: The description of the Listener.
        :param pulumi.Input[str] enable_http2: The HTTP2 feature switch,valid value is on or off. Default is `off`.
        :param pulumi.Input[str] enable_quic: The QUIC feature switch,valid value is on or off. Default is `off`.
        :param pulumi.Input[str] enabled: The enable status of the Listener. Optional choice contains `on`, `off`. Default is `on`.
        :param pulumi.Input[str] listener_name: The name of the Listener.
        :param pulumi.Input[str] load_balancer_id: The Id of the load balancer.
        :param pulumi.Input[int] port: The port receiving request of the Listener, the value range in 1~65535.
        :param pulumi.Input[str] protocol: The protocol of the Listener. Optional choice contains `HTTP`, `HTTPS`.
        :param pulumi.Input[str] server_group_id: The server group id associated with the listener.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ListenerArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a resource to manage alb listener
        ## Example Usage

        ```python
        import pulumi
        import pulumi_volcengine as volcengine

        foo_customized_cfg = volcengine.alb.CustomizedCfg("fooCustomizedCfg",
            customized_cfg_name="acc-test-cfg1",
            description="This is a test modify",
            customized_cfg_content="proxy_connect_timeout 4s;proxy_request_buffering on;",
            project_name="default")
        foo_listener = volcengine.alb.Listener("fooListener",
            load_balancer_id="alb-1iidd17v3klj474adhfrunyz9",
            listener_name="acc-test-listener-1",
            protocol="HTTPS",
            port=6666,
            enabled="on",
            certificate_id="cert-1iidd2pahdyio74adhfr9ajwg",
            ca_certificate_id="cert-1iidd2r9ii0hs74adhfeodxo1",
            server_group_id="rsp-1g72w74y4umf42zbhq4k4hnln",
            enable_http2="on",
            enable_quic="off",
            acl_status="on",
            acl_type="white",
            acl_ids=[
                "acl-1g72w6z11ighs2zbhq4v3rvh4",
                "acl-1g72xvtt7kg002zbhq5diim3s",
            ],
            description="acc test listener",
            customized_cfg_id=foo_customized_cfg.id)
        ```

        ## Import

        AlbListener can be imported using the id, e.g.

        ```sh
         $ pulumi import volcengine:alb/listener:Listener default lsn-273yv0mhs5xj47fap8sehiiso
        ```

        :param str resource_name: The name of the resource.
        :param ListenerArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ListenerArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 acl_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 acl_status: Optional[pulumi.Input[str]] = None,
                 acl_type: Optional[pulumi.Input[str]] = None,
                 ca_certificate_id: Optional[pulumi.Input[str]] = None,
                 certificate_id: Optional[pulumi.Input[str]] = None,
                 customized_cfg_id: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 enable_http2: Optional[pulumi.Input[str]] = None,
                 enable_quic: Optional[pulumi.Input[str]] = None,
                 enabled: Optional[pulumi.Input[str]] = None,
                 listener_name: Optional[pulumi.Input[str]] = None,
                 load_balancer_id: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 protocol: Optional[pulumi.Input[str]] = None,
                 server_group_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ListenerArgs.__new__(ListenerArgs)

            __props__.__dict__["acl_ids"] = acl_ids
            __props__.__dict__["acl_status"] = acl_status
            __props__.__dict__["acl_type"] = acl_type
            __props__.__dict__["ca_certificate_id"] = ca_certificate_id
            __props__.__dict__["certificate_id"] = certificate_id
            __props__.__dict__["customized_cfg_id"] = customized_cfg_id
            __props__.__dict__["description"] = description
            __props__.__dict__["enable_http2"] = enable_http2
            __props__.__dict__["enable_quic"] = enable_quic
            __props__.__dict__["enabled"] = enabled
            __props__.__dict__["listener_name"] = listener_name
            if load_balancer_id is None and not opts.urn:
                raise TypeError("Missing required property 'load_balancer_id'")
            __props__.__dict__["load_balancer_id"] = load_balancer_id
            if port is None and not opts.urn:
                raise TypeError("Missing required property 'port'")
            __props__.__dict__["port"] = port
            if protocol is None and not opts.urn:
                raise TypeError("Missing required property 'protocol'")
            __props__.__dict__["protocol"] = protocol
            if server_group_id is None and not opts.urn:
                raise TypeError("Missing required property 'server_group_id'")
            __props__.__dict__["server_group_id"] = server_group_id
            __props__.__dict__["listener_id"] = None
        super(Listener, __self__).__init__(
            'volcengine:alb/listener:Listener',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            acl_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            acl_status: Optional[pulumi.Input[str]] = None,
            acl_type: Optional[pulumi.Input[str]] = None,
            ca_certificate_id: Optional[pulumi.Input[str]] = None,
            certificate_id: Optional[pulumi.Input[str]] = None,
            customized_cfg_id: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            enable_http2: Optional[pulumi.Input[str]] = None,
            enable_quic: Optional[pulumi.Input[str]] = None,
            enabled: Optional[pulumi.Input[str]] = None,
            listener_id: Optional[pulumi.Input[str]] = None,
            listener_name: Optional[pulumi.Input[str]] = None,
            load_balancer_id: Optional[pulumi.Input[str]] = None,
            port: Optional[pulumi.Input[int]] = None,
            protocol: Optional[pulumi.Input[str]] = None,
            server_group_id: Optional[pulumi.Input[str]] = None) -> 'Listener':
        """
        Get an existing Listener resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] acl_ids: The id list of the Acl. When the AclStatus parameter is configured as on, AclType and AclIds.N are required.
        :param pulumi.Input[str] acl_status: The enable status of Acl. Optional choice contains `on`, `off`. Default is `off`.
        :param pulumi.Input[str] acl_type: The type of the Acl. Optional choice contains `white`, `black`. When the AclStatus parameter is configured as on, AclType and AclIds.N are required.
        :param pulumi.Input[str] ca_certificate_id: The CA certificate id associated with the listener.
        :param pulumi.Input[str] certificate_id: The certificate id associated with the listener.
        :param pulumi.Input[str] customized_cfg_id: Personalized configuration ID, with a value of " " when not bound.
        :param pulumi.Input[str] description: The description of the Listener.
        :param pulumi.Input[str] enable_http2: The HTTP2 feature switch,valid value is on or off. Default is `off`.
        :param pulumi.Input[str] enable_quic: The QUIC feature switch,valid value is on or off. Default is `off`.
        :param pulumi.Input[str] enabled: The enable status of the Listener. Optional choice contains `on`, `off`. Default is `on`.
        :param pulumi.Input[str] listener_id: The ID of the Listener.
        :param pulumi.Input[str] listener_name: The name of the Listener.
        :param pulumi.Input[str] load_balancer_id: The Id of the load balancer.
        :param pulumi.Input[int] port: The port receiving request of the Listener, the value range in 1~65535.
        :param pulumi.Input[str] protocol: The protocol of the Listener. Optional choice contains `HTTP`, `HTTPS`.
        :param pulumi.Input[str] server_group_id: The server group id associated with the listener.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ListenerState.__new__(_ListenerState)

        __props__.__dict__["acl_ids"] = acl_ids
        __props__.__dict__["acl_status"] = acl_status
        __props__.__dict__["acl_type"] = acl_type
        __props__.__dict__["ca_certificate_id"] = ca_certificate_id
        __props__.__dict__["certificate_id"] = certificate_id
        __props__.__dict__["customized_cfg_id"] = customized_cfg_id
        __props__.__dict__["description"] = description
        __props__.__dict__["enable_http2"] = enable_http2
        __props__.__dict__["enable_quic"] = enable_quic
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["listener_id"] = listener_id
        __props__.__dict__["listener_name"] = listener_name
        __props__.__dict__["load_balancer_id"] = load_balancer_id
        __props__.__dict__["port"] = port
        __props__.__dict__["protocol"] = protocol
        __props__.__dict__["server_group_id"] = server_group_id
        return Listener(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="aclIds")
    def acl_ids(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        The id list of the Acl. When the AclStatus parameter is configured as on, AclType and AclIds.N are required.
        """
        return pulumi.get(self, "acl_ids")

    @property
    @pulumi.getter(name="aclStatus")
    def acl_status(self) -> pulumi.Output[Optional[str]]:
        """
        The enable status of Acl. Optional choice contains `on`, `off`. Default is `off`.
        """
        return pulumi.get(self, "acl_status")

    @property
    @pulumi.getter(name="aclType")
    def acl_type(self) -> pulumi.Output[str]:
        """
        The type of the Acl. Optional choice contains `white`, `black`. When the AclStatus parameter is configured as on, AclType and AclIds.N are required.
        """
        return pulumi.get(self, "acl_type")

    @property
    @pulumi.getter(name="caCertificateId")
    def ca_certificate_id(self) -> pulumi.Output[Optional[str]]:
        """
        The CA certificate id associated with the listener.
        """
        return pulumi.get(self, "ca_certificate_id")

    @property
    @pulumi.getter(name="certificateId")
    def certificate_id(self) -> pulumi.Output[Optional[str]]:
        """
        The certificate id associated with the listener.
        """
        return pulumi.get(self, "certificate_id")

    @property
    @pulumi.getter(name="customizedCfgId")
    def customized_cfg_id(self) -> pulumi.Output[Optional[str]]:
        """
        Personalized configuration ID, with a value of " " when not bound.
        """
        return pulumi.get(self, "customized_cfg_id")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        The description of the Listener.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="enableHttp2")
    def enable_http2(self) -> pulumi.Output[Optional[str]]:
        """
        The HTTP2 feature switch,valid value is on or off. Default is `off`.
        """
        return pulumi.get(self, "enable_http2")

    @property
    @pulumi.getter(name="enableQuic")
    def enable_quic(self) -> pulumi.Output[Optional[str]]:
        """
        The QUIC feature switch,valid value is on or off. Default is `off`.
        """
        return pulumi.get(self, "enable_quic")

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[Optional[str]]:
        """
        The enable status of the Listener. Optional choice contains `on`, `off`. Default is `on`.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="listenerId")
    def listener_id(self) -> pulumi.Output[str]:
        """
        The ID of the Listener.
        """
        return pulumi.get(self, "listener_id")

    @property
    @pulumi.getter(name="listenerName")
    def listener_name(self) -> pulumi.Output[str]:
        """
        The name of the Listener.
        """
        return pulumi.get(self, "listener_name")

    @property
    @pulumi.getter(name="loadBalancerId")
    def load_balancer_id(self) -> pulumi.Output[str]:
        """
        The Id of the load balancer.
        """
        return pulumi.get(self, "load_balancer_id")

    @property
    @pulumi.getter
    def port(self) -> pulumi.Output[int]:
        """
        The port receiving request of the Listener, the value range in 1~65535.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def protocol(self) -> pulumi.Output[str]:
        """
        The protocol of the Listener. Optional choice contains `HTTP`, `HTTPS`.
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="serverGroupId")
    def server_group_id(self) -> pulumi.Output[str]:
        """
        The server group id associated with the listener.
        """
        return pulumi.get(self, "server_group_id")

