# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['ListenerDomainExtensionArgs', 'ListenerDomainExtension']

@pulumi.input_type
class ListenerDomainExtensionArgs:
    def __init__(__self__, *,
                 certificate_id: pulumi.Input[str],
                 domain: pulumi.Input[str],
                 listener_id: pulumi.Input[str]):
        """
        The set of arguments for constructing a ListenerDomainExtension resource.
        :param pulumi.Input[str] certificate_id: Server certificate used for the domain name.
        :param pulumi.Input[str] domain: The domain name. The maximum number of associated domain names for an HTTPS listener is 20, with a value range of 1 to 20.
        :param pulumi.Input[str] listener_id: The listener id. Only HTTPS listener is effective.
        """
        pulumi.set(__self__, "certificate_id", certificate_id)
        pulumi.set(__self__, "domain", domain)
        pulumi.set(__self__, "listener_id", listener_id)

    @property
    @pulumi.getter(name="certificateId")
    def certificate_id(self) -> pulumi.Input[str]:
        """
        Server certificate used for the domain name.
        """
        return pulumi.get(self, "certificate_id")

    @certificate_id.setter
    def certificate_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "certificate_id", value)

    @property
    @pulumi.getter
    def domain(self) -> pulumi.Input[str]:
        """
        The domain name. The maximum number of associated domain names for an HTTPS listener is 20, with a value range of 1 to 20.
        """
        return pulumi.get(self, "domain")

    @domain.setter
    def domain(self, value: pulumi.Input[str]):
        pulumi.set(self, "domain", value)

    @property
    @pulumi.getter(name="listenerId")
    def listener_id(self) -> pulumi.Input[str]:
        """
        The listener id. Only HTTPS listener is effective.
        """
        return pulumi.get(self, "listener_id")

    @listener_id.setter
    def listener_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "listener_id", value)


@pulumi.input_type
class _ListenerDomainExtensionState:
    def __init__(__self__, *,
                 certificate_id: Optional[pulumi.Input[str]] = None,
                 domain: Optional[pulumi.Input[str]] = None,
                 domain_extension_id: Optional[pulumi.Input[str]] = None,
                 listener_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering ListenerDomainExtension resources.
        :param pulumi.Input[str] certificate_id: Server certificate used for the domain name.
        :param pulumi.Input[str] domain: The domain name. The maximum number of associated domain names for an HTTPS listener is 20, with a value range of 1 to 20.
        :param pulumi.Input[str] domain_extension_id: The id of the domain extension.
        :param pulumi.Input[str] listener_id: The listener id. Only HTTPS listener is effective.
        """
        if certificate_id is not None:
            pulumi.set(__self__, "certificate_id", certificate_id)
        if domain is not None:
            pulumi.set(__self__, "domain", domain)
        if domain_extension_id is not None:
            pulumi.set(__self__, "domain_extension_id", domain_extension_id)
        if listener_id is not None:
            pulumi.set(__self__, "listener_id", listener_id)

    @property
    @pulumi.getter(name="certificateId")
    def certificate_id(self) -> Optional[pulumi.Input[str]]:
        """
        Server certificate used for the domain name.
        """
        return pulumi.get(self, "certificate_id")

    @certificate_id.setter
    def certificate_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "certificate_id", value)

    @property
    @pulumi.getter
    def domain(self) -> Optional[pulumi.Input[str]]:
        """
        The domain name. The maximum number of associated domain names for an HTTPS listener is 20, with a value range of 1 to 20.
        """
        return pulumi.get(self, "domain")

    @domain.setter
    def domain(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "domain", value)

    @property
    @pulumi.getter(name="domainExtensionId")
    def domain_extension_id(self) -> Optional[pulumi.Input[str]]:
        """
        The id of the domain extension.
        """
        return pulumi.get(self, "domain_extension_id")

    @domain_extension_id.setter
    def domain_extension_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "domain_extension_id", value)

    @property
    @pulumi.getter(name="listenerId")
    def listener_id(self) -> Optional[pulumi.Input[str]]:
        """
        The listener id. Only HTTPS listener is effective.
        """
        return pulumi.get(self, "listener_id")

    @listener_id.setter
    def listener_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "listener_id", value)


class ListenerDomainExtension(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 certificate_id: Optional[pulumi.Input[str]] = None,
                 domain: Optional[pulumi.Input[str]] = None,
                 listener_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a resource to manage alb listener domain extension
        ## Example Usage

        ```python
        import pulumi
        import pulumi_volcengine as volcengine

        foo_listener = volcengine.alb.Listener("fooListener",
            load_balancer_id="alb-1iidd17v3klj474adhfrunyz9",
            listener_name="acc-test-listener-1",
            protocol="HTTPS",
            port=6666,
            enabled="on",
            certificate_id="cert-1iidd2pahdyio74adhfr9ajwg",
            ca_certificate_id="cert-1iidd2r9ii0hs74adhfeodxo1",
            server_group_id="rsp-1g72w74y4umf42zbhq4k4hnln",
            enable_http2="on",
            enable_quic="off",
            acl_status="on",
            acl_type="white",
            acl_ids=["acl-1g72w6z11ighs2zbhq4v3rvh4"],
            description="acc test listener")
        foo_listener_domain_extension = volcengine.alb.ListenerDomainExtension("fooListenerDomainExtension",
            listener_id=foo_listener.id,
            domain="test-modify.com",
            certificate_id="cert-1iidd2pahdyio74adhfr9ajwg")
        ```

        ## Import

        AlbListenerDomainExtension can be imported using the listener id and domain extension id, e.g.

        ```sh
         $ pulumi import volcengine:alb/listenerDomainExtension:ListenerDomainExtension default listenerId:extensionId
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] certificate_id: Server certificate used for the domain name.
        :param pulumi.Input[str] domain: The domain name. The maximum number of associated domain names for an HTTPS listener is 20, with a value range of 1 to 20.
        :param pulumi.Input[str] listener_id: The listener id. Only HTTPS listener is effective.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ListenerDomainExtensionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a resource to manage alb listener domain extension
        ## Example Usage

        ```python
        import pulumi
        import pulumi_volcengine as volcengine

        foo_listener = volcengine.alb.Listener("fooListener",
            load_balancer_id="alb-1iidd17v3klj474adhfrunyz9",
            listener_name="acc-test-listener-1",
            protocol="HTTPS",
            port=6666,
            enabled="on",
            certificate_id="cert-1iidd2pahdyio74adhfr9ajwg",
            ca_certificate_id="cert-1iidd2r9ii0hs74adhfeodxo1",
            server_group_id="rsp-1g72w74y4umf42zbhq4k4hnln",
            enable_http2="on",
            enable_quic="off",
            acl_status="on",
            acl_type="white",
            acl_ids=["acl-1g72w6z11ighs2zbhq4v3rvh4"],
            description="acc test listener")
        foo_listener_domain_extension = volcengine.alb.ListenerDomainExtension("fooListenerDomainExtension",
            listener_id=foo_listener.id,
            domain="test-modify.com",
            certificate_id="cert-1iidd2pahdyio74adhfr9ajwg")
        ```

        ## Import

        AlbListenerDomainExtension can be imported using the listener id and domain extension id, e.g.

        ```sh
         $ pulumi import volcengine:alb/listenerDomainExtension:ListenerDomainExtension default listenerId:extensionId
        ```

        :param str resource_name: The name of the resource.
        :param ListenerDomainExtensionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ListenerDomainExtensionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 certificate_id: Optional[pulumi.Input[str]] = None,
                 domain: Optional[pulumi.Input[str]] = None,
                 listener_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ListenerDomainExtensionArgs.__new__(ListenerDomainExtensionArgs)

            if certificate_id is None and not opts.urn:
                raise TypeError("Missing required property 'certificate_id'")
            __props__.__dict__["certificate_id"] = certificate_id
            if domain is None and not opts.urn:
                raise TypeError("Missing required property 'domain'")
            __props__.__dict__["domain"] = domain
            if listener_id is None and not opts.urn:
                raise TypeError("Missing required property 'listener_id'")
            __props__.__dict__["listener_id"] = listener_id
            __props__.__dict__["domain_extension_id"] = None
        super(ListenerDomainExtension, __self__).__init__(
            'volcengine:alb/listenerDomainExtension:ListenerDomainExtension',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            certificate_id: Optional[pulumi.Input[str]] = None,
            domain: Optional[pulumi.Input[str]] = None,
            domain_extension_id: Optional[pulumi.Input[str]] = None,
            listener_id: Optional[pulumi.Input[str]] = None) -> 'ListenerDomainExtension':
        """
        Get an existing ListenerDomainExtension resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] certificate_id: Server certificate used for the domain name.
        :param pulumi.Input[str] domain: The domain name. The maximum number of associated domain names for an HTTPS listener is 20, with a value range of 1 to 20.
        :param pulumi.Input[str] domain_extension_id: The id of the domain extension.
        :param pulumi.Input[str] listener_id: The listener id. Only HTTPS listener is effective.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ListenerDomainExtensionState.__new__(_ListenerDomainExtensionState)

        __props__.__dict__["certificate_id"] = certificate_id
        __props__.__dict__["domain"] = domain
        __props__.__dict__["domain_extension_id"] = domain_extension_id
        __props__.__dict__["listener_id"] = listener_id
        return ListenerDomainExtension(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="certificateId")
    def certificate_id(self) -> pulumi.Output[str]:
        """
        Server certificate used for the domain name.
        """
        return pulumi.get(self, "certificate_id")

    @property
    @pulumi.getter
    def domain(self) -> pulumi.Output[str]:
        """
        The domain name. The maximum number of associated domain names for an HTTPS listener is 20, with a value range of 1 to 20.
        """
        return pulumi.get(self, "domain")

    @property
    @pulumi.getter(name="domainExtensionId")
    def domain_extension_id(self) -> pulumi.Output[str]:
        """
        The id of the domain extension.
        """
        return pulumi.get(self, "domain_extension_id")

    @property
    @pulumi.getter(name="listenerId")
    def listener_id(self) -> pulumi.Output[str]:
        """
        The listener id. Only HTTPS listener is effective.
        """
        return pulumi.get(self, "listener_id")

