# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'ListenerDomainExtensionsResult',
    'AwaitableListenerDomainExtensionsResult',
    'listener_domain_extensions',
    'listener_domain_extensions_output',
]

@pulumi.output_type
class ListenerDomainExtensionsResult:
    """
    A collection of values returned by ListenerDomainExtensions.
    """
    def __init__(__self__, domain_extensions=None, id=None, listener_id=None, output_file=None, total_count=None):
        if domain_extensions and not isinstance(domain_extensions, list):
            raise TypeError("Expected argument 'domain_extensions' to be a list")
        pulumi.set(__self__, "domain_extensions", domain_extensions)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if listener_id and not isinstance(listener_id, str):
            raise TypeError("Expected argument 'listener_id' to be a str")
        pulumi.set(__self__, "listener_id", listener_id)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if total_count and not isinstance(total_count, int):
            raise TypeError("Expected argument 'total_count' to be a int")
        pulumi.set(__self__, "total_count", total_count)

    @property
    @pulumi.getter(name="domainExtensions")
    def domain_extensions(self) -> Sequence['outputs.ListenerDomainExtensionsDomainExtensionResult']:
        """
        The collection of domain extensions query.
        """
        return pulumi.get(self, "domain_extensions")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="listenerId")
    def listener_id(self) -> str:
        """
        The listener ID that domain belongs to.
        """
        return pulumi.get(self, "listener_id")

    @property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[str]:
        return pulumi.get(self, "output_file")

    @property
    @pulumi.getter(name="totalCount")
    def total_count(self) -> int:
        """
        The total count of Listener query.
        """
        return pulumi.get(self, "total_count")


class AwaitableListenerDomainExtensionsResult(ListenerDomainExtensionsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return ListenerDomainExtensionsResult(
            domain_extensions=self.domain_extensions,
            id=self.id,
            listener_id=self.listener_id,
            output_file=self.output_file,
            total_count=self.total_count)


def listener_domain_extensions(listener_id: Optional[str] = None,
                               output_file: Optional[str] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableListenerDomainExtensionsResult:
    """
    Use this data source to query detailed information of alb listener domain extensions
    ## Example Usage

    ```python
    import pulumi
    import pulumi_volcengine as volcengine

    foo = volcengine.alb.listener_domain_extensions(listener_id="lsn-1g72yeyhrrj7k2zbhq5gp6xch")
    ```


    :param str listener_id: A Listener ID.
    :param str output_file: File name where to save data source results.
    """
    __args__ = dict()
    __args__['listenerId'] = listener_id
    __args__['outputFile'] = output_file
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('volcengine:alb/listenerDomainExtensions:ListenerDomainExtensions', __args__, opts=opts, typ=ListenerDomainExtensionsResult).value

    return AwaitableListenerDomainExtensionsResult(
        domain_extensions=pulumi.get(__ret__, 'domain_extensions'),
        id=pulumi.get(__ret__, 'id'),
        listener_id=pulumi.get(__ret__, 'listener_id'),
        output_file=pulumi.get(__ret__, 'output_file'),
        total_count=pulumi.get(__ret__, 'total_count'))


@_utilities.lift_output_func(listener_domain_extensions)
def listener_domain_extensions_output(listener_id: Optional[pulumi.Input[str]] = None,
                                      output_file: Optional[pulumi.Input[Optional[str]]] = None,
                                      opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[ListenerDomainExtensionsResult]:
    """
    Use this data source to query detailed information of alb listener domain extensions
    ## Example Usage

    ```python
    import pulumi
    import pulumi_volcengine as volcengine

    foo = volcengine.alb.listener_domain_extensions(listener_id="lsn-1g72yeyhrrj7k2zbhq5gp6xch")
    ```


    :param str listener_id: A Listener ID.
    :param str output_file: File name where to save data source results.
    """
    ...
