# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'ListenersResult',
    'AwaitableListenersResult',
    'listeners',
    'listeners_output',
]

@pulumi.output_type
class ListenersResult:
    """
    A collection of values returned by Listeners.
    """
    def __init__(__self__, id=None, ids=None, listener_name=None, listeners=None, load_balancer_id=None, name_regex=None, output_file=None, project_name=None, total_count=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if listener_name and not isinstance(listener_name, str):
            raise TypeError("Expected argument 'listener_name' to be a str")
        pulumi.set(__self__, "listener_name", listener_name)
        if listeners and not isinstance(listeners, list):
            raise TypeError("Expected argument 'listeners' to be a list")
        pulumi.set(__self__, "listeners", listeners)
        if load_balancer_id and not isinstance(load_balancer_id, str):
            raise TypeError("Expected argument 'load_balancer_id' to be a str")
        pulumi.set(__self__, "load_balancer_id", load_balancer_id)
        if name_regex and not isinstance(name_regex, str):
            raise TypeError("Expected argument 'name_regex' to be a str")
        pulumi.set(__self__, "name_regex", name_regex)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if project_name and not isinstance(project_name, str):
            raise TypeError("Expected argument 'project_name' to be a str")
        pulumi.set(__self__, "project_name", project_name)
        if total_count and not isinstance(total_count, int):
            raise TypeError("Expected argument 'total_count' to be a int")
        pulumi.set(__self__, "total_count", total_count)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def ids(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "ids")

    @property
    @pulumi.getter(name="listenerName")
    def listener_name(self) -> Optional[str]:
        """
        The name of the Listener.
        """
        return pulumi.get(self, "listener_name")

    @property
    @pulumi.getter
    def listeners(self) -> Sequence['outputs.ListenersListenerResult']:
        """
        The collection of Listener query.
        """
        return pulumi.get(self, "listeners")

    @property
    @pulumi.getter(name="loadBalancerId")
    def load_balancer_id(self) -> Optional[str]:
        """
        The load balancer ID that the listener belongs to.
        """
        return pulumi.get(self, "load_balancer_id")

    @property
    @pulumi.getter(name="nameRegex")
    def name_regex(self) -> Optional[str]:
        return pulumi.get(self, "name_regex")

    @property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[str]:
        return pulumi.get(self, "output_file")

    @property
    @pulumi.getter(name="projectName")
    def project_name(self) -> Optional[str]:
        """
        The project name of the listener.
        """
        return pulumi.get(self, "project_name")

    @property
    @pulumi.getter(name="totalCount")
    def total_count(self) -> int:
        """
        The total count of Listener query.
        """
        return pulumi.get(self, "total_count")


class AwaitableListenersResult(ListenersResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return ListenersResult(
            id=self.id,
            ids=self.ids,
            listener_name=self.listener_name,
            listeners=self.listeners,
            load_balancer_id=self.load_balancer_id,
            name_regex=self.name_regex,
            output_file=self.output_file,
            project_name=self.project_name,
            total_count=self.total_count)


def listeners(ids: Optional[Sequence[str]] = None,
              listener_name: Optional[str] = None,
              load_balancer_id: Optional[str] = None,
              name_regex: Optional[str] = None,
              output_file: Optional[str] = None,
              project_name: Optional[str] = None,
              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableListenersResult:
    """
    Use this data source to query detailed information of alb listeners


    :param Sequence[str] ids: A list of Listener IDs.
    :param str listener_name: The name of the Listener.
    :param str load_balancer_id: The id of the Alb.
    :param str name_regex: A Name Regex of Listener.
    :param str output_file: File name where to save data source results.
    :param str project_name: The project name of the listener.
    """
    __args__ = dict()
    __args__['ids'] = ids
    __args__['listenerName'] = listener_name
    __args__['loadBalancerId'] = load_balancer_id
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    __args__['projectName'] = project_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('volcengine:alb/listeners:Listeners', __args__, opts=opts, typ=ListenersResult).value

    return AwaitableListenersResult(
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        listener_name=pulumi.get(__ret__, 'listener_name'),
        listeners=pulumi.get(__ret__, 'listeners'),
        load_balancer_id=pulumi.get(__ret__, 'load_balancer_id'),
        name_regex=pulumi.get(__ret__, 'name_regex'),
        output_file=pulumi.get(__ret__, 'output_file'),
        project_name=pulumi.get(__ret__, 'project_name'),
        total_count=pulumi.get(__ret__, 'total_count'))


@_utilities.lift_output_func(listeners)
def listeners_output(ids: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                     listener_name: Optional[pulumi.Input[Optional[str]]] = None,
                     load_balancer_id: Optional[pulumi.Input[Optional[str]]] = None,
                     name_regex: Optional[pulumi.Input[Optional[str]]] = None,
                     output_file: Optional[pulumi.Input[Optional[str]]] = None,
                     project_name: Optional[pulumi.Input[Optional[str]]] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[ListenersResult]:
    """
    Use this data source to query detailed information of alb listeners


    :param Sequence[str] ids: A list of Listener IDs.
    :param str listener_name: The name of the Listener.
    :param str load_balancer_id: The id of the Alb.
    :param str name_regex: A Name Regex of Listener.
    :param str output_file: File name where to save data source results.
    :param str project_name: The project name of the listener.
    """
    ...
