# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['RuleArgs', 'Rule']

@pulumi.input_type
class RuleArgs:
    def __init__(__self__, *,
                 listener_id: pulumi.Input[str],
                 rule_action: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None,
                 domain: Optional[pulumi.Input[str]] = None,
                 redirect_config: Optional[pulumi.Input['RuleRedirectConfigArgs']] = None,
                 rewrite_config: Optional[pulumi.Input['RuleRewriteConfigArgs']] = None,
                 rewrite_enabled: Optional[pulumi.Input[str]] = None,
                 server_group_id: Optional[pulumi.Input[str]] = None,
                 traffic_limit_enabled: Optional[pulumi.Input[str]] = None,
                 traffic_limit_qps: Optional[pulumi.Input[int]] = None,
                 url: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Rule resource.
        :param pulumi.Input[str] listener_id: The ID of listener.
        :param pulumi.Input[str] rule_action: The forwarding rule action, if this parameter is empty(`""`), forward to server group, if value is `Redirect`, will redirect.
        :param pulumi.Input[str] description: The description of the Rule.
        :param pulumi.Input[str] domain: The domain of Rule.
        :param pulumi.Input['RuleRedirectConfigArgs'] redirect_config: The redirect related configuration.
        :param pulumi.Input['RuleRewriteConfigArgs'] rewrite_config: The list of rewrite configurations.
        :param pulumi.Input[str] rewrite_enabled: Rewrite configuration switch for forwarding rules, only allows configuration and takes effect when RuleAction is empty (i.e., forwarding to server group). Only available for whitelist users, please submit an application to experience. Supported values are as follows:
               on: enable.
               off: disable.
        :param pulumi.Input[str] server_group_id: Server group ID, this parameter is required if `rule_action` is empty.
        :param pulumi.Input[str] traffic_limit_enabled: Forwarding rule QPS rate limiting switch:
               on: enable.
               off: disable (default).
        :param pulumi.Input[int] traffic_limit_qps: When Rules.N.TrafficLimitEnabled is turned on, this field is required. Requests per second. Valid values are between 100 and 100000.
        :param pulumi.Input[str] url: The Url of Rule.
        """
        pulumi.set(__self__, "listener_id", listener_id)
        pulumi.set(__self__, "rule_action", rule_action)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if domain is not None:
            pulumi.set(__self__, "domain", domain)
        if redirect_config is not None:
            pulumi.set(__self__, "redirect_config", redirect_config)
        if rewrite_config is not None:
            pulumi.set(__self__, "rewrite_config", rewrite_config)
        if rewrite_enabled is not None:
            pulumi.set(__self__, "rewrite_enabled", rewrite_enabled)
        if server_group_id is not None:
            pulumi.set(__self__, "server_group_id", server_group_id)
        if traffic_limit_enabled is not None:
            pulumi.set(__self__, "traffic_limit_enabled", traffic_limit_enabled)
        if traffic_limit_qps is not None:
            pulumi.set(__self__, "traffic_limit_qps", traffic_limit_qps)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter(name="listenerId")
    def listener_id(self) -> pulumi.Input[str]:
        """
        The ID of listener.
        """
        return pulumi.get(self, "listener_id")

    @listener_id.setter
    def listener_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "listener_id", value)

    @property
    @pulumi.getter(name="ruleAction")
    def rule_action(self) -> pulumi.Input[str]:
        """
        The forwarding rule action, if this parameter is empty(`""`), forward to server group, if value is `Redirect`, will redirect.
        """
        return pulumi.get(self, "rule_action")

    @rule_action.setter
    def rule_action(self, value: pulumi.Input[str]):
        pulumi.set(self, "rule_action", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the Rule.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def domain(self) -> Optional[pulumi.Input[str]]:
        """
        The domain of Rule.
        """
        return pulumi.get(self, "domain")

    @domain.setter
    def domain(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "domain", value)

    @property
    @pulumi.getter(name="redirectConfig")
    def redirect_config(self) -> Optional[pulumi.Input['RuleRedirectConfigArgs']]:
        """
        The redirect related configuration.
        """
        return pulumi.get(self, "redirect_config")

    @redirect_config.setter
    def redirect_config(self, value: Optional[pulumi.Input['RuleRedirectConfigArgs']]):
        pulumi.set(self, "redirect_config", value)

    @property
    @pulumi.getter(name="rewriteConfig")
    def rewrite_config(self) -> Optional[pulumi.Input['RuleRewriteConfigArgs']]:
        """
        The list of rewrite configurations.
        """
        return pulumi.get(self, "rewrite_config")

    @rewrite_config.setter
    def rewrite_config(self, value: Optional[pulumi.Input['RuleRewriteConfigArgs']]):
        pulumi.set(self, "rewrite_config", value)

    @property
    @pulumi.getter(name="rewriteEnabled")
    def rewrite_enabled(self) -> Optional[pulumi.Input[str]]:
        """
        Rewrite configuration switch for forwarding rules, only allows configuration and takes effect when RuleAction is empty (i.e., forwarding to server group). Only available for whitelist users, please submit an application to experience. Supported values are as follows:
        on: enable.
        off: disable.
        """
        return pulumi.get(self, "rewrite_enabled")

    @rewrite_enabled.setter
    def rewrite_enabled(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "rewrite_enabled", value)

    @property
    @pulumi.getter(name="serverGroupId")
    def server_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        Server group ID, this parameter is required if `rule_action` is empty.
        """
        return pulumi.get(self, "server_group_id")

    @server_group_id.setter
    def server_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "server_group_id", value)

    @property
    @pulumi.getter(name="trafficLimitEnabled")
    def traffic_limit_enabled(self) -> Optional[pulumi.Input[str]]:
        """
        Forwarding rule QPS rate limiting switch:
        on: enable.
        off: disable (default).
        """
        return pulumi.get(self, "traffic_limit_enabled")

    @traffic_limit_enabled.setter
    def traffic_limit_enabled(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "traffic_limit_enabled", value)

    @property
    @pulumi.getter(name="trafficLimitQps")
    def traffic_limit_qps(self) -> Optional[pulumi.Input[int]]:
        """
        When Rules.N.TrafficLimitEnabled is turned on, this field is required. Requests per second. Valid values are between 100 and 100000.
        """
        return pulumi.get(self, "traffic_limit_qps")

    @traffic_limit_qps.setter
    def traffic_limit_qps(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "traffic_limit_qps", value)

    @property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[str]]:
        """
        The Url of Rule.
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "url", value)


@pulumi.input_type
class _RuleState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 domain: Optional[pulumi.Input[str]] = None,
                 listener_id: Optional[pulumi.Input[str]] = None,
                 redirect_config: Optional[pulumi.Input['RuleRedirectConfigArgs']] = None,
                 rewrite_config: Optional[pulumi.Input['RuleRewriteConfigArgs']] = None,
                 rewrite_enabled: Optional[pulumi.Input[str]] = None,
                 rule_action: Optional[pulumi.Input[str]] = None,
                 rule_id: Optional[pulumi.Input[str]] = None,
                 server_group_id: Optional[pulumi.Input[str]] = None,
                 traffic_limit_enabled: Optional[pulumi.Input[str]] = None,
                 traffic_limit_qps: Optional[pulumi.Input[int]] = None,
                 url: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Rule resources.
        :param pulumi.Input[str] description: The description of the Rule.
        :param pulumi.Input[str] domain: The domain of Rule.
        :param pulumi.Input[str] listener_id: The ID of listener.
        :param pulumi.Input['RuleRedirectConfigArgs'] redirect_config: The redirect related configuration.
        :param pulumi.Input['RuleRewriteConfigArgs'] rewrite_config: The list of rewrite configurations.
        :param pulumi.Input[str] rewrite_enabled: Rewrite configuration switch for forwarding rules, only allows configuration and takes effect when RuleAction is empty (i.e., forwarding to server group). Only available for whitelist users, please submit an application to experience. Supported values are as follows:
               on: enable.
               off: disable.
        :param pulumi.Input[str] rule_action: The forwarding rule action, if this parameter is empty(`""`), forward to server group, if value is `Redirect`, will redirect.
        :param pulumi.Input[str] rule_id: The ID of rule.
        :param pulumi.Input[str] server_group_id: Server group ID, this parameter is required if `rule_action` is empty.
        :param pulumi.Input[str] traffic_limit_enabled: Forwarding rule QPS rate limiting switch:
               on: enable.
               off: disable (default).
        :param pulumi.Input[int] traffic_limit_qps: When Rules.N.TrafficLimitEnabled is turned on, this field is required. Requests per second. Valid values are between 100 and 100000.
        :param pulumi.Input[str] url: The Url of Rule.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if domain is not None:
            pulumi.set(__self__, "domain", domain)
        if listener_id is not None:
            pulumi.set(__self__, "listener_id", listener_id)
        if redirect_config is not None:
            pulumi.set(__self__, "redirect_config", redirect_config)
        if rewrite_config is not None:
            pulumi.set(__self__, "rewrite_config", rewrite_config)
        if rewrite_enabled is not None:
            pulumi.set(__self__, "rewrite_enabled", rewrite_enabled)
        if rule_action is not None:
            pulumi.set(__self__, "rule_action", rule_action)
        if rule_id is not None:
            pulumi.set(__self__, "rule_id", rule_id)
        if server_group_id is not None:
            pulumi.set(__self__, "server_group_id", server_group_id)
        if traffic_limit_enabled is not None:
            pulumi.set(__self__, "traffic_limit_enabled", traffic_limit_enabled)
        if traffic_limit_qps is not None:
            pulumi.set(__self__, "traffic_limit_qps", traffic_limit_qps)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the Rule.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def domain(self) -> Optional[pulumi.Input[str]]:
        """
        The domain of Rule.
        """
        return pulumi.get(self, "domain")

    @domain.setter
    def domain(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "domain", value)

    @property
    @pulumi.getter(name="listenerId")
    def listener_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of listener.
        """
        return pulumi.get(self, "listener_id")

    @listener_id.setter
    def listener_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "listener_id", value)

    @property
    @pulumi.getter(name="redirectConfig")
    def redirect_config(self) -> Optional[pulumi.Input['RuleRedirectConfigArgs']]:
        """
        The redirect related configuration.
        """
        return pulumi.get(self, "redirect_config")

    @redirect_config.setter
    def redirect_config(self, value: Optional[pulumi.Input['RuleRedirectConfigArgs']]):
        pulumi.set(self, "redirect_config", value)

    @property
    @pulumi.getter(name="rewriteConfig")
    def rewrite_config(self) -> Optional[pulumi.Input['RuleRewriteConfigArgs']]:
        """
        The list of rewrite configurations.
        """
        return pulumi.get(self, "rewrite_config")

    @rewrite_config.setter
    def rewrite_config(self, value: Optional[pulumi.Input['RuleRewriteConfigArgs']]):
        pulumi.set(self, "rewrite_config", value)

    @property
    @pulumi.getter(name="rewriteEnabled")
    def rewrite_enabled(self) -> Optional[pulumi.Input[str]]:
        """
        Rewrite configuration switch for forwarding rules, only allows configuration and takes effect when RuleAction is empty (i.e., forwarding to server group). Only available for whitelist users, please submit an application to experience. Supported values are as follows:
        on: enable.
        off: disable.
        """
        return pulumi.get(self, "rewrite_enabled")

    @rewrite_enabled.setter
    def rewrite_enabled(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "rewrite_enabled", value)

    @property
    @pulumi.getter(name="ruleAction")
    def rule_action(self) -> Optional[pulumi.Input[str]]:
        """
        The forwarding rule action, if this parameter is empty(`""`), forward to server group, if value is `Redirect`, will redirect.
        """
        return pulumi.get(self, "rule_action")

    @rule_action.setter
    def rule_action(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "rule_action", value)

    @property
    @pulumi.getter(name="ruleId")
    def rule_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of rule.
        """
        return pulumi.get(self, "rule_id")

    @rule_id.setter
    def rule_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "rule_id", value)

    @property
    @pulumi.getter(name="serverGroupId")
    def server_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        Server group ID, this parameter is required if `rule_action` is empty.
        """
        return pulumi.get(self, "server_group_id")

    @server_group_id.setter
    def server_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "server_group_id", value)

    @property
    @pulumi.getter(name="trafficLimitEnabled")
    def traffic_limit_enabled(self) -> Optional[pulumi.Input[str]]:
        """
        Forwarding rule QPS rate limiting switch:
        on: enable.
        off: disable (default).
        """
        return pulumi.get(self, "traffic_limit_enabled")

    @traffic_limit_enabled.setter
    def traffic_limit_enabled(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "traffic_limit_enabled", value)

    @property
    @pulumi.getter(name="trafficLimitQps")
    def traffic_limit_qps(self) -> Optional[pulumi.Input[int]]:
        """
        When Rules.N.TrafficLimitEnabled is turned on, this field is required. Requests per second. Valid values are between 100 and 100000.
        """
        return pulumi.get(self, "traffic_limit_qps")

    @traffic_limit_qps.setter
    def traffic_limit_qps(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "traffic_limit_qps", value)

    @property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[str]]:
        """
        The Url of Rule.
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "url", value)


class Rule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 domain: Optional[pulumi.Input[str]] = None,
                 listener_id: Optional[pulumi.Input[str]] = None,
                 redirect_config: Optional[pulumi.Input[pulumi.InputType['RuleRedirectConfigArgs']]] = None,
                 rewrite_config: Optional[pulumi.Input[pulumi.InputType['RuleRewriteConfigArgs']]] = None,
                 rewrite_enabled: Optional[pulumi.Input[str]] = None,
                 rule_action: Optional[pulumi.Input[str]] = None,
                 server_group_id: Optional[pulumi.Input[str]] = None,
                 traffic_limit_enabled: Optional[pulumi.Input[str]] = None,
                 traffic_limit_qps: Optional[pulumi.Input[int]] = None,
                 url: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a resource to manage alb rule
        ## Example Usage

        ```python
        import pulumi
        import pulumi_volcengine as volcengine

        foo = volcengine.alb.Rule("foo",
            description="test",
            domain="www.test.com",
            listener_id="lsn-1iidd19u4oni874adhezjkyj3",
            redirect_config=volcengine.alb.RuleRedirectConfigArgs(
                redirect_domain="www.testtest.com",
                redirect_http_code="302",
                redirect_port="555",
                redirect_uri="/testtest",
            ),
            rewrite_config=volcengine.alb.RuleRewriteConfigArgs(
                rewrite_path="/test",
            ),
            rewrite_enabled="off",
            rule_action="Redirect",
            server_group_id="rsp-1g72w74y4umf42zbhq4k4hnln",
            traffic_limit_enabled="off",
            traffic_limit_qps=100,
            url="/test")
        ```

        ## Import

        AlbRule can be imported using the listener id and rule id, e.g.

        ```sh
         $ pulumi import volcengine:alb/rule:Rule default lsn-273yv0mhs5xj47fap8sehiiso:rule-****
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: The description of the Rule.
        :param pulumi.Input[str] domain: The domain of Rule.
        :param pulumi.Input[str] listener_id: The ID of listener.
        :param pulumi.Input[pulumi.InputType['RuleRedirectConfigArgs']] redirect_config: The redirect related configuration.
        :param pulumi.Input[pulumi.InputType['RuleRewriteConfigArgs']] rewrite_config: The list of rewrite configurations.
        :param pulumi.Input[str] rewrite_enabled: Rewrite configuration switch for forwarding rules, only allows configuration and takes effect when RuleAction is empty (i.e., forwarding to server group). Only available for whitelist users, please submit an application to experience. Supported values are as follows:
               on: enable.
               off: disable.
        :param pulumi.Input[str] rule_action: The forwarding rule action, if this parameter is empty(`""`), forward to server group, if value is `Redirect`, will redirect.
        :param pulumi.Input[str] server_group_id: Server group ID, this parameter is required if `rule_action` is empty.
        :param pulumi.Input[str] traffic_limit_enabled: Forwarding rule QPS rate limiting switch:
               on: enable.
               off: disable (default).
        :param pulumi.Input[int] traffic_limit_qps: When Rules.N.TrafficLimitEnabled is turned on, this field is required. Requests per second. Valid values are between 100 and 100000.
        :param pulumi.Input[str] url: The Url of Rule.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RuleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a resource to manage alb rule
        ## Example Usage

        ```python
        import pulumi
        import pulumi_volcengine as volcengine

        foo = volcengine.alb.Rule("foo",
            description="test",
            domain="www.test.com",
            listener_id="lsn-1iidd19u4oni874adhezjkyj3",
            redirect_config=volcengine.alb.RuleRedirectConfigArgs(
                redirect_domain="www.testtest.com",
                redirect_http_code="302",
                redirect_port="555",
                redirect_uri="/testtest",
            ),
            rewrite_config=volcengine.alb.RuleRewriteConfigArgs(
                rewrite_path="/test",
            ),
            rewrite_enabled="off",
            rule_action="Redirect",
            server_group_id="rsp-1g72w74y4umf42zbhq4k4hnln",
            traffic_limit_enabled="off",
            traffic_limit_qps=100,
            url="/test")
        ```

        ## Import

        AlbRule can be imported using the listener id and rule id, e.g.

        ```sh
         $ pulumi import volcengine:alb/rule:Rule default lsn-273yv0mhs5xj47fap8sehiiso:rule-****
        ```

        :param str resource_name: The name of the resource.
        :param RuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 domain: Optional[pulumi.Input[str]] = None,
                 listener_id: Optional[pulumi.Input[str]] = None,
                 redirect_config: Optional[pulumi.Input[pulumi.InputType['RuleRedirectConfigArgs']]] = None,
                 rewrite_config: Optional[pulumi.Input[pulumi.InputType['RuleRewriteConfigArgs']]] = None,
                 rewrite_enabled: Optional[pulumi.Input[str]] = None,
                 rule_action: Optional[pulumi.Input[str]] = None,
                 server_group_id: Optional[pulumi.Input[str]] = None,
                 traffic_limit_enabled: Optional[pulumi.Input[str]] = None,
                 traffic_limit_qps: Optional[pulumi.Input[int]] = None,
                 url: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RuleArgs.__new__(RuleArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["domain"] = domain
            if listener_id is None and not opts.urn:
                raise TypeError("Missing required property 'listener_id'")
            __props__.__dict__["listener_id"] = listener_id
            __props__.__dict__["redirect_config"] = redirect_config
            __props__.__dict__["rewrite_config"] = rewrite_config
            __props__.__dict__["rewrite_enabled"] = rewrite_enabled
            if rule_action is None and not opts.urn:
                raise TypeError("Missing required property 'rule_action'")
            __props__.__dict__["rule_action"] = rule_action
            __props__.__dict__["server_group_id"] = server_group_id
            __props__.__dict__["traffic_limit_enabled"] = traffic_limit_enabled
            __props__.__dict__["traffic_limit_qps"] = traffic_limit_qps
            __props__.__dict__["url"] = url
            __props__.__dict__["rule_id"] = None
        super(Rule, __self__).__init__(
            'volcengine:alb/rule:Rule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[str]] = None,
            domain: Optional[pulumi.Input[str]] = None,
            listener_id: Optional[pulumi.Input[str]] = None,
            redirect_config: Optional[pulumi.Input[pulumi.InputType['RuleRedirectConfigArgs']]] = None,
            rewrite_config: Optional[pulumi.Input[pulumi.InputType['RuleRewriteConfigArgs']]] = None,
            rewrite_enabled: Optional[pulumi.Input[str]] = None,
            rule_action: Optional[pulumi.Input[str]] = None,
            rule_id: Optional[pulumi.Input[str]] = None,
            server_group_id: Optional[pulumi.Input[str]] = None,
            traffic_limit_enabled: Optional[pulumi.Input[str]] = None,
            traffic_limit_qps: Optional[pulumi.Input[int]] = None,
            url: Optional[pulumi.Input[str]] = None) -> 'Rule':
        """
        Get an existing Rule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: The description of the Rule.
        :param pulumi.Input[str] domain: The domain of Rule.
        :param pulumi.Input[str] listener_id: The ID of listener.
        :param pulumi.Input[pulumi.InputType['RuleRedirectConfigArgs']] redirect_config: The redirect related configuration.
        :param pulumi.Input[pulumi.InputType['RuleRewriteConfigArgs']] rewrite_config: The list of rewrite configurations.
        :param pulumi.Input[str] rewrite_enabled: Rewrite configuration switch for forwarding rules, only allows configuration and takes effect when RuleAction is empty (i.e., forwarding to server group). Only available for whitelist users, please submit an application to experience. Supported values are as follows:
               on: enable.
               off: disable.
        :param pulumi.Input[str] rule_action: The forwarding rule action, if this parameter is empty(`""`), forward to server group, if value is `Redirect`, will redirect.
        :param pulumi.Input[str] rule_id: The ID of rule.
        :param pulumi.Input[str] server_group_id: Server group ID, this parameter is required if `rule_action` is empty.
        :param pulumi.Input[str] traffic_limit_enabled: Forwarding rule QPS rate limiting switch:
               on: enable.
               off: disable (default).
        :param pulumi.Input[int] traffic_limit_qps: When Rules.N.TrafficLimitEnabled is turned on, this field is required. Requests per second. Valid values are between 100 and 100000.
        :param pulumi.Input[str] url: The Url of Rule.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RuleState.__new__(_RuleState)

        __props__.__dict__["description"] = description
        __props__.__dict__["domain"] = domain
        __props__.__dict__["listener_id"] = listener_id
        __props__.__dict__["redirect_config"] = redirect_config
        __props__.__dict__["rewrite_config"] = rewrite_config
        __props__.__dict__["rewrite_enabled"] = rewrite_enabled
        __props__.__dict__["rule_action"] = rule_action
        __props__.__dict__["rule_id"] = rule_id
        __props__.__dict__["server_group_id"] = server_group_id
        __props__.__dict__["traffic_limit_enabled"] = traffic_limit_enabled
        __props__.__dict__["traffic_limit_qps"] = traffic_limit_qps
        __props__.__dict__["url"] = url
        return Rule(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        The description of the Rule.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def domain(self) -> pulumi.Output[str]:
        """
        The domain of Rule.
        """
        return pulumi.get(self, "domain")

    @property
    @pulumi.getter(name="listenerId")
    def listener_id(self) -> pulumi.Output[str]:
        """
        The ID of listener.
        """
        return pulumi.get(self, "listener_id")

    @property
    @pulumi.getter(name="redirectConfig")
    def redirect_config(self) -> pulumi.Output[Optional['outputs.RuleRedirectConfig']]:
        """
        The redirect related configuration.
        """
        return pulumi.get(self, "redirect_config")

    @property
    @pulumi.getter(name="rewriteConfig")
    def rewrite_config(self) -> pulumi.Output[Optional['outputs.RuleRewriteConfig']]:
        """
        The list of rewrite configurations.
        """
        return pulumi.get(self, "rewrite_config")

    @property
    @pulumi.getter(name="rewriteEnabled")
    def rewrite_enabled(self) -> pulumi.Output[Optional[str]]:
        """
        Rewrite configuration switch for forwarding rules, only allows configuration and takes effect when RuleAction is empty (i.e., forwarding to server group). Only available for whitelist users, please submit an application to experience. Supported values are as follows:
        on: enable.
        off: disable.
        """
        return pulumi.get(self, "rewrite_enabled")

    @property
    @pulumi.getter(name="ruleAction")
    def rule_action(self) -> pulumi.Output[str]:
        """
        The forwarding rule action, if this parameter is empty(`""`), forward to server group, if value is `Redirect`, will redirect.
        """
        return pulumi.get(self, "rule_action")

    @property
    @pulumi.getter(name="ruleId")
    def rule_id(self) -> pulumi.Output[str]:
        """
        The ID of rule.
        """
        return pulumi.get(self, "rule_id")

    @property
    @pulumi.getter(name="serverGroupId")
    def server_group_id(self) -> pulumi.Output[Optional[str]]:
        """
        Server group ID, this parameter is required if `rule_action` is empty.
        """
        return pulumi.get(self, "server_group_id")

    @property
    @pulumi.getter(name="trafficLimitEnabled")
    def traffic_limit_enabled(self) -> pulumi.Output[Optional[str]]:
        """
        Forwarding rule QPS rate limiting switch:
        on: enable.
        off: disable (default).
        """
        return pulumi.get(self, "traffic_limit_enabled")

    @property
    @pulumi.getter(name="trafficLimitQps")
    def traffic_limit_qps(self) -> pulumi.Output[Optional[int]]:
        """
        When Rules.N.TrafficLimitEnabled is turned on, this field is required. Requests per second. Valid values are between 100 and 100000.
        """
        return pulumi.get(self, "traffic_limit_qps")

    @property
    @pulumi.getter
    def url(self) -> pulumi.Output[str]:
        """
        The Url of Rule.
        """
        return pulumi.get(self, "url")

