# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ServerGroupArgs', 'ServerGroup']

@pulumi.input_type
class ServerGroupArgs:
    def __init__(__self__, *,
                 vpc_id: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None,
                 health_check: Optional[pulumi.Input['ServerGroupHealthCheckArgs']] = None,
                 project_name: Optional[pulumi.Input[str]] = None,
                 scheduler: Optional[pulumi.Input[str]] = None,
                 server_group_name: Optional[pulumi.Input[str]] = None,
                 server_group_type: Optional[pulumi.Input[str]] = None,
                 sticky_session_config: Optional[pulumi.Input['ServerGroupStickySessionConfigArgs']] = None):
        """
        The set of arguments for constructing a ServerGroup resource.
        :param pulumi.Input[str] vpc_id: The vpc id of the Alb server group.
        :param pulumi.Input[str] description: The description of the Alb server group.
        :param pulumi.Input['ServerGroupHealthCheckArgs'] health_check: The health check config of the Alb server group. The enable status of health check function defaults to `on`.
        :param pulumi.Input[str] project_name: The project name of the Alb server group.
        :param pulumi.Input[str] scheduler: The scheduling algorithm of the Alb server group. Valid values: `wrr`, `wlc`, `sh`.
        :param pulumi.Input[str] server_group_name: The name of the Alb server group.
        :param pulumi.Input[str] server_group_type: The type of the Alb server group. Valid values: `instance`, `ip`. Default is `instance`.
        :param pulumi.Input['ServerGroupStickySessionConfigArgs'] sticky_session_config: The sticky session config of the Alb server group. The enable status of sticky session function defaults to `off`.
        """
        pulumi.set(__self__, "vpc_id", vpc_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if health_check is not None:
            pulumi.set(__self__, "health_check", health_check)
        if project_name is not None:
            pulumi.set(__self__, "project_name", project_name)
        if scheduler is not None:
            pulumi.set(__self__, "scheduler", scheduler)
        if server_group_name is not None:
            pulumi.set(__self__, "server_group_name", server_group_name)
        if server_group_type is not None:
            pulumi.set(__self__, "server_group_type", server_group_type)
        if sticky_session_config is not None:
            pulumi.set(__self__, "sticky_session_config", sticky_session_config)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Input[str]:
        """
        The vpc id of the Alb server group.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "vpc_id", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the Alb server group.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="healthCheck")
    def health_check(self) -> Optional[pulumi.Input['ServerGroupHealthCheckArgs']]:
        """
        The health check config of the Alb server group. The enable status of health check function defaults to `on`.
        """
        return pulumi.get(self, "health_check")

    @health_check.setter
    def health_check(self, value: Optional[pulumi.Input['ServerGroupHealthCheckArgs']]):
        pulumi.set(self, "health_check", value)

    @property
    @pulumi.getter(name="projectName")
    def project_name(self) -> Optional[pulumi.Input[str]]:
        """
        The project name of the Alb server group.
        """
        return pulumi.get(self, "project_name")

    @project_name.setter
    def project_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_name", value)

    @property
    @pulumi.getter
    def scheduler(self) -> Optional[pulumi.Input[str]]:
        """
        The scheduling algorithm of the Alb server group. Valid values: `wrr`, `wlc`, `sh`.
        """
        return pulumi.get(self, "scheduler")

    @scheduler.setter
    def scheduler(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "scheduler", value)

    @property
    @pulumi.getter(name="serverGroupName")
    def server_group_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Alb server group.
        """
        return pulumi.get(self, "server_group_name")

    @server_group_name.setter
    def server_group_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "server_group_name", value)

    @property
    @pulumi.getter(name="serverGroupType")
    def server_group_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of the Alb server group. Valid values: `instance`, `ip`. Default is `instance`.
        """
        return pulumi.get(self, "server_group_type")

    @server_group_type.setter
    def server_group_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "server_group_type", value)

    @property
    @pulumi.getter(name="stickySessionConfig")
    def sticky_session_config(self) -> Optional[pulumi.Input['ServerGroupStickySessionConfigArgs']]:
        """
        The sticky session config of the Alb server group. The enable status of sticky session function defaults to `off`.
        """
        return pulumi.get(self, "sticky_session_config")

    @sticky_session_config.setter
    def sticky_session_config(self, value: Optional[pulumi.Input['ServerGroupStickySessionConfigArgs']]):
        pulumi.set(self, "sticky_session_config", value)


@pulumi.input_type
class _ServerGroupState:
    def __init__(__self__, *,
                 create_time: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 health_check: Optional[pulumi.Input['ServerGroupHealthCheckArgs']] = None,
                 listeners: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 project_name: Optional[pulumi.Input[str]] = None,
                 scheduler: Optional[pulumi.Input[str]] = None,
                 server_count: Optional[pulumi.Input[int]] = None,
                 server_group_name: Optional[pulumi.Input[str]] = None,
                 server_group_type: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 sticky_session_config: Optional[pulumi.Input['ServerGroupStickySessionConfigArgs']] = None,
                 update_time: Optional[pulumi.Input[str]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering ServerGroup resources.
        :param pulumi.Input[str] create_time: The create time of the Alb server group.
        :param pulumi.Input[str] description: The description of the Alb server group.
        :param pulumi.Input['ServerGroupHealthCheckArgs'] health_check: The health check config of the Alb server group. The enable status of health check function defaults to `on`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] listeners: The listener information of the Alb server group.
        :param pulumi.Input[str] project_name: The project name of the Alb server group.
        :param pulumi.Input[str] scheduler: The scheduling algorithm of the Alb server group. Valid values: `wrr`, `wlc`, `sh`.
        :param pulumi.Input[int] server_count: The server count of the Alb server group.
        :param pulumi.Input[str] server_group_name: The name of the Alb server group.
        :param pulumi.Input[str] server_group_type: The type of the Alb server group. Valid values: `instance`, `ip`. Default is `instance`.
        :param pulumi.Input[str] status: The status of the Alb server group.
        :param pulumi.Input['ServerGroupStickySessionConfigArgs'] sticky_session_config: The sticky session config of the Alb server group. The enable status of sticky session function defaults to `off`.
        :param pulumi.Input[str] update_time: The update time of the Alb server group.
        :param pulumi.Input[str] vpc_id: The vpc id of the Alb server group.
        """
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if health_check is not None:
            pulumi.set(__self__, "health_check", health_check)
        if listeners is not None:
            pulumi.set(__self__, "listeners", listeners)
        if project_name is not None:
            pulumi.set(__self__, "project_name", project_name)
        if scheduler is not None:
            pulumi.set(__self__, "scheduler", scheduler)
        if server_count is not None:
            pulumi.set(__self__, "server_count", server_count)
        if server_group_name is not None:
            pulumi.set(__self__, "server_group_name", server_group_name)
        if server_group_type is not None:
            pulumi.set(__self__, "server_group_type", server_group_type)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if sticky_session_config is not None:
            pulumi.set(__self__, "sticky_session_config", sticky_session_config)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[str]]:
        """
        The create time of the Alb server group.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the Alb server group.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="healthCheck")
    def health_check(self) -> Optional[pulumi.Input['ServerGroupHealthCheckArgs']]:
        """
        The health check config of the Alb server group. The enable status of health check function defaults to `on`.
        """
        return pulumi.get(self, "health_check")

    @health_check.setter
    def health_check(self, value: Optional[pulumi.Input['ServerGroupHealthCheckArgs']]):
        pulumi.set(self, "health_check", value)

    @property
    @pulumi.getter
    def listeners(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The listener information of the Alb server group.
        """
        return pulumi.get(self, "listeners")

    @listeners.setter
    def listeners(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "listeners", value)

    @property
    @pulumi.getter(name="projectName")
    def project_name(self) -> Optional[pulumi.Input[str]]:
        """
        The project name of the Alb server group.
        """
        return pulumi.get(self, "project_name")

    @project_name.setter
    def project_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_name", value)

    @property
    @pulumi.getter
    def scheduler(self) -> Optional[pulumi.Input[str]]:
        """
        The scheduling algorithm of the Alb server group. Valid values: `wrr`, `wlc`, `sh`.
        """
        return pulumi.get(self, "scheduler")

    @scheduler.setter
    def scheduler(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "scheduler", value)

    @property
    @pulumi.getter(name="serverCount")
    def server_count(self) -> Optional[pulumi.Input[int]]:
        """
        The server count of the Alb server group.
        """
        return pulumi.get(self, "server_count")

    @server_count.setter
    def server_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "server_count", value)

    @property
    @pulumi.getter(name="serverGroupName")
    def server_group_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Alb server group.
        """
        return pulumi.get(self, "server_group_name")

    @server_group_name.setter
    def server_group_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "server_group_name", value)

    @property
    @pulumi.getter(name="serverGroupType")
    def server_group_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of the Alb server group. Valid values: `instance`, `ip`. Default is `instance`.
        """
        return pulumi.get(self, "server_group_type")

    @server_group_type.setter
    def server_group_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "server_group_type", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The status of the Alb server group.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="stickySessionConfig")
    def sticky_session_config(self) -> Optional[pulumi.Input['ServerGroupStickySessionConfigArgs']]:
        """
        The sticky session config of the Alb server group. The enable status of sticky session function defaults to `off`.
        """
        return pulumi.get(self, "sticky_session_config")

    @sticky_session_config.setter
    def sticky_session_config(self, value: Optional[pulumi.Input['ServerGroupStickySessionConfigArgs']]):
        pulumi.set(self, "sticky_session_config", value)

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[str]]:
        """
        The update time of the Alb server group.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "update_time", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[str]]:
        """
        The vpc id of the Alb server group.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc_id", value)


class ServerGroup(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 health_check: Optional[pulumi.Input[pulumi.InputType['ServerGroupHealthCheckArgs']]] = None,
                 project_name: Optional[pulumi.Input[str]] = None,
                 scheduler: Optional[pulumi.Input[str]] = None,
                 server_group_name: Optional[pulumi.Input[str]] = None,
                 server_group_type: Optional[pulumi.Input[str]] = None,
                 sticky_session_config: Optional[pulumi.Input[pulumi.InputType['ServerGroupStickySessionConfigArgs']]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a resource to manage alb server group
        ## Example Usage

        ```python
        import pulumi
        import pulumi_volcengine as volcengine

        foo_vpc = volcengine.vpc.Vpc("fooVpc",
            vpc_name="acc-test-vpc",
            cidr_block="172.16.0.0/16")
        foo_server_group = volcengine.alb.ServerGroup("fooServerGroup",
            vpc_id=foo_vpc.id,
            server_group_name="acc-test-server-group",
            description="acc-test",
            server_group_type="instance",
            scheduler="wlc",
            project_name="default",
            health_check=volcengine.alb.ServerGroupHealthCheckArgs(
                enabled="on",
                interval=3,
                timeout=3,
                method="GET",
            ),
            sticky_session_config=volcengine.alb.ServerGroupStickySessionConfigArgs(
                sticky_session_enabled="on",
                sticky_session_type="insert",
                cookie_timeout=1100,
            ))
        ```

        ## Import

        AlbServerGroup can be imported using the id, e.g.

        ```sh
         $ pulumi import volcengine:alb/serverGroup:ServerGroup default resource_id
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: The description of the Alb server group.
        :param pulumi.Input[pulumi.InputType['ServerGroupHealthCheckArgs']] health_check: The health check config of the Alb server group. The enable status of health check function defaults to `on`.
        :param pulumi.Input[str] project_name: The project name of the Alb server group.
        :param pulumi.Input[str] scheduler: The scheduling algorithm of the Alb server group. Valid values: `wrr`, `wlc`, `sh`.
        :param pulumi.Input[str] server_group_name: The name of the Alb server group.
        :param pulumi.Input[str] server_group_type: The type of the Alb server group. Valid values: `instance`, `ip`. Default is `instance`.
        :param pulumi.Input[pulumi.InputType['ServerGroupStickySessionConfigArgs']] sticky_session_config: The sticky session config of the Alb server group. The enable status of sticky session function defaults to `off`.
        :param pulumi.Input[str] vpc_id: The vpc id of the Alb server group.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ServerGroupArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a resource to manage alb server group
        ## Example Usage

        ```python
        import pulumi
        import pulumi_volcengine as volcengine

        foo_vpc = volcengine.vpc.Vpc("fooVpc",
            vpc_name="acc-test-vpc",
            cidr_block="172.16.0.0/16")
        foo_server_group = volcengine.alb.ServerGroup("fooServerGroup",
            vpc_id=foo_vpc.id,
            server_group_name="acc-test-server-group",
            description="acc-test",
            server_group_type="instance",
            scheduler="wlc",
            project_name="default",
            health_check=volcengine.alb.ServerGroupHealthCheckArgs(
                enabled="on",
                interval=3,
                timeout=3,
                method="GET",
            ),
            sticky_session_config=volcengine.alb.ServerGroupStickySessionConfigArgs(
                sticky_session_enabled="on",
                sticky_session_type="insert",
                cookie_timeout=1100,
            ))
        ```

        ## Import

        AlbServerGroup can be imported using the id, e.g.

        ```sh
         $ pulumi import volcengine:alb/serverGroup:ServerGroup default resource_id
        ```

        :param str resource_name: The name of the resource.
        :param ServerGroupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ServerGroupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 health_check: Optional[pulumi.Input[pulumi.InputType['ServerGroupHealthCheckArgs']]] = None,
                 project_name: Optional[pulumi.Input[str]] = None,
                 scheduler: Optional[pulumi.Input[str]] = None,
                 server_group_name: Optional[pulumi.Input[str]] = None,
                 server_group_type: Optional[pulumi.Input[str]] = None,
                 sticky_session_config: Optional[pulumi.Input[pulumi.InputType['ServerGroupStickySessionConfigArgs']]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ServerGroupArgs.__new__(ServerGroupArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["health_check"] = health_check
            __props__.__dict__["project_name"] = project_name
            __props__.__dict__["scheduler"] = scheduler
            __props__.__dict__["server_group_name"] = server_group_name
            __props__.__dict__["server_group_type"] = server_group_type
            __props__.__dict__["sticky_session_config"] = sticky_session_config
            if vpc_id is None and not opts.urn:
                raise TypeError("Missing required property 'vpc_id'")
            __props__.__dict__["vpc_id"] = vpc_id
            __props__.__dict__["create_time"] = None
            __props__.__dict__["listeners"] = None
            __props__.__dict__["server_count"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["update_time"] = None
        super(ServerGroup, __self__).__init__(
            'volcengine:alb/serverGroup:ServerGroup',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            create_time: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            health_check: Optional[pulumi.Input[pulumi.InputType['ServerGroupHealthCheckArgs']]] = None,
            listeners: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            project_name: Optional[pulumi.Input[str]] = None,
            scheduler: Optional[pulumi.Input[str]] = None,
            server_count: Optional[pulumi.Input[int]] = None,
            server_group_name: Optional[pulumi.Input[str]] = None,
            server_group_type: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None,
            sticky_session_config: Optional[pulumi.Input[pulumi.InputType['ServerGroupStickySessionConfigArgs']]] = None,
            update_time: Optional[pulumi.Input[str]] = None,
            vpc_id: Optional[pulumi.Input[str]] = None) -> 'ServerGroup':
        """
        Get an existing ServerGroup resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] create_time: The create time of the Alb server group.
        :param pulumi.Input[str] description: The description of the Alb server group.
        :param pulumi.Input[pulumi.InputType['ServerGroupHealthCheckArgs']] health_check: The health check config of the Alb server group. The enable status of health check function defaults to `on`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] listeners: The listener information of the Alb server group.
        :param pulumi.Input[str] project_name: The project name of the Alb server group.
        :param pulumi.Input[str] scheduler: The scheduling algorithm of the Alb server group. Valid values: `wrr`, `wlc`, `sh`.
        :param pulumi.Input[int] server_count: The server count of the Alb server group.
        :param pulumi.Input[str] server_group_name: The name of the Alb server group.
        :param pulumi.Input[str] server_group_type: The type of the Alb server group. Valid values: `instance`, `ip`. Default is `instance`.
        :param pulumi.Input[str] status: The status of the Alb server group.
        :param pulumi.Input[pulumi.InputType['ServerGroupStickySessionConfigArgs']] sticky_session_config: The sticky session config of the Alb server group. The enable status of sticky session function defaults to `off`.
        :param pulumi.Input[str] update_time: The update time of the Alb server group.
        :param pulumi.Input[str] vpc_id: The vpc id of the Alb server group.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ServerGroupState.__new__(_ServerGroupState)

        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["description"] = description
        __props__.__dict__["health_check"] = health_check
        __props__.__dict__["listeners"] = listeners
        __props__.__dict__["project_name"] = project_name
        __props__.__dict__["scheduler"] = scheduler
        __props__.__dict__["server_count"] = server_count
        __props__.__dict__["server_group_name"] = server_group_name
        __props__.__dict__["server_group_type"] = server_group_type
        __props__.__dict__["status"] = status
        __props__.__dict__["sticky_session_config"] = sticky_session_config
        __props__.__dict__["update_time"] = update_time
        __props__.__dict__["vpc_id"] = vpc_id
        return ServerGroup(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[str]:
        """
        The create time of the Alb server group.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        The description of the Alb server group.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="healthCheck")
    def health_check(self) -> pulumi.Output['outputs.ServerGroupHealthCheck']:
        """
        The health check config of the Alb server group. The enable status of health check function defaults to `on`.
        """
        return pulumi.get(self, "health_check")

    @property
    @pulumi.getter
    def listeners(self) -> pulumi.Output[Sequence[str]]:
        """
        The listener information of the Alb server group.
        """
        return pulumi.get(self, "listeners")

    @property
    @pulumi.getter(name="projectName")
    def project_name(self) -> pulumi.Output[str]:
        """
        The project name of the Alb server group.
        """
        return pulumi.get(self, "project_name")

    @property
    @pulumi.getter
    def scheduler(self) -> pulumi.Output[Optional[str]]:
        """
        The scheduling algorithm of the Alb server group. Valid values: `wrr`, `wlc`, `sh`.
        """
        return pulumi.get(self, "scheduler")

    @property
    @pulumi.getter(name="serverCount")
    def server_count(self) -> pulumi.Output[int]:
        """
        The server count of the Alb server group.
        """
        return pulumi.get(self, "server_count")

    @property
    @pulumi.getter(name="serverGroupName")
    def server_group_name(self) -> pulumi.Output[str]:
        """
        The name of the Alb server group.
        """
        return pulumi.get(self, "server_group_name")

    @property
    @pulumi.getter(name="serverGroupType")
    def server_group_type(self) -> pulumi.Output[Optional[str]]:
        """
        The type of the Alb server group. Valid values: `instance`, `ip`. Default is `instance`.
        """
        return pulumi.get(self, "server_group_type")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        The status of the Alb server group.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="stickySessionConfig")
    def sticky_session_config(self) -> pulumi.Output['outputs.ServerGroupStickySessionConfig']:
        """
        The sticky session config of the Alb server group. The enable status of sticky session function defaults to `off`.
        """
        return pulumi.get(self, "sticky_session_config")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[str]:
        """
        The update time of the Alb server group.
        """
        return pulumi.get(self, "update_time")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[str]:
        """
        The vpc id of the Alb server group.
        """
        return pulumi.get(self, "vpc_id")

