# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'ServerGroupServersResult',
    'AwaitableServerGroupServersResult',
    'server_group_servers',
    'server_group_servers_output',
]

@pulumi.output_type
class ServerGroupServersResult:
    """
    A collection of values returned by ServerGroupServers.
    """
    def __init__(__self__, id=None, output_file=None, server_group_id=None, servers=None, total_count=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if server_group_id and not isinstance(server_group_id, str):
            raise TypeError("Expected argument 'server_group_id' to be a str")
        pulumi.set(__self__, "server_group_id", server_group_id)
        if servers and not isinstance(servers, list):
            raise TypeError("Expected argument 'servers' to be a list")
        pulumi.set(__self__, "servers", servers)
        if total_count and not isinstance(total_count, int):
            raise TypeError("Expected argument 'total_count' to be a int")
        pulumi.set(__self__, "total_count", total_count)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[str]:
        return pulumi.get(self, "output_file")

    @property
    @pulumi.getter(name="serverGroupId")
    def server_group_id(self) -> str:
        return pulumi.get(self, "server_group_id")

    @property
    @pulumi.getter
    def servers(self) -> Sequence['outputs.ServerGroupServersServerResult']:
        """
        The server list of ServerGroup.
        """
        return pulumi.get(self, "servers")

    @property
    @pulumi.getter(name="totalCount")
    def total_count(self) -> int:
        """
        The total count of ServerGroupServer query.
        """
        return pulumi.get(self, "total_count")


class AwaitableServerGroupServersResult(ServerGroupServersResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return ServerGroupServersResult(
            id=self.id,
            output_file=self.output_file,
            server_group_id=self.server_group_id,
            servers=self.servers,
            total_count=self.total_count)


def server_group_servers(output_file: Optional[str] = None,
                         server_group_id: Optional[str] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableServerGroupServersResult:
    """
    Use this data source to query detailed information of alb server group servers
    ## Example Usage

    ```python
    import pulumi
    import pulumi_volcengine as volcengine

    foo = volcengine.alb.server_group_servers(server_group_id="rsp-1g7317vrcx3pc2zbhq4c3i6a2")
    ```


    :param str output_file: File name where to save data source results.
    :param str server_group_id: The ID of the ServerGroup.
    """
    __args__ = dict()
    __args__['outputFile'] = output_file
    __args__['serverGroupId'] = server_group_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('volcengine:alb/serverGroupServers:ServerGroupServers', __args__, opts=opts, typ=ServerGroupServersResult).value

    return AwaitableServerGroupServersResult(
        id=pulumi.get(__ret__, 'id'),
        output_file=pulumi.get(__ret__, 'output_file'),
        server_group_id=pulumi.get(__ret__, 'server_group_id'),
        servers=pulumi.get(__ret__, 'servers'),
        total_count=pulumi.get(__ret__, 'total_count'))


@_utilities.lift_output_func(server_group_servers)
def server_group_servers_output(output_file: Optional[pulumi.Input[Optional[str]]] = None,
                                server_group_id: Optional[pulumi.Input[str]] = None,
                                opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[ServerGroupServersResult]:
    """
    Use this data source to query detailed information of alb server group servers
    ## Example Usage

    ```python
    import pulumi
    import pulumi_volcengine as volcengine

    foo = volcengine.alb.server_group_servers(server_group_id="rsp-1g7317vrcx3pc2zbhq4c3i6a2")
    ```


    :param str output_file: File name where to save data source results.
    :param str server_group_id: The ID of the ServerGroup.
    """
    ...
