# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'ServerGroupsResult',
    'AwaitableServerGroupsResult',
    'server_groups',
    'server_groups_output',
]

@pulumi.output_type
class ServerGroupsResult:
    """
    A collection of values returned by ServerGroups.
    """
    def __init__(__self__, id=None, ids=None, name_regex=None, output_file=None, project_name=None, server_group_names=None, server_group_type=None, server_groups=None, total_count=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if name_regex and not isinstance(name_regex, str):
            raise TypeError("Expected argument 'name_regex' to be a str")
        pulumi.set(__self__, "name_regex", name_regex)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if project_name and not isinstance(project_name, str):
            raise TypeError("Expected argument 'project_name' to be a str")
        pulumi.set(__self__, "project_name", project_name)
        if server_group_names and not isinstance(server_group_names, list):
            raise TypeError("Expected argument 'server_group_names' to be a list")
        pulumi.set(__self__, "server_group_names", server_group_names)
        if server_group_type and not isinstance(server_group_type, str):
            raise TypeError("Expected argument 'server_group_type' to be a str")
        pulumi.set(__self__, "server_group_type", server_group_type)
        if server_groups and not isinstance(server_groups, list):
            raise TypeError("Expected argument 'server_groups' to be a list")
        pulumi.set(__self__, "server_groups", server_groups)
        if total_count and not isinstance(total_count, int):
            raise TypeError("Expected argument 'total_count' to be a int")
        pulumi.set(__self__, "total_count", total_count)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def ids(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "ids")

    @property
    @pulumi.getter(name="nameRegex")
    def name_regex(self) -> Optional[str]:
        return pulumi.get(self, "name_regex")

    @property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[str]:
        return pulumi.get(self, "output_file")

    @property
    @pulumi.getter(name="projectName")
    def project_name(self) -> Optional[str]:
        """
        The project name of the Alb server group.
        """
        return pulumi.get(self, "project_name")

    @property
    @pulumi.getter(name="serverGroupNames")
    def server_group_names(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "server_group_names")

    @property
    @pulumi.getter(name="serverGroupType")
    def server_group_type(self) -> Optional[str]:
        """
        The type of the Alb server group.
        """
        return pulumi.get(self, "server_group_type")

    @property
    @pulumi.getter(name="serverGroups")
    def server_groups(self) -> Sequence['outputs.ServerGroupsServerGroupResult']:
        """
        The collection of query.
        """
        return pulumi.get(self, "server_groups")

    @property
    @pulumi.getter(name="totalCount")
    def total_count(self) -> int:
        """
        The total count of query.
        """
        return pulumi.get(self, "total_count")


class AwaitableServerGroupsResult(ServerGroupsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return ServerGroupsResult(
            id=self.id,
            ids=self.ids,
            name_regex=self.name_regex,
            output_file=self.output_file,
            project_name=self.project_name,
            server_group_names=self.server_group_names,
            server_group_type=self.server_group_type,
            server_groups=self.server_groups,
            total_count=self.total_count)


def server_groups(ids: Optional[Sequence[str]] = None,
                  name_regex: Optional[str] = None,
                  output_file: Optional[str] = None,
                  project_name: Optional[str] = None,
                  server_group_names: Optional[Sequence[str]] = None,
                  server_group_type: Optional[str] = None,
                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableServerGroupsResult:
    """
    Use this data source to query detailed information of alb server groups
    ## Example Usage

    ```python
    import pulumi
    import pulumi_volcengine as volcengine

    foo_vpc = volcengine.vpc.Vpc("fooVpc",
        vpc_name="acc-test-vpc",
        cidr_block="172.16.0.0/16")
    foo_server_group = []
    for range in [{"value": i} for i in range(0, 3)]:
        foo_server_group.append(volcengine.alb.ServerGroup(f"fooServerGroup-{range['value']}",
            vpc_id=foo_vpc.id,
            server_group_name=f"acc-test-server-group-{range['value']}",
            description="acc-test",
            server_group_type="instance",
            scheduler="sh",
            project_name="default",
            health_check=volcengine.alb.ServerGroupHealthCheckArgs(
                enabled="on",
                interval=3,
                timeout=3,
                method="GET",
            ),
            sticky_session_config=volcengine.alb.ServerGroupStickySessionConfigArgs(
                sticky_session_enabled="on",
                sticky_session_type="insert",
                cookie_timeout=1100,
            )))
    foo_server_groups = volcengine.alb.server_groups_output(ids=[__item.id for __item in foo_server_group])
    ```


    :param Sequence[str] ids: A list of Alb server group IDs.
    :param str name_regex: A Name Regex of Resource.
    :param str output_file: File name where to save data source results.
    :param str project_name: The project name of Alb server group.
    :param Sequence[str] server_group_names: A list of Alb server group name.
    :param str server_group_type: The type of Alb server group. Valid values: `instance`, `ip`.
    """
    __args__ = dict()
    __args__['ids'] = ids
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    __args__['projectName'] = project_name
    __args__['serverGroupNames'] = server_group_names
    __args__['serverGroupType'] = server_group_type
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('volcengine:alb/serverGroups:ServerGroups', __args__, opts=opts, typ=ServerGroupsResult).value

    return AwaitableServerGroupsResult(
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        name_regex=pulumi.get(__ret__, 'name_regex'),
        output_file=pulumi.get(__ret__, 'output_file'),
        project_name=pulumi.get(__ret__, 'project_name'),
        server_group_names=pulumi.get(__ret__, 'server_group_names'),
        server_group_type=pulumi.get(__ret__, 'server_group_type'),
        server_groups=pulumi.get(__ret__, 'server_groups'),
        total_count=pulumi.get(__ret__, 'total_count'))


@_utilities.lift_output_func(server_groups)
def server_groups_output(ids: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                         name_regex: Optional[pulumi.Input[Optional[str]]] = None,
                         output_file: Optional[pulumi.Input[Optional[str]]] = None,
                         project_name: Optional[pulumi.Input[Optional[str]]] = None,
                         server_group_names: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                         server_group_type: Optional[pulumi.Input[Optional[str]]] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[ServerGroupsResult]:
    """
    Use this data source to query detailed information of alb server groups
    ## Example Usage

    ```python
    import pulumi
    import pulumi_volcengine as volcengine

    foo_vpc = volcengine.vpc.Vpc("fooVpc",
        vpc_name="acc-test-vpc",
        cidr_block="172.16.0.0/16")
    foo_server_group = []
    for range in [{"value": i} for i in range(0, 3)]:
        foo_server_group.append(volcengine.alb.ServerGroup(f"fooServerGroup-{range['value']}",
            vpc_id=foo_vpc.id,
            server_group_name=f"acc-test-server-group-{range['value']}",
            description="acc-test",
            server_group_type="instance",
            scheduler="sh",
            project_name="default",
            health_check=volcengine.alb.ServerGroupHealthCheckArgs(
                enabled="on",
                interval=3,
                timeout=3,
                method="GET",
            ),
            sticky_session_config=volcengine.alb.ServerGroupStickySessionConfigArgs(
                sticky_session_enabled="on",
                sticky_session_type="insert",
                cookie_timeout=1100,
            )))
    foo_server_groups = volcengine.alb.server_groups_output(ids=[__item.id for __item in foo_server_group])
    ```


    :param Sequence[str] ids: A list of Alb server group IDs.
    :param str name_regex: A Name Regex of Resource.
    :param str output_file: File name where to save data source results.
    :param str project_name: The project name of Alb server group.
    :param Sequence[str] server_group_names: A list of Alb server group name.
    :param str server_group_type: The type of Alb server group. Valid values: `instance`, `ip`.
    """
    ...
