# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'ScalingActivitiesResult',
    'AwaitableScalingActivitiesResult',
    'scaling_activities',
    'scaling_activities_output',
]

@pulumi.output_type
class ScalingActivitiesResult:
    """
    A collection of values returned by ScalingActivities.
    """
    def __init__(__self__, activities=None, end_time=None, id=None, ids=None, output_file=None, scaling_group_id=None, start_time=None, status_code=None, total_count=None):
        if activities and not isinstance(activities, list):
            raise TypeError("Expected argument 'activities' to be a list")
        pulumi.set(__self__, "activities", activities)
        if end_time and not isinstance(end_time, str):
            raise TypeError("Expected argument 'end_time' to be a str")
        pulumi.set(__self__, "end_time", end_time)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if scaling_group_id and not isinstance(scaling_group_id, str):
            raise TypeError("Expected argument 'scaling_group_id' to be a str")
        pulumi.set(__self__, "scaling_group_id", scaling_group_id)
        if start_time and not isinstance(start_time, str):
            raise TypeError("Expected argument 'start_time' to be a str")
        pulumi.set(__self__, "start_time", start_time)
        if status_code and not isinstance(status_code, str):
            raise TypeError("Expected argument 'status_code' to be a str")
        pulumi.set(__self__, "status_code", status_code)
        if total_count and not isinstance(total_count, int):
            raise TypeError("Expected argument 'total_count' to be a int")
        pulumi.set(__self__, "total_count", total_count)

    @property
    @pulumi.getter
    def activities(self) -> Sequence['outputs.ScalingActivitiesActivityResult']:
        """
        The collection of Scaling Activity query.
        """
        return pulumi.get(self, "activities")

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> Optional[str]:
        return pulumi.get(self, "end_time")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def ids(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "ids")

    @property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[str]:
        return pulumi.get(self, "output_file")

    @property
    @pulumi.getter(name="scalingGroupId")
    def scaling_group_id(self) -> str:
        """
        The scaling group Id.
        """
        return pulumi.get(self, "scaling_group_id")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[str]:
        return pulumi.get(self, "start_time")

    @property
    @pulumi.getter(name="statusCode")
    def status_code(self) -> Optional[str]:
        """
        The Status Code of Scaling Activity.
        """
        return pulumi.get(self, "status_code")

    @property
    @pulumi.getter(name="totalCount")
    def total_count(self) -> int:
        """
        The total count of Scaling Activity query.
        """
        return pulumi.get(self, "total_count")


class AwaitableScalingActivitiesResult(ScalingActivitiesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return ScalingActivitiesResult(
            activities=self.activities,
            end_time=self.end_time,
            id=self.id,
            ids=self.ids,
            output_file=self.output_file,
            scaling_group_id=self.scaling_group_id,
            start_time=self.start_time,
            status_code=self.status_code,
            total_count=self.total_count)


def scaling_activities(end_time: Optional[str] = None,
                       ids: Optional[Sequence[str]] = None,
                       output_file: Optional[str] = None,
                       scaling_group_id: Optional[str] = None,
                       start_time: Optional[str] = None,
                       status_code: Optional[str] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableScalingActivitiesResult:
    """
    Use this data source to query detailed information of scaling activities
    ## Example Usage

    ```python
    import pulumi
    import pulumi_volcengine as volcengine

    foo_zones = volcengine.ecs.zones()
    foo_vpc = volcengine.vpc.Vpc("fooVpc",
        vpc_name="acc-test-vpc",
        cidr_block="172.16.0.0/16")
    foo_subnet = volcengine.vpc.Subnet("fooSubnet",
        subnet_name="acc-test-subnet",
        cidr_block="172.16.0.0/24",
        zone_id=foo_zones.zones[0].id,
        vpc_id=foo_vpc.id)
    foo_security_group = volcengine.vpc.SecurityGroup("fooSecurityGroup",
        security_group_name="acc-test-security-group",
        vpc_id=foo_vpc.id)
    foo_images = volcengine.ecs.images(os_type="Linux",
        visibility="public",
        instance_type_id="ecs.g1.large")
    foo_key_pair = volcengine.ecs.KeyPair("fooKeyPair",
        description="acc-test-2",
        key_pair_name="acc-test-key-pair-name")
    foo_launch_template = volcengine.ecs.LaunchTemplate("fooLaunchTemplate",
        description="acc-test-desc",
        eip_bandwidth=200,
        eip_billing_type="PostPaidByBandwidth",
        eip_isp="BGP",
        host_name="acc-hostname",
        image_id=foo_images.images[0].image_id,
        instance_charge_type="PostPaid",
        instance_name="acc-instance-name",
        instance_type_id="ecs.g1.large",
        key_pair_name=foo_key_pair.key_pair_name,
        launch_template_name="acc-test-template",
        network_interfaces=[volcengine.ecs.LaunchTemplateNetworkInterfaceArgs(
            subnet_id=foo_subnet.id,
            security_group_ids=[foo_security_group.id],
        )],
        volumes=[volcengine.ecs.LaunchTemplateVolumeArgs(
            volume_type="ESSD_PL0",
            size=50,
            delete_with_instance=True,
        )])
    foo_scaling_group = volcengine.autoscaling.ScalingGroup("fooScalingGroup",
        scaling_group_name="acc-test-scaling-group",
        subnet_ids=[foo_subnet.id],
        multi_az_policy="BALANCE",
        desire_instance_number=-1,
        min_instance_number=0,
        max_instance_number=10,
        instance_terminate_policy="OldestInstance",
        default_cooldown=10,
        launch_template_id=foo_launch_template.id,
        launch_template_version="Default")
    foo_scaling_group_enabler = volcengine.autoscaling.ScalingGroupEnabler("fooScalingGroupEnabler", scaling_group_id=foo_scaling_group.id)
    foo_instance = []
    for range in [{"value": i} for i in range(0, 3)]:
        foo_instance.append(volcengine.ecs.Instance(f"fooInstance-{range['value']}",
            instance_name=f"acc-test-ecs-{range['value']}",
            description="acc-test",
            host_name="tf-acc-test",
            image_id=foo_images.images[0].image_id,
            instance_type="ecs.g1.large",
            password="93f0cb0614Aab12",
            instance_charge_type="PostPaid",
            system_volume_type="ESSD_PL0",
            system_volume_size=40,
            subnet_id=foo_subnet.id,
            security_group_ids=[foo_security_group.id]))
    foo_scaling_instance_attachment = []
    def create_foo_scaling_instance_attachment(range_body):
        for range in [{"value": i} for i in range(0, range_body)]:
            foo_scaling_instance_attachment.append(volcengine.autoscaling.ScalingInstanceAttachment(f"fooScalingInstanceAttachment-{range['value']}",
                instance_id=foo_instance[range["value"]].id,
                scaling_group_id=foo_scaling_group.id,
                entrusted=True,
                opts=pulumi.ResourceOptions(depends_on=[foo_scaling_group_enabler])))

    (len(foo_instance)).apply(create_foo_scaling_instance_attachment)
    foo_scaling_activities = volcengine.autoscaling.scaling_activities_output(scaling_group_id=foo_scaling_group.id)
    ```


    :param str end_time: An end time to start a Scaling Activity.
    :param Sequence[str] ids: A list of Scaling Activity IDs.
    :param str output_file: File name where to save data source results.
    :param str scaling_group_id: A Id of Scaling Group.
    :param str start_time: A start time to start a Scaling Activity.
    :param str status_code: A status code of Scaling Activity. Valid values: Init, Running, Success, PartialSuccess, Error, Rejected, Exception.
    """
    __args__ = dict()
    __args__['endTime'] = end_time
    __args__['ids'] = ids
    __args__['outputFile'] = output_file
    __args__['scalingGroupId'] = scaling_group_id
    __args__['startTime'] = start_time
    __args__['statusCode'] = status_code
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('volcengine:autoscaling/scalingActivities:ScalingActivities', __args__, opts=opts, typ=ScalingActivitiesResult).value

    return AwaitableScalingActivitiesResult(
        activities=pulumi.get(__ret__, 'activities'),
        end_time=pulumi.get(__ret__, 'end_time'),
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        output_file=pulumi.get(__ret__, 'output_file'),
        scaling_group_id=pulumi.get(__ret__, 'scaling_group_id'),
        start_time=pulumi.get(__ret__, 'start_time'),
        status_code=pulumi.get(__ret__, 'status_code'),
        total_count=pulumi.get(__ret__, 'total_count'))


@_utilities.lift_output_func(scaling_activities)
def scaling_activities_output(end_time: Optional[pulumi.Input[Optional[str]]] = None,
                              ids: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                              output_file: Optional[pulumi.Input[Optional[str]]] = None,
                              scaling_group_id: Optional[pulumi.Input[str]] = None,
                              start_time: Optional[pulumi.Input[Optional[str]]] = None,
                              status_code: Optional[pulumi.Input[Optional[str]]] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[ScalingActivitiesResult]:
    """
    Use this data source to query detailed information of scaling activities
    ## Example Usage

    ```python
    import pulumi
    import pulumi_volcengine as volcengine

    foo_zones = volcengine.ecs.zones()
    foo_vpc = volcengine.vpc.Vpc("fooVpc",
        vpc_name="acc-test-vpc",
        cidr_block="172.16.0.0/16")
    foo_subnet = volcengine.vpc.Subnet("fooSubnet",
        subnet_name="acc-test-subnet",
        cidr_block="172.16.0.0/24",
        zone_id=foo_zones.zones[0].id,
        vpc_id=foo_vpc.id)
    foo_security_group = volcengine.vpc.SecurityGroup("fooSecurityGroup",
        security_group_name="acc-test-security-group",
        vpc_id=foo_vpc.id)
    foo_images = volcengine.ecs.images(os_type="Linux",
        visibility="public",
        instance_type_id="ecs.g1.large")
    foo_key_pair = volcengine.ecs.KeyPair("fooKeyPair",
        description="acc-test-2",
        key_pair_name="acc-test-key-pair-name")
    foo_launch_template = volcengine.ecs.LaunchTemplate("fooLaunchTemplate",
        description="acc-test-desc",
        eip_bandwidth=200,
        eip_billing_type="PostPaidByBandwidth",
        eip_isp="BGP",
        host_name="acc-hostname",
        image_id=foo_images.images[0].image_id,
        instance_charge_type="PostPaid",
        instance_name="acc-instance-name",
        instance_type_id="ecs.g1.large",
        key_pair_name=foo_key_pair.key_pair_name,
        launch_template_name="acc-test-template",
        network_interfaces=[volcengine.ecs.LaunchTemplateNetworkInterfaceArgs(
            subnet_id=foo_subnet.id,
            security_group_ids=[foo_security_group.id],
        )],
        volumes=[volcengine.ecs.LaunchTemplateVolumeArgs(
            volume_type="ESSD_PL0",
            size=50,
            delete_with_instance=True,
        )])
    foo_scaling_group = volcengine.autoscaling.ScalingGroup("fooScalingGroup",
        scaling_group_name="acc-test-scaling-group",
        subnet_ids=[foo_subnet.id],
        multi_az_policy="BALANCE",
        desire_instance_number=-1,
        min_instance_number=0,
        max_instance_number=10,
        instance_terminate_policy="OldestInstance",
        default_cooldown=10,
        launch_template_id=foo_launch_template.id,
        launch_template_version="Default")
    foo_scaling_group_enabler = volcengine.autoscaling.ScalingGroupEnabler("fooScalingGroupEnabler", scaling_group_id=foo_scaling_group.id)
    foo_instance = []
    for range in [{"value": i} for i in range(0, 3)]:
        foo_instance.append(volcengine.ecs.Instance(f"fooInstance-{range['value']}",
            instance_name=f"acc-test-ecs-{range['value']}",
            description="acc-test",
            host_name="tf-acc-test",
            image_id=foo_images.images[0].image_id,
            instance_type="ecs.g1.large",
            password="93f0cb0614Aab12",
            instance_charge_type="PostPaid",
            system_volume_type="ESSD_PL0",
            system_volume_size=40,
            subnet_id=foo_subnet.id,
            security_group_ids=[foo_security_group.id]))
    foo_scaling_instance_attachment = []
    def create_foo_scaling_instance_attachment(range_body):
        for range in [{"value": i} for i in range(0, range_body)]:
            foo_scaling_instance_attachment.append(volcengine.autoscaling.ScalingInstanceAttachment(f"fooScalingInstanceAttachment-{range['value']}",
                instance_id=foo_instance[range["value"]].id,
                scaling_group_id=foo_scaling_group.id,
                entrusted=True,
                opts=pulumi.ResourceOptions(depends_on=[foo_scaling_group_enabler])))

    (len(foo_instance)).apply(create_foo_scaling_instance_attachment)
    foo_scaling_activities = volcengine.autoscaling.scaling_activities_output(scaling_group_id=foo_scaling_group.id)
    ```


    :param str end_time: An end time to start a Scaling Activity.
    :param Sequence[str] ids: A list of Scaling Activity IDs.
    :param str output_file: File name where to save data source results.
    :param str scaling_group_id: A Id of Scaling Group.
    :param str start_time: A start time to start a Scaling Activity.
    :param str status_code: A status code of Scaling Activity. Valid values: Init, Running, Success, PartialSuccess, Error, Rejected, Exception.
    """
    ...
