# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ScalingConfigurationArgs', 'ScalingConfiguration']

@pulumi.input_type
class ScalingConfigurationArgs:
    def __init__(__self__, *,
                 image_id: pulumi.Input[str],
                 instance_name: pulumi.Input[str],
                 instance_types: pulumi.Input[Sequence[pulumi.Input[str]]],
                 scaling_configuration_name: pulumi.Input[str],
                 scaling_group_id: pulumi.Input[str],
                 security_group_ids: pulumi.Input[Sequence[pulumi.Input[str]]],
                 volumes: pulumi.Input[Sequence[pulumi.Input['ScalingConfigurationVolumeArgs']]],
                 eip_bandwidth: Optional[pulumi.Input[int]] = None,
                 eip_billing_type: Optional[pulumi.Input[str]] = None,
                 eip_isp: Optional[pulumi.Input[str]] = None,
                 host_name: Optional[pulumi.Input[str]] = None,
                 hpc_cluster_id: Optional[pulumi.Input[str]] = None,
                 instance_description: Optional[pulumi.Input[str]] = None,
                 ipv6_address_count: Optional[pulumi.Input[int]] = None,
                 key_pair_name: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 project_name: Optional[pulumi.Input[str]] = None,
                 security_enhancement_strategy: Optional[pulumi.Input[str]] = None,
                 spot_strategy: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['ScalingConfigurationTagArgs']]]] = None,
                 user_data: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a ScalingConfiguration resource.
        :param pulumi.Input[str] image_id: The ECS image id which the scaling configuration set.
        :param pulumi.Input[str] instance_name: The ECS instance name which the scaling configuration set.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] instance_types: The list of the ECS instance type which the scaling configuration set. The maximum number of instance types is 10.
        :param pulumi.Input[str] scaling_configuration_name: The name of the scaling configuration.
        :param pulumi.Input[str] scaling_group_id: The id of the scaling group to which the scaling configuration belongs.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_group_ids: The list of the security group id of the networkInterface which the scaling configuration set. A maximum of 5 security groups can be bound at the same time, and the value ranges from 1 to 5.
        :param pulumi.Input[Sequence[pulumi.Input['ScalingConfigurationVolumeArgs']]] volumes: The list of volume of the scaling configuration. The number of supported volumes ranges from 1 to 15.
        :param pulumi.Input[int] eip_bandwidth: The EIP bandwidth which the scaling configuration set. When the value of Eip.BillingType is PostPaidByBandwidth, the value is 1 to 500. When the value of Eip.BillingType is PostPaidByTraffic, the value is 1 to 200.
        :param pulumi.Input[str] eip_billing_type: The EIP billing type which the scaling configuration set. Valid values: PostPaidByBandwidth, PostPaidByTraffic.
        :param pulumi.Input[str] eip_isp: The EIP ISP which the scaling configuration set. Valid values: BGP, ChinaMobile, ChinaUnicom, ChinaTelecom.
        :param pulumi.Input[str] host_name: The ECS hostname which the scaling configuration set.
        :param pulumi.Input[str] hpc_cluster_id: The ID of the HPC cluster to which the instance belongs. Valid only when InstanceTypes.N specifies High Performance Computing GPU Type.
        :param pulumi.Input[str] instance_description: The ECS instance description which the scaling configuration set.
        :param pulumi.Input[int] ipv6_address_count: Assign IPv6 address to instance network card. Possible values:
               0: Do not assign IPv6 address.
               1: Assign IPv6 address and the system will automatically assign an IPv6 subnet for you.
        :param pulumi.Input[str] key_pair_name: The ECS key pair name which the scaling configuration set.
        :param pulumi.Input[str] password: The ECS password which the scaling configuration set.
        :param pulumi.Input[str] project_name: The project to which the instance created by the scaling configuration belongs.
        :param pulumi.Input[str] security_enhancement_strategy: The Ecs security enhancement strategy which the scaling configuration set. Valid values: Active, InActive.
        :param pulumi.Input[str] spot_strategy: The preemption policy of the instance. Valid Value: NoSpot (default), SpotAsPriceGo.
        :param pulumi.Input[Sequence[pulumi.Input['ScalingConfigurationTagArgs']]] tags: The label of the instance created by the scaling configuration. Up to 20 tags are supported.
        :param pulumi.Input[str] user_data: The ECS user data which the scaling configuration set.
        """
        pulumi.set(__self__, "image_id", image_id)
        pulumi.set(__self__, "instance_name", instance_name)
        pulumi.set(__self__, "instance_types", instance_types)
        pulumi.set(__self__, "scaling_configuration_name", scaling_configuration_name)
        pulumi.set(__self__, "scaling_group_id", scaling_group_id)
        pulumi.set(__self__, "security_group_ids", security_group_ids)
        pulumi.set(__self__, "volumes", volumes)
        if eip_bandwidth is not None:
            pulumi.set(__self__, "eip_bandwidth", eip_bandwidth)
        if eip_billing_type is not None:
            pulumi.set(__self__, "eip_billing_type", eip_billing_type)
        if eip_isp is not None:
            pulumi.set(__self__, "eip_isp", eip_isp)
        if host_name is not None:
            pulumi.set(__self__, "host_name", host_name)
        if hpc_cluster_id is not None:
            pulumi.set(__self__, "hpc_cluster_id", hpc_cluster_id)
        if instance_description is not None:
            pulumi.set(__self__, "instance_description", instance_description)
        if ipv6_address_count is not None:
            pulumi.set(__self__, "ipv6_address_count", ipv6_address_count)
        if key_pair_name is not None:
            pulumi.set(__self__, "key_pair_name", key_pair_name)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if project_name is not None:
            pulumi.set(__self__, "project_name", project_name)
        if security_enhancement_strategy is not None:
            pulumi.set(__self__, "security_enhancement_strategy", security_enhancement_strategy)
        if spot_strategy is not None:
            pulumi.set(__self__, "spot_strategy", spot_strategy)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if user_data is not None:
            pulumi.set(__self__, "user_data", user_data)

    @property
    @pulumi.getter(name="imageId")
    def image_id(self) -> pulumi.Input[str]:
        """
        The ECS image id which the scaling configuration set.
        """
        return pulumi.get(self, "image_id")

    @image_id.setter
    def image_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "image_id", value)

    @property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> pulumi.Input[str]:
        """
        The ECS instance name which the scaling configuration set.
        """
        return pulumi.get(self, "instance_name")

    @instance_name.setter
    def instance_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "instance_name", value)

    @property
    @pulumi.getter(name="instanceTypes")
    def instance_types(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        The list of the ECS instance type which the scaling configuration set. The maximum number of instance types is 10.
        """
        return pulumi.get(self, "instance_types")

    @instance_types.setter
    def instance_types(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "instance_types", value)

    @property
    @pulumi.getter(name="scalingConfigurationName")
    def scaling_configuration_name(self) -> pulumi.Input[str]:
        """
        The name of the scaling configuration.
        """
        return pulumi.get(self, "scaling_configuration_name")

    @scaling_configuration_name.setter
    def scaling_configuration_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "scaling_configuration_name", value)

    @property
    @pulumi.getter(name="scalingGroupId")
    def scaling_group_id(self) -> pulumi.Input[str]:
        """
        The id of the scaling group to which the scaling configuration belongs.
        """
        return pulumi.get(self, "scaling_group_id")

    @scaling_group_id.setter
    def scaling_group_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "scaling_group_id", value)

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        The list of the security group id of the networkInterface which the scaling configuration set. A maximum of 5 security groups can be bound at the same time, and the value ranges from 1 to 5.
        """
        return pulumi.get(self, "security_group_ids")

    @security_group_ids.setter
    def security_group_ids(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "security_group_ids", value)

    @property
    @pulumi.getter
    def volumes(self) -> pulumi.Input[Sequence[pulumi.Input['ScalingConfigurationVolumeArgs']]]:
        """
        The list of volume of the scaling configuration. The number of supported volumes ranges from 1 to 15.
        """
        return pulumi.get(self, "volumes")

    @volumes.setter
    def volumes(self, value: pulumi.Input[Sequence[pulumi.Input['ScalingConfigurationVolumeArgs']]]):
        pulumi.set(self, "volumes", value)

    @property
    @pulumi.getter(name="eipBandwidth")
    def eip_bandwidth(self) -> Optional[pulumi.Input[int]]:
        """
        The EIP bandwidth which the scaling configuration set. When the value of Eip.BillingType is PostPaidByBandwidth, the value is 1 to 500. When the value of Eip.BillingType is PostPaidByTraffic, the value is 1 to 200.
        """
        return pulumi.get(self, "eip_bandwidth")

    @eip_bandwidth.setter
    def eip_bandwidth(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "eip_bandwidth", value)

    @property
    @pulumi.getter(name="eipBillingType")
    def eip_billing_type(self) -> Optional[pulumi.Input[str]]:
        """
        The EIP billing type which the scaling configuration set. Valid values: PostPaidByBandwidth, PostPaidByTraffic.
        """
        return pulumi.get(self, "eip_billing_type")

    @eip_billing_type.setter
    def eip_billing_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "eip_billing_type", value)

    @property
    @pulumi.getter(name="eipIsp")
    def eip_isp(self) -> Optional[pulumi.Input[str]]:
        """
        The EIP ISP which the scaling configuration set. Valid values: BGP, ChinaMobile, ChinaUnicom, ChinaTelecom.
        """
        return pulumi.get(self, "eip_isp")

    @eip_isp.setter
    def eip_isp(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "eip_isp", value)

    @property
    @pulumi.getter(name="hostName")
    def host_name(self) -> Optional[pulumi.Input[str]]:
        """
        The ECS hostname which the scaling configuration set.
        """
        return pulumi.get(self, "host_name")

    @host_name.setter
    def host_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "host_name", value)

    @property
    @pulumi.getter(name="hpcClusterId")
    def hpc_cluster_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the HPC cluster to which the instance belongs. Valid only when InstanceTypes.N specifies High Performance Computing GPU Type.
        """
        return pulumi.get(self, "hpc_cluster_id")

    @hpc_cluster_id.setter
    def hpc_cluster_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "hpc_cluster_id", value)

    @property
    @pulumi.getter(name="instanceDescription")
    def instance_description(self) -> Optional[pulumi.Input[str]]:
        """
        The ECS instance description which the scaling configuration set.
        """
        return pulumi.get(self, "instance_description")

    @instance_description.setter
    def instance_description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_description", value)

    @property
    @pulumi.getter(name="ipv6AddressCount")
    def ipv6_address_count(self) -> Optional[pulumi.Input[int]]:
        """
        Assign IPv6 address to instance network card. Possible values:
        0: Do not assign IPv6 address.
        1: Assign IPv6 address and the system will automatically assign an IPv6 subnet for you.
        """
        return pulumi.get(self, "ipv6_address_count")

    @ipv6_address_count.setter
    def ipv6_address_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "ipv6_address_count", value)

    @property
    @pulumi.getter(name="keyPairName")
    def key_pair_name(self) -> Optional[pulumi.Input[str]]:
        """
        The ECS key pair name which the scaling configuration set.
        """
        return pulumi.get(self, "key_pair_name")

    @key_pair_name.setter
    def key_pair_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_pair_name", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        The ECS password which the scaling configuration set.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter(name="projectName")
    def project_name(self) -> Optional[pulumi.Input[str]]:
        """
        The project to which the instance created by the scaling configuration belongs.
        """
        return pulumi.get(self, "project_name")

    @project_name.setter
    def project_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_name", value)

    @property
    @pulumi.getter(name="securityEnhancementStrategy")
    def security_enhancement_strategy(self) -> Optional[pulumi.Input[str]]:
        """
        The Ecs security enhancement strategy which the scaling configuration set. Valid values: Active, InActive.
        """
        return pulumi.get(self, "security_enhancement_strategy")

    @security_enhancement_strategy.setter
    def security_enhancement_strategy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "security_enhancement_strategy", value)

    @property
    @pulumi.getter(name="spotStrategy")
    def spot_strategy(self) -> Optional[pulumi.Input[str]]:
        """
        The preemption policy of the instance. Valid Value: NoSpot (default), SpotAsPriceGo.
        """
        return pulumi.get(self, "spot_strategy")

    @spot_strategy.setter
    def spot_strategy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "spot_strategy", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ScalingConfigurationTagArgs']]]]:
        """
        The label of the instance created by the scaling configuration. Up to 20 tags are supported.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ScalingConfigurationTagArgs']]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="userData")
    def user_data(self) -> Optional[pulumi.Input[str]]:
        """
        The ECS user data which the scaling configuration set.
        """
        return pulumi.get(self, "user_data")

    @user_data.setter
    def user_data(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_data", value)


@pulumi.input_type
class _ScalingConfigurationState:
    def __init__(__self__, *,
                 created_at: Optional[pulumi.Input[str]] = None,
                 eip_bandwidth: Optional[pulumi.Input[int]] = None,
                 eip_billing_type: Optional[pulumi.Input[str]] = None,
                 eip_isp: Optional[pulumi.Input[str]] = None,
                 host_name: Optional[pulumi.Input[str]] = None,
                 hpc_cluster_id: Optional[pulumi.Input[str]] = None,
                 image_id: Optional[pulumi.Input[str]] = None,
                 instance_description: Optional[pulumi.Input[str]] = None,
                 instance_name: Optional[pulumi.Input[str]] = None,
                 instance_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 ipv6_address_count: Optional[pulumi.Input[int]] = None,
                 key_pair_name: Optional[pulumi.Input[str]] = None,
                 lifecycle_state: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 project_name: Optional[pulumi.Input[str]] = None,
                 scaling_configuration_id: Optional[pulumi.Input[str]] = None,
                 scaling_configuration_name: Optional[pulumi.Input[str]] = None,
                 scaling_group_id: Optional[pulumi.Input[str]] = None,
                 security_enhancement_strategy: Optional[pulumi.Input[str]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 spot_strategy: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['ScalingConfigurationTagArgs']]]] = None,
                 updated_at: Optional[pulumi.Input[str]] = None,
                 user_data: Optional[pulumi.Input[str]] = None,
                 volumes: Optional[pulumi.Input[Sequence[pulumi.Input['ScalingConfigurationVolumeArgs']]]] = None):
        """
        Input properties used for looking up and filtering ScalingConfiguration resources.
        :param pulumi.Input[str] created_at: The create time of the scaling configuration.
        :param pulumi.Input[int] eip_bandwidth: The EIP bandwidth which the scaling configuration set. When the value of Eip.BillingType is PostPaidByBandwidth, the value is 1 to 500. When the value of Eip.BillingType is PostPaidByTraffic, the value is 1 to 200.
        :param pulumi.Input[str] eip_billing_type: The EIP billing type which the scaling configuration set. Valid values: PostPaidByBandwidth, PostPaidByTraffic.
        :param pulumi.Input[str] eip_isp: The EIP ISP which the scaling configuration set. Valid values: BGP, ChinaMobile, ChinaUnicom, ChinaTelecom.
        :param pulumi.Input[str] host_name: The ECS hostname which the scaling configuration set.
        :param pulumi.Input[str] hpc_cluster_id: The ID of the HPC cluster to which the instance belongs. Valid only when InstanceTypes.N specifies High Performance Computing GPU Type.
        :param pulumi.Input[str] image_id: The ECS image id which the scaling configuration set.
        :param pulumi.Input[str] instance_description: The ECS instance description which the scaling configuration set.
        :param pulumi.Input[str] instance_name: The ECS instance name which the scaling configuration set.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] instance_types: The list of the ECS instance type which the scaling configuration set. The maximum number of instance types is 10.
        :param pulumi.Input[int] ipv6_address_count: Assign IPv6 address to instance network card. Possible values:
               0: Do not assign IPv6 address.
               1: Assign IPv6 address and the system will automatically assign an IPv6 subnet for you.
        :param pulumi.Input[str] key_pair_name: The ECS key pair name which the scaling configuration set.
        :param pulumi.Input[str] lifecycle_state: The lifecycle state of the scaling configuration.
        :param pulumi.Input[str] password: The ECS password which the scaling configuration set.
        :param pulumi.Input[str] project_name: The project to which the instance created by the scaling configuration belongs.
        :param pulumi.Input[str] scaling_configuration_id: The id of the scaling configuration.
        :param pulumi.Input[str] scaling_configuration_name: The name of the scaling configuration.
        :param pulumi.Input[str] scaling_group_id: The id of the scaling group to which the scaling configuration belongs.
        :param pulumi.Input[str] security_enhancement_strategy: The Ecs security enhancement strategy which the scaling configuration set. Valid values: Active, InActive.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_group_ids: The list of the security group id of the networkInterface which the scaling configuration set. A maximum of 5 security groups can be bound at the same time, and the value ranges from 1 to 5.
        :param pulumi.Input[str] spot_strategy: The preemption policy of the instance. Valid Value: NoSpot (default), SpotAsPriceGo.
        :param pulumi.Input[Sequence[pulumi.Input['ScalingConfigurationTagArgs']]] tags: The label of the instance created by the scaling configuration. Up to 20 tags are supported.
        :param pulumi.Input[str] updated_at: The create time of the scaling configuration.
        :param pulumi.Input[str] user_data: The ECS user data which the scaling configuration set.
        :param pulumi.Input[Sequence[pulumi.Input['ScalingConfigurationVolumeArgs']]] volumes: The list of volume of the scaling configuration. The number of supported volumes ranges from 1 to 15.
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if eip_bandwidth is not None:
            pulumi.set(__self__, "eip_bandwidth", eip_bandwidth)
        if eip_billing_type is not None:
            pulumi.set(__self__, "eip_billing_type", eip_billing_type)
        if eip_isp is not None:
            pulumi.set(__self__, "eip_isp", eip_isp)
        if host_name is not None:
            pulumi.set(__self__, "host_name", host_name)
        if hpc_cluster_id is not None:
            pulumi.set(__self__, "hpc_cluster_id", hpc_cluster_id)
        if image_id is not None:
            pulumi.set(__self__, "image_id", image_id)
        if instance_description is not None:
            pulumi.set(__self__, "instance_description", instance_description)
        if instance_name is not None:
            pulumi.set(__self__, "instance_name", instance_name)
        if instance_types is not None:
            pulumi.set(__self__, "instance_types", instance_types)
        if ipv6_address_count is not None:
            pulumi.set(__self__, "ipv6_address_count", ipv6_address_count)
        if key_pair_name is not None:
            pulumi.set(__self__, "key_pair_name", key_pair_name)
        if lifecycle_state is not None:
            pulumi.set(__self__, "lifecycle_state", lifecycle_state)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if project_name is not None:
            pulumi.set(__self__, "project_name", project_name)
        if scaling_configuration_id is not None:
            pulumi.set(__self__, "scaling_configuration_id", scaling_configuration_id)
        if scaling_configuration_name is not None:
            pulumi.set(__self__, "scaling_configuration_name", scaling_configuration_name)
        if scaling_group_id is not None:
            pulumi.set(__self__, "scaling_group_id", scaling_group_id)
        if security_enhancement_strategy is not None:
            pulumi.set(__self__, "security_enhancement_strategy", security_enhancement_strategy)
        if security_group_ids is not None:
            pulumi.set(__self__, "security_group_ids", security_group_ids)
        if spot_strategy is not None:
            pulumi.set(__self__, "spot_strategy", spot_strategy)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)
        if user_data is not None:
            pulumi.set(__self__, "user_data", user_data)
        if volumes is not None:
            pulumi.set(__self__, "volumes", volumes)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[str]]:
        """
        The create time of the scaling configuration.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "created_at", value)

    @property
    @pulumi.getter(name="eipBandwidth")
    def eip_bandwidth(self) -> Optional[pulumi.Input[int]]:
        """
        The EIP bandwidth which the scaling configuration set. When the value of Eip.BillingType is PostPaidByBandwidth, the value is 1 to 500. When the value of Eip.BillingType is PostPaidByTraffic, the value is 1 to 200.
        """
        return pulumi.get(self, "eip_bandwidth")

    @eip_bandwidth.setter
    def eip_bandwidth(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "eip_bandwidth", value)

    @property
    @pulumi.getter(name="eipBillingType")
    def eip_billing_type(self) -> Optional[pulumi.Input[str]]:
        """
        The EIP billing type which the scaling configuration set. Valid values: PostPaidByBandwidth, PostPaidByTraffic.
        """
        return pulumi.get(self, "eip_billing_type")

    @eip_billing_type.setter
    def eip_billing_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "eip_billing_type", value)

    @property
    @pulumi.getter(name="eipIsp")
    def eip_isp(self) -> Optional[pulumi.Input[str]]:
        """
        The EIP ISP which the scaling configuration set. Valid values: BGP, ChinaMobile, ChinaUnicom, ChinaTelecom.
        """
        return pulumi.get(self, "eip_isp")

    @eip_isp.setter
    def eip_isp(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "eip_isp", value)

    @property
    @pulumi.getter(name="hostName")
    def host_name(self) -> Optional[pulumi.Input[str]]:
        """
        The ECS hostname which the scaling configuration set.
        """
        return pulumi.get(self, "host_name")

    @host_name.setter
    def host_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "host_name", value)

    @property
    @pulumi.getter(name="hpcClusterId")
    def hpc_cluster_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the HPC cluster to which the instance belongs. Valid only when InstanceTypes.N specifies High Performance Computing GPU Type.
        """
        return pulumi.get(self, "hpc_cluster_id")

    @hpc_cluster_id.setter
    def hpc_cluster_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "hpc_cluster_id", value)

    @property
    @pulumi.getter(name="imageId")
    def image_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ECS image id which the scaling configuration set.
        """
        return pulumi.get(self, "image_id")

    @image_id.setter
    def image_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "image_id", value)

    @property
    @pulumi.getter(name="instanceDescription")
    def instance_description(self) -> Optional[pulumi.Input[str]]:
        """
        The ECS instance description which the scaling configuration set.
        """
        return pulumi.get(self, "instance_description")

    @instance_description.setter
    def instance_description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_description", value)

    @property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> Optional[pulumi.Input[str]]:
        """
        The ECS instance name which the scaling configuration set.
        """
        return pulumi.get(self, "instance_name")

    @instance_name.setter
    def instance_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_name", value)

    @property
    @pulumi.getter(name="instanceTypes")
    def instance_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of the ECS instance type which the scaling configuration set. The maximum number of instance types is 10.
        """
        return pulumi.get(self, "instance_types")

    @instance_types.setter
    def instance_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "instance_types", value)

    @property
    @pulumi.getter(name="ipv6AddressCount")
    def ipv6_address_count(self) -> Optional[pulumi.Input[int]]:
        """
        Assign IPv6 address to instance network card. Possible values:
        0: Do not assign IPv6 address.
        1: Assign IPv6 address and the system will automatically assign an IPv6 subnet for you.
        """
        return pulumi.get(self, "ipv6_address_count")

    @ipv6_address_count.setter
    def ipv6_address_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "ipv6_address_count", value)

    @property
    @pulumi.getter(name="keyPairName")
    def key_pair_name(self) -> Optional[pulumi.Input[str]]:
        """
        The ECS key pair name which the scaling configuration set.
        """
        return pulumi.get(self, "key_pair_name")

    @key_pair_name.setter
    def key_pair_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_pair_name", value)

    @property
    @pulumi.getter(name="lifecycleState")
    def lifecycle_state(self) -> Optional[pulumi.Input[str]]:
        """
        The lifecycle state of the scaling configuration.
        """
        return pulumi.get(self, "lifecycle_state")

    @lifecycle_state.setter
    def lifecycle_state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lifecycle_state", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        The ECS password which the scaling configuration set.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter(name="projectName")
    def project_name(self) -> Optional[pulumi.Input[str]]:
        """
        The project to which the instance created by the scaling configuration belongs.
        """
        return pulumi.get(self, "project_name")

    @project_name.setter
    def project_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_name", value)

    @property
    @pulumi.getter(name="scalingConfigurationId")
    def scaling_configuration_id(self) -> Optional[pulumi.Input[str]]:
        """
        The id of the scaling configuration.
        """
        return pulumi.get(self, "scaling_configuration_id")

    @scaling_configuration_id.setter
    def scaling_configuration_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "scaling_configuration_id", value)

    @property
    @pulumi.getter(name="scalingConfigurationName")
    def scaling_configuration_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the scaling configuration.
        """
        return pulumi.get(self, "scaling_configuration_name")

    @scaling_configuration_name.setter
    def scaling_configuration_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "scaling_configuration_name", value)

    @property
    @pulumi.getter(name="scalingGroupId")
    def scaling_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        The id of the scaling group to which the scaling configuration belongs.
        """
        return pulumi.get(self, "scaling_group_id")

    @scaling_group_id.setter
    def scaling_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "scaling_group_id", value)

    @property
    @pulumi.getter(name="securityEnhancementStrategy")
    def security_enhancement_strategy(self) -> Optional[pulumi.Input[str]]:
        """
        The Ecs security enhancement strategy which the scaling configuration set. Valid values: Active, InActive.
        """
        return pulumi.get(self, "security_enhancement_strategy")

    @security_enhancement_strategy.setter
    def security_enhancement_strategy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "security_enhancement_strategy", value)

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of the security group id of the networkInterface which the scaling configuration set. A maximum of 5 security groups can be bound at the same time, and the value ranges from 1 to 5.
        """
        return pulumi.get(self, "security_group_ids")

    @security_group_ids.setter
    def security_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "security_group_ids", value)

    @property
    @pulumi.getter(name="spotStrategy")
    def spot_strategy(self) -> Optional[pulumi.Input[str]]:
        """
        The preemption policy of the instance. Valid Value: NoSpot (default), SpotAsPriceGo.
        """
        return pulumi.get(self, "spot_strategy")

    @spot_strategy.setter
    def spot_strategy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "spot_strategy", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ScalingConfigurationTagArgs']]]]:
        """
        The label of the instance created by the scaling configuration. Up to 20 tags are supported.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ScalingConfigurationTagArgs']]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[str]]:
        """
        The create time of the scaling configuration.
        """
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "updated_at", value)

    @property
    @pulumi.getter(name="userData")
    def user_data(self) -> Optional[pulumi.Input[str]]:
        """
        The ECS user data which the scaling configuration set.
        """
        return pulumi.get(self, "user_data")

    @user_data.setter
    def user_data(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_data", value)

    @property
    @pulumi.getter
    def volumes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ScalingConfigurationVolumeArgs']]]]:
        """
        The list of volume of the scaling configuration. The number of supported volumes ranges from 1 to 15.
        """
        return pulumi.get(self, "volumes")

    @volumes.setter
    def volumes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ScalingConfigurationVolumeArgs']]]]):
        pulumi.set(self, "volumes", value)


class ScalingConfiguration(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 eip_bandwidth: Optional[pulumi.Input[int]] = None,
                 eip_billing_type: Optional[pulumi.Input[str]] = None,
                 eip_isp: Optional[pulumi.Input[str]] = None,
                 host_name: Optional[pulumi.Input[str]] = None,
                 hpc_cluster_id: Optional[pulumi.Input[str]] = None,
                 image_id: Optional[pulumi.Input[str]] = None,
                 instance_description: Optional[pulumi.Input[str]] = None,
                 instance_name: Optional[pulumi.Input[str]] = None,
                 instance_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 ipv6_address_count: Optional[pulumi.Input[int]] = None,
                 key_pair_name: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 project_name: Optional[pulumi.Input[str]] = None,
                 scaling_configuration_name: Optional[pulumi.Input[str]] = None,
                 scaling_group_id: Optional[pulumi.Input[str]] = None,
                 security_enhancement_strategy: Optional[pulumi.Input[str]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 spot_strategy: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ScalingConfigurationTagArgs']]]]] = None,
                 user_data: Optional[pulumi.Input[str]] = None,
                 volumes: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ScalingConfigurationVolumeArgs']]]]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_volcengine as volcengine

        foo_zones = volcengine.ecs.zones()
        foo_vpc = volcengine.vpc.Vpc("fooVpc",
            vpc_name="acc-test-vpc",
            cidr_block="172.16.0.0/16")
        foo_subnet = volcengine.vpc.Subnet("fooSubnet",
            subnet_name="acc-test-subnet",
            cidr_block="172.16.0.0/24",
            zone_id=foo_zones.zones[0].id,
            vpc_id=foo_vpc.id)
        foo_security_group = volcengine.vpc.SecurityGroup("fooSecurityGroup",
            security_group_name="acc-test-security-group",
            vpc_id=foo_vpc.id)
        foo_images = volcengine.ecs.images(os_type="Linux",
            visibility="public",
            instance_type_id="ecs.g1.large")
        foo_scaling_group = volcengine.autoscaling.ScalingGroup("fooScalingGroup",
            scaling_group_name="acc-test-scaling-group",
            subnet_ids=[foo_subnet.id],
            multi_az_policy="BALANCE",
            desire_instance_number=0,
            min_instance_number=0,
            max_instance_number=1,
            instance_terminate_policy="OldestInstance",
            default_cooldown=10)
        foo_scaling_configuration = volcengine.autoscaling.ScalingConfiguration("fooScalingConfiguration",
            scaling_configuration_name="tf-test",
            scaling_group_id=foo_scaling_group.id,
            image_id=foo_images.images[0].image_id,
            instance_types=["ecs.g2i.large"],
            instance_name="tf-test",
            instance_description="",
            host_name="",
            password="",
            key_pair_name="tf-keypair",
            security_enhancement_strategy="InActive",
            volumes=[
                volcengine.autoscaling.ScalingConfigurationVolumeArgs(
                    volume_type="ESSD_PL0",
                    size=20,
                    delete_with_instance=False,
                ),
                volcengine.autoscaling.ScalingConfigurationVolumeArgs(
                    volume_type="ESSD_PL0",
                    size=50,
                    delete_with_instance=True,
                ),
            ],
            security_group_ids=[foo_security_group.id],
            eip_bandwidth=10,
            eip_isp="ChinaMobile",
            eip_billing_type="PostPaidByBandwidth",
            user_data="IyEvYmluL2Jhc2gKZWNobyAidGVzdCI=",
            tags=[
                volcengine.autoscaling.ScalingConfigurationTagArgs(
                    key="tf-key1",
                    value="tf-value1",
                ),
                volcengine.autoscaling.ScalingConfigurationTagArgs(
                    key="tf-key2",
                    value="tf-value2",
                ),
            ],
            project_name="default",
            hpc_cluster_id="",
            spot_strategy="NoSpot")
        ```

        ## Import

        ScalingConfiguration can be imported using the id, e.g.

        ```sh
         $ pulumi import volcengine:autoscaling/scalingConfiguration:ScalingConfiguration default scc-ybkuck3mx8cm9tm5yglz
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] eip_bandwidth: The EIP bandwidth which the scaling configuration set. When the value of Eip.BillingType is PostPaidByBandwidth, the value is 1 to 500. When the value of Eip.BillingType is PostPaidByTraffic, the value is 1 to 200.
        :param pulumi.Input[str] eip_billing_type: The EIP billing type which the scaling configuration set. Valid values: PostPaidByBandwidth, PostPaidByTraffic.
        :param pulumi.Input[str] eip_isp: The EIP ISP which the scaling configuration set. Valid values: BGP, ChinaMobile, ChinaUnicom, ChinaTelecom.
        :param pulumi.Input[str] host_name: The ECS hostname which the scaling configuration set.
        :param pulumi.Input[str] hpc_cluster_id: The ID of the HPC cluster to which the instance belongs. Valid only when InstanceTypes.N specifies High Performance Computing GPU Type.
        :param pulumi.Input[str] image_id: The ECS image id which the scaling configuration set.
        :param pulumi.Input[str] instance_description: The ECS instance description which the scaling configuration set.
        :param pulumi.Input[str] instance_name: The ECS instance name which the scaling configuration set.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] instance_types: The list of the ECS instance type which the scaling configuration set. The maximum number of instance types is 10.
        :param pulumi.Input[int] ipv6_address_count: Assign IPv6 address to instance network card. Possible values:
               0: Do not assign IPv6 address.
               1: Assign IPv6 address and the system will automatically assign an IPv6 subnet for you.
        :param pulumi.Input[str] key_pair_name: The ECS key pair name which the scaling configuration set.
        :param pulumi.Input[str] password: The ECS password which the scaling configuration set.
        :param pulumi.Input[str] project_name: The project to which the instance created by the scaling configuration belongs.
        :param pulumi.Input[str] scaling_configuration_name: The name of the scaling configuration.
        :param pulumi.Input[str] scaling_group_id: The id of the scaling group to which the scaling configuration belongs.
        :param pulumi.Input[str] security_enhancement_strategy: The Ecs security enhancement strategy which the scaling configuration set. Valid values: Active, InActive.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_group_ids: The list of the security group id of the networkInterface which the scaling configuration set. A maximum of 5 security groups can be bound at the same time, and the value ranges from 1 to 5.
        :param pulumi.Input[str] spot_strategy: The preemption policy of the instance. Valid Value: NoSpot (default), SpotAsPriceGo.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ScalingConfigurationTagArgs']]]] tags: The label of the instance created by the scaling configuration. Up to 20 tags are supported.
        :param pulumi.Input[str] user_data: The ECS user data which the scaling configuration set.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ScalingConfigurationVolumeArgs']]]] volumes: The list of volume of the scaling configuration. The number of supported volumes ranges from 1 to 15.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ScalingConfigurationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_volcengine as volcengine

        foo_zones = volcengine.ecs.zones()
        foo_vpc = volcengine.vpc.Vpc("fooVpc",
            vpc_name="acc-test-vpc",
            cidr_block="172.16.0.0/16")
        foo_subnet = volcengine.vpc.Subnet("fooSubnet",
            subnet_name="acc-test-subnet",
            cidr_block="172.16.0.0/24",
            zone_id=foo_zones.zones[0].id,
            vpc_id=foo_vpc.id)
        foo_security_group = volcengine.vpc.SecurityGroup("fooSecurityGroup",
            security_group_name="acc-test-security-group",
            vpc_id=foo_vpc.id)
        foo_images = volcengine.ecs.images(os_type="Linux",
            visibility="public",
            instance_type_id="ecs.g1.large")
        foo_scaling_group = volcengine.autoscaling.ScalingGroup("fooScalingGroup",
            scaling_group_name="acc-test-scaling-group",
            subnet_ids=[foo_subnet.id],
            multi_az_policy="BALANCE",
            desire_instance_number=0,
            min_instance_number=0,
            max_instance_number=1,
            instance_terminate_policy="OldestInstance",
            default_cooldown=10)
        foo_scaling_configuration = volcengine.autoscaling.ScalingConfiguration("fooScalingConfiguration",
            scaling_configuration_name="tf-test",
            scaling_group_id=foo_scaling_group.id,
            image_id=foo_images.images[0].image_id,
            instance_types=["ecs.g2i.large"],
            instance_name="tf-test",
            instance_description="",
            host_name="",
            password="",
            key_pair_name="tf-keypair",
            security_enhancement_strategy="InActive",
            volumes=[
                volcengine.autoscaling.ScalingConfigurationVolumeArgs(
                    volume_type="ESSD_PL0",
                    size=20,
                    delete_with_instance=False,
                ),
                volcengine.autoscaling.ScalingConfigurationVolumeArgs(
                    volume_type="ESSD_PL0",
                    size=50,
                    delete_with_instance=True,
                ),
            ],
            security_group_ids=[foo_security_group.id],
            eip_bandwidth=10,
            eip_isp="ChinaMobile",
            eip_billing_type="PostPaidByBandwidth",
            user_data="IyEvYmluL2Jhc2gKZWNobyAidGVzdCI=",
            tags=[
                volcengine.autoscaling.ScalingConfigurationTagArgs(
                    key="tf-key1",
                    value="tf-value1",
                ),
                volcengine.autoscaling.ScalingConfigurationTagArgs(
                    key="tf-key2",
                    value="tf-value2",
                ),
            ],
            project_name="default",
            hpc_cluster_id="",
            spot_strategy="NoSpot")
        ```

        ## Import

        ScalingConfiguration can be imported using the id, e.g.

        ```sh
         $ pulumi import volcengine:autoscaling/scalingConfiguration:ScalingConfiguration default scc-ybkuck3mx8cm9tm5yglz
        ```

        :param str resource_name: The name of the resource.
        :param ScalingConfigurationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ScalingConfigurationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 eip_bandwidth: Optional[pulumi.Input[int]] = None,
                 eip_billing_type: Optional[pulumi.Input[str]] = None,
                 eip_isp: Optional[pulumi.Input[str]] = None,
                 host_name: Optional[pulumi.Input[str]] = None,
                 hpc_cluster_id: Optional[pulumi.Input[str]] = None,
                 image_id: Optional[pulumi.Input[str]] = None,
                 instance_description: Optional[pulumi.Input[str]] = None,
                 instance_name: Optional[pulumi.Input[str]] = None,
                 instance_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 ipv6_address_count: Optional[pulumi.Input[int]] = None,
                 key_pair_name: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 project_name: Optional[pulumi.Input[str]] = None,
                 scaling_configuration_name: Optional[pulumi.Input[str]] = None,
                 scaling_group_id: Optional[pulumi.Input[str]] = None,
                 security_enhancement_strategy: Optional[pulumi.Input[str]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 spot_strategy: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ScalingConfigurationTagArgs']]]]] = None,
                 user_data: Optional[pulumi.Input[str]] = None,
                 volumes: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ScalingConfigurationVolumeArgs']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ScalingConfigurationArgs.__new__(ScalingConfigurationArgs)

            __props__.__dict__["eip_bandwidth"] = eip_bandwidth
            __props__.__dict__["eip_billing_type"] = eip_billing_type
            __props__.__dict__["eip_isp"] = eip_isp
            __props__.__dict__["host_name"] = host_name
            __props__.__dict__["hpc_cluster_id"] = hpc_cluster_id
            if image_id is None and not opts.urn:
                raise TypeError("Missing required property 'image_id'")
            __props__.__dict__["image_id"] = image_id
            __props__.__dict__["instance_description"] = instance_description
            if instance_name is None and not opts.urn:
                raise TypeError("Missing required property 'instance_name'")
            __props__.__dict__["instance_name"] = instance_name
            if instance_types is None and not opts.urn:
                raise TypeError("Missing required property 'instance_types'")
            __props__.__dict__["instance_types"] = instance_types
            __props__.__dict__["ipv6_address_count"] = ipv6_address_count
            __props__.__dict__["key_pair_name"] = key_pair_name
            __props__.__dict__["password"] = None if password is None else pulumi.Output.secret(password)
            __props__.__dict__["project_name"] = project_name
            if scaling_configuration_name is None and not opts.urn:
                raise TypeError("Missing required property 'scaling_configuration_name'")
            __props__.__dict__["scaling_configuration_name"] = scaling_configuration_name
            if scaling_group_id is None and not opts.urn:
                raise TypeError("Missing required property 'scaling_group_id'")
            __props__.__dict__["scaling_group_id"] = scaling_group_id
            __props__.__dict__["security_enhancement_strategy"] = security_enhancement_strategy
            if security_group_ids is None and not opts.urn:
                raise TypeError("Missing required property 'security_group_ids'")
            __props__.__dict__["security_group_ids"] = security_group_ids
            __props__.__dict__["spot_strategy"] = spot_strategy
            __props__.__dict__["tags"] = tags
            __props__.__dict__["user_data"] = user_data
            if volumes is None and not opts.urn:
                raise TypeError("Missing required property 'volumes'")
            __props__.__dict__["volumes"] = volumes
            __props__.__dict__["created_at"] = None
            __props__.__dict__["lifecycle_state"] = None
            __props__.__dict__["scaling_configuration_id"] = None
            __props__.__dict__["updated_at"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["password"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(ScalingConfiguration, __self__).__init__(
            'volcengine:autoscaling/scalingConfiguration:ScalingConfiguration',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            created_at: Optional[pulumi.Input[str]] = None,
            eip_bandwidth: Optional[pulumi.Input[int]] = None,
            eip_billing_type: Optional[pulumi.Input[str]] = None,
            eip_isp: Optional[pulumi.Input[str]] = None,
            host_name: Optional[pulumi.Input[str]] = None,
            hpc_cluster_id: Optional[pulumi.Input[str]] = None,
            image_id: Optional[pulumi.Input[str]] = None,
            instance_description: Optional[pulumi.Input[str]] = None,
            instance_name: Optional[pulumi.Input[str]] = None,
            instance_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            ipv6_address_count: Optional[pulumi.Input[int]] = None,
            key_pair_name: Optional[pulumi.Input[str]] = None,
            lifecycle_state: Optional[pulumi.Input[str]] = None,
            password: Optional[pulumi.Input[str]] = None,
            project_name: Optional[pulumi.Input[str]] = None,
            scaling_configuration_id: Optional[pulumi.Input[str]] = None,
            scaling_configuration_name: Optional[pulumi.Input[str]] = None,
            scaling_group_id: Optional[pulumi.Input[str]] = None,
            security_enhancement_strategy: Optional[pulumi.Input[str]] = None,
            security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            spot_strategy: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ScalingConfigurationTagArgs']]]]] = None,
            updated_at: Optional[pulumi.Input[str]] = None,
            user_data: Optional[pulumi.Input[str]] = None,
            volumes: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ScalingConfigurationVolumeArgs']]]]] = None) -> 'ScalingConfiguration':
        """
        Get an existing ScalingConfiguration resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] created_at: The create time of the scaling configuration.
        :param pulumi.Input[int] eip_bandwidth: The EIP bandwidth which the scaling configuration set. When the value of Eip.BillingType is PostPaidByBandwidth, the value is 1 to 500. When the value of Eip.BillingType is PostPaidByTraffic, the value is 1 to 200.
        :param pulumi.Input[str] eip_billing_type: The EIP billing type which the scaling configuration set. Valid values: PostPaidByBandwidth, PostPaidByTraffic.
        :param pulumi.Input[str] eip_isp: The EIP ISP which the scaling configuration set. Valid values: BGP, ChinaMobile, ChinaUnicom, ChinaTelecom.
        :param pulumi.Input[str] host_name: The ECS hostname which the scaling configuration set.
        :param pulumi.Input[str] hpc_cluster_id: The ID of the HPC cluster to which the instance belongs. Valid only when InstanceTypes.N specifies High Performance Computing GPU Type.
        :param pulumi.Input[str] image_id: The ECS image id which the scaling configuration set.
        :param pulumi.Input[str] instance_description: The ECS instance description which the scaling configuration set.
        :param pulumi.Input[str] instance_name: The ECS instance name which the scaling configuration set.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] instance_types: The list of the ECS instance type which the scaling configuration set. The maximum number of instance types is 10.
        :param pulumi.Input[int] ipv6_address_count: Assign IPv6 address to instance network card. Possible values:
               0: Do not assign IPv6 address.
               1: Assign IPv6 address and the system will automatically assign an IPv6 subnet for you.
        :param pulumi.Input[str] key_pair_name: The ECS key pair name which the scaling configuration set.
        :param pulumi.Input[str] lifecycle_state: The lifecycle state of the scaling configuration.
        :param pulumi.Input[str] password: The ECS password which the scaling configuration set.
        :param pulumi.Input[str] project_name: The project to which the instance created by the scaling configuration belongs.
        :param pulumi.Input[str] scaling_configuration_id: The id of the scaling configuration.
        :param pulumi.Input[str] scaling_configuration_name: The name of the scaling configuration.
        :param pulumi.Input[str] scaling_group_id: The id of the scaling group to which the scaling configuration belongs.
        :param pulumi.Input[str] security_enhancement_strategy: The Ecs security enhancement strategy which the scaling configuration set. Valid values: Active, InActive.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_group_ids: The list of the security group id of the networkInterface which the scaling configuration set. A maximum of 5 security groups can be bound at the same time, and the value ranges from 1 to 5.
        :param pulumi.Input[str] spot_strategy: The preemption policy of the instance. Valid Value: NoSpot (default), SpotAsPriceGo.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ScalingConfigurationTagArgs']]]] tags: The label of the instance created by the scaling configuration. Up to 20 tags are supported.
        :param pulumi.Input[str] updated_at: The create time of the scaling configuration.
        :param pulumi.Input[str] user_data: The ECS user data which the scaling configuration set.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ScalingConfigurationVolumeArgs']]]] volumes: The list of volume of the scaling configuration. The number of supported volumes ranges from 1 to 15.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ScalingConfigurationState.__new__(_ScalingConfigurationState)

        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["eip_bandwidth"] = eip_bandwidth
        __props__.__dict__["eip_billing_type"] = eip_billing_type
        __props__.__dict__["eip_isp"] = eip_isp
        __props__.__dict__["host_name"] = host_name
        __props__.__dict__["hpc_cluster_id"] = hpc_cluster_id
        __props__.__dict__["image_id"] = image_id
        __props__.__dict__["instance_description"] = instance_description
        __props__.__dict__["instance_name"] = instance_name
        __props__.__dict__["instance_types"] = instance_types
        __props__.__dict__["ipv6_address_count"] = ipv6_address_count
        __props__.__dict__["key_pair_name"] = key_pair_name
        __props__.__dict__["lifecycle_state"] = lifecycle_state
        __props__.__dict__["password"] = password
        __props__.__dict__["project_name"] = project_name
        __props__.__dict__["scaling_configuration_id"] = scaling_configuration_id
        __props__.__dict__["scaling_configuration_name"] = scaling_configuration_name
        __props__.__dict__["scaling_group_id"] = scaling_group_id
        __props__.__dict__["security_enhancement_strategy"] = security_enhancement_strategy
        __props__.__dict__["security_group_ids"] = security_group_ids
        __props__.__dict__["spot_strategy"] = spot_strategy
        __props__.__dict__["tags"] = tags
        __props__.__dict__["updated_at"] = updated_at
        __props__.__dict__["user_data"] = user_data
        __props__.__dict__["volumes"] = volumes
        return ScalingConfiguration(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[str]:
        """
        The create time of the scaling configuration.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="eipBandwidth")
    def eip_bandwidth(self) -> pulumi.Output[int]:
        """
        The EIP bandwidth which the scaling configuration set. When the value of Eip.BillingType is PostPaidByBandwidth, the value is 1 to 500. When the value of Eip.BillingType is PostPaidByTraffic, the value is 1 to 200.
        """
        return pulumi.get(self, "eip_bandwidth")

    @property
    @pulumi.getter(name="eipBillingType")
    def eip_billing_type(self) -> pulumi.Output[str]:
        """
        The EIP billing type which the scaling configuration set. Valid values: PostPaidByBandwidth, PostPaidByTraffic.
        """
        return pulumi.get(self, "eip_billing_type")

    @property
    @pulumi.getter(name="eipIsp")
    def eip_isp(self) -> pulumi.Output[str]:
        """
        The EIP ISP which the scaling configuration set. Valid values: BGP, ChinaMobile, ChinaUnicom, ChinaTelecom.
        """
        return pulumi.get(self, "eip_isp")

    @property
    @pulumi.getter(name="hostName")
    def host_name(self) -> pulumi.Output[Optional[str]]:
        """
        The ECS hostname which the scaling configuration set.
        """
        return pulumi.get(self, "host_name")

    @property
    @pulumi.getter(name="hpcClusterId")
    def hpc_cluster_id(self) -> pulumi.Output[Optional[str]]:
        """
        The ID of the HPC cluster to which the instance belongs. Valid only when InstanceTypes.N specifies High Performance Computing GPU Type.
        """
        return pulumi.get(self, "hpc_cluster_id")

    @property
    @pulumi.getter(name="imageId")
    def image_id(self) -> pulumi.Output[str]:
        """
        The ECS image id which the scaling configuration set.
        """
        return pulumi.get(self, "image_id")

    @property
    @pulumi.getter(name="instanceDescription")
    def instance_description(self) -> pulumi.Output[Optional[str]]:
        """
        The ECS instance description which the scaling configuration set.
        """
        return pulumi.get(self, "instance_description")

    @property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> pulumi.Output[str]:
        """
        The ECS instance name which the scaling configuration set.
        """
        return pulumi.get(self, "instance_name")

    @property
    @pulumi.getter(name="instanceTypes")
    def instance_types(self) -> pulumi.Output[Sequence[str]]:
        """
        The list of the ECS instance type which the scaling configuration set. The maximum number of instance types is 10.
        """
        return pulumi.get(self, "instance_types")

    @property
    @pulumi.getter(name="ipv6AddressCount")
    def ipv6_address_count(self) -> pulumi.Output[Optional[int]]:
        """
        Assign IPv6 address to instance network card. Possible values:
        0: Do not assign IPv6 address.
        1: Assign IPv6 address and the system will automatically assign an IPv6 subnet for you.
        """
        return pulumi.get(self, "ipv6_address_count")

    @property
    @pulumi.getter(name="keyPairName")
    def key_pair_name(self) -> pulumi.Output[Optional[str]]:
        """
        The ECS key pair name which the scaling configuration set.
        """
        return pulumi.get(self, "key_pair_name")

    @property
    @pulumi.getter(name="lifecycleState")
    def lifecycle_state(self) -> pulumi.Output[str]:
        """
        The lifecycle state of the scaling configuration.
        """
        return pulumi.get(self, "lifecycle_state")

    @property
    @pulumi.getter
    def password(self) -> pulumi.Output[Optional[str]]:
        """
        The ECS password which the scaling configuration set.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter(name="projectName")
    def project_name(self) -> pulumi.Output[Optional[str]]:
        """
        The project to which the instance created by the scaling configuration belongs.
        """
        return pulumi.get(self, "project_name")

    @property
    @pulumi.getter(name="scalingConfigurationId")
    def scaling_configuration_id(self) -> pulumi.Output[str]:
        """
        The id of the scaling configuration.
        """
        return pulumi.get(self, "scaling_configuration_id")

    @property
    @pulumi.getter(name="scalingConfigurationName")
    def scaling_configuration_name(self) -> pulumi.Output[str]:
        """
        The name of the scaling configuration.
        """
        return pulumi.get(self, "scaling_configuration_name")

    @property
    @pulumi.getter(name="scalingGroupId")
    def scaling_group_id(self) -> pulumi.Output[str]:
        """
        The id of the scaling group to which the scaling configuration belongs.
        """
        return pulumi.get(self, "scaling_group_id")

    @property
    @pulumi.getter(name="securityEnhancementStrategy")
    def security_enhancement_strategy(self) -> pulumi.Output[Optional[str]]:
        """
        The Ecs security enhancement strategy which the scaling configuration set. Valid values: Active, InActive.
        """
        return pulumi.get(self, "security_enhancement_strategy")

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> pulumi.Output[Sequence[str]]:
        """
        The list of the security group id of the networkInterface which the scaling configuration set. A maximum of 5 security groups can be bound at the same time, and the value ranges from 1 to 5.
        """
        return pulumi.get(self, "security_group_ids")

    @property
    @pulumi.getter(name="spotStrategy")
    def spot_strategy(self) -> pulumi.Output[Optional[str]]:
        """
        The preemption policy of the instance. Valid Value: NoSpot (default), SpotAsPriceGo.
        """
        return pulumi.get(self, "spot_strategy")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['outputs.ScalingConfigurationTag']]]:
        """
        The label of the instance created by the scaling configuration. Up to 20 tags are supported.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[str]:
        """
        The create time of the scaling configuration.
        """
        return pulumi.get(self, "updated_at")

    @property
    @pulumi.getter(name="userData")
    def user_data(self) -> pulumi.Output[Optional[str]]:
        """
        The ECS user data which the scaling configuration set.
        """
        return pulumi.get(self, "user_data")

    @property
    @pulumi.getter
    def volumes(self) -> pulumi.Output[Sequence['outputs.ScalingConfigurationVolume']]:
        """
        The list of volume of the scaling configuration. The number of supported volumes ranges from 1 to 15.
        """
        return pulumi.get(self, "volumes")

