# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['ScalingGroupEnablerArgs', 'ScalingGroupEnabler']

@pulumi.input_type
class ScalingGroupEnablerArgs:
    def __init__(__self__, *,
                 scaling_group_id: pulumi.Input[str]):
        """
        The set of arguments for constructing a ScalingGroupEnabler resource.
        :param pulumi.Input[str] scaling_group_id: The id of the scaling group.
        """
        pulumi.set(__self__, "scaling_group_id", scaling_group_id)

    @property
    @pulumi.getter(name="scalingGroupId")
    def scaling_group_id(self) -> pulumi.Input[str]:
        """
        The id of the scaling group.
        """
        return pulumi.get(self, "scaling_group_id")

    @scaling_group_id.setter
    def scaling_group_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "scaling_group_id", value)


@pulumi.input_type
class _ScalingGroupEnablerState:
    def __init__(__self__, *,
                 scaling_group_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering ScalingGroupEnabler resources.
        :param pulumi.Input[str] scaling_group_id: The id of the scaling group.
        """
        if scaling_group_id is not None:
            pulumi.set(__self__, "scaling_group_id", scaling_group_id)

    @property
    @pulumi.getter(name="scalingGroupId")
    def scaling_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        The id of the scaling group.
        """
        return pulumi.get(self, "scaling_group_id")

    @scaling_group_id.setter
    def scaling_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "scaling_group_id", value)


class ScalingGroupEnabler(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 scaling_group_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a resource to manage scaling group enabler
        ## Example Usage

        ```python
        import pulumi
        import pulumi_volcengine as volcengine

        # 创建步骤：terraform init -> pulumi preview -> pulumi up
        # 删除步骤: terraform state rm volcengine_scaling_configuration.foo1 -> terraform destroy
        # 创建伸缩组
        foo = volcengine.autoscaling.ScalingGroup("foo",
            scaling_group_name="zzm-tf-test",
            subnet_ids=["subnet-2fegl9waotzi859gp67relkhv"],
            multi_az_policy="BALANCE",
            desire_instance_number=0,
            min_instance_number=0,
            max_instance_number=1,
            instance_terminate_policy="OldestInstance",
            default_cooldown=10)
        # 创建伸缩配置
        foo1 = volcengine.autoscaling.ScalingConfiguration("foo1",
            scaling_configuration_name="terraform-test",
            scaling_group_id=foo.scaling_group_id,
            image_id="image-ybx2d38wdfl8j1pupx7b",
            instance_types=["ecs.g1.2xlarge"],
            instance_name="tf-test",
            instance_description="",
            host_name="",
            password="",
            key_pair_name="zktest",
            security_enhancement_strategy="InActive",
            volumes=[
                volcengine.autoscaling.ScalingConfigurationVolumeArgs(
                    volume_type="ESSD_PL0",
                    size=20,
                    delete_with_instance=False,
                ),
                volcengine.autoscaling.ScalingConfigurationVolumeArgs(
                    volume_type="ESSD_PL0",
                    size=20,
                    delete_with_instance=True,
                ),
            ],
            security_group_ids=["sg-12b8llnkn1la817q7y1be4kop"],
            eip_bandwidth=0,
            eip_isp="ChinaMobile",
            eip_billing_type="PostPaidByBandwidth")
        # 绑定伸缩配置
        foo2 = volcengine.autoscaling.ScalingConfigurationAttachment("foo2", scaling_configuration_id=foo1.scaling_configuration_id,
        opts=pulumi.ResourceOptions(depends_on=[foo1]))
        # 启用伸缩组
        foo3 = volcengine.autoscaling.ScalingGroupEnabler("foo3", scaling_group_id=foo.scaling_group_id,
        opts=pulumi.ResourceOptions(depends_on=[foo2]))
        ```

        ## Import

        Scaling Group enabler can be imported using the scaling_group_id, e.g.

        ```sh
         $ pulumi import volcengine:autoscaling/scalingGroupEnabler:ScalingGroupEnabler default enable:scg-mizl7m1kqccg5smt1bdpijuj
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] scaling_group_id: The id of the scaling group.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ScalingGroupEnablerArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a resource to manage scaling group enabler
        ## Example Usage

        ```python
        import pulumi
        import pulumi_volcengine as volcengine

        # 创建步骤：terraform init -> pulumi preview -> pulumi up
        # 删除步骤: terraform state rm volcengine_scaling_configuration.foo1 -> terraform destroy
        # 创建伸缩组
        foo = volcengine.autoscaling.ScalingGroup("foo",
            scaling_group_name="zzm-tf-test",
            subnet_ids=["subnet-2fegl9waotzi859gp67relkhv"],
            multi_az_policy="BALANCE",
            desire_instance_number=0,
            min_instance_number=0,
            max_instance_number=1,
            instance_terminate_policy="OldestInstance",
            default_cooldown=10)
        # 创建伸缩配置
        foo1 = volcengine.autoscaling.ScalingConfiguration("foo1",
            scaling_configuration_name="terraform-test",
            scaling_group_id=foo.scaling_group_id,
            image_id="image-ybx2d38wdfl8j1pupx7b",
            instance_types=["ecs.g1.2xlarge"],
            instance_name="tf-test",
            instance_description="",
            host_name="",
            password="",
            key_pair_name="zktest",
            security_enhancement_strategy="InActive",
            volumes=[
                volcengine.autoscaling.ScalingConfigurationVolumeArgs(
                    volume_type="ESSD_PL0",
                    size=20,
                    delete_with_instance=False,
                ),
                volcengine.autoscaling.ScalingConfigurationVolumeArgs(
                    volume_type="ESSD_PL0",
                    size=20,
                    delete_with_instance=True,
                ),
            ],
            security_group_ids=["sg-12b8llnkn1la817q7y1be4kop"],
            eip_bandwidth=0,
            eip_isp="ChinaMobile",
            eip_billing_type="PostPaidByBandwidth")
        # 绑定伸缩配置
        foo2 = volcengine.autoscaling.ScalingConfigurationAttachment("foo2", scaling_configuration_id=foo1.scaling_configuration_id,
        opts=pulumi.ResourceOptions(depends_on=[foo1]))
        # 启用伸缩组
        foo3 = volcengine.autoscaling.ScalingGroupEnabler("foo3", scaling_group_id=foo.scaling_group_id,
        opts=pulumi.ResourceOptions(depends_on=[foo2]))
        ```

        ## Import

        Scaling Group enabler can be imported using the scaling_group_id, e.g.

        ```sh
         $ pulumi import volcengine:autoscaling/scalingGroupEnabler:ScalingGroupEnabler default enable:scg-mizl7m1kqccg5smt1bdpijuj
        ```

        :param str resource_name: The name of the resource.
        :param ScalingGroupEnablerArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ScalingGroupEnablerArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 scaling_group_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ScalingGroupEnablerArgs.__new__(ScalingGroupEnablerArgs)

            if scaling_group_id is None and not opts.urn:
                raise TypeError("Missing required property 'scaling_group_id'")
            __props__.__dict__["scaling_group_id"] = scaling_group_id
        super(ScalingGroupEnabler, __self__).__init__(
            'volcengine:autoscaling/scalingGroupEnabler:ScalingGroupEnabler',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            scaling_group_id: Optional[pulumi.Input[str]] = None) -> 'ScalingGroupEnabler':
        """
        Get an existing ScalingGroupEnabler resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] scaling_group_id: The id of the scaling group.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ScalingGroupEnablerState.__new__(_ScalingGroupEnablerState)

        __props__.__dict__["scaling_group_id"] = scaling_group_id
        return ScalingGroupEnabler(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="scalingGroupId")
    def scaling_group_id(self) -> pulumi.Output[str]:
        """
        The id of the scaling group.
        """
        return pulumi.get(self, "scaling_group_id")

