# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'ScalingGroupsResult',
    'AwaitableScalingGroupsResult',
    'scaling_groups',
    'scaling_groups_output',
]

@pulumi.output_type
class ScalingGroupsResult:
    """
    A collection of values returned by ScalingGroups.
    """
    def __init__(__self__, id=None, ids=None, name_regex=None, output_file=None, project_name=None, scaling_group_names=None, scaling_groups=None, total_count=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if name_regex and not isinstance(name_regex, str):
            raise TypeError("Expected argument 'name_regex' to be a str")
        pulumi.set(__self__, "name_regex", name_regex)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if project_name and not isinstance(project_name, str):
            raise TypeError("Expected argument 'project_name' to be a str")
        pulumi.set(__self__, "project_name", project_name)
        if scaling_group_names and not isinstance(scaling_group_names, list):
            raise TypeError("Expected argument 'scaling_group_names' to be a list")
        pulumi.set(__self__, "scaling_group_names", scaling_group_names)
        if scaling_groups and not isinstance(scaling_groups, list):
            raise TypeError("Expected argument 'scaling_groups' to be a list")
        pulumi.set(__self__, "scaling_groups", scaling_groups)
        if total_count and not isinstance(total_count, int):
            raise TypeError("Expected argument 'total_count' to be a int")
        pulumi.set(__self__, "total_count", total_count)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def ids(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "ids")

    @property
    @pulumi.getter(name="nameRegex")
    def name_regex(self) -> Optional[str]:
        return pulumi.get(self, "name_regex")

    @property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[str]:
        return pulumi.get(self, "output_file")

    @property
    @pulumi.getter(name="projectName")
    def project_name(self) -> Optional[str]:
        """
        The ProjectName of scaling group.
        """
        return pulumi.get(self, "project_name")

    @property
    @pulumi.getter(name="scalingGroupNames")
    def scaling_group_names(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "scaling_group_names")

    @property
    @pulumi.getter(name="scalingGroups")
    def scaling_groups(self) -> Sequence['outputs.ScalingGroupsScalingGroupResult']:
        """
        The collection of scaling group query.
        """
        return pulumi.get(self, "scaling_groups")

    @property
    @pulumi.getter(name="totalCount")
    def total_count(self) -> int:
        """
        The total count of scaling group query.
        """
        return pulumi.get(self, "total_count")


class AwaitableScalingGroupsResult(ScalingGroupsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return ScalingGroupsResult(
            id=self.id,
            ids=self.ids,
            name_regex=self.name_regex,
            output_file=self.output_file,
            project_name=self.project_name,
            scaling_group_names=self.scaling_group_names,
            scaling_groups=self.scaling_groups,
            total_count=self.total_count)


def scaling_groups(ids: Optional[Sequence[str]] = None,
                   name_regex: Optional[str] = None,
                   output_file: Optional[str] = None,
                   project_name: Optional[str] = None,
                   scaling_group_names: Optional[Sequence[str]] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableScalingGroupsResult:
    """
    Use this data source to query detailed information of scaling groups
    ## Example Usage

    ```python
    import pulumi
    import pulumi_volcengine as volcengine

    foo_zones = volcengine.ecs.zones()
    foo_vpc = volcengine.vpc.Vpc("fooVpc",
        vpc_name="acc-test-vpc",
        cidr_block="172.16.0.0/16")
    foo_subnet = volcengine.vpc.Subnet("fooSubnet",
        subnet_name="acc-test-subnet",
        cidr_block="172.16.0.0/24",
        zone_id=foo_zones.zones[0].id,
        vpc_id=foo_vpc.id)
    foo_scaling_group = []
    for range in [{"value": i} for i in range(0, 3)]:
        foo_scaling_group.append(volcengine.autoscaling.ScalingGroup(f"fooScalingGroup-{range['value']}",
            scaling_group_name=f"acc-test-scaling-group-{range['value']}",
            subnet_ids=[foo_subnet.id],
            multi_az_policy="BALANCE",
            desire_instance_number=0,
            min_instance_number=0,
            max_instance_number=10,
            instance_terminate_policy="OldestInstance",
            default_cooldown=30,
            tags=[
                volcengine.autoscaling.ScalingGroupTagArgs(
                    key="k2",
                    value="v2",
                ),
                volcengine.autoscaling.ScalingGroupTagArgs(
                    key="k1",
                    value="v1",
                ),
            ]))
    default = volcengine.autoscaling.scaling_groups_output(ids=[__item.id for __item in foo_scaling_group])
    ```


    :param Sequence[str] ids: A list of scaling group ids.
    :param str name_regex: A Name Regex of scaling group.
    :param str output_file: File name where to save data source results.
    :param str project_name: The project name of the scaling group.
    :param Sequence[str] scaling_group_names: A list of scaling group names.
    """
    __args__ = dict()
    __args__['ids'] = ids
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    __args__['projectName'] = project_name
    __args__['scalingGroupNames'] = scaling_group_names
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('volcengine:autoscaling/scalingGroups:ScalingGroups', __args__, opts=opts, typ=ScalingGroupsResult).value

    return AwaitableScalingGroupsResult(
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        name_regex=pulumi.get(__ret__, 'name_regex'),
        output_file=pulumi.get(__ret__, 'output_file'),
        project_name=pulumi.get(__ret__, 'project_name'),
        scaling_group_names=pulumi.get(__ret__, 'scaling_group_names'),
        scaling_groups=pulumi.get(__ret__, 'scaling_groups'),
        total_count=pulumi.get(__ret__, 'total_count'))


@_utilities.lift_output_func(scaling_groups)
def scaling_groups_output(ids: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                          name_regex: Optional[pulumi.Input[Optional[str]]] = None,
                          output_file: Optional[pulumi.Input[Optional[str]]] = None,
                          project_name: Optional[pulumi.Input[Optional[str]]] = None,
                          scaling_group_names: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[ScalingGroupsResult]:
    """
    Use this data source to query detailed information of scaling groups
    ## Example Usage

    ```python
    import pulumi
    import pulumi_volcengine as volcengine

    foo_zones = volcengine.ecs.zones()
    foo_vpc = volcengine.vpc.Vpc("fooVpc",
        vpc_name="acc-test-vpc",
        cidr_block="172.16.0.0/16")
    foo_subnet = volcengine.vpc.Subnet("fooSubnet",
        subnet_name="acc-test-subnet",
        cidr_block="172.16.0.0/24",
        zone_id=foo_zones.zones[0].id,
        vpc_id=foo_vpc.id)
    foo_scaling_group = []
    for range in [{"value": i} for i in range(0, 3)]:
        foo_scaling_group.append(volcengine.autoscaling.ScalingGroup(f"fooScalingGroup-{range['value']}",
            scaling_group_name=f"acc-test-scaling-group-{range['value']}",
            subnet_ids=[foo_subnet.id],
            multi_az_policy="BALANCE",
            desire_instance_number=0,
            min_instance_number=0,
            max_instance_number=10,
            instance_terminate_policy="OldestInstance",
            default_cooldown=30,
            tags=[
                volcengine.autoscaling.ScalingGroupTagArgs(
                    key="k2",
                    value="v2",
                ),
                volcengine.autoscaling.ScalingGroupTagArgs(
                    key="k1",
                    value="v1",
                ),
            ]))
    default = volcengine.autoscaling.scaling_groups_output(ids=[__item.id for __item in foo_scaling_group])
    ```


    :param Sequence[str] ids: A list of scaling group ids.
    :param str name_regex: A Name Regex of scaling group.
    :param str output_file: File name where to save data source results.
    :param str project_name: The project name of the scaling group.
    :param Sequence[str] scaling_group_names: A list of scaling group names.
    """
    ...
