# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['ScalingInstanceAttachmentArgs', 'ScalingInstanceAttachment']

@pulumi.input_type
class ScalingInstanceAttachmentArgs:
    def __init__(__self__, *,
                 instance_id: pulumi.Input[str],
                 scaling_group_id: pulumi.Input[str],
                 delete_type: Optional[pulumi.Input[str]] = None,
                 detach_option: Optional[pulumi.Input[str]] = None,
                 entrusted: Optional[pulumi.Input[bool]] = None):
        """
        The set of arguments for constructing a ScalingInstanceAttachment resource.
        :param pulumi.Input[str] instance_id: The id of the instance.
        :param pulumi.Input[str] scaling_group_id: The id of the scaling group.
        :param pulumi.Input[str] delete_type: The type of delete activity. Valid values: Remove, Detach. Default value is Remove.
        :param pulumi.Input[str] detach_option: Whether to cancel the association of the instance with the load balancing and public network IP. Valid values: both, none. Default value is both.
        :param pulumi.Input[bool] entrusted: Whether to host the instance to a scaling group. Default value is false.
        """
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "scaling_group_id", scaling_group_id)
        if delete_type is not None:
            pulumi.set(__self__, "delete_type", delete_type)
        if detach_option is not None:
            pulumi.set(__self__, "detach_option", detach_option)
        if entrusted is not None:
            pulumi.set(__self__, "entrusted", entrusted)

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Input[str]:
        """
        The id of the instance.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "instance_id", value)

    @property
    @pulumi.getter(name="scalingGroupId")
    def scaling_group_id(self) -> pulumi.Input[str]:
        """
        The id of the scaling group.
        """
        return pulumi.get(self, "scaling_group_id")

    @scaling_group_id.setter
    def scaling_group_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "scaling_group_id", value)

    @property
    @pulumi.getter(name="deleteType")
    def delete_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of delete activity. Valid values: Remove, Detach. Default value is Remove.
        """
        return pulumi.get(self, "delete_type")

    @delete_type.setter
    def delete_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "delete_type", value)

    @property
    @pulumi.getter(name="detachOption")
    def detach_option(self) -> Optional[pulumi.Input[str]]:
        """
        Whether to cancel the association of the instance with the load balancing and public network IP. Valid values: both, none. Default value is both.
        """
        return pulumi.get(self, "detach_option")

    @detach_option.setter
    def detach_option(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "detach_option", value)

    @property
    @pulumi.getter
    def entrusted(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to host the instance to a scaling group. Default value is false.
        """
        return pulumi.get(self, "entrusted")

    @entrusted.setter
    def entrusted(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "entrusted", value)


@pulumi.input_type
class _ScalingInstanceAttachmentState:
    def __init__(__self__, *,
                 delete_type: Optional[pulumi.Input[str]] = None,
                 detach_option: Optional[pulumi.Input[str]] = None,
                 entrusted: Optional[pulumi.Input[bool]] = None,
                 instance_id: Optional[pulumi.Input[str]] = None,
                 scaling_group_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering ScalingInstanceAttachment resources.
        :param pulumi.Input[str] delete_type: The type of delete activity. Valid values: Remove, Detach. Default value is Remove.
        :param pulumi.Input[str] detach_option: Whether to cancel the association of the instance with the load balancing and public network IP. Valid values: both, none. Default value is both.
        :param pulumi.Input[bool] entrusted: Whether to host the instance to a scaling group. Default value is false.
        :param pulumi.Input[str] instance_id: The id of the instance.
        :param pulumi.Input[str] scaling_group_id: The id of the scaling group.
        """
        if delete_type is not None:
            pulumi.set(__self__, "delete_type", delete_type)
        if detach_option is not None:
            pulumi.set(__self__, "detach_option", detach_option)
        if entrusted is not None:
            pulumi.set(__self__, "entrusted", entrusted)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if scaling_group_id is not None:
            pulumi.set(__self__, "scaling_group_id", scaling_group_id)

    @property
    @pulumi.getter(name="deleteType")
    def delete_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of delete activity. Valid values: Remove, Detach. Default value is Remove.
        """
        return pulumi.get(self, "delete_type")

    @delete_type.setter
    def delete_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "delete_type", value)

    @property
    @pulumi.getter(name="detachOption")
    def detach_option(self) -> Optional[pulumi.Input[str]]:
        """
        Whether to cancel the association of the instance with the load balancing and public network IP. Valid values: both, none. Default value is both.
        """
        return pulumi.get(self, "detach_option")

    @detach_option.setter
    def detach_option(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "detach_option", value)

    @property
    @pulumi.getter
    def entrusted(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to host the instance to a scaling group. Default value is false.
        """
        return pulumi.get(self, "entrusted")

    @entrusted.setter
    def entrusted(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "entrusted", value)

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[str]]:
        """
        The id of the instance.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_id", value)

    @property
    @pulumi.getter(name="scalingGroupId")
    def scaling_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        The id of the scaling group.
        """
        return pulumi.get(self, "scaling_group_id")

    @scaling_group_id.setter
    def scaling_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "scaling_group_id", value)


class ScalingInstanceAttachment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 delete_type: Optional[pulumi.Input[str]] = None,
                 detach_option: Optional[pulumi.Input[str]] = None,
                 entrusted: Optional[pulumi.Input[bool]] = None,
                 instance_id: Optional[pulumi.Input[str]] = None,
                 scaling_group_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a resource to manage scaling instance attachment
        ## Example Usage

        ```python
        import pulumi
        import pulumi_volcengine as volcengine

        foo_zones = volcengine.ecs.zones()
        foo_vpc = volcengine.vpc.Vpc("fooVpc",
            vpc_name="acc-test-vpc",
            cidr_block="172.16.0.0/16")
        foo_subnet = volcengine.vpc.Subnet("fooSubnet",
            subnet_name="acc-test-subnet",
            cidr_block="172.16.0.0/24",
            zone_id=foo_zones.zones[0].id,
            vpc_id=foo_vpc.id)
        foo_security_group = volcengine.vpc.SecurityGroup("fooSecurityGroup",
            security_group_name="acc-test-security-group",
            vpc_id=foo_vpc.id)
        foo_images = volcengine.ecs.images(os_type="Linux",
            visibility="public",
            instance_type_id="ecs.g1.large")
        foo_key_pair = volcengine.ecs.KeyPair("fooKeyPair",
            description="acc-test-2",
            key_pair_name="acc-test-key-pair-name")
        foo_launch_template = volcengine.ecs.LaunchTemplate("fooLaunchTemplate",
            description="acc-test-desc",
            eip_bandwidth=200,
            eip_billing_type="PostPaidByBandwidth",
            eip_isp="BGP",
            host_name="acc-hostname",
            image_id=foo_images.images[0].image_id,
            instance_charge_type="PostPaid",
            instance_name="acc-instance-name",
            instance_type_id="ecs.g1.large",
            key_pair_name=foo_key_pair.key_pair_name,
            launch_template_name="acc-test-template",
            network_interfaces=[volcengine.ecs.LaunchTemplateNetworkInterfaceArgs(
                subnet_id=foo_subnet.id,
                security_group_ids=[foo_security_group.id],
            )],
            volumes=[volcengine.ecs.LaunchTemplateVolumeArgs(
                volume_type="ESSD_PL0",
                size=50,
                delete_with_instance=True,
            )])
        foo_scaling_group = volcengine.autoscaling.ScalingGroup("fooScalingGroup",
            scaling_group_name="acc-test-scaling-group",
            subnet_ids=[foo_subnet.id],
            multi_az_policy="BALANCE",
            desire_instance_number=-1,
            min_instance_number=0,
            max_instance_number=1,
            instance_terminate_policy="OldestInstance",
            default_cooldown=10,
            launch_template_id=foo_launch_template.id,
            launch_template_version="Default")
        foo_scaling_group_enabler = volcengine.autoscaling.ScalingGroupEnabler("fooScalingGroupEnabler", scaling_group_id=foo_scaling_group.id)
        foo_instance = volcengine.ecs.Instance("fooInstance",
            instance_name="acc-test-ecs",
            description="acc-test",
            host_name="tf-acc-test",
            image_id=foo_images.images[0].image_id,
            instance_type="ecs.g1.large",
            password="93f0cb0614Aab12",
            instance_charge_type="PostPaid",
            system_volume_type="ESSD_PL0",
            system_volume_size=40,
            subnet_id=foo_subnet.id,
            security_group_ids=[foo_security_group.id])
        foo_scaling_instance_attachment = volcengine.autoscaling.ScalingInstanceAttachment("fooScalingInstanceAttachment",
            instance_id=foo_instance.id,
            scaling_group_id=foo_scaling_group.id,
            entrusted=True,
            opts=pulumi.ResourceOptions(depends_on=[foo_scaling_group_enabler]))
        ```

        ## Import

        Scaling instance attachment can be imported using the scaling_group_id and instance_id, e.g. You can choose to remove or detach the instance according to the `delete_type` field.

        ```sh
         $ pulumi import volcengine:autoscaling/scalingInstanceAttachment:ScalingInstanceAttachment default scg-mizl7m1kqccg5smt1bdpijuj:i-l8u2ai4j0fauo6mrpgk8
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] delete_type: The type of delete activity. Valid values: Remove, Detach. Default value is Remove.
        :param pulumi.Input[str] detach_option: Whether to cancel the association of the instance with the load balancing and public network IP. Valid values: both, none. Default value is both.
        :param pulumi.Input[bool] entrusted: Whether to host the instance to a scaling group. Default value is false.
        :param pulumi.Input[str] instance_id: The id of the instance.
        :param pulumi.Input[str] scaling_group_id: The id of the scaling group.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ScalingInstanceAttachmentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a resource to manage scaling instance attachment
        ## Example Usage

        ```python
        import pulumi
        import pulumi_volcengine as volcengine

        foo_zones = volcengine.ecs.zones()
        foo_vpc = volcengine.vpc.Vpc("fooVpc",
            vpc_name="acc-test-vpc",
            cidr_block="172.16.0.0/16")
        foo_subnet = volcengine.vpc.Subnet("fooSubnet",
            subnet_name="acc-test-subnet",
            cidr_block="172.16.0.0/24",
            zone_id=foo_zones.zones[0].id,
            vpc_id=foo_vpc.id)
        foo_security_group = volcengine.vpc.SecurityGroup("fooSecurityGroup",
            security_group_name="acc-test-security-group",
            vpc_id=foo_vpc.id)
        foo_images = volcengine.ecs.images(os_type="Linux",
            visibility="public",
            instance_type_id="ecs.g1.large")
        foo_key_pair = volcengine.ecs.KeyPair("fooKeyPair",
            description="acc-test-2",
            key_pair_name="acc-test-key-pair-name")
        foo_launch_template = volcengine.ecs.LaunchTemplate("fooLaunchTemplate",
            description="acc-test-desc",
            eip_bandwidth=200,
            eip_billing_type="PostPaidByBandwidth",
            eip_isp="BGP",
            host_name="acc-hostname",
            image_id=foo_images.images[0].image_id,
            instance_charge_type="PostPaid",
            instance_name="acc-instance-name",
            instance_type_id="ecs.g1.large",
            key_pair_name=foo_key_pair.key_pair_name,
            launch_template_name="acc-test-template",
            network_interfaces=[volcengine.ecs.LaunchTemplateNetworkInterfaceArgs(
                subnet_id=foo_subnet.id,
                security_group_ids=[foo_security_group.id],
            )],
            volumes=[volcengine.ecs.LaunchTemplateVolumeArgs(
                volume_type="ESSD_PL0",
                size=50,
                delete_with_instance=True,
            )])
        foo_scaling_group = volcengine.autoscaling.ScalingGroup("fooScalingGroup",
            scaling_group_name="acc-test-scaling-group",
            subnet_ids=[foo_subnet.id],
            multi_az_policy="BALANCE",
            desire_instance_number=-1,
            min_instance_number=0,
            max_instance_number=1,
            instance_terminate_policy="OldestInstance",
            default_cooldown=10,
            launch_template_id=foo_launch_template.id,
            launch_template_version="Default")
        foo_scaling_group_enabler = volcengine.autoscaling.ScalingGroupEnabler("fooScalingGroupEnabler", scaling_group_id=foo_scaling_group.id)
        foo_instance = volcengine.ecs.Instance("fooInstance",
            instance_name="acc-test-ecs",
            description="acc-test",
            host_name="tf-acc-test",
            image_id=foo_images.images[0].image_id,
            instance_type="ecs.g1.large",
            password="93f0cb0614Aab12",
            instance_charge_type="PostPaid",
            system_volume_type="ESSD_PL0",
            system_volume_size=40,
            subnet_id=foo_subnet.id,
            security_group_ids=[foo_security_group.id])
        foo_scaling_instance_attachment = volcengine.autoscaling.ScalingInstanceAttachment("fooScalingInstanceAttachment",
            instance_id=foo_instance.id,
            scaling_group_id=foo_scaling_group.id,
            entrusted=True,
            opts=pulumi.ResourceOptions(depends_on=[foo_scaling_group_enabler]))
        ```

        ## Import

        Scaling instance attachment can be imported using the scaling_group_id and instance_id, e.g. You can choose to remove or detach the instance according to the `delete_type` field.

        ```sh
         $ pulumi import volcengine:autoscaling/scalingInstanceAttachment:ScalingInstanceAttachment default scg-mizl7m1kqccg5smt1bdpijuj:i-l8u2ai4j0fauo6mrpgk8
        ```

        :param str resource_name: The name of the resource.
        :param ScalingInstanceAttachmentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ScalingInstanceAttachmentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 delete_type: Optional[pulumi.Input[str]] = None,
                 detach_option: Optional[pulumi.Input[str]] = None,
                 entrusted: Optional[pulumi.Input[bool]] = None,
                 instance_id: Optional[pulumi.Input[str]] = None,
                 scaling_group_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ScalingInstanceAttachmentArgs.__new__(ScalingInstanceAttachmentArgs)

            __props__.__dict__["delete_type"] = delete_type
            __props__.__dict__["detach_option"] = detach_option
            __props__.__dict__["entrusted"] = entrusted
            if instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'instance_id'")
            __props__.__dict__["instance_id"] = instance_id
            if scaling_group_id is None and not opts.urn:
                raise TypeError("Missing required property 'scaling_group_id'")
            __props__.__dict__["scaling_group_id"] = scaling_group_id
        super(ScalingInstanceAttachment, __self__).__init__(
            'volcengine:autoscaling/scalingInstanceAttachment:ScalingInstanceAttachment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            delete_type: Optional[pulumi.Input[str]] = None,
            detach_option: Optional[pulumi.Input[str]] = None,
            entrusted: Optional[pulumi.Input[bool]] = None,
            instance_id: Optional[pulumi.Input[str]] = None,
            scaling_group_id: Optional[pulumi.Input[str]] = None) -> 'ScalingInstanceAttachment':
        """
        Get an existing ScalingInstanceAttachment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] delete_type: The type of delete activity. Valid values: Remove, Detach. Default value is Remove.
        :param pulumi.Input[str] detach_option: Whether to cancel the association of the instance with the load balancing and public network IP. Valid values: both, none. Default value is both.
        :param pulumi.Input[bool] entrusted: Whether to host the instance to a scaling group. Default value is false.
        :param pulumi.Input[str] instance_id: The id of the instance.
        :param pulumi.Input[str] scaling_group_id: The id of the scaling group.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ScalingInstanceAttachmentState.__new__(_ScalingInstanceAttachmentState)

        __props__.__dict__["delete_type"] = delete_type
        __props__.__dict__["detach_option"] = detach_option
        __props__.__dict__["entrusted"] = entrusted
        __props__.__dict__["instance_id"] = instance_id
        __props__.__dict__["scaling_group_id"] = scaling_group_id
        return ScalingInstanceAttachment(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="deleteType")
    def delete_type(self) -> pulumi.Output[Optional[str]]:
        """
        The type of delete activity. Valid values: Remove, Detach. Default value is Remove.
        """
        return pulumi.get(self, "delete_type")

    @property
    @pulumi.getter(name="detachOption")
    def detach_option(self) -> pulumi.Output[Optional[str]]:
        """
        Whether to cancel the association of the instance with the load balancing and public network IP. Valid values: both, none. Default value is both.
        """
        return pulumi.get(self, "detach_option")

    @property
    @pulumi.getter
    def entrusted(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether to host the instance to a scaling group. Default value is false.
        """
        return pulumi.get(self, "entrusted")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[str]:
        """
        The id of the instance.
        """
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter(name="scalingGroupId")
    def scaling_group_id(self) -> pulumi.Output[str]:
        """
        The id of the scaling group.
        """
        return pulumi.get(self, "scaling_group_id")

