# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'ScalingInstancesResult',
    'AwaitableScalingInstancesResult',
    'scaling_instances',
    'scaling_instances_output',
]

@pulumi.output_type
class ScalingInstancesResult:
    """
    A collection of values returned by ScalingInstances.
    """
    def __init__(__self__, creation_type=None, id=None, ids=None, output_file=None, scaling_configuration_id=None, scaling_group_id=None, scaling_instances=None, status=None, total_count=None):
        if creation_type and not isinstance(creation_type, str):
            raise TypeError("Expected argument 'creation_type' to be a str")
        pulumi.set(__self__, "creation_type", creation_type)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if scaling_configuration_id and not isinstance(scaling_configuration_id, str):
            raise TypeError("Expected argument 'scaling_configuration_id' to be a str")
        pulumi.set(__self__, "scaling_configuration_id", scaling_configuration_id)
        if scaling_group_id and not isinstance(scaling_group_id, str):
            raise TypeError("Expected argument 'scaling_group_id' to be a str")
        pulumi.set(__self__, "scaling_group_id", scaling_group_id)
        if scaling_instances and not isinstance(scaling_instances, list):
            raise TypeError("Expected argument 'scaling_instances' to be a list")
        pulumi.set(__self__, "scaling_instances", scaling_instances)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if total_count and not isinstance(total_count, int):
            raise TypeError("Expected argument 'total_count' to be a int")
        pulumi.set(__self__, "total_count", total_count)

    @property
    @pulumi.getter(name="creationType")
    def creation_type(self) -> Optional[str]:
        """
        The creation type of the instance. Valid values: AutoCreated, Attached.
        """
        return pulumi.get(self, "creation_type")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def ids(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "ids")

    @property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[str]:
        return pulumi.get(self, "output_file")

    @property
    @pulumi.getter(name="scalingConfigurationId")
    def scaling_configuration_id(self) -> Optional[str]:
        """
        The id of the scaling configuration.
        """
        return pulumi.get(self, "scaling_configuration_id")

    @property
    @pulumi.getter(name="scalingGroupId")
    def scaling_group_id(self) -> str:
        """
        The id of the scaling group.
        """
        return pulumi.get(self, "scaling_group_id")

    @property
    @pulumi.getter(name="scalingInstances")
    def scaling_instances(self) -> Sequence['outputs.ScalingInstancesScalingInstanceResult']:
        """
        The collection of scaling instances.
        """
        return pulumi.get(self, "scaling_instances")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        The status of instances.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="totalCount")
    def total_count(self) -> int:
        """
        The total count of scaling instances query.
        """
        return pulumi.get(self, "total_count")


class AwaitableScalingInstancesResult(ScalingInstancesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return ScalingInstancesResult(
            creation_type=self.creation_type,
            id=self.id,
            ids=self.ids,
            output_file=self.output_file,
            scaling_configuration_id=self.scaling_configuration_id,
            scaling_group_id=self.scaling_group_id,
            scaling_instances=self.scaling_instances,
            status=self.status,
            total_count=self.total_count)


def scaling_instances(creation_type: Optional[str] = None,
                      ids: Optional[Sequence[str]] = None,
                      output_file: Optional[str] = None,
                      scaling_configuration_id: Optional[str] = None,
                      scaling_group_id: Optional[str] = None,
                      status: Optional[str] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableScalingInstancesResult:
    """
    Use this data source to query detailed information of scaling instances
    ## Example Usage

    ```python
    import pulumi
    import pulumi_volcengine as volcengine

    foo_zones = volcengine.ecs.zones()
    foo_vpc = volcengine.vpc.Vpc("fooVpc",
        vpc_name="acc-test-vpc",
        cidr_block="172.16.0.0/16")
    foo_subnet = volcengine.vpc.Subnet("fooSubnet",
        subnet_name="acc-test-subnet",
        cidr_block="172.16.0.0/24",
        zone_id=foo_zones.zones[0].id,
        vpc_id=foo_vpc.id)
    foo_security_group = volcengine.vpc.SecurityGroup("fooSecurityGroup",
        security_group_name="acc-test-security-group",
        vpc_id=foo_vpc.id)
    foo_images = volcengine.ecs.images(os_type="Linux",
        visibility="public",
        instance_type_id="ecs.g1.large")
    foo_key_pair = volcengine.ecs.KeyPair("fooKeyPair",
        description="acc-test-2",
        key_pair_name="acc-test-key-pair-name")
    foo_launch_template = volcengine.ecs.LaunchTemplate("fooLaunchTemplate",
        description="acc-test-desc",
        eip_bandwidth=200,
        eip_billing_type="PostPaidByBandwidth",
        eip_isp="BGP",
        host_name="acc-hostname",
        image_id=foo_images.images[0].image_id,
        instance_charge_type="PostPaid",
        instance_name="acc-instance-name",
        instance_type_id="ecs.g1.large",
        key_pair_name=foo_key_pair.key_pair_name,
        launch_template_name="acc-test-template",
        network_interfaces=[volcengine.ecs.LaunchTemplateNetworkInterfaceArgs(
            subnet_id=foo_subnet.id,
            security_group_ids=[foo_security_group.id],
        )],
        volumes=[volcengine.ecs.LaunchTemplateVolumeArgs(
            volume_type="ESSD_PL0",
            size=50,
            delete_with_instance=True,
        )])
    foo_scaling_group = volcengine.autoscaling.ScalingGroup("fooScalingGroup",
        scaling_group_name="acc-test-scaling-group",
        subnet_ids=[foo_subnet.id],
        multi_az_policy="BALANCE",
        desire_instance_number=-1,
        min_instance_number=0,
        max_instance_number=10,
        instance_terminate_policy="OldestInstance",
        default_cooldown=10,
        launch_template_id=foo_launch_template.id,
        launch_template_version="Default")
    foo_scaling_group_enabler = volcengine.autoscaling.ScalingGroupEnabler("fooScalingGroupEnabler", scaling_group_id=foo_scaling_group.id)
    foo_instance = []
    for range in [{"value": i} for i in range(0, 3)]:
        foo_instance.append(volcengine.ecs.Instance(f"fooInstance-{range['value']}",
            instance_name=f"acc-test-ecs-{range['value']}",
            description="acc-test",
            host_name="tf-acc-test",
            image_id=foo_images.images[0].image_id,
            instance_type="ecs.g1.large",
            password="93f0cb0614Aab12",
            instance_charge_type="PostPaid",
            system_volume_type="ESSD_PL0",
            system_volume_size=40,
            subnet_id=foo_subnet.id,
            security_group_ids=[foo_security_group.id]))
    foo_scaling_instance_attachment = []
    def create_foo_scaling_instance_attachment(range_body):
        for range in [{"value": i} for i in range(0, range_body)]:
            foo_scaling_instance_attachment.append(volcengine.autoscaling.ScalingInstanceAttachment(f"fooScalingInstanceAttachment-{range['value']}",
                instance_id=foo_instance[range["value"]].id,
                scaling_group_id=foo_scaling_group.id,
                entrusted=True,
                opts=pulumi.ResourceOptions(depends_on=[foo_scaling_group_enabler])))

    (len(foo_instance)).apply(create_foo_scaling_instance_attachment)
    foo_scaling_instances = volcengine.autoscaling.scaling_instances_output(scaling_group_id=foo_scaling_group.id,
        ids=[__item.instance_id for __item in foo_scaling_instance_attachment])
    ```


    :param str creation_type: The creation type of the instances. Valid values: AutoCreated, Attached.
    :param Sequence[str] ids: A list of instance ids.
    :param str output_file: File name where to save data source results.
    :param str scaling_configuration_id: The id of the scaling configuration id.
    :param str scaling_group_id: The id of the scaling group.
    :param str status: The status of instances. Valid values: Init, Pending, Pending:Wait, InService, Error, Removing, Removing:Wait, Stopped, Protected.
    """
    __args__ = dict()
    __args__['creationType'] = creation_type
    __args__['ids'] = ids
    __args__['outputFile'] = output_file
    __args__['scalingConfigurationId'] = scaling_configuration_id
    __args__['scalingGroupId'] = scaling_group_id
    __args__['status'] = status
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('volcengine:autoscaling/scalingInstances:ScalingInstances', __args__, opts=opts, typ=ScalingInstancesResult).value

    return AwaitableScalingInstancesResult(
        creation_type=pulumi.get(__ret__, 'creation_type'),
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        output_file=pulumi.get(__ret__, 'output_file'),
        scaling_configuration_id=pulumi.get(__ret__, 'scaling_configuration_id'),
        scaling_group_id=pulumi.get(__ret__, 'scaling_group_id'),
        scaling_instances=pulumi.get(__ret__, 'scaling_instances'),
        status=pulumi.get(__ret__, 'status'),
        total_count=pulumi.get(__ret__, 'total_count'))


@_utilities.lift_output_func(scaling_instances)
def scaling_instances_output(creation_type: Optional[pulumi.Input[Optional[str]]] = None,
                             ids: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                             output_file: Optional[pulumi.Input[Optional[str]]] = None,
                             scaling_configuration_id: Optional[pulumi.Input[Optional[str]]] = None,
                             scaling_group_id: Optional[pulumi.Input[str]] = None,
                             status: Optional[pulumi.Input[Optional[str]]] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[ScalingInstancesResult]:
    """
    Use this data source to query detailed information of scaling instances
    ## Example Usage

    ```python
    import pulumi
    import pulumi_volcengine as volcengine

    foo_zones = volcengine.ecs.zones()
    foo_vpc = volcengine.vpc.Vpc("fooVpc",
        vpc_name="acc-test-vpc",
        cidr_block="172.16.0.0/16")
    foo_subnet = volcengine.vpc.Subnet("fooSubnet",
        subnet_name="acc-test-subnet",
        cidr_block="172.16.0.0/24",
        zone_id=foo_zones.zones[0].id,
        vpc_id=foo_vpc.id)
    foo_security_group = volcengine.vpc.SecurityGroup("fooSecurityGroup",
        security_group_name="acc-test-security-group",
        vpc_id=foo_vpc.id)
    foo_images = volcengine.ecs.images(os_type="Linux",
        visibility="public",
        instance_type_id="ecs.g1.large")
    foo_key_pair = volcengine.ecs.KeyPair("fooKeyPair",
        description="acc-test-2",
        key_pair_name="acc-test-key-pair-name")
    foo_launch_template = volcengine.ecs.LaunchTemplate("fooLaunchTemplate",
        description="acc-test-desc",
        eip_bandwidth=200,
        eip_billing_type="PostPaidByBandwidth",
        eip_isp="BGP",
        host_name="acc-hostname",
        image_id=foo_images.images[0].image_id,
        instance_charge_type="PostPaid",
        instance_name="acc-instance-name",
        instance_type_id="ecs.g1.large",
        key_pair_name=foo_key_pair.key_pair_name,
        launch_template_name="acc-test-template",
        network_interfaces=[volcengine.ecs.LaunchTemplateNetworkInterfaceArgs(
            subnet_id=foo_subnet.id,
            security_group_ids=[foo_security_group.id],
        )],
        volumes=[volcengine.ecs.LaunchTemplateVolumeArgs(
            volume_type="ESSD_PL0",
            size=50,
            delete_with_instance=True,
        )])
    foo_scaling_group = volcengine.autoscaling.ScalingGroup("fooScalingGroup",
        scaling_group_name="acc-test-scaling-group",
        subnet_ids=[foo_subnet.id],
        multi_az_policy="BALANCE",
        desire_instance_number=-1,
        min_instance_number=0,
        max_instance_number=10,
        instance_terminate_policy="OldestInstance",
        default_cooldown=10,
        launch_template_id=foo_launch_template.id,
        launch_template_version="Default")
    foo_scaling_group_enabler = volcengine.autoscaling.ScalingGroupEnabler("fooScalingGroupEnabler", scaling_group_id=foo_scaling_group.id)
    foo_instance = []
    for range in [{"value": i} for i in range(0, 3)]:
        foo_instance.append(volcengine.ecs.Instance(f"fooInstance-{range['value']}",
            instance_name=f"acc-test-ecs-{range['value']}",
            description="acc-test",
            host_name="tf-acc-test",
            image_id=foo_images.images[0].image_id,
            instance_type="ecs.g1.large",
            password="93f0cb0614Aab12",
            instance_charge_type="PostPaid",
            system_volume_type="ESSD_PL0",
            system_volume_size=40,
            subnet_id=foo_subnet.id,
            security_group_ids=[foo_security_group.id]))
    foo_scaling_instance_attachment = []
    def create_foo_scaling_instance_attachment(range_body):
        for range in [{"value": i} for i in range(0, range_body)]:
            foo_scaling_instance_attachment.append(volcengine.autoscaling.ScalingInstanceAttachment(f"fooScalingInstanceAttachment-{range['value']}",
                instance_id=foo_instance[range["value"]].id,
                scaling_group_id=foo_scaling_group.id,
                entrusted=True,
                opts=pulumi.ResourceOptions(depends_on=[foo_scaling_group_enabler])))

    (len(foo_instance)).apply(create_foo_scaling_instance_attachment)
    foo_scaling_instances = volcengine.autoscaling.scaling_instances_output(scaling_group_id=foo_scaling_group.id,
        ids=[__item.instance_id for __item in foo_scaling_instance_attachment])
    ```


    :param str creation_type: The creation type of the instances. Valid values: AutoCreated, Attached.
    :param Sequence[str] ids: A list of instance ids.
    :param str output_file: File name where to save data source results.
    :param str scaling_configuration_id: The id of the scaling configuration id.
    :param str scaling_group_id: The id of the scaling group.
    :param str status: The status of instances. Valid values: Init, Pending, Pending:Wait, InService, Error, Removing, Removing:Wait, Stopped, Protected.
    """
    ...
