# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['ScalingPolicyArgs', 'ScalingPolicy']

@pulumi.input_type
class ScalingPolicyArgs:
    def __init__(__self__, *,
                 adjustment_type: pulumi.Input[str],
                 adjustment_value: pulumi.Input[int],
                 scaling_group_id: pulumi.Input[str],
                 scaling_policy_name: pulumi.Input[str],
                 scaling_policy_type: pulumi.Input[str],
                 active: Optional[pulumi.Input[bool]] = None,
                 alarm_policy_condition_comparison_operator: Optional[pulumi.Input[str]] = None,
                 alarm_policy_condition_metric_name: Optional[pulumi.Input[str]] = None,
                 alarm_policy_condition_metric_unit: Optional[pulumi.Input[str]] = None,
                 alarm_policy_condition_threshold: Optional[pulumi.Input[str]] = None,
                 alarm_policy_evaluation_count: Optional[pulumi.Input[int]] = None,
                 alarm_policy_rule_type: Optional[pulumi.Input[str]] = None,
                 cooldown: Optional[pulumi.Input[int]] = None,
                 scheduled_policy_launch_time: Optional[pulumi.Input[str]] = None,
                 scheduled_policy_recurrence_end_time: Optional[pulumi.Input[str]] = None,
                 scheduled_policy_recurrence_type: Optional[pulumi.Input[str]] = None,
                 scheduled_policy_recurrence_value: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a ScalingPolicy resource.
        :param pulumi.Input[str] adjustment_type: The adjustment type of the scaling policy. Valid values: QuantityChangeInCapacity, PercentChangeInCapacity, TotalCapacity.
        :param pulumi.Input[int] adjustment_value: The adjustment value of the scaling policy. When the value of the `AdjustmentType` parameter is `QuantityChangeInCapacity`: -100 ~ 100, 0 is not allowed, unit: piece. When the value of the `AdjustmentType` parameter is `PercentChangeInCapacity`: -100 ~ 10000, 0 is not allowed, unit: %. When the value of the `AdjustmentType` parameter is `TotalCapacity`: the default is 0 to 100, unit: piece.
        :param pulumi.Input[str] scaling_group_id: The id of the scaling group to which the scaling policy belongs.
        :param pulumi.Input[str] scaling_policy_name: The name of the scaling policy.
        :param pulumi.Input[str] scaling_policy_type: The type of scaling policy. Valid values: Scheduled, Recurrence, Alarm.
        :param pulumi.Input[bool] active: The active flag of the scaling policy. [Warning] the scaling policy can be active only when the scaling group be active otherwise will fail.
        :param pulumi.Input[str] alarm_policy_condition_comparison_operator: The comparison operator of the alarm policy condition of the scaling policy. Valid values: `>`, `<`, `=`. It is only valid and required when the value of `ScalingPolicyType` is `Alarm`.
        :param pulumi.Input[str] alarm_policy_condition_metric_name: The metric name of the alarm policy condition of the scaling policy. Valid values: CpuTotal_Max, CpuTotal_Min, CpuTotal_Avg, MemoryUsedUtilization_Max, MemoryUsedUtilization_Min, MemoryUsedUtilization_Avg, Instance_CpuBusy_Max, Instance_CpuBusy_Min, Instance_CpuBusy_Avg.
        :param pulumi.Input[str] alarm_policy_condition_metric_unit: The comparison operator of the alarm policy condition of the scaling policy. It is only valid and required when the value of `ScalingPolicyType` is `Alarm`.
        :param pulumi.Input[str] alarm_policy_condition_threshold: The threshold of the alarm policy condition of the scaling policy. It is only valid and required when the value of `ScalingPolicyType` is `Alarm`.
        :param pulumi.Input[int] alarm_policy_evaluation_count: The evaluation count of the alarm policy of the scaling policy. It is only valid and required when the value of `ScalingPolicyType` is `Alarm`.
        :param pulumi.Input[str] alarm_policy_rule_type: The rule type of the alarm policy of the scaling policy. Valid value: Static. It is only valid and required when the value of `ScalingPolicyType` is `Alarm`.
        :param pulumi.Input[int] cooldown: The cooldown of the scaling policy. Default value is the cooldown time of the scaling group. Value: 0~86400, unit: second, if left blank, the cooling time of the scaling group will be used by default.
        :param pulumi.Input[str] scheduled_policy_launch_time: The launch time of the scheduled policy of the scaling policy.
               When the value of `ScalingPolicyType` is `Scheduled`, it means that the trigger time of the scheduled task must be greater than the current time.
               When the value of `ScalingPolicyType` is `Recurrence`: If `ScheduledPolicy.RecurrenceType` is not specified, it means to execute only once according to the date and time specified here.
               If `ScheduledPolicy.RecurrenceType` is specified, it indicates the start time of the periodic task. Only the time within 90 days from the date of creation/modification is supported.
               When the value of `ScalingPolicyType` is `Alarm`, this parameter is invalid.
        :param pulumi.Input[str] scheduled_policy_recurrence_end_time: The recurrence end time of the scheduled policy of the scaling policy. Valid and required when `ScalingPolicyType` is `Recurrence`. If not configured, it will default to the day/week/month after this moment according to the recurrence period (ScheduledPolicy.RecurrenceType).
        :param pulumi.Input[str] scheduled_policy_recurrence_type: The recurrence type the scheduled policy of the scaling policy. Valid values: Daily, Weekly, Monthly, Cron.
        :param pulumi.Input[str] scheduled_policy_recurrence_value: The recurrence value the scheduled policy of the scaling policy. Valid and required when `ScalingPolicyType` is `Recurrence`. When the value of the ScheduledPolicy.RecurrenceType parameter is Daily, only one value can be filled in, ranging from 1 to 31.
               When the value of the ScheduledPolicy.RecurrenceType parameter is Weekly, you can enter multiple values separated by commas (,). The values from Monday to Sunday are: 1,2,3,4,5,6,7.
               When the value of the ScheduledPolicy.RecurrenceType parameter is Monthly, the format is A-B. The value ranges of A and B are both 1~31, and B must be greater than or equal to A.
               When the value of the ScheduledPolicy.RecurrenceType parameter is Cron, it means UTC+8 time, supports 5-field expressions of minutes, hours, days, months, and weeks, and supports wildcard English commas (,), English question marks (?), and conjunctions ( -), asterisk (*), pound sign (#), slash (/), L, and W.
        """
        pulumi.set(__self__, "adjustment_type", adjustment_type)
        pulumi.set(__self__, "adjustment_value", adjustment_value)
        pulumi.set(__self__, "scaling_group_id", scaling_group_id)
        pulumi.set(__self__, "scaling_policy_name", scaling_policy_name)
        pulumi.set(__self__, "scaling_policy_type", scaling_policy_type)
        if active is not None:
            pulumi.set(__self__, "active", active)
        if alarm_policy_condition_comparison_operator is not None:
            pulumi.set(__self__, "alarm_policy_condition_comparison_operator", alarm_policy_condition_comparison_operator)
        if alarm_policy_condition_metric_name is not None:
            pulumi.set(__self__, "alarm_policy_condition_metric_name", alarm_policy_condition_metric_name)
        if alarm_policy_condition_metric_unit is not None:
            pulumi.set(__self__, "alarm_policy_condition_metric_unit", alarm_policy_condition_metric_unit)
        if alarm_policy_condition_threshold is not None:
            pulumi.set(__self__, "alarm_policy_condition_threshold", alarm_policy_condition_threshold)
        if alarm_policy_evaluation_count is not None:
            pulumi.set(__self__, "alarm_policy_evaluation_count", alarm_policy_evaluation_count)
        if alarm_policy_rule_type is not None:
            pulumi.set(__self__, "alarm_policy_rule_type", alarm_policy_rule_type)
        if cooldown is not None:
            pulumi.set(__self__, "cooldown", cooldown)
        if scheduled_policy_launch_time is not None:
            pulumi.set(__self__, "scheduled_policy_launch_time", scheduled_policy_launch_time)
        if scheduled_policy_recurrence_end_time is not None:
            pulumi.set(__self__, "scheduled_policy_recurrence_end_time", scheduled_policy_recurrence_end_time)
        if scheduled_policy_recurrence_type is not None:
            pulumi.set(__self__, "scheduled_policy_recurrence_type", scheduled_policy_recurrence_type)
        if scheduled_policy_recurrence_value is not None:
            pulumi.set(__self__, "scheduled_policy_recurrence_value", scheduled_policy_recurrence_value)

    @property
    @pulumi.getter(name="adjustmentType")
    def adjustment_type(self) -> pulumi.Input[str]:
        """
        The adjustment type of the scaling policy. Valid values: QuantityChangeInCapacity, PercentChangeInCapacity, TotalCapacity.
        """
        return pulumi.get(self, "adjustment_type")

    @adjustment_type.setter
    def adjustment_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "adjustment_type", value)

    @property
    @pulumi.getter(name="adjustmentValue")
    def adjustment_value(self) -> pulumi.Input[int]:
        """
        The adjustment value of the scaling policy. When the value of the `AdjustmentType` parameter is `QuantityChangeInCapacity`: -100 ~ 100, 0 is not allowed, unit: piece. When the value of the `AdjustmentType` parameter is `PercentChangeInCapacity`: -100 ~ 10000, 0 is not allowed, unit: %. When the value of the `AdjustmentType` parameter is `TotalCapacity`: the default is 0 to 100, unit: piece.
        """
        return pulumi.get(self, "adjustment_value")

    @adjustment_value.setter
    def adjustment_value(self, value: pulumi.Input[int]):
        pulumi.set(self, "adjustment_value", value)

    @property
    @pulumi.getter(name="scalingGroupId")
    def scaling_group_id(self) -> pulumi.Input[str]:
        """
        The id of the scaling group to which the scaling policy belongs.
        """
        return pulumi.get(self, "scaling_group_id")

    @scaling_group_id.setter
    def scaling_group_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "scaling_group_id", value)

    @property
    @pulumi.getter(name="scalingPolicyName")
    def scaling_policy_name(self) -> pulumi.Input[str]:
        """
        The name of the scaling policy.
        """
        return pulumi.get(self, "scaling_policy_name")

    @scaling_policy_name.setter
    def scaling_policy_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "scaling_policy_name", value)

    @property
    @pulumi.getter(name="scalingPolicyType")
    def scaling_policy_type(self) -> pulumi.Input[str]:
        """
        The type of scaling policy. Valid values: Scheduled, Recurrence, Alarm.
        """
        return pulumi.get(self, "scaling_policy_type")

    @scaling_policy_type.setter
    def scaling_policy_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "scaling_policy_type", value)

    @property
    @pulumi.getter
    def active(self) -> Optional[pulumi.Input[bool]]:
        """
        The active flag of the scaling policy. [Warning] the scaling policy can be active only when the scaling group be active otherwise will fail.
        """
        return pulumi.get(self, "active")

    @active.setter
    def active(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "active", value)

    @property
    @pulumi.getter(name="alarmPolicyConditionComparisonOperator")
    def alarm_policy_condition_comparison_operator(self) -> Optional[pulumi.Input[str]]:
        """
        The comparison operator of the alarm policy condition of the scaling policy. Valid values: `>`, `<`, `=`. It is only valid and required when the value of `ScalingPolicyType` is `Alarm`.
        """
        return pulumi.get(self, "alarm_policy_condition_comparison_operator")

    @alarm_policy_condition_comparison_operator.setter
    def alarm_policy_condition_comparison_operator(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "alarm_policy_condition_comparison_operator", value)

    @property
    @pulumi.getter(name="alarmPolicyConditionMetricName")
    def alarm_policy_condition_metric_name(self) -> Optional[pulumi.Input[str]]:
        """
        The metric name of the alarm policy condition of the scaling policy. Valid values: CpuTotal_Max, CpuTotal_Min, CpuTotal_Avg, MemoryUsedUtilization_Max, MemoryUsedUtilization_Min, MemoryUsedUtilization_Avg, Instance_CpuBusy_Max, Instance_CpuBusy_Min, Instance_CpuBusy_Avg.
        """
        return pulumi.get(self, "alarm_policy_condition_metric_name")

    @alarm_policy_condition_metric_name.setter
    def alarm_policy_condition_metric_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "alarm_policy_condition_metric_name", value)

    @property
    @pulumi.getter(name="alarmPolicyConditionMetricUnit")
    def alarm_policy_condition_metric_unit(self) -> Optional[pulumi.Input[str]]:
        """
        The comparison operator of the alarm policy condition of the scaling policy. It is only valid and required when the value of `ScalingPolicyType` is `Alarm`.
        """
        return pulumi.get(self, "alarm_policy_condition_metric_unit")

    @alarm_policy_condition_metric_unit.setter
    def alarm_policy_condition_metric_unit(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "alarm_policy_condition_metric_unit", value)

    @property
    @pulumi.getter(name="alarmPolicyConditionThreshold")
    def alarm_policy_condition_threshold(self) -> Optional[pulumi.Input[str]]:
        """
        The threshold of the alarm policy condition of the scaling policy. It is only valid and required when the value of `ScalingPolicyType` is `Alarm`.
        """
        return pulumi.get(self, "alarm_policy_condition_threshold")

    @alarm_policy_condition_threshold.setter
    def alarm_policy_condition_threshold(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "alarm_policy_condition_threshold", value)

    @property
    @pulumi.getter(name="alarmPolicyEvaluationCount")
    def alarm_policy_evaluation_count(self) -> Optional[pulumi.Input[int]]:
        """
        The evaluation count of the alarm policy of the scaling policy. It is only valid and required when the value of `ScalingPolicyType` is `Alarm`.
        """
        return pulumi.get(self, "alarm_policy_evaluation_count")

    @alarm_policy_evaluation_count.setter
    def alarm_policy_evaluation_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "alarm_policy_evaluation_count", value)

    @property
    @pulumi.getter(name="alarmPolicyRuleType")
    def alarm_policy_rule_type(self) -> Optional[pulumi.Input[str]]:
        """
        The rule type of the alarm policy of the scaling policy. Valid value: Static. It is only valid and required when the value of `ScalingPolicyType` is `Alarm`.
        """
        return pulumi.get(self, "alarm_policy_rule_type")

    @alarm_policy_rule_type.setter
    def alarm_policy_rule_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "alarm_policy_rule_type", value)

    @property
    @pulumi.getter
    def cooldown(self) -> Optional[pulumi.Input[int]]:
        """
        The cooldown of the scaling policy. Default value is the cooldown time of the scaling group. Value: 0~86400, unit: second, if left blank, the cooling time of the scaling group will be used by default.
        """
        return pulumi.get(self, "cooldown")

    @cooldown.setter
    def cooldown(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "cooldown", value)

    @property
    @pulumi.getter(name="scheduledPolicyLaunchTime")
    def scheduled_policy_launch_time(self) -> Optional[pulumi.Input[str]]:
        """
        The launch time of the scheduled policy of the scaling policy.
        When the value of `ScalingPolicyType` is `Scheduled`, it means that the trigger time of the scheduled task must be greater than the current time.
        When the value of `ScalingPolicyType` is `Recurrence`: If `ScheduledPolicy.RecurrenceType` is not specified, it means to execute only once according to the date and time specified here.
        If `ScheduledPolicy.RecurrenceType` is specified, it indicates the start time of the periodic task. Only the time within 90 days from the date of creation/modification is supported.
        When the value of `ScalingPolicyType` is `Alarm`, this parameter is invalid.
        """
        return pulumi.get(self, "scheduled_policy_launch_time")

    @scheduled_policy_launch_time.setter
    def scheduled_policy_launch_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "scheduled_policy_launch_time", value)

    @property
    @pulumi.getter(name="scheduledPolicyRecurrenceEndTime")
    def scheduled_policy_recurrence_end_time(self) -> Optional[pulumi.Input[str]]:
        """
        The recurrence end time of the scheduled policy of the scaling policy. Valid and required when `ScalingPolicyType` is `Recurrence`. If not configured, it will default to the day/week/month after this moment according to the recurrence period (ScheduledPolicy.RecurrenceType).
        """
        return pulumi.get(self, "scheduled_policy_recurrence_end_time")

    @scheduled_policy_recurrence_end_time.setter
    def scheduled_policy_recurrence_end_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "scheduled_policy_recurrence_end_time", value)

    @property
    @pulumi.getter(name="scheduledPolicyRecurrenceType")
    def scheduled_policy_recurrence_type(self) -> Optional[pulumi.Input[str]]:
        """
        The recurrence type the scheduled policy of the scaling policy. Valid values: Daily, Weekly, Monthly, Cron.
        """
        return pulumi.get(self, "scheduled_policy_recurrence_type")

    @scheduled_policy_recurrence_type.setter
    def scheduled_policy_recurrence_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "scheduled_policy_recurrence_type", value)

    @property
    @pulumi.getter(name="scheduledPolicyRecurrenceValue")
    def scheduled_policy_recurrence_value(self) -> Optional[pulumi.Input[str]]:
        """
        The recurrence value the scheduled policy of the scaling policy. Valid and required when `ScalingPolicyType` is `Recurrence`. When the value of the ScheduledPolicy.RecurrenceType parameter is Daily, only one value can be filled in, ranging from 1 to 31.
        When the value of the ScheduledPolicy.RecurrenceType parameter is Weekly, you can enter multiple values separated by commas (,). The values from Monday to Sunday are: 1,2,3,4,5,6,7.
        When the value of the ScheduledPolicy.RecurrenceType parameter is Monthly, the format is A-B. The value ranges of A and B are both 1~31, and B must be greater than or equal to A.
        When the value of the ScheduledPolicy.RecurrenceType parameter is Cron, it means UTC+8 time, supports 5-field expressions of minutes, hours, days, months, and weeks, and supports wildcard English commas (,), English question marks (?), and conjunctions ( -), asterisk (*), pound sign (#), slash (/), L, and W.
        """
        return pulumi.get(self, "scheduled_policy_recurrence_value")

    @scheduled_policy_recurrence_value.setter
    def scheduled_policy_recurrence_value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "scheduled_policy_recurrence_value", value)


@pulumi.input_type
class _ScalingPolicyState:
    def __init__(__self__, *,
                 active: Optional[pulumi.Input[bool]] = None,
                 adjustment_type: Optional[pulumi.Input[str]] = None,
                 adjustment_value: Optional[pulumi.Input[int]] = None,
                 alarm_policy_condition_comparison_operator: Optional[pulumi.Input[str]] = None,
                 alarm_policy_condition_metric_name: Optional[pulumi.Input[str]] = None,
                 alarm_policy_condition_metric_unit: Optional[pulumi.Input[str]] = None,
                 alarm_policy_condition_threshold: Optional[pulumi.Input[str]] = None,
                 alarm_policy_evaluation_count: Optional[pulumi.Input[int]] = None,
                 alarm_policy_rule_type: Optional[pulumi.Input[str]] = None,
                 cooldown: Optional[pulumi.Input[int]] = None,
                 scaling_group_id: Optional[pulumi.Input[str]] = None,
                 scaling_policy_id: Optional[pulumi.Input[str]] = None,
                 scaling_policy_name: Optional[pulumi.Input[str]] = None,
                 scaling_policy_type: Optional[pulumi.Input[str]] = None,
                 scheduled_policy_launch_time: Optional[pulumi.Input[str]] = None,
                 scheduled_policy_recurrence_end_time: Optional[pulumi.Input[str]] = None,
                 scheduled_policy_recurrence_type: Optional[pulumi.Input[str]] = None,
                 scheduled_policy_recurrence_value: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering ScalingPolicy resources.
        :param pulumi.Input[bool] active: The active flag of the scaling policy. [Warning] the scaling policy can be active only when the scaling group be active otherwise will fail.
        :param pulumi.Input[str] adjustment_type: The adjustment type of the scaling policy. Valid values: QuantityChangeInCapacity, PercentChangeInCapacity, TotalCapacity.
        :param pulumi.Input[int] adjustment_value: The adjustment value of the scaling policy. When the value of the `AdjustmentType` parameter is `QuantityChangeInCapacity`: -100 ~ 100, 0 is not allowed, unit: piece. When the value of the `AdjustmentType` parameter is `PercentChangeInCapacity`: -100 ~ 10000, 0 is not allowed, unit: %. When the value of the `AdjustmentType` parameter is `TotalCapacity`: the default is 0 to 100, unit: piece.
        :param pulumi.Input[str] alarm_policy_condition_comparison_operator: The comparison operator of the alarm policy condition of the scaling policy. Valid values: `>`, `<`, `=`. It is only valid and required when the value of `ScalingPolicyType` is `Alarm`.
        :param pulumi.Input[str] alarm_policy_condition_metric_name: The metric name of the alarm policy condition of the scaling policy. Valid values: CpuTotal_Max, CpuTotal_Min, CpuTotal_Avg, MemoryUsedUtilization_Max, MemoryUsedUtilization_Min, MemoryUsedUtilization_Avg, Instance_CpuBusy_Max, Instance_CpuBusy_Min, Instance_CpuBusy_Avg.
        :param pulumi.Input[str] alarm_policy_condition_metric_unit: The comparison operator of the alarm policy condition of the scaling policy. It is only valid and required when the value of `ScalingPolicyType` is `Alarm`.
        :param pulumi.Input[str] alarm_policy_condition_threshold: The threshold of the alarm policy condition of the scaling policy. It is only valid and required when the value of `ScalingPolicyType` is `Alarm`.
        :param pulumi.Input[int] alarm_policy_evaluation_count: The evaluation count of the alarm policy of the scaling policy. It is only valid and required when the value of `ScalingPolicyType` is `Alarm`.
        :param pulumi.Input[str] alarm_policy_rule_type: The rule type of the alarm policy of the scaling policy. Valid value: Static. It is only valid and required when the value of `ScalingPolicyType` is `Alarm`.
        :param pulumi.Input[int] cooldown: The cooldown of the scaling policy. Default value is the cooldown time of the scaling group. Value: 0~86400, unit: second, if left blank, the cooling time of the scaling group will be used by default.
        :param pulumi.Input[str] scaling_group_id: The id of the scaling group to which the scaling policy belongs.
        :param pulumi.Input[str] scaling_policy_id: The id of the scaling policy.
        :param pulumi.Input[str] scaling_policy_name: The name of the scaling policy.
        :param pulumi.Input[str] scaling_policy_type: The type of scaling policy. Valid values: Scheduled, Recurrence, Alarm.
        :param pulumi.Input[str] scheduled_policy_launch_time: The launch time of the scheduled policy of the scaling policy.
               When the value of `ScalingPolicyType` is `Scheduled`, it means that the trigger time of the scheduled task must be greater than the current time.
               When the value of `ScalingPolicyType` is `Recurrence`: If `ScheduledPolicy.RecurrenceType` is not specified, it means to execute only once according to the date and time specified here.
               If `ScheduledPolicy.RecurrenceType` is specified, it indicates the start time of the periodic task. Only the time within 90 days from the date of creation/modification is supported.
               When the value of `ScalingPolicyType` is `Alarm`, this parameter is invalid.
        :param pulumi.Input[str] scheduled_policy_recurrence_end_time: The recurrence end time of the scheduled policy of the scaling policy. Valid and required when `ScalingPolicyType` is `Recurrence`. If not configured, it will default to the day/week/month after this moment according to the recurrence period (ScheduledPolicy.RecurrenceType).
        :param pulumi.Input[str] scheduled_policy_recurrence_type: The recurrence type the scheduled policy of the scaling policy. Valid values: Daily, Weekly, Monthly, Cron.
        :param pulumi.Input[str] scheduled_policy_recurrence_value: The recurrence value the scheduled policy of the scaling policy. Valid and required when `ScalingPolicyType` is `Recurrence`. When the value of the ScheduledPolicy.RecurrenceType parameter is Daily, only one value can be filled in, ranging from 1 to 31.
               When the value of the ScheduledPolicy.RecurrenceType parameter is Weekly, you can enter multiple values separated by commas (,). The values from Monday to Sunday are: 1,2,3,4,5,6,7.
               When the value of the ScheduledPolicy.RecurrenceType parameter is Monthly, the format is A-B. The value ranges of A and B are both 1~31, and B must be greater than or equal to A.
               When the value of the ScheduledPolicy.RecurrenceType parameter is Cron, it means UTC+8 time, supports 5-field expressions of minutes, hours, days, months, and weeks, and supports wildcard English commas (,), English question marks (?), and conjunctions ( -), asterisk (*), pound sign (#), slash (/), L, and W.
        :param pulumi.Input[str] status: The status of the scaling policy. Valid values: Active, InActive.
        """
        if active is not None:
            pulumi.set(__self__, "active", active)
        if adjustment_type is not None:
            pulumi.set(__self__, "adjustment_type", adjustment_type)
        if adjustment_value is not None:
            pulumi.set(__self__, "adjustment_value", adjustment_value)
        if alarm_policy_condition_comparison_operator is not None:
            pulumi.set(__self__, "alarm_policy_condition_comparison_operator", alarm_policy_condition_comparison_operator)
        if alarm_policy_condition_metric_name is not None:
            pulumi.set(__self__, "alarm_policy_condition_metric_name", alarm_policy_condition_metric_name)
        if alarm_policy_condition_metric_unit is not None:
            pulumi.set(__self__, "alarm_policy_condition_metric_unit", alarm_policy_condition_metric_unit)
        if alarm_policy_condition_threshold is not None:
            pulumi.set(__self__, "alarm_policy_condition_threshold", alarm_policy_condition_threshold)
        if alarm_policy_evaluation_count is not None:
            pulumi.set(__self__, "alarm_policy_evaluation_count", alarm_policy_evaluation_count)
        if alarm_policy_rule_type is not None:
            pulumi.set(__self__, "alarm_policy_rule_type", alarm_policy_rule_type)
        if cooldown is not None:
            pulumi.set(__self__, "cooldown", cooldown)
        if scaling_group_id is not None:
            pulumi.set(__self__, "scaling_group_id", scaling_group_id)
        if scaling_policy_id is not None:
            pulumi.set(__self__, "scaling_policy_id", scaling_policy_id)
        if scaling_policy_name is not None:
            pulumi.set(__self__, "scaling_policy_name", scaling_policy_name)
        if scaling_policy_type is not None:
            pulumi.set(__self__, "scaling_policy_type", scaling_policy_type)
        if scheduled_policy_launch_time is not None:
            pulumi.set(__self__, "scheduled_policy_launch_time", scheduled_policy_launch_time)
        if scheduled_policy_recurrence_end_time is not None:
            pulumi.set(__self__, "scheduled_policy_recurrence_end_time", scheduled_policy_recurrence_end_time)
        if scheduled_policy_recurrence_type is not None:
            pulumi.set(__self__, "scheduled_policy_recurrence_type", scheduled_policy_recurrence_type)
        if scheduled_policy_recurrence_value is not None:
            pulumi.set(__self__, "scheduled_policy_recurrence_value", scheduled_policy_recurrence_value)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def active(self) -> Optional[pulumi.Input[bool]]:
        """
        The active flag of the scaling policy. [Warning] the scaling policy can be active only when the scaling group be active otherwise will fail.
        """
        return pulumi.get(self, "active")

    @active.setter
    def active(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "active", value)

    @property
    @pulumi.getter(name="adjustmentType")
    def adjustment_type(self) -> Optional[pulumi.Input[str]]:
        """
        The adjustment type of the scaling policy. Valid values: QuantityChangeInCapacity, PercentChangeInCapacity, TotalCapacity.
        """
        return pulumi.get(self, "adjustment_type")

    @adjustment_type.setter
    def adjustment_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "adjustment_type", value)

    @property
    @pulumi.getter(name="adjustmentValue")
    def adjustment_value(self) -> Optional[pulumi.Input[int]]:
        """
        The adjustment value of the scaling policy. When the value of the `AdjustmentType` parameter is `QuantityChangeInCapacity`: -100 ~ 100, 0 is not allowed, unit: piece. When the value of the `AdjustmentType` parameter is `PercentChangeInCapacity`: -100 ~ 10000, 0 is not allowed, unit: %. When the value of the `AdjustmentType` parameter is `TotalCapacity`: the default is 0 to 100, unit: piece.
        """
        return pulumi.get(self, "adjustment_value")

    @adjustment_value.setter
    def adjustment_value(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "adjustment_value", value)

    @property
    @pulumi.getter(name="alarmPolicyConditionComparisonOperator")
    def alarm_policy_condition_comparison_operator(self) -> Optional[pulumi.Input[str]]:
        """
        The comparison operator of the alarm policy condition of the scaling policy. Valid values: `>`, `<`, `=`. It is only valid and required when the value of `ScalingPolicyType` is `Alarm`.
        """
        return pulumi.get(self, "alarm_policy_condition_comparison_operator")

    @alarm_policy_condition_comparison_operator.setter
    def alarm_policy_condition_comparison_operator(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "alarm_policy_condition_comparison_operator", value)

    @property
    @pulumi.getter(name="alarmPolicyConditionMetricName")
    def alarm_policy_condition_metric_name(self) -> Optional[pulumi.Input[str]]:
        """
        The metric name of the alarm policy condition of the scaling policy. Valid values: CpuTotal_Max, CpuTotal_Min, CpuTotal_Avg, MemoryUsedUtilization_Max, MemoryUsedUtilization_Min, MemoryUsedUtilization_Avg, Instance_CpuBusy_Max, Instance_CpuBusy_Min, Instance_CpuBusy_Avg.
        """
        return pulumi.get(self, "alarm_policy_condition_metric_name")

    @alarm_policy_condition_metric_name.setter
    def alarm_policy_condition_metric_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "alarm_policy_condition_metric_name", value)

    @property
    @pulumi.getter(name="alarmPolicyConditionMetricUnit")
    def alarm_policy_condition_metric_unit(self) -> Optional[pulumi.Input[str]]:
        """
        The comparison operator of the alarm policy condition of the scaling policy. It is only valid and required when the value of `ScalingPolicyType` is `Alarm`.
        """
        return pulumi.get(self, "alarm_policy_condition_metric_unit")

    @alarm_policy_condition_metric_unit.setter
    def alarm_policy_condition_metric_unit(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "alarm_policy_condition_metric_unit", value)

    @property
    @pulumi.getter(name="alarmPolicyConditionThreshold")
    def alarm_policy_condition_threshold(self) -> Optional[pulumi.Input[str]]:
        """
        The threshold of the alarm policy condition of the scaling policy. It is only valid and required when the value of `ScalingPolicyType` is `Alarm`.
        """
        return pulumi.get(self, "alarm_policy_condition_threshold")

    @alarm_policy_condition_threshold.setter
    def alarm_policy_condition_threshold(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "alarm_policy_condition_threshold", value)

    @property
    @pulumi.getter(name="alarmPolicyEvaluationCount")
    def alarm_policy_evaluation_count(self) -> Optional[pulumi.Input[int]]:
        """
        The evaluation count of the alarm policy of the scaling policy. It is only valid and required when the value of `ScalingPolicyType` is `Alarm`.
        """
        return pulumi.get(self, "alarm_policy_evaluation_count")

    @alarm_policy_evaluation_count.setter
    def alarm_policy_evaluation_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "alarm_policy_evaluation_count", value)

    @property
    @pulumi.getter(name="alarmPolicyRuleType")
    def alarm_policy_rule_type(self) -> Optional[pulumi.Input[str]]:
        """
        The rule type of the alarm policy of the scaling policy. Valid value: Static. It is only valid and required when the value of `ScalingPolicyType` is `Alarm`.
        """
        return pulumi.get(self, "alarm_policy_rule_type")

    @alarm_policy_rule_type.setter
    def alarm_policy_rule_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "alarm_policy_rule_type", value)

    @property
    @pulumi.getter
    def cooldown(self) -> Optional[pulumi.Input[int]]:
        """
        The cooldown of the scaling policy. Default value is the cooldown time of the scaling group. Value: 0~86400, unit: second, if left blank, the cooling time of the scaling group will be used by default.
        """
        return pulumi.get(self, "cooldown")

    @cooldown.setter
    def cooldown(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "cooldown", value)

    @property
    @pulumi.getter(name="scalingGroupId")
    def scaling_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        The id of the scaling group to which the scaling policy belongs.
        """
        return pulumi.get(self, "scaling_group_id")

    @scaling_group_id.setter
    def scaling_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "scaling_group_id", value)

    @property
    @pulumi.getter(name="scalingPolicyId")
    def scaling_policy_id(self) -> Optional[pulumi.Input[str]]:
        """
        The id of the scaling policy.
        """
        return pulumi.get(self, "scaling_policy_id")

    @scaling_policy_id.setter
    def scaling_policy_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "scaling_policy_id", value)

    @property
    @pulumi.getter(name="scalingPolicyName")
    def scaling_policy_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the scaling policy.
        """
        return pulumi.get(self, "scaling_policy_name")

    @scaling_policy_name.setter
    def scaling_policy_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "scaling_policy_name", value)

    @property
    @pulumi.getter(name="scalingPolicyType")
    def scaling_policy_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of scaling policy. Valid values: Scheduled, Recurrence, Alarm.
        """
        return pulumi.get(self, "scaling_policy_type")

    @scaling_policy_type.setter
    def scaling_policy_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "scaling_policy_type", value)

    @property
    @pulumi.getter(name="scheduledPolicyLaunchTime")
    def scheduled_policy_launch_time(self) -> Optional[pulumi.Input[str]]:
        """
        The launch time of the scheduled policy of the scaling policy.
        When the value of `ScalingPolicyType` is `Scheduled`, it means that the trigger time of the scheduled task must be greater than the current time.
        When the value of `ScalingPolicyType` is `Recurrence`: If `ScheduledPolicy.RecurrenceType` is not specified, it means to execute only once according to the date and time specified here.
        If `ScheduledPolicy.RecurrenceType` is specified, it indicates the start time of the periodic task. Only the time within 90 days from the date of creation/modification is supported.
        When the value of `ScalingPolicyType` is `Alarm`, this parameter is invalid.
        """
        return pulumi.get(self, "scheduled_policy_launch_time")

    @scheduled_policy_launch_time.setter
    def scheduled_policy_launch_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "scheduled_policy_launch_time", value)

    @property
    @pulumi.getter(name="scheduledPolicyRecurrenceEndTime")
    def scheduled_policy_recurrence_end_time(self) -> Optional[pulumi.Input[str]]:
        """
        The recurrence end time of the scheduled policy of the scaling policy. Valid and required when `ScalingPolicyType` is `Recurrence`. If not configured, it will default to the day/week/month after this moment according to the recurrence period (ScheduledPolicy.RecurrenceType).
        """
        return pulumi.get(self, "scheduled_policy_recurrence_end_time")

    @scheduled_policy_recurrence_end_time.setter
    def scheduled_policy_recurrence_end_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "scheduled_policy_recurrence_end_time", value)

    @property
    @pulumi.getter(name="scheduledPolicyRecurrenceType")
    def scheduled_policy_recurrence_type(self) -> Optional[pulumi.Input[str]]:
        """
        The recurrence type the scheduled policy of the scaling policy. Valid values: Daily, Weekly, Monthly, Cron.
        """
        return pulumi.get(self, "scheduled_policy_recurrence_type")

    @scheduled_policy_recurrence_type.setter
    def scheduled_policy_recurrence_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "scheduled_policy_recurrence_type", value)

    @property
    @pulumi.getter(name="scheduledPolicyRecurrenceValue")
    def scheduled_policy_recurrence_value(self) -> Optional[pulumi.Input[str]]:
        """
        The recurrence value the scheduled policy of the scaling policy. Valid and required when `ScalingPolicyType` is `Recurrence`. When the value of the ScheduledPolicy.RecurrenceType parameter is Daily, only one value can be filled in, ranging from 1 to 31.
        When the value of the ScheduledPolicy.RecurrenceType parameter is Weekly, you can enter multiple values separated by commas (,). The values from Monday to Sunday are: 1,2,3,4,5,6,7.
        When the value of the ScheduledPolicy.RecurrenceType parameter is Monthly, the format is A-B. The value ranges of A and B are both 1~31, and B must be greater than or equal to A.
        When the value of the ScheduledPolicy.RecurrenceType parameter is Cron, it means UTC+8 time, supports 5-field expressions of minutes, hours, days, months, and weeks, and supports wildcard English commas (,), English question marks (?), and conjunctions ( -), asterisk (*), pound sign (#), slash (/), L, and W.
        """
        return pulumi.get(self, "scheduled_policy_recurrence_value")

    @scheduled_policy_recurrence_value.setter
    def scheduled_policy_recurrence_value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "scheduled_policy_recurrence_value", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The status of the scaling policy. Valid values: Active, InActive.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)


class ScalingPolicy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 active: Optional[pulumi.Input[bool]] = None,
                 adjustment_type: Optional[pulumi.Input[str]] = None,
                 adjustment_value: Optional[pulumi.Input[int]] = None,
                 alarm_policy_condition_comparison_operator: Optional[pulumi.Input[str]] = None,
                 alarm_policy_condition_metric_name: Optional[pulumi.Input[str]] = None,
                 alarm_policy_condition_metric_unit: Optional[pulumi.Input[str]] = None,
                 alarm_policy_condition_threshold: Optional[pulumi.Input[str]] = None,
                 alarm_policy_evaluation_count: Optional[pulumi.Input[int]] = None,
                 alarm_policy_rule_type: Optional[pulumi.Input[str]] = None,
                 cooldown: Optional[pulumi.Input[int]] = None,
                 scaling_group_id: Optional[pulumi.Input[str]] = None,
                 scaling_policy_name: Optional[pulumi.Input[str]] = None,
                 scaling_policy_type: Optional[pulumi.Input[str]] = None,
                 scheduled_policy_launch_time: Optional[pulumi.Input[str]] = None,
                 scheduled_policy_recurrence_end_time: Optional[pulumi.Input[str]] = None,
                 scheduled_policy_recurrence_type: Optional[pulumi.Input[str]] = None,
                 scheduled_policy_recurrence_value: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a resource to manage scaling policy
        ## Example Usage

        ```python
        import pulumi
        import pulumi_volcengine as volcengine

        foo_zones = volcengine.ecs.zones()
        foo_vpc = volcengine.vpc.Vpc("fooVpc",
            vpc_name="acc-test-vpc",
            cidr_block="172.16.0.0/16")
        foo_subnet = volcengine.vpc.Subnet("fooSubnet",
            subnet_name="acc-test-subnet",
            cidr_block="172.16.0.0/24",
            zone_id=foo_zones.zones[0].id,
            vpc_id=foo_vpc.id)
        foo_scaling_group = volcengine.autoscaling.ScalingGroup("fooScalingGroup",
            scaling_group_name="acc-test-scaling-group",
            subnet_ids=[foo_subnet.id],
            multi_az_policy="BALANCE",
            desire_instance_number=0,
            min_instance_number=0,
            max_instance_number=1,
            instance_terminate_policy="OldestInstance",
            default_cooldown=10)
        foo_scaling_policy = volcengine.autoscaling.ScalingPolicy("fooScalingPolicy",
            active=False,
            scaling_group_id=foo_scaling_group.id,
            scaling_policy_name="acc-tf-sg-policy-test",
            scaling_policy_type="Alarm",
            adjustment_type="QuantityChangeInCapacity",
            adjustment_value=100,
            cooldown=10,
            alarm_policy_rule_type="Static",
            alarm_policy_evaluation_count=1,
            alarm_policy_condition_metric_name="Instance_CpuBusy_Avg",
            alarm_policy_condition_metric_unit="Percent",
            alarm_policy_condition_comparison_operator="=",
            alarm_policy_condition_threshold="100")
        ```

        ## Import

        ScalingPolicy can be imported using the ScalingGroupId:ScalingPolicyId, e.g.

        ```sh
         $ pulumi import volcengine:autoscaling/scalingPolicy:ScalingPolicy default scg-yblfbfhy7agh9zn72iaz:sp-yblf9l4fvcl8j1prohsp
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] active: The active flag of the scaling policy. [Warning] the scaling policy can be active only when the scaling group be active otherwise will fail.
        :param pulumi.Input[str] adjustment_type: The adjustment type of the scaling policy. Valid values: QuantityChangeInCapacity, PercentChangeInCapacity, TotalCapacity.
        :param pulumi.Input[int] adjustment_value: The adjustment value of the scaling policy. When the value of the `AdjustmentType` parameter is `QuantityChangeInCapacity`: -100 ~ 100, 0 is not allowed, unit: piece. When the value of the `AdjustmentType` parameter is `PercentChangeInCapacity`: -100 ~ 10000, 0 is not allowed, unit: %. When the value of the `AdjustmentType` parameter is `TotalCapacity`: the default is 0 to 100, unit: piece.
        :param pulumi.Input[str] alarm_policy_condition_comparison_operator: The comparison operator of the alarm policy condition of the scaling policy. Valid values: `>`, `<`, `=`. It is only valid and required when the value of `ScalingPolicyType` is `Alarm`.
        :param pulumi.Input[str] alarm_policy_condition_metric_name: The metric name of the alarm policy condition of the scaling policy. Valid values: CpuTotal_Max, CpuTotal_Min, CpuTotal_Avg, MemoryUsedUtilization_Max, MemoryUsedUtilization_Min, MemoryUsedUtilization_Avg, Instance_CpuBusy_Max, Instance_CpuBusy_Min, Instance_CpuBusy_Avg.
        :param pulumi.Input[str] alarm_policy_condition_metric_unit: The comparison operator of the alarm policy condition of the scaling policy. It is only valid and required when the value of `ScalingPolicyType` is `Alarm`.
        :param pulumi.Input[str] alarm_policy_condition_threshold: The threshold of the alarm policy condition of the scaling policy. It is only valid and required when the value of `ScalingPolicyType` is `Alarm`.
        :param pulumi.Input[int] alarm_policy_evaluation_count: The evaluation count of the alarm policy of the scaling policy. It is only valid and required when the value of `ScalingPolicyType` is `Alarm`.
        :param pulumi.Input[str] alarm_policy_rule_type: The rule type of the alarm policy of the scaling policy. Valid value: Static. It is only valid and required when the value of `ScalingPolicyType` is `Alarm`.
        :param pulumi.Input[int] cooldown: The cooldown of the scaling policy. Default value is the cooldown time of the scaling group. Value: 0~86400, unit: second, if left blank, the cooling time of the scaling group will be used by default.
        :param pulumi.Input[str] scaling_group_id: The id of the scaling group to which the scaling policy belongs.
        :param pulumi.Input[str] scaling_policy_name: The name of the scaling policy.
        :param pulumi.Input[str] scaling_policy_type: The type of scaling policy. Valid values: Scheduled, Recurrence, Alarm.
        :param pulumi.Input[str] scheduled_policy_launch_time: The launch time of the scheduled policy of the scaling policy.
               When the value of `ScalingPolicyType` is `Scheduled`, it means that the trigger time of the scheduled task must be greater than the current time.
               When the value of `ScalingPolicyType` is `Recurrence`: If `ScheduledPolicy.RecurrenceType` is not specified, it means to execute only once according to the date and time specified here.
               If `ScheduledPolicy.RecurrenceType` is specified, it indicates the start time of the periodic task. Only the time within 90 days from the date of creation/modification is supported.
               When the value of `ScalingPolicyType` is `Alarm`, this parameter is invalid.
        :param pulumi.Input[str] scheduled_policy_recurrence_end_time: The recurrence end time of the scheduled policy of the scaling policy. Valid and required when `ScalingPolicyType` is `Recurrence`. If not configured, it will default to the day/week/month after this moment according to the recurrence period (ScheduledPolicy.RecurrenceType).
        :param pulumi.Input[str] scheduled_policy_recurrence_type: The recurrence type the scheduled policy of the scaling policy. Valid values: Daily, Weekly, Monthly, Cron.
        :param pulumi.Input[str] scheduled_policy_recurrence_value: The recurrence value the scheduled policy of the scaling policy. Valid and required when `ScalingPolicyType` is `Recurrence`. When the value of the ScheduledPolicy.RecurrenceType parameter is Daily, only one value can be filled in, ranging from 1 to 31.
               When the value of the ScheduledPolicy.RecurrenceType parameter is Weekly, you can enter multiple values separated by commas (,). The values from Monday to Sunday are: 1,2,3,4,5,6,7.
               When the value of the ScheduledPolicy.RecurrenceType parameter is Monthly, the format is A-B. The value ranges of A and B are both 1~31, and B must be greater than or equal to A.
               When the value of the ScheduledPolicy.RecurrenceType parameter is Cron, it means UTC+8 time, supports 5-field expressions of minutes, hours, days, months, and weeks, and supports wildcard English commas (,), English question marks (?), and conjunctions ( -), asterisk (*), pound sign (#), slash (/), L, and W.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ScalingPolicyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a resource to manage scaling policy
        ## Example Usage

        ```python
        import pulumi
        import pulumi_volcengine as volcengine

        foo_zones = volcengine.ecs.zones()
        foo_vpc = volcengine.vpc.Vpc("fooVpc",
            vpc_name="acc-test-vpc",
            cidr_block="172.16.0.0/16")
        foo_subnet = volcengine.vpc.Subnet("fooSubnet",
            subnet_name="acc-test-subnet",
            cidr_block="172.16.0.0/24",
            zone_id=foo_zones.zones[0].id,
            vpc_id=foo_vpc.id)
        foo_scaling_group = volcengine.autoscaling.ScalingGroup("fooScalingGroup",
            scaling_group_name="acc-test-scaling-group",
            subnet_ids=[foo_subnet.id],
            multi_az_policy="BALANCE",
            desire_instance_number=0,
            min_instance_number=0,
            max_instance_number=1,
            instance_terminate_policy="OldestInstance",
            default_cooldown=10)
        foo_scaling_policy = volcengine.autoscaling.ScalingPolicy("fooScalingPolicy",
            active=False,
            scaling_group_id=foo_scaling_group.id,
            scaling_policy_name="acc-tf-sg-policy-test",
            scaling_policy_type="Alarm",
            adjustment_type="QuantityChangeInCapacity",
            adjustment_value=100,
            cooldown=10,
            alarm_policy_rule_type="Static",
            alarm_policy_evaluation_count=1,
            alarm_policy_condition_metric_name="Instance_CpuBusy_Avg",
            alarm_policy_condition_metric_unit="Percent",
            alarm_policy_condition_comparison_operator="=",
            alarm_policy_condition_threshold="100")
        ```

        ## Import

        ScalingPolicy can be imported using the ScalingGroupId:ScalingPolicyId, e.g.

        ```sh
         $ pulumi import volcengine:autoscaling/scalingPolicy:ScalingPolicy default scg-yblfbfhy7agh9zn72iaz:sp-yblf9l4fvcl8j1prohsp
        ```

        :param str resource_name: The name of the resource.
        :param ScalingPolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ScalingPolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 active: Optional[pulumi.Input[bool]] = None,
                 adjustment_type: Optional[pulumi.Input[str]] = None,
                 adjustment_value: Optional[pulumi.Input[int]] = None,
                 alarm_policy_condition_comparison_operator: Optional[pulumi.Input[str]] = None,
                 alarm_policy_condition_metric_name: Optional[pulumi.Input[str]] = None,
                 alarm_policy_condition_metric_unit: Optional[pulumi.Input[str]] = None,
                 alarm_policy_condition_threshold: Optional[pulumi.Input[str]] = None,
                 alarm_policy_evaluation_count: Optional[pulumi.Input[int]] = None,
                 alarm_policy_rule_type: Optional[pulumi.Input[str]] = None,
                 cooldown: Optional[pulumi.Input[int]] = None,
                 scaling_group_id: Optional[pulumi.Input[str]] = None,
                 scaling_policy_name: Optional[pulumi.Input[str]] = None,
                 scaling_policy_type: Optional[pulumi.Input[str]] = None,
                 scheduled_policy_launch_time: Optional[pulumi.Input[str]] = None,
                 scheduled_policy_recurrence_end_time: Optional[pulumi.Input[str]] = None,
                 scheduled_policy_recurrence_type: Optional[pulumi.Input[str]] = None,
                 scheduled_policy_recurrence_value: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ScalingPolicyArgs.__new__(ScalingPolicyArgs)

            __props__.__dict__["active"] = active
            if adjustment_type is None and not opts.urn:
                raise TypeError("Missing required property 'adjustment_type'")
            __props__.__dict__["adjustment_type"] = adjustment_type
            if adjustment_value is None and not opts.urn:
                raise TypeError("Missing required property 'adjustment_value'")
            __props__.__dict__["adjustment_value"] = adjustment_value
            __props__.__dict__["alarm_policy_condition_comparison_operator"] = alarm_policy_condition_comparison_operator
            __props__.__dict__["alarm_policy_condition_metric_name"] = alarm_policy_condition_metric_name
            __props__.__dict__["alarm_policy_condition_metric_unit"] = alarm_policy_condition_metric_unit
            __props__.__dict__["alarm_policy_condition_threshold"] = alarm_policy_condition_threshold
            __props__.__dict__["alarm_policy_evaluation_count"] = alarm_policy_evaluation_count
            __props__.__dict__["alarm_policy_rule_type"] = alarm_policy_rule_type
            __props__.__dict__["cooldown"] = cooldown
            if scaling_group_id is None and not opts.urn:
                raise TypeError("Missing required property 'scaling_group_id'")
            __props__.__dict__["scaling_group_id"] = scaling_group_id
            if scaling_policy_name is None and not opts.urn:
                raise TypeError("Missing required property 'scaling_policy_name'")
            __props__.__dict__["scaling_policy_name"] = scaling_policy_name
            if scaling_policy_type is None and not opts.urn:
                raise TypeError("Missing required property 'scaling_policy_type'")
            __props__.__dict__["scaling_policy_type"] = scaling_policy_type
            __props__.__dict__["scheduled_policy_launch_time"] = scheduled_policy_launch_time
            __props__.__dict__["scheduled_policy_recurrence_end_time"] = scheduled_policy_recurrence_end_time
            __props__.__dict__["scheduled_policy_recurrence_type"] = scheduled_policy_recurrence_type
            __props__.__dict__["scheduled_policy_recurrence_value"] = scheduled_policy_recurrence_value
            __props__.__dict__["scaling_policy_id"] = None
            __props__.__dict__["status"] = None
        super(ScalingPolicy, __self__).__init__(
            'volcengine:autoscaling/scalingPolicy:ScalingPolicy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            active: Optional[pulumi.Input[bool]] = None,
            adjustment_type: Optional[pulumi.Input[str]] = None,
            adjustment_value: Optional[pulumi.Input[int]] = None,
            alarm_policy_condition_comparison_operator: Optional[pulumi.Input[str]] = None,
            alarm_policy_condition_metric_name: Optional[pulumi.Input[str]] = None,
            alarm_policy_condition_metric_unit: Optional[pulumi.Input[str]] = None,
            alarm_policy_condition_threshold: Optional[pulumi.Input[str]] = None,
            alarm_policy_evaluation_count: Optional[pulumi.Input[int]] = None,
            alarm_policy_rule_type: Optional[pulumi.Input[str]] = None,
            cooldown: Optional[pulumi.Input[int]] = None,
            scaling_group_id: Optional[pulumi.Input[str]] = None,
            scaling_policy_id: Optional[pulumi.Input[str]] = None,
            scaling_policy_name: Optional[pulumi.Input[str]] = None,
            scaling_policy_type: Optional[pulumi.Input[str]] = None,
            scheduled_policy_launch_time: Optional[pulumi.Input[str]] = None,
            scheduled_policy_recurrence_end_time: Optional[pulumi.Input[str]] = None,
            scheduled_policy_recurrence_type: Optional[pulumi.Input[str]] = None,
            scheduled_policy_recurrence_value: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None) -> 'ScalingPolicy':
        """
        Get an existing ScalingPolicy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] active: The active flag of the scaling policy. [Warning] the scaling policy can be active only when the scaling group be active otherwise will fail.
        :param pulumi.Input[str] adjustment_type: The adjustment type of the scaling policy. Valid values: QuantityChangeInCapacity, PercentChangeInCapacity, TotalCapacity.
        :param pulumi.Input[int] adjustment_value: The adjustment value of the scaling policy. When the value of the `AdjustmentType` parameter is `QuantityChangeInCapacity`: -100 ~ 100, 0 is not allowed, unit: piece. When the value of the `AdjustmentType` parameter is `PercentChangeInCapacity`: -100 ~ 10000, 0 is not allowed, unit: %. When the value of the `AdjustmentType` parameter is `TotalCapacity`: the default is 0 to 100, unit: piece.
        :param pulumi.Input[str] alarm_policy_condition_comparison_operator: The comparison operator of the alarm policy condition of the scaling policy. Valid values: `>`, `<`, `=`. It is only valid and required when the value of `ScalingPolicyType` is `Alarm`.
        :param pulumi.Input[str] alarm_policy_condition_metric_name: The metric name of the alarm policy condition of the scaling policy. Valid values: CpuTotal_Max, CpuTotal_Min, CpuTotal_Avg, MemoryUsedUtilization_Max, MemoryUsedUtilization_Min, MemoryUsedUtilization_Avg, Instance_CpuBusy_Max, Instance_CpuBusy_Min, Instance_CpuBusy_Avg.
        :param pulumi.Input[str] alarm_policy_condition_metric_unit: The comparison operator of the alarm policy condition of the scaling policy. It is only valid and required when the value of `ScalingPolicyType` is `Alarm`.
        :param pulumi.Input[str] alarm_policy_condition_threshold: The threshold of the alarm policy condition of the scaling policy. It is only valid and required when the value of `ScalingPolicyType` is `Alarm`.
        :param pulumi.Input[int] alarm_policy_evaluation_count: The evaluation count of the alarm policy of the scaling policy. It is only valid and required when the value of `ScalingPolicyType` is `Alarm`.
        :param pulumi.Input[str] alarm_policy_rule_type: The rule type of the alarm policy of the scaling policy. Valid value: Static. It is only valid and required when the value of `ScalingPolicyType` is `Alarm`.
        :param pulumi.Input[int] cooldown: The cooldown of the scaling policy. Default value is the cooldown time of the scaling group. Value: 0~86400, unit: second, if left blank, the cooling time of the scaling group will be used by default.
        :param pulumi.Input[str] scaling_group_id: The id of the scaling group to which the scaling policy belongs.
        :param pulumi.Input[str] scaling_policy_id: The id of the scaling policy.
        :param pulumi.Input[str] scaling_policy_name: The name of the scaling policy.
        :param pulumi.Input[str] scaling_policy_type: The type of scaling policy. Valid values: Scheduled, Recurrence, Alarm.
        :param pulumi.Input[str] scheduled_policy_launch_time: The launch time of the scheduled policy of the scaling policy.
               When the value of `ScalingPolicyType` is `Scheduled`, it means that the trigger time of the scheduled task must be greater than the current time.
               When the value of `ScalingPolicyType` is `Recurrence`: If `ScheduledPolicy.RecurrenceType` is not specified, it means to execute only once according to the date and time specified here.
               If `ScheduledPolicy.RecurrenceType` is specified, it indicates the start time of the periodic task. Only the time within 90 days from the date of creation/modification is supported.
               When the value of `ScalingPolicyType` is `Alarm`, this parameter is invalid.
        :param pulumi.Input[str] scheduled_policy_recurrence_end_time: The recurrence end time of the scheduled policy of the scaling policy. Valid and required when `ScalingPolicyType` is `Recurrence`. If not configured, it will default to the day/week/month after this moment according to the recurrence period (ScheduledPolicy.RecurrenceType).
        :param pulumi.Input[str] scheduled_policy_recurrence_type: The recurrence type the scheduled policy of the scaling policy. Valid values: Daily, Weekly, Monthly, Cron.
        :param pulumi.Input[str] scheduled_policy_recurrence_value: The recurrence value the scheduled policy of the scaling policy. Valid and required when `ScalingPolicyType` is `Recurrence`. When the value of the ScheduledPolicy.RecurrenceType parameter is Daily, only one value can be filled in, ranging from 1 to 31.
               When the value of the ScheduledPolicy.RecurrenceType parameter is Weekly, you can enter multiple values separated by commas (,). The values from Monday to Sunday are: 1,2,3,4,5,6,7.
               When the value of the ScheduledPolicy.RecurrenceType parameter is Monthly, the format is A-B. The value ranges of A and B are both 1~31, and B must be greater than or equal to A.
               When the value of the ScheduledPolicy.RecurrenceType parameter is Cron, it means UTC+8 time, supports 5-field expressions of minutes, hours, days, months, and weeks, and supports wildcard English commas (,), English question marks (?), and conjunctions ( -), asterisk (*), pound sign (#), slash (/), L, and W.
        :param pulumi.Input[str] status: The status of the scaling policy. Valid values: Active, InActive.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ScalingPolicyState.__new__(_ScalingPolicyState)

        __props__.__dict__["active"] = active
        __props__.__dict__["adjustment_type"] = adjustment_type
        __props__.__dict__["adjustment_value"] = adjustment_value
        __props__.__dict__["alarm_policy_condition_comparison_operator"] = alarm_policy_condition_comparison_operator
        __props__.__dict__["alarm_policy_condition_metric_name"] = alarm_policy_condition_metric_name
        __props__.__dict__["alarm_policy_condition_metric_unit"] = alarm_policy_condition_metric_unit
        __props__.__dict__["alarm_policy_condition_threshold"] = alarm_policy_condition_threshold
        __props__.__dict__["alarm_policy_evaluation_count"] = alarm_policy_evaluation_count
        __props__.__dict__["alarm_policy_rule_type"] = alarm_policy_rule_type
        __props__.__dict__["cooldown"] = cooldown
        __props__.__dict__["scaling_group_id"] = scaling_group_id
        __props__.__dict__["scaling_policy_id"] = scaling_policy_id
        __props__.__dict__["scaling_policy_name"] = scaling_policy_name
        __props__.__dict__["scaling_policy_type"] = scaling_policy_type
        __props__.__dict__["scheduled_policy_launch_time"] = scheduled_policy_launch_time
        __props__.__dict__["scheduled_policy_recurrence_end_time"] = scheduled_policy_recurrence_end_time
        __props__.__dict__["scheduled_policy_recurrence_type"] = scheduled_policy_recurrence_type
        __props__.__dict__["scheduled_policy_recurrence_value"] = scheduled_policy_recurrence_value
        __props__.__dict__["status"] = status
        return ScalingPolicy(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def active(self) -> pulumi.Output[bool]:
        """
        The active flag of the scaling policy. [Warning] the scaling policy can be active only when the scaling group be active otherwise will fail.
        """
        return pulumi.get(self, "active")

    @property
    @pulumi.getter(name="adjustmentType")
    def adjustment_type(self) -> pulumi.Output[str]:
        """
        The adjustment type of the scaling policy. Valid values: QuantityChangeInCapacity, PercentChangeInCapacity, TotalCapacity.
        """
        return pulumi.get(self, "adjustment_type")

    @property
    @pulumi.getter(name="adjustmentValue")
    def adjustment_value(self) -> pulumi.Output[int]:
        """
        The adjustment value of the scaling policy. When the value of the `AdjustmentType` parameter is `QuantityChangeInCapacity`: -100 ~ 100, 0 is not allowed, unit: piece. When the value of the `AdjustmentType` parameter is `PercentChangeInCapacity`: -100 ~ 10000, 0 is not allowed, unit: %. When the value of the `AdjustmentType` parameter is `TotalCapacity`: the default is 0 to 100, unit: piece.
        """
        return pulumi.get(self, "adjustment_value")

    @property
    @pulumi.getter(name="alarmPolicyConditionComparisonOperator")
    def alarm_policy_condition_comparison_operator(self) -> pulumi.Output[Optional[str]]:
        """
        The comparison operator of the alarm policy condition of the scaling policy. Valid values: `>`, `<`, `=`. It is only valid and required when the value of `ScalingPolicyType` is `Alarm`.
        """
        return pulumi.get(self, "alarm_policy_condition_comparison_operator")

    @property
    @pulumi.getter(name="alarmPolicyConditionMetricName")
    def alarm_policy_condition_metric_name(self) -> pulumi.Output[Optional[str]]:
        """
        The metric name of the alarm policy condition of the scaling policy. Valid values: CpuTotal_Max, CpuTotal_Min, CpuTotal_Avg, MemoryUsedUtilization_Max, MemoryUsedUtilization_Min, MemoryUsedUtilization_Avg, Instance_CpuBusy_Max, Instance_CpuBusy_Min, Instance_CpuBusy_Avg.
        """
        return pulumi.get(self, "alarm_policy_condition_metric_name")

    @property
    @pulumi.getter(name="alarmPolicyConditionMetricUnit")
    def alarm_policy_condition_metric_unit(self) -> pulumi.Output[Optional[str]]:
        """
        The comparison operator of the alarm policy condition of the scaling policy. It is only valid and required when the value of `ScalingPolicyType` is `Alarm`.
        """
        return pulumi.get(self, "alarm_policy_condition_metric_unit")

    @property
    @pulumi.getter(name="alarmPolicyConditionThreshold")
    def alarm_policy_condition_threshold(self) -> pulumi.Output[Optional[str]]:
        """
        The threshold of the alarm policy condition of the scaling policy. It is only valid and required when the value of `ScalingPolicyType` is `Alarm`.
        """
        return pulumi.get(self, "alarm_policy_condition_threshold")

    @property
    @pulumi.getter(name="alarmPolicyEvaluationCount")
    def alarm_policy_evaluation_count(self) -> pulumi.Output[Optional[int]]:
        """
        The evaluation count of the alarm policy of the scaling policy. It is only valid and required when the value of `ScalingPolicyType` is `Alarm`.
        """
        return pulumi.get(self, "alarm_policy_evaluation_count")

    @property
    @pulumi.getter(name="alarmPolicyRuleType")
    def alarm_policy_rule_type(self) -> pulumi.Output[Optional[str]]:
        """
        The rule type of the alarm policy of the scaling policy. Valid value: Static. It is only valid and required when the value of `ScalingPolicyType` is `Alarm`.
        """
        return pulumi.get(self, "alarm_policy_rule_type")

    @property
    @pulumi.getter
    def cooldown(self) -> pulumi.Output[int]:
        """
        The cooldown of the scaling policy. Default value is the cooldown time of the scaling group. Value: 0~86400, unit: second, if left blank, the cooling time of the scaling group will be used by default.
        """
        return pulumi.get(self, "cooldown")

    @property
    @pulumi.getter(name="scalingGroupId")
    def scaling_group_id(self) -> pulumi.Output[str]:
        """
        The id of the scaling group to which the scaling policy belongs.
        """
        return pulumi.get(self, "scaling_group_id")

    @property
    @pulumi.getter(name="scalingPolicyId")
    def scaling_policy_id(self) -> pulumi.Output[str]:
        """
        The id of the scaling policy.
        """
        return pulumi.get(self, "scaling_policy_id")

    @property
    @pulumi.getter(name="scalingPolicyName")
    def scaling_policy_name(self) -> pulumi.Output[str]:
        """
        The name of the scaling policy.
        """
        return pulumi.get(self, "scaling_policy_name")

    @property
    @pulumi.getter(name="scalingPolicyType")
    def scaling_policy_type(self) -> pulumi.Output[str]:
        """
        The type of scaling policy. Valid values: Scheduled, Recurrence, Alarm.
        """
        return pulumi.get(self, "scaling_policy_type")

    @property
    @pulumi.getter(name="scheduledPolicyLaunchTime")
    def scheduled_policy_launch_time(self) -> pulumi.Output[str]:
        """
        The launch time of the scheduled policy of the scaling policy.
        When the value of `ScalingPolicyType` is `Scheduled`, it means that the trigger time of the scheduled task must be greater than the current time.
        When the value of `ScalingPolicyType` is `Recurrence`: If `ScheduledPolicy.RecurrenceType` is not specified, it means to execute only once according to the date and time specified here.
        If `ScheduledPolicy.RecurrenceType` is specified, it indicates the start time of the periodic task. Only the time within 90 days from the date of creation/modification is supported.
        When the value of `ScalingPolicyType` is `Alarm`, this parameter is invalid.
        """
        return pulumi.get(self, "scheduled_policy_launch_time")

    @property
    @pulumi.getter(name="scheduledPolicyRecurrenceEndTime")
    def scheduled_policy_recurrence_end_time(self) -> pulumi.Output[Optional[str]]:
        """
        The recurrence end time of the scheduled policy of the scaling policy. Valid and required when `ScalingPolicyType` is `Recurrence`. If not configured, it will default to the day/week/month after this moment according to the recurrence period (ScheduledPolicy.RecurrenceType).
        """
        return pulumi.get(self, "scheduled_policy_recurrence_end_time")

    @property
    @pulumi.getter(name="scheduledPolicyRecurrenceType")
    def scheduled_policy_recurrence_type(self) -> pulumi.Output[Optional[str]]:
        """
        The recurrence type the scheduled policy of the scaling policy. Valid values: Daily, Weekly, Monthly, Cron.
        """
        return pulumi.get(self, "scheduled_policy_recurrence_type")

    @property
    @pulumi.getter(name="scheduledPolicyRecurrenceValue")
    def scheduled_policy_recurrence_value(self) -> pulumi.Output[Optional[str]]:
        """
        The recurrence value the scheduled policy of the scaling policy. Valid and required when `ScalingPolicyType` is `Recurrence`. When the value of the ScheduledPolicy.RecurrenceType parameter is Daily, only one value can be filled in, ranging from 1 to 31.
        When the value of the ScheduledPolicy.RecurrenceType parameter is Weekly, you can enter multiple values separated by commas (,). The values from Monday to Sunday are: 1,2,3,4,5,6,7.
        When the value of the ScheduledPolicy.RecurrenceType parameter is Monthly, the format is A-B. The value ranges of A and B are both 1~31, and B must be greater than or equal to A.
        When the value of the ScheduledPolicy.RecurrenceType parameter is Cron, it means UTC+8 time, supports 5-field expressions of minutes, hours, days, months, and weeks, and supports wildcard English commas (,), English question marks (?), and conjunctions ( -), asterisk (*), pound sign (#), slash (/), L, and W.
        """
        return pulumi.get(self, "scheduled_policy_recurrence_value")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        The status of the scaling policy. Valid values: Active, InActive.
        """
        return pulumi.get(self, "status")

