# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'BandwidthPackagesResult',
    'AwaitableBandwidthPackagesResult',
    'bandwidth_packages',
    'bandwidth_packages_output',
]

@pulumi.output_type
class BandwidthPackagesResult:
    """
    A collection of values returned by BandwidthPackages.
    """
    def __init__(__self__, bandwidth_package_name=None, id=None, ids=None, isp=None, name_regex=None, output_file=None, packages=None, project_name=None, protocol=None, security_protection_enabled=None, tag_filters=None, total_count=None):
        if bandwidth_package_name and not isinstance(bandwidth_package_name, str):
            raise TypeError("Expected argument 'bandwidth_package_name' to be a str")
        pulumi.set(__self__, "bandwidth_package_name", bandwidth_package_name)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if isp and not isinstance(isp, str):
            raise TypeError("Expected argument 'isp' to be a str")
        pulumi.set(__self__, "isp", isp)
        if name_regex and not isinstance(name_regex, str):
            raise TypeError("Expected argument 'name_regex' to be a str")
        pulumi.set(__self__, "name_regex", name_regex)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if packages and not isinstance(packages, list):
            raise TypeError("Expected argument 'packages' to be a list")
        pulumi.set(__self__, "packages", packages)
        if project_name and not isinstance(project_name, str):
            raise TypeError("Expected argument 'project_name' to be a str")
        pulumi.set(__self__, "project_name", project_name)
        if protocol and not isinstance(protocol, str):
            raise TypeError("Expected argument 'protocol' to be a str")
        pulumi.set(__self__, "protocol", protocol)
        if security_protection_enabled and not isinstance(security_protection_enabled, bool):
            raise TypeError("Expected argument 'security_protection_enabled' to be a bool")
        pulumi.set(__self__, "security_protection_enabled", security_protection_enabled)
        if tag_filters and not isinstance(tag_filters, list):
            raise TypeError("Expected argument 'tag_filters' to be a list")
        pulumi.set(__self__, "tag_filters", tag_filters)
        if total_count and not isinstance(total_count, int):
            raise TypeError("Expected argument 'total_count' to be a int")
        pulumi.set(__self__, "total_count", total_count)

    @property
    @pulumi.getter(name="bandwidthPackageName")
    def bandwidth_package_name(self) -> Optional[str]:
        """
        The name of the bandwidth package.
        """
        return pulumi.get(self, "bandwidth_package_name")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def ids(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "ids")

    @property
    @pulumi.getter
    def isp(self) -> Optional[str]:
        """
        The line type.
        """
        return pulumi.get(self, "isp")

    @property
    @pulumi.getter(name="nameRegex")
    def name_regex(self) -> Optional[str]:
        return pulumi.get(self, "name_regex")

    @property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[str]:
        return pulumi.get(self, "output_file")

    @property
    @pulumi.getter
    def packages(self) -> Sequence['outputs.BandwidthPackagesPackageResult']:
        """
        The collection of query.
        """
        return pulumi.get(self, "packages")

    @property
    @pulumi.getter(name="projectName")
    def project_name(self) -> Optional[str]:
        """
        The project name of the bandwidth package.
        """
        return pulumi.get(self, "project_name")

    @property
    @pulumi.getter
    def protocol(self) -> Optional[str]:
        """
        The protocol of the bandwidth package.
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="securityProtectionEnabled")
    def security_protection_enabled(self) -> Optional[bool]:
        return pulumi.get(self, "security_protection_enabled")

    @property
    @pulumi.getter(name="tagFilters")
    def tag_filters(self) -> Optional[Sequence['outputs.BandwidthPackagesTagFilterResult']]:
        return pulumi.get(self, "tag_filters")

    @property
    @pulumi.getter(name="totalCount")
    def total_count(self) -> int:
        """
        The total count of query.
        """
        return pulumi.get(self, "total_count")


class AwaitableBandwidthPackagesResult(BandwidthPackagesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return BandwidthPackagesResult(
            bandwidth_package_name=self.bandwidth_package_name,
            id=self.id,
            ids=self.ids,
            isp=self.isp,
            name_regex=self.name_regex,
            output_file=self.output_file,
            packages=self.packages,
            project_name=self.project_name,
            protocol=self.protocol,
            security_protection_enabled=self.security_protection_enabled,
            tag_filters=self.tag_filters,
            total_count=self.total_count)


def bandwidth_packages(bandwidth_package_name: Optional[str] = None,
                       ids: Optional[Sequence[str]] = None,
                       isp: Optional[str] = None,
                       name_regex: Optional[str] = None,
                       output_file: Optional[str] = None,
                       project_name: Optional[str] = None,
                       protocol: Optional[str] = None,
                       security_protection_enabled: Optional[bool] = None,
                       tag_filters: Optional[Sequence[pulumi.InputType['BandwidthPackagesTagFilterArgs']]] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableBandwidthPackagesResult:
    """
    Use this data source to query detailed information of bandwidth packages
    ## Example Usage

    ```python
    import pulumi
    import pulumi_volcengine as volcengine

    foo = volcengine.bandwidth_package.bandwidth_packages(ids=["bwp-rr0eev56j7y8v0x58ggbclr"])
    ```


    :param str bandwidth_package_name: Shared bandwidth package name to be queried.
    :param Sequence[str] ids: Shared bandwidth package instance ID to be queried.
    :param str isp: Line types for shared bandwidth packages.
    :param str name_regex: A Name Regex of Resource.
    :param str output_file: File name where to save data source results.
    :param str project_name: The project name of the bandwidth package to be queried.
    :param str protocol: The IP protocol values for shared bandwidth packages are as follows: `IPv4`: IPv4 protocol. `IPv6`: IPv6 protocol.
    :param bool security_protection_enabled: Security protection types for shared bandwidth packages.
    :param Sequence[pulumi.InputType['BandwidthPackagesTagFilterArgs']] tag_filters: A list of tags.
    """
    __args__ = dict()
    __args__['bandwidthPackageName'] = bandwidth_package_name
    __args__['ids'] = ids
    __args__['isp'] = isp
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    __args__['projectName'] = project_name
    __args__['protocol'] = protocol
    __args__['securityProtectionEnabled'] = security_protection_enabled
    __args__['tagFilters'] = tag_filters
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('volcengine:bandwidth_package/bandwidthPackages:BandwidthPackages', __args__, opts=opts, typ=BandwidthPackagesResult).value

    return AwaitableBandwidthPackagesResult(
        bandwidth_package_name=pulumi.get(__ret__, 'bandwidth_package_name'),
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        isp=pulumi.get(__ret__, 'isp'),
        name_regex=pulumi.get(__ret__, 'name_regex'),
        output_file=pulumi.get(__ret__, 'output_file'),
        packages=pulumi.get(__ret__, 'packages'),
        project_name=pulumi.get(__ret__, 'project_name'),
        protocol=pulumi.get(__ret__, 'protocol'),
        security_protection_enabled=pulumi.get(__ret__, 'security_protection_enabled'),
        tag_filters=pulumi.get(__ret__, 'tag_filters'),
        total_count=pulumi.get(__ret__, 'total_count'))


@_utilities.lift_output_func(bandwidth_packages)
def bandwidth_packages_output(bandwidth_package_name: Optional[pulumi.Input[Optional[str]]] = None,
                              ids: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                              isp: Optional[pulumi.Input[Optional[str]]] = None,
                              name_regex: Optional[pulumi.Input[Optional[str]]] = None,
                              output_file: Optional[pulumi.Input[Optional[str]]] = None,
                              project_name: Optional[pulumi.Input[Optional[str]]] = None,
                              protocol: Optional[pulumi.Input[Optional[str]]] = None,
                              security_protection_enabled: Optional[pulumi.Input[Optional[bool]]] = None,
                              tag_filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['BandwidthPackagesTagFilterArgs']]]]] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[BandwidthPackagesResult]:
    """
    Use this data source to query detailed information of bandwidth packages
    ## Example Usage

    ```python
    import pulumi
    import pulumi_volcengine as volcengine

    foo = volcengine.bandwidth_package.bandwidth_packages(ids=["bwp-rr0eev56j7y8v0x58ggbclr"])
    ```


    :param str bandwidth_package_name: Shared bandwidth package name to be queried.
    :param Sequence[str] ids: Shared bandwidth package instance ID to be queried.
    :param str isp: Line types for shared bandwidth packages.
    :param str name_regex: A Name Regex of Resource.
    :param str output_file: File name where to save data source results.
    :param str project_name: The project name of the bandwidth package to be queried.
    :param str protocol: The IP protocol values for shared bandwidth packages are as follows: `IPv4`: IPv4 protocol. `IPv6`: IPv6 protocol.
    :param bool security_protection_enabled: Security protection types for shared bandwidth packages.
    :param Sequence[pulumi.InputType['BandwidthPackagesTagFilterArgs']] tag_filters: A list of tags.
    """
    ...
