# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['ClusterBindArgs', 'ClusterBind']

@pulumi.input_type
class ClusterBindArgs:
    def __init__(__self__, *,
                 cluster_id: pulumi.Input[str],
                 type: pulumi.Input[str],
                 workspace_id: pulumi.Input[str]):
        """
        The set of arguments for constructing a ClusterBind resource.
        :param pulumi.Input[str] cluster_id: The id of the cluster.
        :param pulumi.Input[str] type: The type of the cluster bind.
        :param pulumi.Input[str] workspace_id: The id of the workspace.
        """
        pulumi.set(__self__, "cluster_id", cluster_id)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "workspace_id", workspace_id)

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> pulumi.Input[str]:
        """
        The id of the cluster.
        """
        return pulumi.get(self, "cluster_id")

    @cluster_id.setter
    def cluster_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "cluster_id", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        The type of the cluster bind.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> pulumi.Input[str]:
        """
        The id of the workspace.
        """
        return pulumi.get(self, "workspace_id")

    @workspace_id.setter
    def workspace_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "workspace_id", value)


@pulumi.input_type
class _ClusterBindState:
    def __init__(__self__, *,
                 cluster_id: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 workspace_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering ClusterBind resources.
        :param pulumi.Input[str] cluster_id: The id of the cluster.
        :param pulumi.Input[str] type: The type of the cluster bind.
        :param pulumi.Input[str] workspace_id: The id of the workspace.
        """
        if cluster_id is not None:
            pulumi.set(__self__, "cluster_id", cluster_id)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if workspace_id is not None:
            pulumi.set(__self__, "workspace_id", workspace_id)

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> Optional[pulumi.Input[str]]:
        """
        The id of the cluster.
        """
        return pulumi.get(self, "cluster_id")

    @cluster_id.setter
    def cluster_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_id", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of the cluster bind.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> Optional[pulumi.Input[str]]:
        """
        The id of the workspace.
        """
        return pulumi.get(self, "workspace_id")

    @workspace_id.setter
    def workspace_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "workspace_id", value)


class ClusterBind(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cluster_id: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 workspace_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a resource to manage bioos cluster bind
        ## Example Usage

        ```python
        import pulumi
        import pulumi_volcengine as volcengine

        example = volcengine.bioos.ClusterBind("example",
            cluster_id="ucfhp1nteig48u8ufv8s0",
            type="workflow",
            workspace_id="wcfhp1vdeig48u8ufv8sg")
        #必填
        ```

        ## Import

        Cluster binder can be imported using the workspace id and cluster id, e.g.

        ```sh
         $ pulumi import volcengine:bioos/clusterBind:ClusterBind default wc*****:uc***
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] cluster_id: The id of the cluster.
        :param pulumi.Input[str] type: The type of the cluster bind.
        :param pulumi.Input[str] workspace_id: The id of the workspace.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ClusterBindArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a resource to manage bioos cluster bind
        ## Example Usage

        ```python
        import pulumi
        import pulumi_volcengine as volcengine

        example = volcengine.bioos.ClusterBind("example",
            cluster_id="ucfhp1nteig48u8ufv8s0",
            type="workflow",
            workspace_id="wcfhp1vdeig48u8ufv8sg")
        #必填
        ```

        ## Import

        Cluster binder can be imported using the workspace id and cluster id, e.g.

        ```sh
         $ pulumi import volcengine:bioos/clusterBind:ClusterBind default wc*****:uc***
        ```

        :param str resource_name: The name of the resource.
        :param ClusterBindArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ClusterBindArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cluster_id: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 workspace_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ClusterBindArgs.__new__(ClusterBindArgs)

            if cluster_id is None and not opts.urn:
                raise TypeError("Missing required property 'cluster_id'")
            __props__.__dict__["cluster_id"] = cluster_id
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            if workspace_id is None and not opts.urn:
                raise TypeError("Missing required property 'workspace_id'")
            __props__.__dict__["workspace_id"] = workspace_id
        super(ClusterBind, __self__).__init__(
            'volcengine:bioos/clusterBind:ClusterBind',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cluster_id: Optional[pulumi.Input[str]] = None,
            type: Optional[pulumi.Input[str]] = None,
            workspace_id: Optional[pulumi.Input[str]] = None) -> 'ClusterBind':
        """
        Get an existing ClusterBind resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] cluster_id: The id of the cluster.
        :param pulumi.Input[str] type: The type of the cluster bind.
        :param pulumi.Input[str] workspace_id: The id of the workspace.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ClusterBindState.__new__(_ClusterBindState)

        __props__.__dict__["cluster_id"] = cluster_id
        __props__.__dict__["type"] = type
        __props__.__dict__["workspace_id"] = workspace_id
        return ClusterBind(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> pulumi.Output[str]:
        """
        The id of the cluster.
        """
        return pulumi.get(self, "cluster_id")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        The type of the cluster bind.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> pulumi.Output[str]:
        """
        The id of the workspace.
        """
        return pulumi.get(self, "workspace_id")

