# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'ClustersResult',
    'AwaitableClustersResult',
    'clusters',
    'clusters_output',
]

@pulumi.output_type
class ClustersResult:
    """
    A collection of values returned by Clusters.
    """
    def __init__(__self__, id=None, ids=None, items=None, output_file=None, public=None, statuses=None, total_count=None, types=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if items and not isinstance(items, list):
            raise TypeError("Expected argument 'items' to be a list")
        pulumi.set(__self__, "items", items)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if public and not isinstance(public, bool):
            raise TypeError("Expected argument 'public' to be a bool")
        pulumi.set(__self__, "public", public)
        if statuses and not isinstance(statuses, list):
            raise TypeError("Expected argument 'statuses' to be a list")
        pulumi.set(__self__, "statuses", statuses)
        if total_count and not isinstance(total_count, int):
            raise TypeError("Expected argument 'total_count' to be a int")
        pulumi.set(__self__, "total_count", total_count)
        if types and not isinstance(types, list):
            raise TypeError("Expected argument 'types' to be a list")
        pulumi.set(__self__, "types", types)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def ids(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "ids")

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.ClustersItemResult']:
        """
        The list of clusters.
        """
        return pulumi.get(self, "items")

    @property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[str]:
        return pulumi.get(self, "output_file")

    @property
    @pulumi.getter
    def public(self) -> Optional[bool]:
        """
        whether it is a public cluster.
        """
        return pulumi.get(self, "public")

    @property
    @pulumi.getter
    def statuses(self) -> Optional[Sequence[str]]:
        """
        The status of the cluster.
        """
        return pulumi.get(self, "statuses")

    @property
    @pulumi.getter(name="totalCount")
    def total_count(self) -> int:
        """
        The total count of Cluster query.
        """
        return pulumi.get(self, "total_count")

    @property
    @pulumi.getter
    def types(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "types")


class AwaitableClustersResult(ClustersResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return ClustersResult(
            id=self.id,
            ids=self.ids,
            items=self.items,
            output_file=self.output_file,
            public=self.public,
            statuses=self.statuses,
            total_count=self.total_count,
            types=self.types)


def clusters(ids: Optional[Sequence[str]] = None,
             output_file: Optional[str] = None,
             public: Optional[bool] = None,
             statuses: Optional[Sequence[str]] = None,
             types: Optional[Sequence[str]] = None,
             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableClustersResult:
    """
    Use this data source to query detailed information of bioos clusters
    ## Example Usage

    ```python
    import pulumi
    import pulumi_volcengine as volcengine

    default = volcengine.bioos.clusters()
    ```


    :param Sequence[str] ids: A list of cluster ids.
    :param str output_file: File name where to save data source results.
    :param bool public: whether it is a public cluster.
    :param Sequence[str] statuses: The status of the clusters.
    :param Sequence[str] types: The type of the clusters.
    """
    __args__ = dict()
    __args__['ids'] = ids
    __args__['outputFile'] = output_file
    __args__['public'] = public
    __args__['statuses'] = statuses
    __args__['types'] = types
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('volcengine:bioos/clusters:Clusters', __args__, opts=opts, typ=ClustersResult).value

    return AwaitableClustersResult(
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        items=pulumi.get(__ret__, 'items'),
        output_file=pulumi.get(__ret__, 'output_file'),
        public=pulumi.get(__ret__, 'public'),
        statuses=pulumi.get(__ret__, 'statuses'),
        total_count=pulumi.get(__ret__, 'total_count'),
        types=pulumi.get(__ret__, 'types'))


@_utilities.lift_output_func(clusters)
def clusters_output(ids: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                    output_file: Optional[pulumi.Input[Optional[str]]] = None,
                    public: Optional[pulumi.Input[Optional[bool]]] = None,
                    statuses: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                    types: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[ClustersResult]:
    """
    Use this data source to query detailed information of bioos clusters
    ## Example Usage

    ```python
    import pulumi
    import pulumi_volcengine as volcengine

    default = volcengine.bioos.clusters()
    ```


    :param Sequence[str] ids: A list of cluster ids.
    :param str output_file: File name where to save data source results.
    :param bool public: whether it is a public cluster.
    :param Sequence[str] statuses: The status of the clusters.
    :param Sequence[str] types: The type of the clusters.
    """
    ...
