# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'WorkspacesResult',
    'AwaitableWorkspacesResult',
    'workspaces',
    'workspaces_output',
]

@pulumi.output_type
class WorkspacesResult:
    """
    A collection of values returned by Workspaces.
    """
    def __init__(__self__, id=None, ids=None, items=None, keyword=None, output_file=None, sort_by=None, sort_order=None, total_count=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if items and not isinstance(items, list):
            raise TypeError("Expected argument 'items' to be a list")
        pulumi.set(__self__, "items", items)
        if keyword and not isinstance(keyword, str):
            raise TypeError("Expected argument 'keyword' to be a str")
        pulumi.set(__self__, "keyword", keyword)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if sort_by and not isinstance(sort_by, str):
            raise TypeError("Expected argument 'sort_by' to be a str")
        pulumi.set(__self__, "sort_by", sort_by)
        if sort_order and not isinstance(sort_order, str):
            raise TypeError("Expected argument 'sort_order' to be a str")
        pulumi.set(__self__, "sort_order", sort_order)
        if total_count and not isinstance(total_count, int):
            raise TypeError("Expected argument 'total_count' to be a int")
        pulumi.set(__self__, "total_count", total_count)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def ids(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "ids")

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.WorkspacesItemResult']:
        """
        A list of workspaces.
        """
        return pulumi.get(self, "items")

    @property
    @pulumi.getter
    def keyword(self) -> Optional[str]:
        return pulumi.get(self, "keyword")

    @property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[str]:
        return pulumi.get(self, "output_file")

    @property
    @pulumi.getter(name="sortBy")
    def sort_by(self) -> Optional[str]:
        return pulumi.get(self, "sort_by")

    @property
    @pulumi.getter(name="sortOrder")
    def sort_order(self) -> Optional[str]:
        return pulumi.get(self, "sort_order")

    @property
    @pulumi.getter(name="totalCount")
    def total_count(self) -> int:
        """
        The total count of Workspace query.
        """
        return pulumi.get(self, "total_count")


class AwaitableWorkspacesResult(WorkspacesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return WorkspacesResult(
            id=self.id,
            ids=self.ids,
            items=self.items,
            keyword=self.keyword,
            output_file=self.output_file,
            sort_by=self.sort_by,
            sort_order=self.sort_order,
            total_count=self.total_count)


def workspaces(ids: Optional[Sequence[str]] = None,
               keyword: Optional[str] = None,
               output_file: Optional[str] = None,
               sort_by: Optional[str] = None,
               sort_order: Optional[str] = None,
               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableWorkspacesResult:
    """
    Use this data source to query detailed information of bioos workspaces
    ## Example Usage

    ```python
    import pulumi
    import pulumi_volcengine as volcengine

    default = volcengine.bioos.workspaces()
    ```


    :param Sequence[str] ids: A list of workspace ids.
    :param str keyword: Keyword to filter by workspace name or description.
    :param str output_file: File name where to save data source results.
    :param str sort_by: Sort Field (Name CreateTime).
    :param str sort_order: The sort order.
    """
    __args__ = dict()
    __args__['ids'] = ids
    __args__['keyword'] = keyword
    __args__['outputFile'] = output_file
    __args__['sortBy'] = sort_by
    __args__['sortOrder'] = sort_order
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('volcengine:bioos/workspaces:Workspaces', __args__, opts=opts, typ=WorkspacesResult).value

    return AwaitableWorkspacesResult(
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        items=pulumi.get(__ret__, 'items'),
        keyword=pulumi.get(__ret__, 'keyword'),
        output_file=pulumi.get(__ret__, 'output_file'),
        sort_by=pulumi.get(__ret__, 'sort_by'),
        sort_order=pulumi.get(__ret__, 'sort_order'),
        total_count=pulumi.get(__ret__, 'total_count'))


@_utilities.lift_output_func(workspaces)
def workspaces_output(ids: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                      keyword: Optional[pulumi.Input[Optional[str]]] = None,
                      output_file: Optional[pulumi.Input[Optional[str]]] = None,
                      sort_by: Optional[pulumi.Input[Optional[str]]] = None,
                      sort_order: Optional[pulumi.Input[Optional[str]]] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[WorkspacesResult]:
    """
    Use this data source to query detailed information of bioos workspaces
    ## Example Usage

    ```python
    import pulumi
    import pulumi_volcengine as volcengine

    default = volcengine.bioos.workspaces()
    ```


    :param Sequence[str] ids: A list of workspace ids.
    :param str keyword: Keyword to filter by workspace name or description.
    :param str output_file: File name where to save data source results.
    :param str sort_by: Sort Field (Name CreateTime).
    :param str sort_order: The sort order.
    """
    ...
