# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['AttachInstanceArgs', 'AttachInstance']

@pulumi.input_type
class AttachInstanceArgs:
    def __init__(__self__, *,
                 cen_id: pulumi.Input[str],
                 instance_id: pulumi.Input[str],
                 instance_region_id: pulumi.Input[str],
                 instance_type: pulumi.Input[str],
                 instance_owner_id: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a AttachInstance resource.
        :param pulumi.Input[str] cen_id: The ID of the cen.
        :param pulumi.Input[str] instance_id: The ID of the instance.
        :param pulumi.Input[str] instance_region_id: The region ID of the instance.
        :param pulumi.Input[str] instance_type: The type of the instance. Valid values: `VPC`, `DCGW`.
        :param pulumi.Input[str] instance_owner_id: The owner ID of the instance.
        """
        pulumi.set(__self__, "cen_id", cen_id)
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "instance_region_id", instance_region_id)
        pulumi.set(__self__, "instance_type", instance_type)
        if instance_owner_id is not None:
            pulumi.set(__self__, "instance_owner_id", instance_owner_id)

    @property
    @pulumi.getter(name="cenId")
    def cen_id(self) -> pulumi.Input[str]:
        """
        The ID of the cen.
        """
        return pulumi.get(self, "cen_id")

    @cen_id.setter
    def cen_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "cen_id", value)

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Input[str]:
        """
        The ID of the instance.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "instance_id", value)

    @property
    @pulumi.getter(name="instanceRegionId")
    def instance_region_id(self) -> pulumi.Input[str]:
        """
        The region ID of the instance.
        """
        return pulumi.get(self, "instance_region_id")

    @instance_region_id.setter
    def instance_region_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "instance_region_id", value)

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> pulumi.Input[str]:
        """
        The type of the instance. Valid values: `VPC`, `DCGW`.
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "instance_type", value)

    @property
    @pulumi.getter(name="instanceOwnerId")
    def instance_owner_id(self) -> Optional[pulumi.Input[str]]:
        """
        The owner ID of the instance.
        """
        return pulumi.get(self, "instance_owner_id")

    @instance_owner_id.setter
    def instance_owner_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_owner_id", value)


@pulumi.input_type
class _AttachInstanceState:
    def __init__(__self__, *,
                 cen_id: Optional[pulumi.Input[str]] = None,
                 creation_time: Optional[pulumi.Input[str]] = None,
                 instance_id: Optional[pulumi.Input[str]] = None,
                 instance_owner_id: Optional[pulumi.Input[str]] = None,
                 instance_region_id: Optional[pulumi.Input[str]] = None,
                 instance_type: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering AttachInstance resources.
        :param pulumi.Input[str] cen_id: The ID of the cen.
        :param pulumi.Input[str] creation_time: The create time of the cen attaching instance.
        :param pulumi.Input[str] instance_id: The ID of the instance.
        :param pulumi.Input[str] instance_owner_id: The owner ID of the instance.
        :param pulumi.Input[str] instance_region_id: The region ID of the instance.
        :param pulumi.Input[str] instance_type: The type of the instance. Valid values: `VPC`, `DCGW`.
        :param pulumi.Input[str] status: The status of the cen attaching instance.
        """
        if cen_id is not None:
            pulumi.set(__self__, "cen_id", cen_id)
        if creation_time is not None:
            pulumi.set(__self__, "creation_time", creation_time)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if instance_owner_id is not None:
            pulumi.set(__self__, "instance_owner_id", instance_owner_id)
        if instance_region_id is not None:
            pulumi.set(__self__, "instance_region_id", instance_region_id)
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", instance_type)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="cenId")
    def cen_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the cen.
        """
        return pulumi.get(self, "cen_id")

    @cen_id.setter
    def cen_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cen_id", value)

    @property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> Optional[pulumi.Input[str]]:
        """
        The create time of the cen attaching instance.
        """
        return pulumi.get(self, "creation_time")

    @creation_time.setter
    def creation_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "creation_time", value)

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the instance.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_id", value)

    @property
    @pulumi.getter(name="instanceOwnerId")
    def instance_owner_id(self) -> Optional[pulumi.Input[str]]:
        """
        The owner ID of the instance.
        """
        return pulumi.get(self, "instance_owner_id")

    @instance_owner_id.setter
    def instance_owner_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_owner_id", value)

    @property
    @pulumi.getter(name="instanceRegionId")
    def instance_region_id(self) -> Optional[pulumi.Input[str]]:
        """
        The region ID of the instance.
        """
        return pulumi.get(self, "instance_region_id")

    @instance_region_id.setter
    def instance_region_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_region_id", value)

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of the instance. Valid values: `VPC`, `DCGW`.
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_type", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The status of the cen attaching instance.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)


class AttachInstance(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cen_id: Optional[pulumi.Input[str]] = None,
                 instance_id: Optional[pulumi.Input[str]] = None,
                 instance_owner_id: Optional[pulumi.Input[str]] = None,
                 instance_region_id: Optional[pulumi.Input[str]] = None,
                 instance_type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a resource to manage cen attach instance
        ## Example Usage

        ```python
        import pulumi
        import pulumi_volcengine as volcengine

        foo = volcengine.cen.AttachInstance("foo",
            cen_id="cen-12ar8uclj68sg17q7y20v9gil",
            instance_id="vpc-2fe5dpn0av2m859gp68rhk2dc",
            instance_region_id="cn-beijing",
            instance_type="VPC")
        foo1 = volcengine.cen.AttachInstance("foo1",
            cen_id="cen-12ar8uclj68sg17q7y20v9gil",
            instance_id="vpc-in66ktl5t24g8gbssz0sqva1",
            instance_region_id="cn-beijing",
            instance_type="VPC")
        ```

        ## Import

        Cen attach instance can be imported using the CenId:InstanceId:InstanceType:RegionId, e.g.

        ```sh
         $ pulumi import volcengine:cen/attachInstance:AttachInstance default cen-7qthudw0ll6jmc***:vpc-2fexiqjlgjif45oxruvso****:VPC:cn-beijing
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] cen_id: The ID of the cen.
        :param pulumi.Input[str] instance_id: The ID of the instance.
        :param pulumi.Input[str] instance_owner_id: The owner ID of the instance.
        :param pulumi.Input[str] instance_region_id: The region ID of the instance.
        :param pulumi.Input[str] instance_type: The type of the instance. Valid values: `VPC`, `DCGW`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AttachInstanceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a resource to manage cen attach instance
        ## Example Usage

        ```python
        import pulumi
        import pulumi_volcengine as volcengine

        foo = volcengine.cen.AttachInstance("foo",
            cen_id="cen-12ar8uclj68sg17q7y20v9gil",
            instance_id="vpc-2fe5dpn0av2m859gp68rhk2dc",
            instance_region_id="cn-beijing",
            instance_type="VPC")
        foo1 = volcengine.cen.AttachInstance("foo1",
            cen_id="cen-12ar8uclj68sg17q7y20v9gil",
            instance_id="vpc-in66ktl5t24g8gbssz0sqva1",
            instance_region_id="cn-beijing",
            instance_type="VPC")
        ```

        ## Import

        Cen attach instance can be imported using the CenId:InstanceId:InstanceType:RegionId, e.g.

        ```sh
         $ pulumi import volcengine:cen/attachInstance:AttachInstance default cen-7qthudw0ll6jmc***:vpc-2fexiqjlgjif45oxruvso****:VPC:cn-beijing
        ```

        :param str resource_name: The name of the resource.
        :param AttachInstanceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AttachInstanceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cen_id: Optional[pulumi.Input[str]] = None,
                 instance_id: Optional[pulumi.Input[str]] = None,
                 instance_owner_id: Optional[pulumi.Input[str]] = None,
                 instance_region_id: Optional[pulumi.Input[str]] = None,
                 instance_type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AttachInstanceArgs.__new__(AttachInstanceArgs)

            if cen_id is None and not opts.urn:
                raise TypeError("Missing required property 'cen_id'")
            __props__.__dict__["cen_id"] = cen_id
            if instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'instance_id'")
            __props__.__dict__["instance_id"] = instance_id
            __props__.__dict__["instance_owner_id"] = instance_owner_id
            if instance_region_id is None and not opts.urn:
                raise TypeError("Missing required property 'instance_region_id'")
            __props__.__dict__["instance_region_id"] = instance_region_id
            if instance_type is None and not opts.urn:
                raise TypeError("Missing required property 'instance_type'")
            __props__.__dict__["instance_type"] = instance_type
            __props__.__dict__["creation_time"] = None
            __props__.__dict__["status"] = None
        super(AttachInstance, __self__).__init__(
            'volcengine:cen/attachInstance:AttachInstance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cen_id: Optional[pulumi.Input[str]] = None,
            creation_time: Optional[pulumi.Input[str]] = None,
            instance_id: Optional[pulumi.Input[str]] = None,
            instance_owner_id: Optional[pulumi.Input[str]] = None,
            instance_region_id: Optional[pulumi.Input[str]] = None,
            instance_type: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None) -> 'AttachInstance':
        """
        Get an existing AttachInstance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] cen_id: The ID of the cen.
        :param pulumi.Input[str] creation_time: The create time of the cen attaching instance.
        :param pulumi.Input[str] instance_id: The ID of the instance.
        :param pulumi.Input[str] instance_owner_id: The owner ID of the instance.
        :param pulumi.Input[str] instance_region_id: The region ID of the instance.
        :param pulumi.Input[str] instance_type: The type of the instance. Valid values: `VPC`, `DCGW`.
        :param pulumi.Input[str] status: The status of the cen attaching instance.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AttachInstanceState.__new__(_AttachInstanceState)

        __props__.__dict__["cen_id"] = cen_id
        __props__.__dict__["creation_time"] = creation_time
        __props__.__dict__["instance_id"] = instance_id
        __props__.__dict__["instance_owner_id"] = instance_owner_id
        __props__.__dict__["instance_region_id"] = instance_region_id
        __props__.__dict__["instance_type"] = instance_type
        __props__.__dict__["status"] = status
        return AttachInstance(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="cenId")
    def cen_id(self) -> pulumi.Output[str]:
        """
        The ID of the cen.
        """
        return pulumi.get(self, "cen_id")

    @property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> pulumi.Output[str]:
        """
        The create time of the cen attaching instance.
        """
        return pulumi.get(self, "creation_time")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[str]:
        """
        The ID of the instance.
        """
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter(name="instanceOwnerId")
    def instance_owner_id(self) -> pulumi.Output[str]:
        """
        The owner ID of the instance.
        """
        return pulumi.get(self, "instance_owner_id")

    @property
    @pulumi.getter(name="instanceRegionId")
    def instance_region_id(self) -> pulumi.Output[str]:
        """
        The region ID of the instance.
        """
        return pulumi.get(self, "instance_region_id")

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> pulumi.Output[str]:
        """
        The type of the instance. Valid values: `VPC`, `DCGW`.
        """
        return pulumi.get(self, "instance_type")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        The status of the cen attaching instance.
        """
        return pulumi.get(self, "status")

