# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['InterRegionBandwidthArgs', 'InterRegionBandwidth']

@pulumi.input_type
class InterRegionBandwidthArgs:
    def __init__(__self__, *,
                 bandwidth: pulumi.Input[int],
                 cen_id: pulumi.Input[str],
                 local_region_id: pulumi.Input[str],
                 peer_region_id: pulumi.Input[str]):
        """
        The set of arguments for constructing a InterRegionBandwidth resource.
        :param pulumi.Input[int] bandwidth: The bandwidth of the cen inter region bandwidth.
        :param pulumi.Input[str] cen_id: The cen ID of the cen inter region bandwidth.
        :param pulumi.Input[str] local_region_id: The local region id of the cen inter region bandwidth.
        :param pulumi.Input[str] peer_region_id: The peer region id of the cen inter region bandwidth.
        """
        pulumi.set(__self__, "bandwidth", bandwidth)
        pulumi.set(__self__, "cen_id", cen_id)
        pulumi.set(__self__, "local_region_id", local_region_id)
        pulumi.set(__self__, "peer_region_id", peer_region_id)

    @property
    @pulumi.getter
    def bandwidth(self) -> pulumi.Input[int]:
        """
        The bandwidth of the cen inter region bandwidth.
        """
        return pulumi.get(self, "bandwidth")

    @bandwidth.setter
    def bandwidth(self, value: pulumi.Input[int]):
        pulumi.set(self, "bandwidth", value)

    @property
    @pulumi.getter(name="cenId")
    def cen_id(self) -> pulumi.Input[str]:
        """
        The cen ID of the cen inter region bandwidth.
        """
        return pulumi.get(self, "cen_id")

    @cen_id.setter
    def cen_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "cen_id", value)

    @property
    @pulumi.getter(name="localRegionId")
    def local_region_id(self) -> pulumi.Input[str]:
        """
        The local region id of the cen inter region bandwidth.
        """
        return pulumi.get(self, "local_region_id")

    @local_region_id.setter
    def local_region_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "local_region_id", value)

    @property
    @pulumi.getter(name="peerRegionId")
    def peer_region_id(self) -> pulumi.Input[str]:
        """
        The peer region id of the cen inter region bandwidth.
        """
        return pulumi.get(self, "peer_region_id")

    @peer_region_id.setter
    def peer_region_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "peer_region_id", value)


@pulumi.input_type
class _InterRegionBandwidthState:
    def __init__(__self__, *,
                 bandwidth: Optional[pulumi.Input[int]] = None,
                 cen_id: Optional[pulumi.Input[str]] = None,
                 creation_time: Optional[pulumi.Input[str]] = None,
                 inter_region_bandwidth_id: Optional[pulumi.Input[str]] = None,
                 local_region_id: Optional[pulumi.Input[str]] = None,
                 peer_region_id: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 update_time: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering InterRegionBandwidth resources.
        :param pulumi.Input[int] bandwidth: The bandwidth of the cen inter region bandwidth.
        :param pulumi.Input[str] cen_id: The cen ID of the cen inter region bandwidth.
        :param pulumi.Input[str] creation_time: The create time of the cen inter region bandwidth.
        :param pulumi.Input[str] inter_region_bandwidth_id: The ID of the cen inter region bandwidth.
        :param pulumi.Input[str] local_region_id: The local region id of the cen inter region bandwidth.
        :param pulumi.Input[str] peer_region_id: The peer region id of the cen inter region bandwidth.
        :param pulumi.Input[str] status: The status of the cen inter region bandwidth.
        :param pulumi.Input[str] update_time: The update time of the cen inter region bandwidth.
        """
        if bandwidth is not None:
            pulumi.set(__self__, "bandwidth", bandwidth)
        if cen_id is not None:
            pulumi.set(__self__, "cen_id", cen_id)
        if creation_time is not None:
            pulumi.set(__self__, "creation_time", creation_time)
        if inter_region_bandwidth_id is not None:
            pulumi.set(__self__, "inter_region_bandwidth_id", inter_region_bandwidth_id)
        if local_region_id is not None:
            pulumi.set(__self__, "local_region_id", local_region_id)
        if peer_region_id is not None:
            pulumi.set(__self__, "peer_region_id", peer_region_id)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @property
    @pulumi.getter
    def bandwidth(self) -> Optional[pulumi.Input[int]]:
        """
        The bandwidth of the cen inter region bandwidth.
        """
        return pulumi.get(self, "bandwidth")

    @bandwidth.setter
    def bandwidth(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "bandwidth", value)

    @property
    @pulumi.getter(name="cenId")
    def cen_id(self) -> Optional[pulumi.Input[str]]:
        """
        The cen ID of the cen inter region bandwidth.
        """
        return pulumi.get(self, "cen_id")

    @cen_id.setter
    def cen_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cen_id", value)

    @property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> Optional[pulumi.Input[str]]:
        """
        The create time of the cen inter region bandwidth.
        """
        return pulumi.get(self, "creation_time")

    @creation_time.setter
    def creation_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "creation_time", value)

    @property
    @pulumi.getter(name="interRegionBandwidthId")
    def inter_region_bandwidth_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the cen inter region bandwidth.
        """
        return pulumi.get(self, "inter_region_bandwidth_id")

    @inter_region_bandwidth_id.setter
    def inter_region_bandwidth_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "inter_region_bandwidth_id", value)

    @property
    @pulumi.getter(name="localRegionId")
    def local_region_id(self) -> Optional[pulumi.Input[str]]:
        """
        The local region id of the cen inter region bandwidth.
        """
        return pulumi.get(self, "local_region_id")

    @local_region_id.setter
    def local_region_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "local_region_id", value)

    @property
    @pulumi.getter(name="peerRegionId")
    def peer_region_id(self) -> Optional[pulumi.Input[str]]:
        """
        The peer region id of the cen inter region bandwidth.
        """
        return pulumi.get(self, "peer_region_id")

    @peer_region_id.setter
    def peer_region_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "peer_region_id", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The status of the cen inter region bandwidth.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[str]]:
        """
        The update time of the cen inter region bandwidth.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "update_time", value)


class InterRegionBandwidth(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bandwidth: Optional[pulumi.Input[int]] = None,
                 cen_id: Optional[pulumi.Input[str]] = None,
                 local_region_id: Optional[pulumi.Input[str]] = None,
                 peer_region_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a resource to manage cen inter region bandwidth
        ## Example Usage

        ```python
        import pulumi
        import pulumi_volcengine as volcengine

        foo = volcengine.cen.InterRegionBandwidth("foo",
            bandwidth=1,
            cen_id="cen-274vsbhwvvb407fap8sp611w7",
            local_region_id="cn-north-3",
            peer_region_id="cn-zhangjiakou")
        ```

        ## Import

        CenInterRegionBandwidth can be imported using the id, e.g.

        ```sh
         $ pulumi import volcengine:cen/interRegionBandwidth:InterRegionBandwidth default cirb-3tex2x1cwd4c6c0v****
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] bandwidth: The bandwidth of the cen inter region bandwidth.
        :param pulumi.Input[str] cen_id: The cen ID of the cen inter region bandwidth.
        :param pulumi.Input[str] local_region_id: The local region id of the cen inter region bandwidth.
        :param pulumi.Input[str] peer_region_id: The peer region id of the cen inter region bandwidth.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: InterRegionBandwidthArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a resource to manage cen inter region bandwidth
        ## Example Usage

        ```python
        import pulumi
        import pulumi_volcengine as volcengine

        foo = volcengine.cen.InterRegionBandwidth("foo",
            bandwidth=1,
            cen_id="cen-274vsbhwvvb407fap8sp611w7",
            local_region_id="cn-north-3",
            peer_region_id="cn-zhangjiakou")
        ```

        ## Import

        CenInterRegionBandwidth can be imported using the id, e.g.

        ```sh
         $ pulumi import volcengine:cen/interRegionBandwidth:InterRegionBandwidth default cirb-3tex2x1cwd4c6c0v****
        ```

        :param str resource_name: The name of the resource.
        :param InterRegionBandwidthArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(InterRegionBandwidthArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bandwidth: Optional[pulumi.Input[int]] = None,
                 cen_id: Optional[pulumi.Input[str]] = None,
                 local_region_id: Optional[pulumi.Input[str]] = None,
                 peer_region_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = InterRegionBandwidthArgs.__new__(InterRegionBandwidthArgs)

            if bandwidth is None and not opts.urn:
                raise TypeError("Missing required property 'bandwidth'")
            __props__.__dict__["bandwidth"] = bandwidth
            if cen_id is None and not opts.urn:
                raise TypeError("Missing required property 'cen_id'")
            __props__.__dict__["cen_id"] = cen_id
            if local_region_id is None and not opts.urn:
                raise TypeError("Missing required property 'local_region_id'")
            __props__.__dict__["local_region_id"] = local_region_id
            if peer_region_id is None and not opts.urn:
                raise TypeError("Missing required property 'peer_region_id'")
            __props__.__dict__["peer_region_id"] = peer_region_id
            __props__.__dict__["creation_time"] = None
            __props__.__dict__["inter_region_bandwidth_id"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["update_time"] = None
        super(InterRegionBandwidth, __self__).__init__(
            'volcengine:cen/interRegionBandwidth:InterRegionBandwidth',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            bandwidth: Optional[pulumi.Input[int]] = None,
            cen_id: Optional[pulumi.Input[str]] = None,
            creation_time: Optional[pulumi.Input[str]] = None,
            inter_region_bandwidth_id: Optional[pulumi.Input[str]] = None,
            local_region_id: Optional[pulumi.Input[str]] = None,
            peer_region_id: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None,
            update_time: Optional[pulumi.Input[str]] = None) -> 'InterRegionBandwidth':
        """
        Get an existing InterRegionBandwidth resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] bandwidth: The bandwidth of the cen inter region bandwidth.
        :param pulumi.Input[str] cen_id: The cen ID of the cen inter region bandwidth.
        :param pulumi.Input[str] creation_time: The create time of the cen inter region bandwidth.
        :param pulumi.Input[str] inter_region_bandwidth_id: The ID of the cen inter region bandwidth.
        :param pulumi.Input[str] local_region_id: The local region id of the cen inter region bandwidth.
        :param pulumi.Input[str] peer_region_id: The peer region id of the cen inter region bandwidth.
        :param pulumi.Input[str] status: The status of the cen inter region bandwidth.
        :param pulumi.Input[str] update_time: The update time of the cen inter region bandwidth.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _InterRegionBandwidthState.__new__(_InterRegionBandwidthState)

        __props__.__dict__["bandwidth"] = bandwidth
        __props__.__dict__["cen_id"] = cen_id
        __props__.__dict__["creation_time"] = creation_time
        __props__.__dict__["inter_region_bandwidth_id"] = inter_region_bandwidth_id
        __props__.__dict__["local_region_id"] = local_region_id
        __props__.__dict__["peer_region_id"] = peer_region_id
        __props__.__dict__["status"] = status
        __props__.__dict__["update_time"] = update_time
        return InterRegionBandwidth(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def bandwidth(self) -> pulumi.Output[int]:
        """
        The bandwidth of the cen inter region bandwidth.
        """
        return pulumi.get(self, "bandwidth")

    @property
    @pulumi.getter(name="cenId")
    def cen_id(self) -> pulumi.Output[str]:
        """
        The cen ID of the cen inter region bandwidth.
        """
        return pulumi.get(self, "cen_id")

    @property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> pulumi.Output[str]:
        """
        The create time of the cen inter region bandwidth.
        """
        return pulumi.get(self, "creation_time")

    @property
    @pulumi.getter(name="interRegionBandwidthId")
    def inter_region_bandwidth_id(self) -> pulumi.Output[str]:
        """
        The ID of the cen inter region bandwidth.
        """
        return pulumi.get(self, "inter_region_bandwidth_id")

    @property
    @pulumi.getter(name="localRegionId")
    def local_region_id(self) -> pulumi.Output[str]:
        """
        The local region id of the cen inter region bandwidth.
        """
        return pulumi.get(self, "local_region_id")

    @property
    @pulumi.getter(name="peerRegionId")
    def peer_region_id(self) -> pulumi.Output[str]:
        """
        The peer region id of the cen inter region bandwidth.
        """
        return pulumi.get(self, "peer_region_id")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        The status of the cen inter region bandwidth.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[str]:
        """
        The update time of the cen inter region bandwidth.
        """
        return pulumi.get(self, "update_time")

