# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['RouteEntryArgs', 'RouteEntry']

@pulumi.input_type
class RouteEntryArgs:
    def __init__(__self__, *,
                 cen_id: pulumi.Input[str],
                 destination_cidr_block: pulumi.Input[str],
                 instance_id: pulumi.Input[str],
                 instance_region_id: pulumi.Input[str],
                 instance_type: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a RouteEntry resource.
        :param pulumi.Input[str] cen_id: The cen ID of the cen route entry.
        :param pulumi.Input[str] destination_cidr_block: The destination cidr block of the cen route entry.
        :param pulumi.Input[str] instance_id: The instance id of the next hop of the cen route entry.
        :param pulumi.Input[str] instance_region_id: The instance region id of the next hop of the cen route entry.
        :param pulumi.Input[str] instance_type: The instance type of the next hop of the cen route entry.
        """
        pulumi.set(__self__, "cen_id", cen_id)
        pulumi.set(__self__, "destination_cidr_block", destination_cidr_block)
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "instance_region_id", instance_region_id)
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", instance_type)

    @property
    @pulumi.getter(name="cenId")
    def cen_id(self) -> pulumi.Input[str]:
        """
        The cen ID of the cen route entry.
        """
        return pulumi.get(self, "cen_id")

    @cen_id.setter
    def cen_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "cen_id", value)

    @property
    @pulumi.getter(name="destinationCidrBlock")
    def destination_cidr_block(self) -> pulumi.Input[str]:
        """
        The destination cidr block of the cen route entry.
        """
        return pulumi.get(self, "destination_cidr_block")

    @destination_cidr_block.setter
    def destination_cidr_block(self, value: pulumi.Input[str]):
        pulumi.set(self, "destination_cidr_block", value)

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Input[str]:
        """
        The instance id of the next hop of the cen route entry.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "instance_id", value)

    @property
    @pulumi.getter(name="instanceRegionId")
    def instance_region_id(self) -> pulumi.Input[str]:
        """
        The instance region id of the next hop of the cen route entry.
        """
        return pulumi.get(self, "instance_region_id")

    @instance_region_id.setter
    def instance_region_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "instance_region_id", value)

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[pulumi.Input[str]]:
        """
        The instance type of the next hop of the cen route entry.
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_type", value)


@pulumi.input_type
class _RouteEntryState:
    def __init__(__self__, *,
                 as_paths: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 cen_id: Optional[pulumi.Input[str]] = None,
                 destination_cidr_block: Optional[pulumi.Input[str]] = None,
                 instance_id: Optional[pulumi.Input[str]] = None,
                 instance_region_id: Optional[pulumi.Input[str]] = None,
                 instance_type: Optional[pulumi.Input[str]] = None,
                 publish_status: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering RouteEntry resources.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] as_paths: The AS path of the cen route entry.
        :param pulumi.Input[str] cen_id: The cen ID of the cen route entry.
        :param pulumi.Input[str] destination_cidr_block: The destination cidr block of the cen route entry.
        :param pulumi.Input[str] instance_id: The instance id of the next hop of the cen route entry.
        :param pulumi.Input[str] instance_region_id: The instance region id of the next hop of the cen route entry.
        :param pulumi.Input[str] instance_type: The instance type of the next hop of the cen route entry.
        :param pulumi.Input[str] publish_status: The publish status of the cen route entry.
        :param pulumi.Input[str] status: The status of the cen route entry.
        """
        if as_paths is not None:
            pulumi.set(__self__, "as_paths", as_paths)
        if cen_id is not None:
            pulumi.set(__self__, "cen_id", cen_id)
        if destination_cidr_block is not None:
            pulumi.set(__self__, "destination_cidr_block", destination_cidr_block)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if instance_region_id is not None:
            pulumi.set(__self__, "instance_region_id", instance_region_id)
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", instance_type)
        if publish_status is not None:
            pulumi.set(__self__, "publish_status", publish_status)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="asPaths")
    def as_paths(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The AS path of the cen route entry.
        """
        return pulumi.get(self, "as_paths")

    @as_paths.setter
    def as_paths(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "as_paths", value)

    @property
    @pulumi.getter(name="cenId")
    def cen_id(self) -> Optional[pulumi.Input[str]]:
        """
        The cen ID of the cen route entry.
        """
        return pulumi.get(self, "cen_id")

    @cen_id.setter
    def cen_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cen_id", value)

    @property
    @pulumi.getter(name="destinationCidrBlock")
    def destination_cidr_block(self) -> Optional[pulumi.Input[str]]:
        """
        The destination cidr block of the cen route entry.
        """
        return pulumi.get(self, "destination_cidr_block")

    @destination_cidr_block.setter
    def destination_cidr_block(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "destination_cidr_block", value)

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[str]]:
        """
        The instance id of the next hop of the cen route entry.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_id", value)

    @property
    @pulumi.getter(name="instanceRegionId")
    def instance_region_id(self) -> Optional[pulumi.Input[str]]:
        """
        The instance region id of the next hop of the cen route entry.
        """
        return pulumi.get(self, "instance_region_id")

    @instance_region_id.setter
    def instance_region_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_region_id", value)

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[pulumi.Input[str]]:
        """
        The instance type of the next hop of the cen route entry.
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_type", value)

    @property
    @pulumi.getter(name="publishStatus")
    def publish_status(self) -> Optional[pulumi.Input[str]]:
        """
        The publish status of the cen route entry.
        """
        return pulumi.get(self, "publish_status")

    @publish_status.setter
    def publish_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "publish_status", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The status of the cen route entry.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)


class RouteEntry(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cen_id: Optional[pulumi.Input[str]] = None,
                 destination_cidr_block: Optional[pulumi.Input[str]] = None,
                 instance_id: Optional[pulumi.Input[str]] = None,
                 instance_region_id: Optional[pulumi.Input[str]] = None,
                 instance_type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a resource to manage cen route entry
        ## Example Usage

        ```python
        import pulumi
        import pulumi_volcengine as volcengine

        foo = volcengine.cen.RouteEntry("foo",
            cen_id="cen-12ar8uclj68sg17q7y20v9gil",
            destination_cidr_block="192.168.0.0/24",
            instance_id="vpc-im67wjcikxkw8gbssx8ufpj8",
            instance_region_id="cn-beijing",
            instance_type="VPC")
        foo1 = volcengine.cen.RouteEntry("foo1",
            cen_id="cen-12ar8uclj68sg17q7y20v9gil",
            destination_cidr_block="192.168.17.0/24",
            instance_id="vpc-im67wjcikxkw8gbssx8ufpj8",
            instance_region_id="cn-beijing",
            instance_type="VPC")
        ```

        ## Import

        CenRouteEntry can be imported using the CenId:DestinationCidrBlock:InstanceId:InstanceType:InstanceRegionId, e.g.

        ```sh
         $ pulumi import volcengine:cen/routeEntry:RouteEntry default cen-2nim00ybaylts7trquyzt****:100.XX.XX.0/24:vpc-vtbnbb04qw3k2hgi12cv****:VPC:cn-beijing
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] cen_id: The cen ID of the cen route entry.
        :param pulumi.Input[str] destination_cidr_block: The destination cidr block of the cen route entry.
        :param pulumi.Input[str] instance_id: The instance id of the next hop of the cen route entry.
        :param pulumi.Input[str] instance_region_id: The instance region id of the next hop of the cen route entry.
        :param pulumi.Input[str] instance_type: The instance type of the next hop of the cen route entry.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RouteEntryArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a resource to manage cen route entry
        ## Example Usage

        ```python
        import pulumi
        import pulumi_volcengine as volcengine

        foo = volcengine.cen.RouteEntry("foo",
            cen_id="cen-12ar8uclj68sg17q7y20v9gil",
            destination_cidr_block="192.168.0.0/24",
            instance_id="vpc-im67wjcikxkw8gbssx8ufpj8",
            instance_region_id="cn-beijing",
            instance_type="VPC")
        foo1 = volcengine.cen.RouteEntry("foo1",
            cen_id="cen-12ar8uclj68sg17q7y20v9gil",
            destination_cidr_block="192.168.17.0/24",
            instance_id="vpc-im67wjcikxkw8gbssx8ufpj8",
            instance_region_id="cn-beijing",
            instance_type="VPC")
        ```

        ## Import

        CenRouteEntry can be imported using the CenId:DestinationCidrBlock:InstanceId:InstanceType:InstanceRegionId, e.g.

        ```sh
         $ pulumi import volcengine:cen/routeEntry:RouteEntry default cen-2nim00ybaylts7trquyzt****:100.XX.XX.0/24:vpc-vtbnbb04qw3k2hgi12cv****:VPC:cn-beijing
        ```

        :param str resource_name: The name of the resource.
        :param RouteEntryArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RouteEntryArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cen_id: Optional[pulumi.Input[str]] = None,
                 destination_cidr_block: Optional[pulumi.Input[str]] = None,
                 instance_id: Optional[pulumi.Input[str]] = None,
                 instance_region_id: Optional[pulumi.Input[str]] = None,
                 instance_type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RouteEntryArgs.__new__(RouteEntryArgs)

            if cen_id is None and not opts.urn:
                raise TypeError("Missing required property 'cen_id'")
            __props__.__dict__["cen_id"] = cen_id
            if destination_cidr_block is None and not opts.urn:
                raise TypeError("Missing required property 'destination_cidr_block'")
            __props__.__dict__["destination_cidr_block"] = destination_cidr_block
            if instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'instance_id'")
            __props__.__dict__["instance_id"] = instance_id
            if instance_region_id is None and not opts.urn:
                raise TypeError("Missing required property 'instance_region_id'")
            __props__.__dict__["instance_region_id"] = instance_region_id
            __props__.__dict__["instance_type"] = instance_type
            __props__.__dict__["as_paths"] = None
            __props__.__dict__["publish_status"] = None
            __props__.__dict__["status"] = None
        super(RouteEntry, __self__).__init__(
            'volcengine:cen/routeEntry:RouteEntry',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            as_paths: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            cen_id: Optional[pulumi.Input[str]] = None,
            destination_cidr_block: Optional[pulumi.Input[str]] = None,
            instance_id: Optional[pulumi.Input[str]] = None,
            instance_region_id: Optional[pulumi.Input[str]] = None,
            instance_type: Optional[pulumi.Input[str]] = None,
            publish_status: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None) -> 'RouteEntry':
        """
        Get an existing RouteEntry resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] as_paths: The AS path of the cen route entry.
        :param pulumi.Input[str] cen_id: The cen ID of the cen route entry.
        :param pulumi.Input[str] destination_cidr_block: The destination cidr block of the cen route entry.
        :param pulumi.Input[str] instance_id: The instance id of the next hop of the cen route entry.
        :param pulumi.Input[str] instance_region_id: The instance region id of the next hop of the cen route entry.
        :param pulumi.Input[str] instance_type: The instance type of the next hop of the cen route entry.
        :param pulumi.Input[str] publish_status: The publish status of the cen route entry.
        :param pulumi.Input[str] status: The status of the cen route entry.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RouteEntryState.__new__(_RouteEntryState)

        __props__.__dict__["as_paths"] = as_paths
        __props__.__dict__["cen_id"] = cen_id
        __props__.__dict__["destination_cidr_block"] = destination_cidr_block
        __props__.__dict__["instance_id"] = instance_id
        __props__.__dict__["instance_region_id"] = instance_region_id
        __props__.__dict__["instance_type"] = instance_type
        __props__.__dict__["publish_status"] = publish_status
        __props__.__dict__["status"] = status
        return RouteEntry(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="asPaths")
    def as_paths(self) -> pulumi.Output[Sequence[str]]:
        """
        The AS path of the cen route entry.
        """
        return pulumi.get(self, "as_paths")

    @property
    @pulumi.getter(name="cenId")
    def cen_id(self) -> pulumi.Output[str]:
        """
        The cen ID of the cen route entry.
        """
        return pulumi.get(self, "cen_id")

    @property
    @pulumi.getter(name="destinationCidrBlock")
    def destination_cidr_block(self) -> pulumi.Output[str]:
        """
        The destination cidr block of the cen route entry.
        """
        return pulumi.get(self, "destination_cidr_block")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[str]:
        """
        The instance id of the next hop of the cen route entry.
        """
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter(name="instanceRegionId")
    def instance_region_id(self) -> pulumi.Output[str]:
        """
        The instance region id of the next hop of the cen route entry.
        """
        return pulumi.get(self, "instance_region_id")

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> pulumi.Output[Optional[str]]:
        """
        The instance type of the next hop of the cen route entry.
        """
        return pulumi.get(self, "instance_type")

    @property
    @pulumi.getter(name="publishStatus")
    def publish_status(self) -> pulumi.Output[str]:
        """
        The publish status of the cen route entry.
        """
        return pulumi.get(self, "publish_status")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        The status of the cen route entry.
        """
        return pulumi.get(self, "status")

