# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'ServiceRouteEntriesResult',
    'AwaitableServiceRouteEntriesResult',
    'service_route_entries',
    'service_route_entries_output',
]

@pulumi.output_type
class ServiceRouteEntriesResult:
    """
    A collection of values returned by ServiceRouteEntries.
    """
    def __init__(__self__, cen_id=None, destination_cidr_block=None, id=None, output_file=None, service_region_id=None, service_route_entries=None, service_vpc_id=None, total_count=None):
        if cen_id and not isinstance(cen_id, str):
            raise TypeError("Expected argument 'cen_id' to be a str")
        pulumi.set(__self__, "cen_id", cen_id)
        if destination_cidr_block and not isinstance(destination_cidr_block, str):
            raise TypeError("Expected argument 'destination_cidr_block' to be a str")
        pulumi.set(__self__, "destination_cidr_block", destination_cidr_block)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if service_region_id and not isinstance(service_region_id, str):
            raise TypeError("Expected argument 'service_region_id' to be a str")
        pulumi.set(__self__, "service_region_id", service_region_id)
        if service_route_entries and not isinstance(service_route_entries, list):
            raise TypeError("Expected argument 'service_route_entries' to be a list")
        pulumi.set(__self__, "service_route_entries", service_route_entries)
        if service_vpc_id and not isinstance(service_vpc_id, str):
            raise TypeError("Expected argument 'service_vpc_id' to be a str")
        pulumi.set(__self__, "service_vpc_id", service_vpc_id)
        if total_count and not isinstance(total_count, int):
            raise TypeError("Expected argument 'total_count' to be a int")
        pulumi.set(__self__, "total_count", total_count)

    @property
    @pulumi.getter(name="cenId")
    def cen_id(self) -> Optional[str]:
        """
        The cen ID of the cen service route entry.
        """
        return pulumi.get(self, "cen_id")

    @property
    @pulumi.getter(name="destinationCidrBlock")
    def destination_cidr_block(self) -> Optional[str]:
        """
        The destination cidr block of the cen service route entry.
        """
        return pulumi.get(self, "destination_cidr_block")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[str]:
        return pulumi.get(self, "output_file")

    @property
    @pulumi.getter(name="serviceRegionId")
    def service_region_id(self) -> Optional[str]:
        """
        The service region id of the cen service route entry.
        """
        return pulumi.get(self, "service_region_id")

    @property
    @pulumi.getter(name="serviceRouteEntries")
    def service_route_entries(self) -> Sequence['outputs.ServiceRouteEntriesServiceRouteEntryResult']:
        """
        The collection of cen service route entry query.
        """
        return pulumi.get(self, "service_route_entries")

    @property
    @pulumi.getter(name="serviceVpcId")
    def service_vpc_id(self) -> Optional[str]:
        """
        The service VPC id of the cen service route entry.
        """
        return pulumi.get(self, "service_vpc_id")

    @property
    @pulumi.getter(name="totalCount")
    def total_count(self) -> int:
        """
        The total count of cen service route entry.
        """
        return pulumi.get(self, "total_count")


class AwaitableServiceRouteEntriesResult(ServiceRouteEntriesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return ServiceRouteEntriesResult(
            cen_id=self.cen_id,
            destination_cidr_block=self.destination_cidr_block,
            id=self.id,
            output_file=self.output_file,
            service_region_id=self.service_region_id,
            service_route_entries=self.service_route_entries,
            service_vpc_id=self.service_vpc_id,
            total_count=self.total_count)


def service_route_entries(cen_id: Optional[str] = None,
                          destination_cidr_block: Optional[str] = None,
                          output_file: Optional[str] = None,
                          service_region_id: Optional[str] = None,
                          service_vpc_id: Optional[str] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableServiceRouteEntriesResult:
    """
    Use this data source to query detailed information of cen service route entries
    ## Example Usage

    ```python
    import pulumi
    import pulumi_volcengine as volcengine

    default = volcengine.cen.service_route_entries(cen_id="cen-12ar8uclj68sg17q7y20v9gil")
    ```


    :param str cen_id: A cen ID.
    :param str destination_cidr_block: A destination cidr block.
    :param str output_file: File name where to save data source results.
    :param str service_region_id: A service region id.
    :param str service_vpc_id: A service VPC id.
    """
    __args__ = dict()
    __args__['cenId'] = cen_id
    __args__['destinationCidrBlock'] = destination_cidr_block
    __args__['outputFile'] = output_file
    __args__['serviceRegionId'] = service_region_id
    __args__['serviceVpcId'] = service_vpc_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('volcengine:cen/serviceRouteEntries:ServiceRouteEntries', __args__, opts=opts, typ=ServiceRouteEntriesResult).value

    return AwaitableServiceRouteEntriesResult(
        cen_id=pulumi.get(__ret__, 'cen_id'),
        destination_cidr_block=pulumi.get(__ret__, 'destination_cidr_block'),
        id=pulumi.get(__ret__, 'id'),
        output_file=pulumi.get(__ret__, 'output_file'),
        service_region_id=pulumi.get(__ret__, 'service_region_id'),
        service_route_entries=pulumi.get(__ret__, 'service_route_entries'),
        service_vpc_id=pulumi.get(__ret__, 'service_vpc_id'),
        total_count=pulumi.get(__ret__, 'total_count'))


@_utilities.lift_output_func(service_route_entries)
def service_route_entries_output(cen_id: Optional[pulumi.Input[Optional[str]]] = None,
                                 destination_cidr_block: Optional[pulumi.Input[Optional[str]]] = None,
                                 output_file: Optional[pulumi.Input[Optional[str]]] = None,
                                 service_region_id: Optional[pulumi.Input[Optional[str]]] = None,
                                 service_vpc_id: Optional[pulumi.Input[Optional[str]]] = None,
                                 opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[ServiceRouteEntriesResult]:
    """
    Use this data source to query detailed information of cen service route entries
    ## Example Usage

    ```python
    import pulumi
    import pulumi_volcengine as volcengine

    default = volcengine.cen.service_route_entries(cen_id="cen-12ar8uclj68sg17q7y20v9gil")
    ```


    :param str cen_id: A cen ID.
    :param str destination_cidr_block: A destination cidr block.
    :param str output_file: File name where to save data source results.
    :param str service_region_id: A service region id.
    :param str service_vpc_id: A service VPC id.
    """
    ...
