# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ClbArgs', 'Clb']

@pulumi.input_type
class ClbArgs:
    def __init__(__self__, *,
                 load_balancer_spec: pulumi.Input[str],
                 subnet_id: pulumi.Input[str],
                 type: pulumi.Input[str],
                 address_ip_version: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 eip_billing_config: Optional[pulumi.Input['ClbEipBillingConfigArgs']] = None,
                 eni_address: Optional[pulumi.Input[str]] = None,
                 eni_ipv6_address: Optional[pulumi.Input[str]] = None,
                 load_balancer_billing_type: Optional[pulumi.Input[str]] = None,
                 load_balancer_name: Optional[pulumi.Input[str]] = None,
                 master_zone_id: Optional[pulumi.Input[str]] = None,
                 modification_protection_reason: Optional[pulumi.Input[str]] = None,
                 modification_protection_status: Optional[pulumi.Input[str]] = None,
                 period: Optional[pulumi.Input[int]] = None,
                 project_name: Optional[pulumi.Input[str]] = None,
                 region_id: Optional[pulumi.Input[str]] = None,
                 slave_zone_id: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['ClbTagArgs']]]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Clb resource.
        :param pulumi.Input[str] load_balancer_spec: The specification of the CLB, the value can be `small_1`, `small_2`, `medium_1`, `medium_2`, `large_1`, `large_2`.
        :param pulumi.Input[str] subnet_id: The id of the Subnet.
        :param pulumi.Input[str] type: The type of the CLB. And optional choice contains `public` or `private`.
        :param pulumi.Input[str] address_ip_version: The address ip version of the Clb. Valid values: `ipv4`, `DualStack`. Default is `ipv4`.
               When the value of this field is `DualStack`, the type of the CLB must be `private`, and suggest using a combination of resource `vpc.Ipv6Gateway` and `vpc.Ipv6AddressBandwidth` to achieve ipv6 public network access function.
        :param pulumi.Input[str] description: The description of the CLB.
        :param pulumi.Input['ClbEipBillingConfigArgs'] eip_billing_config: The billing configuration of the EIP which automatically associated to CLB. This field is valid when the type of CLB is `public`.When the type of the CLB is `private`, suggest using a combination of resource `eip.Address` and `eip.Associate` to achieve public network access function.
        :param pulumi.Input[str] eni_address: The eni address of the CLB.
        :param pulumi.Input[str] eni_ipv6_address: The eni ipv6 address of the Clb.
        :param pulumi.Input[str] load_balancer_billing_type: The billing type of the CLB, the value can be `PostPaid` or `PrePaid`.
        :param pulumi.Input[str] load_balancer_name: The name of the CLB.
        :param pulumi.Input[str] master_zone_id: The master zone ID of the CLB.
        :param pulumi.Input[str] modification_protection_reason: The reason of the console modification protection.
        :param pulumi.Input[str] modification_protection_status: The status of the console modification protection, the value can be `NonProtection` or `ConsoleProtection`.
        :param pulumi.Input[int] period: The period of the NatGateway, the valid value range in 1~9 or 12 or 24 or 36. Default value is 12. The period unit defaults to `Month`.This field is only effective when creating a PrePaid NatGateway. When importing resources, this attribute will not be imported. If this attribute is set, please use lifecycle and ignore_changes ignore changes in fields.
        :param pulumi.Input[str] project_name: The ProjectName of the CLB.
        :param pulumi.Input[str] region_id: The region of the request.
        :param pulumi.Input[str] slave_zone_id: The slave zone ID of the CLB.
        :param pulumi.Input[Sequence[pulumi.Input['ClbTagArgs']]] tags: Tags.
        :param pulumi.Input[str] vpc_id: The id of the VPC.
        """
        pulumi.set(__self__, "load_balancer_spec", load_balancer_spec)
        pulumi.set(__self__, "subnet_id", subnet_id)
        pulumi.set(__self__, "type", type)
        if address_ip_version is not None:
            pulumi.set(__self__, "address_ip_version", address_ip_version)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if eip_billing_config is not None:
            pulumi.set(__self__, "eip_billing_config", eip_billing_config)
        if eni_address is not None:
            pulumi.set(__self__, "eni_address", eni_address)
        if eni_ipv6_address is not None:
            pulumi.set(__self__, "eni_ipv6_address", eni_ipv6_address)
        if load_balancer_billing_type is not None:
            pulumi.set(__self__, "load_balancer_billing_type", load_balancer_billing_type)
        if load_balancer_name is not None:
            pulumi.set(__self__, "load_balancer_name", load_balancer_name)
        if master_zone_id is not None:
            pulumi.set(__self__, "master_zone_id", master_zone_id)
        if modification_protection_reason is not None:
            pulumi.set(__self__, "modification_protection_reason", modification_protection_reason)
        if modification_protection_status is not None:
            pulumi.set(__self__, "modification_protection_status", modification_protection_status)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if project_name is not None:
            pulumi.set(__self__, "project_name", project_name)
        if region_id is not None:
            pulumi.set(__self__, "region_id", region_id)
        if slave_zone_id is not None:
            pulumi.set(__self__, "slave_zone_id", slave_zone_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)

    @property
    @pulumi.getter(name="loadBalancerSpec")
    def load_balancer_spec(self) -> pulumi.Input[str]:
        """
        The specification of the CLB, the value can be `small_1`, `small_2`, `medium_1`, `medium_2`, `large_1`, `large_2`.
        """
        return pulumi.get(self, "load_balancer_spec")

    @load_balancer_spec.setter
    def load_balancer_spec(self, value: pulumi.Input[str]):
        pulumi.set(self, "load_balancer_spec", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Input[str]:
        """
        The id of the Subnet.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "subnet_id", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        The type of the CLB. And optional choice contains `public` or `private`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="addressIpVersion")
    def address_ip_version(self) -> Optional[pulumi.Input[str]]:
        """
        The address ip version of the Clb. Valid values: `ipv4`, `DualStack`. Default is `ipv4`.
        When the value of this field is `DualStack`, the type of the CLB must be `private`, and suggest using a combination of resource `vpc.Ipv6Gateway` and `vpc.Ipv6AddressBandwidth` to achieve ipv6 public network access function.
        """
        return pulumi.get(self, "address_ip_version")

    @address_ip_version.setter
    def address_ip_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "address_ip_version", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the CLB.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="eipBillingConfig")
    def eip_billing_config(self) -> Optional[pulumi.Input['ClbEipBillingConfigArgs']]:
        """
        The billing configuration of the EIP which automatically associated to CLB. This field is valid when the type of CLB is `public`.When the type of the CLB is `private`, suggest using a combination of resource `eip.Address` and `eip.Associate` to achieve public network access function.
        """
        return pulumi.get(self, "eip_billing_config")

    @eip_billing_config.setter
    def eip_billing_config(self, value: Optional[pulumi.Input['ClbEipBillingConfigArgs']]):
        pulumi.set(self, "eip_billing_config", value)

    @property
    @pulumi.getter(name="eniAddress")
    def eni_address(self) -> Optional[pulumi.Input[str]]:
        """
        The eni address of the CLB.
        """
        return pulumi.get(self, "eni_address")

    @eni_address.setter
    def eni_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "eni_address", value)

    @property
    @pulumi.getter(name="eniIpv6Address")
    def eni_ipv6_address(self) -> Optional[pulumi.Input[str]]:
        """
        The eni ipv6 address of the Clb.
        """
        return pulumi.get(self, "eni_ipv6_address")

    @eni_ipv6_address.setter
    def eni_ipv6_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "eni_ipv6_address", value)

    @property
    @pulumi.getter(name="loadBalancerBillingType")
    def load_balancer_billing_type(self) -> Optional[pulumi.Input[str]]:
        """
        The billing type of the CLB, the value can be `PostPaid` or `PrePaid`.
        """
        return pulumi.get(self, "load_balancer_billing_type")

    @load_balancer_billing_type.setter
    def load_balancer_billing_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "load_balancer_billing_type", value)

    @property
    @pulumi.getter(name="loadBalancerName")
    def load_balancer_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the CLB.
        """
        return pulumi.get(self, "load_balancer_name")

    @load_balancer_name.setter
    def load_balancer_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "load_balancer_name", value)

    @property
    @pulumi.getter(name="masterZoneId")
    def master_zone_id(self) -> Optional[pulumi.Input[str]]:
        """
        The master zone ID of the CLB.
        """
        return pulumi.get(self, "master_zone_id")

    @master_zone_id.setter
    def master_zone_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "master_zone_id", value)

    @property
    @pulumi.getter(name="modificationProtectionReason")
    def modification_protection_reason(self) -> Optional[pulumi.Input[str]]:
        """
        The reason of the console modification protection.
        """
        return pulumi.get(self, "modification_protection_reason")

    @modification_protection_reason.setter
    def modification_protection_reason(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "modification_protection_reason", value)

    @property
    @pulumi.getter(name="modificationProtectionStatus")
    def modification_protection_status(self) -> Optional[pulumi.Input[str]]:
        """
        The status of the console modification protection, the value can be `NonProtection` or `ConsoleProtection`.
        """
        return pulumi.get(self, "modification_protection_status")

    @modification_protection_status.setter
    def modification_protection_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "modification_protection_status", value)

    @property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[int]]:
        """
        The period of the NatGateway, the valid value range in 1~9 or 12 or 24 or 36. Default value is 12. The period unit defaults to `Month`.This field is only effective when creating a PrePaid NatGateway. When importing resources, this attribute will not be imported. If this attribute is set, please use lifecycle and ignore_changes ignore changes in fields.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "period", value)

    @property
    @pulumi.getter(name="projectName")
    def project_name(self) -> Optional[pulumi.Input[str]]:
        """
        The ProjectName of the CLB.
        """
        return pulumi.get(self, "project_name")

    @project_name.setter
    def project_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_name", value)

    @property
    @pulumi.getter(name="regionId")
    def region_id(self) -> Optional[pulumi.Input[str]]:
        """
        The region of the request.
        """
        return pulumi.get(self, "region_id")

    @region_id.setter
    def region_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region_id", value)

    @property
    @pulumi.getter(name="slaveZoneId")
    def slave_zone_id(self) -> Optional[pulumi.Input[str]]:
        """
        The slave zone ID of the CLB.
        """
        return pulumi.get(self, "slave_zone_id")

    @slave_zone_id.setter
    def slave_zone_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "slave_zone_id", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClbTagArgs']]]]:
        """
        Tags.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClbTagArgs']]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[str]]:
        """
        The id of the VPC.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc_id", value)


@pulumi.input_type
class _ClbState:
    def __init__(__self__, *,
                 address_ip_version: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 eip_address: Optional[pulumi.Input[str]] = None,
                 eip_billing_config: Optional[pulumi.Input['ClbEipBillingConfigArgs']] = None,
                 eip_id: Optional[pulumi.Input[str]] = None,
                 eni_address: Optional[pulumi.Input[str]] = None,
                 eni_ipv6_address: Optional[pulumi.Input[str]] = None,
                 ipv6_eip_id: Optional[pulumi.Input[str]] = None,
                 load_balancer_billing_type: Optional[pulumi.Input[str]] = None,
                 load_balancer_name: Optional[pulumi.Input[str]] = None,
                 load_balancer_spec: Optional[pulumi.Input[str]] = None,
                 master_zone_id: Optional[pulumi.Input[str]] = None,
                 modification_protection_reason: Optional[pulumi.Input[str]] = None,
                 modification_protection_status: Optional[pulumi.Input[str]] = None,
                 period: Optional[pulumi.Input[int]] = None,
                 project_name: Optional[pulumi.Input[str]] = None,
                 region_id: Optional[pulumi.Input[str]] = None,
                 renew_type: Optional[pulumi.Input[str]] = None,
                 slave_zone_id: Optional[pulumi.Input[str]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['ClbTagArgs']]]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Clb resources.
        :param pulumi.Input[str] address_ip_version: The address ip version of the Clb. Valid values: `ipv4`, `DualStack`. Default is `ipv4`.
               When the value of this field is `DualStack`, the type of the CLB must be `private`, and suggest using a combination of resource `vpc.Ipv6Gateway` and `vpc.Ipv6AddressBandwidth` to achieve ipv6 public network access function.
        :param pulumi.Input[str] description: The description of the CLB.
        :param pulumi.Input[str] eip_address: The Eip address of the Clb.
        :param pulumi.Input['ClbEipBillingConfigArgs'] eip_billing_config: The billing configuration of the EIP which automatically associated to CLB. This field is valid when the type of CLB is `public`.When the type of the CLB is `private`, suggest using a combination of resource `eip.Address` and `eip.Associate` to achieve public network access function.
        :param pulumi.Input[str] eip_id: The Eip ID of the Clb.
        :param pulumi.Input[str] eni_address: The eni address of the CLB.
        :param pulumi.Input[str] eni_ipv6_address: The eni ipv6 address of the Clb.
        :param pulumi.Input[str] ipv6_eip_id: The Ipv6 Eip ID of the Clb.
        :param pulumi.Input[str] load_balancer_billing_type: The billing type of the CLB, the value can be `PostPaid` or `PrePaid`.
        :param pulumi.Input[str] load_balancer_name: The name of the CLB.
        :param pulumi.Input[str] load_balancer_spec: The specification of the CLB, the value can be `small_1`, `small_2`, `medium_1`, `medium_2`, `large_1`, `large_2`.
        :param pulumi.Input[str] master_zone_id: The master zone ID of the CLB.
        :param pulumi.Input[str] modification_protection_reason: The reason of the console modification protection.
        :param pulumi.Input[str] modification_protection_status: The status of the console modification protection, the value can be `NonProtection` or `ConsoleProtection`.
        :param pulumi.Input[int] period: The period of the NatGateway, the valid value range in 1~9 or 12 or 24 or 36. Default value is 12. The period unit defaults to `Month`.This field is only effective when creating a PrePaid NatGateway. When importing resources, this attribute will not be imported. If this attribute is set, please use lifecycle and ignore_changes ignore changes in fields.
        :param pulumi.Input[str] project_name: The ProjectName of the CLB.
        :param pulumi.Input[str] region_id: The region of the request.
        :param pulumi.Input[str] renew_type: The renew type of the CLB. When the value of the load_balancer_billing_type is `PrePaid`, the query returns this field.
        :param pulumi.Input[str] slave_zone_id: The slave zone ID of the CLB.
        :param pulumi.Input[str] subnet_id: The id of the Subnet.
        :param pulumi.Input[Sequence[pulumi.Input['ClbTagArgs']]] tags: Tags.
        :param pulumi.Input[str] type: The type of the CLB. And optional choice contains `public` or `private`.
        :param pulumi.Input[str] vpc_id: The id of the VPC.
        """
        if address_ip_version is not None:
            pulumi.set(__self__, "address_ip_version", address_ip_version)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if eip_address is not None:
            pulumi.set(__self__, "eip_address", eip_address)
        if eip_billing_config is not None:
            pulumi.set(__self__, "eip_billing_config", eip_billing_config)
        if eip_id is not None:
            pulumi.set(__self__, "eip_id", eip_id)
        if eni_address is not None:
            pulumi.set(__self__, "eni_address", eni_address)
        if eni_ipv6_address is not None:
            pulumi.set(__self__, "eni_ipv6_address", eni_ipv6_address)
        if ipv6_eip_id is not None:
            pulumi.set(__self__, "ipv6_eip_id", ipv6_eip_id)
        if load_balancer_billing_type is not None:
            pulumi.set(__self__, "load_balancer_billing_type", load_balancer_billing_type)
        if load_balancer_name is not None:
            pulumi.set(__self__, "load_balancer_name", load_balancer_name)
        if load_balancer_spec is not None:
            pulumi.set(__self__, "load_balancer_spec", load_balancer_spec)
        if master_zone_id is not None:
            pulumi.set(__self__, "master_zone_id", master_zone_id)
        if modification_protection_reason is not None:
            pulumi.set(__self__, "modification_protection_reason", modification_protection_reason)
        if modification_protection_status is not None:
            pulumi.set(__self__, "modification_protection_status", modification_protection_status)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if project_name is not None:
            pulumi.set(__self__, "project_name", project_name)
        if region_id is not None:
            pulumi.set(__self__, "region_id", region_id)
        if renew_type is not None:
            pulumi.set(__self__, "renew_type", renew_type)
        if slave_zone_id is not None:
            pulumi.set(__self__, "slave_zone_id", slave_zone_id)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)

    @property
    @pulumi.getter(name="addressIpVersion")
    def address_ip_version(self) -> Optional[pulumi.Input[str]]:
        """
        The address ip version of the Clb. Valid values: `ipv4`, `DualStack`. Default is `ipv4`.
        When the value of this field is `DualStack`, the type of the CLB must be `private`, and suggest using a combination of resource `vpc.Ipv6Gateway` and `vpc.Ipv6AddressBandwidth` to achieve ipv6 public network access function.
        """
        return pulumi.get(self, "address_ip_version")

    @address_ip_version.setter
    def address_ip_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "address_ip_version", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the CLB.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="eipAddress")
    def eip_address(self) -> Optional[pulumi.Input[str]]:
        """
        The Eip address of the Clb.
        """
        return pulumi.get(self, "eip_address")

    @eip_address.setter
    def eip_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "eip_address", value)

    @property
    @pulumi.getter(name="eipBillingConfig")
    def eip_billing_config(self) -> Optional[pulumi.Input['ClbEipBillingConfigArgs']]:
        """
        The billing configuration of the EIP which automatically associated to CLB. This field is valid when the type of CLB is `public`.When the type of the CLB is `private`, suggest using a combination of resource `eip.Address` and `eip.Associate` to achieve public network access function.
        """
        return pulumi.get(self, "eip_billing_config")

    @eip_billing_config.setter
    def eip_billing_config(self, value: Optional[pulumi.Input['ClbEipBillingConfigArgs']]):
        pulumi.set(self, "eip_billing_config", value)

    @property
    @pulumi.getter(name="eipId")
    def eip_id(self) -> Optional[pulumi.Input[str]]:
        """
        The Eip ID of the Clb.
        """
        return pulumi.get(self, "eip_id")

    @eip_id.setter
    def eip_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "eip_id", value)

    @property
    @pulumi.getter(name="eniAddress")
    def eni_address(self) -> Optional[pulumi.Input[str]]:
        """
        The eni address of the CLB.
        """
        return pulumi.get(self, "eni_address")

    @eni_address.setter
    def eni_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "eni_address", value)

    @property
    @pulumi.getter(name="eniIpv6Address")
    def eni_ipv6_address(self) -> Optional[pulumi.Input[str]]:
        """
        The eni ipv6 address of the Clb.
        """
        return pulumi.get(self, "eni_ipv6_address")

    @eni_ipv6_address.setter
    def eni_ipv6_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "eni_ipv6_address", value)

    @property
    @pulumi.getter(name="ipv6EipId")
    def ipv6_eip_id(self) -> Optional[pulumi.Input[str]]:
        """
        The Ipv6 Eip ID of the Clb.
        """
        return pulumi.get(self, "ipv6_eip_id")

    @ipv6_eip_id.setter
    def ipv6_eip_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ipv6_eip_id", value)

    @property
    @pulumi.getter(name="loadBalancerBillingType")
    def load_balancer_billing_type(self) -> Optional[pulumi.Input[str]]:
        """
        The billing type of the CLB, the value can be `PostPaid` or `PrePaid`.
        """
        return pulumi.get(self, "load_balancer_billing_type")

    @load_balancer_billing_type.setter
    def load_balancer_billing_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "load_balancer_billing_type", value)

    @property
    @pulumi.getter(name="loadBalancerName")
    def load_balancer_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the CLB.
        """
        return pulumi.get(self, "load_balancer_name")

    @load_balancer_name.setter
    def load_balancer_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "load_balancer_name", value)

    @property
    @pulumi.getter(name="loadBalancerSpec")
    def load_balancer_spec(self) -> Optional[pulumi.Input[str]]:
        """
        The specification of the CLB, the value can be `small_1`, `small_2`, `medium_1`, `medium_2`, `large_1`, `large_2`.
        """
        return pulumi.get(self, "load_balancer_spec")

    @load_balancer_spec.setter
    def load_balancer_spec(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "load_balancer_spec", value)

    @property
    @pulumi.getter(name="masterZoneId")
    def master_zone_id(self) -> Optional[pulumi.Input[str]]:
        """
        The master zone ID of the CLB.
        """
        return pulumi.get(self, "master_zone_id")

    @master_zone_id.setter
    def master_zone_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "master_zone_id", value)

    @property
    @pulumi.getter(name="modificationProtectionReason")
    def modification_protection_reason(self) -> Optional[pulumi.Input[str]]:
        """
        The reason of the console modification protection.
        """
        return pulumi.get(self, "modification_protection_reason")

    @modification_protection_reason.setter
    def modification_protection_reason(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "modification_protection_reason", value)

    @property
    @pulumi.getter(name="modificationProtectionStatus")
    def modification_protection_status(self) -> Optional[pulumi.Input[str]]:
        """
        The status of the console modification protection, the value can be `NonProtection` or `ConsoleProtection`.
        """
        return pulumi.get(self, "modification_protection_status")

    @modification_protection_status.setter
    def modification_protection_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "modification_protection_status", value)

    @property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[int]]:
        """
        The period of the NatGateway, the valid value range in 1~9 or 12 or 24 or 36. Default value is 12. The period unit defaults to `Month`.This field is only effective when creating a PrePaid NatGateway. When importing resources, this attribute will not be imported. If this attribute is set, please use lifecycle and ignore_changes ignore changes in fields.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "period", value)

    @property
    @pulumi.getter(name="projectName")
    def project_name(self) -> Optional[pulumi.Input[str]]:
        """
        The ProjectName of the CLB.
        """
        return pulumi.get(self, "project_name")

    @project_name.setter
    def project_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_name", value)

    @property
    @pulumi.getter(name="regionId")
    def region_id(self) -> Optional[pulumi.Input[str]]:
        """
        The region of the request.
        """
        return pulumi.get(self, "region_id")

    @region_id.setter
    def region_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region_id", value)

    @property
    @pulumi.getter(name="renewType")
    def renew_type(self) -> Optional[pulumi.Input[str]]:
        """
        The renew type of the CLB. When the value of the load_balancer_billing_type is `PrePaid`, the query returns this field.
        """
        return pulumi.get(self, "renew_type")

    @renew_type.setter
    def renew_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "renew_type", value)

    @property
    @pulumi.getter(name="slaveZoneId")
    def slave_zone_id(self) -> Optional[pulumi.Input[str]]:
        """
        The slave zone ID of the CLB.
        """
        return pulumi.get(self, "slave_zone_id")

    @slave_zone_id.setter
    def slave_zone_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "slave_zone_id", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[str]]:
        """
        The id of the Subnet.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subnet_id", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClbTagArgs']]]]:
        """
        Tags.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClbTagArgs']]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of the CLB. And optional choice contains `public` or `private`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[str]]:
        """
        The id of the VPC.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc_id", value)


class Clb(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 address_ip_version: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 eip_billing_config: Optional[pulumi.Input[pulumi.InputType['ClbEipBillingConfigArgs']]] = None,
                 eni_address: Optional[pulumi.Input[str]] = None,
                 eni_ipv6_address: Optional[pulumi.Input[str]] = None,
                 load_balancer_billing_type: Optional[pulumi.Input[str]] = None,
                 load_balancer_name: Optional[pulumi.Input[str]] = None,
                 load_balancer_spec: Optional[pulumi.Input[str]] = None,
                 master_zone_id: Optional[pulumi.Input[str]] = None,
                 modification_protection_reason: Optional[pulumi.Input[str]] = None,
                 modification_protection_status: Optional[pulumi.Input[str]] = None,
                 period: Optional[pulumi.Input[int]] = None,
                 project_name: Optional[pulumi.Input[str]] = None,
                 region_id: Optional[pulumi.Input[str]] = None,
                 slave_zone_id: Optional[pulumi.Input[str]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ClbTagArgs']]]]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_volcengine as volcengine

        foo_zones = volcengine.ecs.zones()
        foo_vpc = volcengine.vpc.Vpc("fooVpc",
            vpc_name="acc-test-vpc",
            cidr_block="172.16.0.0/16")
        foo_subnet = volcengine.vpc.Subnet("fooSubnet",
            subnet_name="acc-test-subnet",
            cidr_block="172.16.0.0/24",
            zone_id=foo_zones.zones[0].id,
            vpc_id=foo_vpc.id)
        # ipv4 public clb
        public_clb = volcengine.clb.Clb("publicClb",
            type="public",
            subnet_id=foo_subnet.id,
            load_balancer_name="acc-test-clb-public",
            load_balancer_spec="small_1",
            description="acc-test-demo",
            project_name="default",
            eip_billing_config=volcengine.clb.ClbEipBillingConfigArgs(
                isp="BGP",
                eip_billing_type="PostPaidByBandwidth",
                bandwidth=1,
            ),
            tags=[volcengine.clb.ClbTagArgs(
                key="k1",
                value="v1",
            )])
        # ipv4 private clb
        private_clb = volcengine.clb.Clb("privateClb",
            type="private",
            subnet_id=foo_subnet.id,
            load_balancer_name="acc-test-clb-private",
            load_balancer_spec="small_1",
            description="acc-test-demo",
            project_name="default")
        eip = volcengine.eip.Address("eip",
            billing_type="PostPaidByBandwidth",
            bandwidth=1,
            isp="BGP",
            description="tf-test",
            project_name="default")
        associate = volcengine.eip.Associate("associate",
            allocation_id=eip.id,
            instance_id=private_clb.id,
            instance_type="ClbInstance")
        # ipv6 private clb
        vpc_ipv6 = volcengine.vpc.Vpc("vpcIpv6",
            vpc_name="acc-test-vpc-ipv6",
            cidr_block="172.16.0.0/16",
            enable_ipv6=True)
        subnet_ipv6 = volcengine.vpc.Subnet("subnetIpv6",
            subnet_name="acc-test-subnet-ipv6",
            cidr_block="172.16.0.0/24",
            zone_id=foo_zones.zones[1].id,
            vpc_id=vpc_ipv6.id,
            ipv6_cidr_block=1)
        private_clb_ipv6 = volcengine.clb.Clb("privateClbIpv6",
            type="private",
            subnet_id=subnet_ipv6.id,
            load_balancer_name="acc-test-clb-ipv6",
            load_balancer_spec="small_1",
            description="acc-test-demo",
            project_name="default",
            address_ip_version="DualStack")
        ipv6_gateway = volcengine.vpc.Ipv6Gateway("ipv6Gateway", vpc_id=vpc_ipv6.id)
        foo_ipv6_address_bandwidth = volcengine.vpc.Ipv6AddressBandwidth("fooIpv6AddressBandwidth",
            ipv6_address=private_clb_ipv6.eni_ipv6_address,
            billing_type="PostPaidByBandwidth",
            bandwidth=5,
            opts=pulumi.ResourceOptions(depends_on=[ipv6_gateway]))
        ```

        ## Import

        CLB can be imported using the id, e.g.

        ```sh
         $ pulumi import volcengine:clb/clb:Clb default clb-273y2ok6ets007fap8txvf6us
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] address_ip_version: The address ip version of the Clb. Valid values: `ipv4`, `DualStack`. Default is `ipv4`.
               When the value of this field is `DualStack`, the type of the CLB must be `private`, and suggest using a combination of resource `vpc.Ipv6Gateway` and `vpc.Ipv6AddressBandwidth` to achieve ipv6 public network access function.
        :param pulumi.Input[str] description: The description of the CLB.
        :param pulumi.Input[pulumi.InputType['ClbEipBillingConfigArgs']] eip_billing_config: The billing configuration of the EIP which automatically associated to CLB. This field is valid when the type of CLB is `public`.When the type of the CLB is `private`, suggest using a combination of resource `eip.Address` and `eip.Associate` to achieve public network access function.
        :param pulumi.Input[str] eni_address: The eni address of the CLB.
        :param pulumi.Input[str] eni_ipv6_address: The eni ipv6 address of the Clb.
        :param pulumi.Input[str] load_balancer_billing_type: The billing type of the CLB, the value can be `PostPaid` or `PrePaid`.
        :param pulumi.Input[str] load_balancer_name: The name of the CLB.
        :param pulumi.Input[str] load_balancer_spec: The specification of the CLB, the value can be `small_1`, `small_2`, `medium_1`, `medium_2`, `large_1`, `large_2`.
        :param pulumi.Input[str] master_zone_id: The master zone ID of the CLB.
        :param pulumi.Input[str] modification_protection_reason: The reason of the console modification protection.
        :param pulumi.Input[str] modification_protection_status: The status of the console modification protection, the value can be `NonProtection` or `ConsoleProtection`.
        :param pulumi.Input[int] period: The period of the NatGateway, the valid value range in 1~9 or 12 or 24 or 36. Default value is 12. The period unit defaults to `Month`.This field is only effective when creating a PrePaid NatGateway. When importing resources, this attribute will not be imported. If this attribute is set, please use lifecycle and ignore_changes ignore changes in fields.
        :param pulumi.Input[str] project_name: The ProjectName of the CLB.
        :param pulumi.Input[str] region_id: The region of the request.
        :param pulumi.Input[str] slave_zone_id: The slave zone ID of the CLB.
        :param pulumi.Input[str] subnet_id: The id of the Subnet.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ClbTagArgs']]]] tags: Tags.
        :param pulumi.Input[str] type: The type of the CLB. And optional choice contains `public` or `private`.
        :param pulumi.Input[str] vpc_id: The id of the VPC.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ClbArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_volcengine as volcengine

        foo_zones = volcengine.ecs.zones()
        foo_vpc = volcengine.vpc.Vpc("fooVpc",
            vpc_name="acc-test-vpc",
            cidr_block="172.16.0.0/16")
        foo_subnet = volcengine.vpc.Subnet("fooSubnet",
            subnet_name="acc-test-subnet",
            cidr_block="172.16.0.0/24",
            zone_id=foo_zones.zones[0].id,
            vpc_id=foo_vpc.id)
        # ipv4 public clb
        public_clb = volcengine.clb.Clb("publicClb",
            type="public",
            subnet_id=foo_subnet.id,
            load_balancer_name="acc-test-clb-public",
            load_balancer_spec="small_1",
            description="acc-test-demo",
            project_name="default",
            eip_billing_config=volcengine.clb.ClbEipBillingConfigArgs(
                isp="BGP",
                eip_billing_type="PostPaidByBandwidth",
                bandwidth=1,
            ),
            tags=[volcengine.clb.ClbTagArgs(
                key="k1",
                value="v1",
            )])
        # ipv4 private clb
        private_clb = volcengine.clb.Clb("privateClb",
            type="private",
            subnet_id=foo_subnet.id,
            load_balancer_name="acc-test-clb-private",
            load_balancer_spec="small_1",
            description="acc-test-demo",
            project_name="default")
        eip = volcengine.eip.Address("eip",
            billing_type="PostPaidByBandwidth",
            bandwidth=1,
            isp="BGP",
            description="tf-test",
            project_name="default")
        associate = volcengine.eip.Associate("associate",
            allocation_id=eip.id,
            instance_id=private_clb.id,
            instance_type="ClbInstance")
        # ipv6 private clb
        vpc_ipv6 = volcengine.vpc.Vpc("vpcIpv6",
            vpc_name="acc-test-vpc-ipv6",
            cidr_block="172.16.0.0/16",
            enable_ipv6=True)
        subnet_ipv6 = volcengine.vpc.Subnet("subnetIpv6",
            subnet_name="acc-test-subnet-ipv6",
            cidr_block="172.16.0.0/24",
            zone_id=foo_zones.zones[1].id,
            vpc_id=vpc_ipv6.id,
            ipv6_cidr_block=1)
        private_clb_ipv6 = volcengine.clb.Clb("privateClbIpv6",
            type="private",
            subnet_id=subnet_ipv6.id,
            load_balancer_name="acc-test-clb-ipv6",
            load_balancer_spec="small_1",
            description="acc-test-demo",
            project_name="default",
            address_ip_version="DualStack")
        ipv6_gateway = volcengine.vpc.Ipv6Gateway("ipv6Gateway", vpc_id=vpc_ipv6.id)
        foo_ipv6_address_bandwidth = volcengine.vpc.Ipv6AddressBandwidth("fooIpv6AddressBandwidth",
            ipv6_address=private_clb_ipv6.eni_ipv6_address,
            billing_type="PostPaidByBandwidth",
            bandwidth=5,
            opts=pulumi.ResourceOptions(depends_on=[ipv6_gateway]))
        ```

        ## Import

        CLB can be imported using the id, e.g.

        ```sh
         $ pulumi import volcengine:clb/clb:Clb default clb-273y2ok6ets007fap8txvf6us
        ```

        :param str resource_name: The name of the resource.
        :param ClbArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ClbArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 address_ip_version: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 eip_billing_config: Optional[pulumi.Input[pulumi.InputType['ClbEipBillingConfigArgs']]] = None,
                 eni_address: Optional[pulumi.Input[str]] = None,
                 eni_ipv6_address: Optional[pulumi.Input[str]] = None,
                 load_balancer_billing_type: Optional[pulumi.Input[str]] = None,
                 load_balancer_name: Optional[pulumi.Input[str]] = None,
                 load_balancer_spec: Optional[pulumi.Input[str]] = None,
                 master_zone_id: Optional[pulumi.Input[str]] = None,
                 modification_protection_reason: Optional[pulumi.Input[str]] = None,
                 modification_protection_status: Optional[pulumi.Input[str]] = None,
                 period: Optional[pulumi.Input[int]] = None,
                 project_name: Optional[pulumi.Input[str]] = None,
                 region_id: Optional[pulumi.Input[str]] = None,
                 slave_zone_id: Optional[pulumi.Input[str]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ClbTagArgs']]]]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ClbArgs.__new__(ClbArgs)

            __props__.__dict__["address_ip_version"] = address_ip_version
            __props__.__dict__["description"] = description
            __props__.__dict__["eip_billing_config"] = eip_billing_config
            __props__.__dict__["eni_address"] = eni_address
            __props__.__dict__["eni_ipv6_address"] = eni_ipv6_address
            __props__.__dict__["load_balancer_billing_type"] = load_balancer_billing_type
            __props__.__dict__["load_balancer_name"] = load_balancer_name
            if load_balancer_spec is None and not opts.urn:
                raise TypeError("Missing required property 'load_balancer_spec'")
            __props__.__dict__["load_balancer_spec"] = load_balancer_spec
            __props__.__dict__["master_zone_id"] = master_zone_id
            __props__.__dict__["modification_protection_reason"] = modification_protection_reason
            __props__.__dict__["modification_protection_status"] = modification_protection_status
            __props__.__dict__["period"] = period
            __props__.__dict__["project_name"] = project_name
            __props__.__dict__["region_id"] = region_id
            __props__.__dict__["slave_zone_id"] = slave_zone_id
            if subnet_id is None and not opts.urn:
                raise TypeError("Missing required property 'subnet_id'")
            __props__.__dict__["subnet_id"] = subnet_id
            __props__.__dict__["tags"] = tags
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["vpc_id"] = vpc_id
            __props__.__dict__["eip_address"] = None
            __props__.__dict__["eip_id"] = None
            __props__.__dict__["ipv6_eip_id"] = None
            __props__.__dict__["renew_type"] = None
        super(Clb, __self__).__init__(
            'volcengine:clb/clb:Clb',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            address_ip_version: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            eip_address: Optional[pulumi.Input[str]] = None,
            eip_billing_config: Optional[pulumi.Input[pulumi.InputType['ClbEipBillingConfigArgs']]] = None,
            eip_id: Optional[pulumi.Input[str]] = None,
            eni_address: Optional[pulumi.Input[str]] = None,
            eni_ipv6_address: Optional[pulumi.Input[str]] = None,
            ipv6_eip_id: Optional[pulumi.Input[str]] = None,
            load_balancer_billing_type: Optional[pulumi.Input[str]] = None,
            load_balancer_name: Optional[pulumi.Input[str]] = None,
            load_balancer_spec: Optional[pulumi.Input[str]] = None,
            master_zone_id: Optional[pulumi.Input[str]] = None,
            modification_protection_reason: Optional[pulumi.Input[str]] = None,
            modification_protection_status: Optional[pulumi.Input[str]] = None,
            period: Optional[pulumi.Input[int]] = None,
            project_name: Optional[pulumi.Input[str]] = None,
            region_id: Optional[pulumi.Input[str]] = None,
            renew_type: Optional[pulumi.Input[str]] = None,
            slave_zone_id: Optional[pulumi.Input[str]] = None,
            subnet_id: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ClbTagArgs']]]]] = None,
            type: Optional[pulumi.Input[str]] = None,
            vpc_id: Optional[pulumi.Input[str]] = None) -> 'Clb':
        """
        Get an existing Clb resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] address_ip_version: The address ip version of the Clb. Valid values: `ipv4`, `DualStack`. Default is `ipv4`.
               When the value of this field is `DualStack`, the type of the CLB must be `private`, and suggest using a combination of resource `vpc.Ipv6Gateway` and `vpc.Ipv6AddressBandwidth` to achieve ipv6 public network access function.
        :param pulumi.Input[str] description: The description of the CLB.
        :param pulumi.Input[str] eip_address: The Eip address of the Clb.
        :param pulumi.Input[pulumi.InputType['ClbEipBillingConfigArgs']] eip_billing_config: The billing configuration of the EIP which automatically associated to CLB. This field is valid when the type of CLB is `public`.When the type of the CLB is `private`, suggest using a combination of resource `eip.Address` and `eip.Associate` to achieve public network access function.
        :param pulumi.Input[str] eip_id: The Eip ID of the Clb.
        :param pulumi.Input[str] eni_address: The eni address of the CLB.
        :param pulumi.Input[str] eni_ipv6_address: The eni ipv6 address of the Clb.
        :param pulumi.Input[str] ipv6_eip_id: The Ipv6 Eip ID of the Clb.
        :param pulumi.Input[str] load_balancer_billing_type: The billing type of the CLB, the value can be `PostPaid` or `PrePaid`.
        :param pulumi.Input[str] load_balancer_name: The name of the CLB.
        :param pulumi.Input[str] load_balancer_spec: The specification of the CLB, the value can be `small_1`, `small_2`, `medium_1`, `medium_2`, `large_1`, `large_2`.
        :param pulumi.Input[str] master_zone_id: The master zone ID of the CLB.
        :param pulumi.Input[str] modification_protection_reason: The reason of the console modification protection.
        :param pulumi.Input[str] modification_protection_status: The status of the console modification protection, the value can be `NonProtection` or `ConsoleProtection`.
        :param pulumi.Input[int] period: The period of the NatGateway, the valid value range in 1~9 or 12 or 24 or 36. Default value is 12. The period unit defaults to `Month`.This field is only effective when creating a PrePaid NatGateway. When importing resources, this attribute will not be imported. If this attribute is set, please use lifecycle and ignore_changes ignore changes in fields.
        :param pulumi.Input[str] project_name: The ProjectName of the CLB.
        :param pulumi.Input[str] region_id: The region of the request.
        :param pulumi.Input[str] renew_type: The renew type of the CLB. When the value of the load_balancer_billing_type is `PrePaid`, the query returns this field.
        :param pulumi.Input[str] slave_zone_id: The slave zone ID of the CLB.
        :param pulumi.Input[str] subnet_id: The id of the Subnet.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ClbTagArgs']]]] tags: Tags.
        :param pulumi.Input[str] type: The type of the CLB. And optional choice contains `public` or `private`.
        :param pulumi.Input[str] vpc_id: The id of the VPC.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ClbState.__new__(_ClbState)

        __props__.__dict__["address_ip_version"] = address_ip_version
        __props__.__dict__["description"] = description
        __props__.__dict__["eip_address"] = eip_address
        __props__.__dict__["eip_billing_config"] = eip_billing_config
        __props__.__dict__["eip_id"] = eip_id
        __props__.__dict__["eni_address"] = eni_address
        __props__.__dict__["eni_ipv6_address"] = eni_ipv6_address
        __props__.__dict__["ipv6_eip_id"] = ipv6_eip_id
        __props__.__dict__["load_balancer_billing_type"] = load_balancer_billing_type
        __props__.__dict__["load_balancer_name"] = load_balancer_name
        __props__.__dict__["load_balancer_spec"] = load_balancer_spec
        __props__.__dict__["master_zone_id"] = master_zone_id
        __props__.__dict__["modification_protection_reason"] = modification_protection_reason
        __props__.__dict__["modification_protection_status"] = modification_protection_status
        __props__.__dict__["period"] = period
        __props__.__dict__["project_name"] = project_name
        __props__.__dict__["region_id"] = region_id
        __props__.__dict__["renew_type"] = renew_type
        __props__.__dict__["slave_zone_id"] = slave_zone_id
        __props__.__dict__["subnet_id"] = subnet_id
        __props__.__dict__["tags"] = tags
        __props__.__dict__["type"] = type
        __props__.__dict__["vpc_id"] = vpc_id
        return Clb(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="addressIpVersion")
    def address_ip_version(self) -> pulumi.Output[Optional[str]]:
        """
        The address ip version of the Clb. Valid values: `ipv4`, `DualStack`. Default is `ipv4`.
        When the value of this field is `DualStack`, the type of the CLB must be `private`, and suggest using a combination of resource `vpc.Ipv6Gateway` and `vpc.Ipv6AddressBandwidth` to achieve ipv6 public network access function.
        """
        return pulumi.get(self, "address_ip_version")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        The description of the CLB.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="eipAddress")
    def eip_address(self) -> pulumi.Output[str]:
        """
        The Eip address of the Clb.
        """
        return pulumi.get(self, "eip_address")

    @property
    @pulumi.getter(name="eipBillingConfig")
    def eip_billing_config(self) -> pulumi.Output['outputs.ClbEipBillingConfig']:
        """
        The billing configuration of the EIP which automatically associated to CLB. This field is valid when the type of CLB is `public`.When the type of the CLB is `private`, suggest using a combination of resource `eip.Address` and `eip.Associate` to achieve public network access function.
        """
        return pulumi.get(self, "eip_billing_config")

    @property
    @pulumi.getter(name="eipId")
    def eip_id(self) -> pulumi.Output[str]:
        """
        The Eip ID of the Clb.
        """
        return pulumi.get(self, "eip_id")

    @property
    @pulumi.getter(name="eniAddress")
    def eni_address(self) -> pulumi.Output[str]:
        """
        The eni address of the CLB.
        """
        return pulumi.get(self, "eni_address")

    @property
    @pulumi.getter(name="eniIpv6Address")
    def eni_ipv6_address(self) -> pulumi.Output[str]:
        """
        The eni ipv6 address of the Clb.
        """
        return pulumi.get(self, "eni_ipv6_address")

    @property
    @pulumi.getter(name="ipv6EipId")
    def ipv6_eip_id(self) -> pulumi.Output[str]:
        """
        The Ipv6 Eip ID of the Clb.
        """
        return pulumi.get(self, "ipv6_eip_id")

    @property
    @pulumi.getter(name="loadBalancerBillingType")
    def load_balancer_billing_type(self) -> pulumi.Output[str]:
        """
        The billing type of the CLB, the value can be `PostPaid` or `PrePaid`.
        """
        return pulumi.get(self, "load_balancer_billing_type")

    @property
    @pulumi.getter(name="loadBalancerName")
    def load_balancer_name(self) -> pulumi.Output[str]:
        """
        The name of the CLB.
        """
        return pulumi.get(self, "load_balancer_name")

    @property
    @pulumi.getter(name="loadBalancerSpec")
    def load_balancer_spec(self) -> pulumi.Output[str]:
        """
        The specification of the CLB, the value can be `small_1`, `small_2`, `medium_1`, `medium_2`, `large_1`, `large_2`.
        """
        return pulumi.get(self, "load_balancer_spec")

    @property
    @pulumi.getter(name="masterZoneId")
    def master_zone_id(self) -> pulumi.Output[str]:
        """
        The master zone ID of the CLB.
        """
        return pulumi.get(self, "master_zone_id")

    @property
    @pulumi.getter(name="modificationProtectionReason")
    def modification_protection_reason(self) -> pulumi.Output[Optional[str]]:
        """
        The reason of the console modification protection.
        """
        return pulumi.get(self, "modification_protection_reason")

    @property
    @pulumi.getter(name="modificationProtectionStatus")
    def modification_protection_status(self) -> pulumi.Output[Optional[str]]:
        """
        The status of the console modification protection, the value can be `NonProtection` or `ConsoleProtection`.
        """
        return pulumi.get(self, "modification_protection_status")

    @property
    @pulumi.getter
    def period(self) -> pulumi.Output[Optional[int]]:
        """
        The period of the NatGateway, the valid value range in 1~9 or 12 or 24 or 36. Default value is 12. The period unit defaults to `Month`.This field is only effective when creating a PrePaid NatGateway. When importing resources, this attribute will not be imported. If this attribute is set, please use lifecycle and ignore_changes ignore changes in fields.
        """
        return pulumi.get(self, "period")

    @property
    @pulumi.getter(name="projectName")
    def project_name(self) -> pulumi.Output[str]:
        """
        The ProjectName of the CLB.
        """
        return pulumi.get(self, "project_name")

    @property
    @pulumi.getter(name="regionId")
    def region_id(self) -> pulumi.Output[str]:
        """
        The region of the request.
        """
        return pulumi.get(self, "region_id")

    @property
    @pulumi.getter(name="renewType")
    def renew_type(self) -> pulumi.Output[str]:
        """
        The renew type of the CLB. When the value of the load_balancer_billing_type is `PrePaid`, the query returns this field.
        """
        return pulumi.get(self, "renew_type")

    @property
    @pulumi.getter(name="slaveZoneId")
    def slave_zone_id(self) -> pulumi.Output[str]:
        """
        The slave zone ID of the CLB.
        """
        return pulumi.get(self, "slave_zone_id")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Output[str]:
        """
        The id of the Subnet.
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['outputs.ClbTag']]]:
        """
        Tags.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        The type of the CLB. And optional choice contains `public` or `private`.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[str]:
        """
        The id of the VPC.
        """
        return pulumi.get(self, "vpc_id")

