# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ListenerArgs', 'Listener']

@pulumi.input_type
class ListenerArgs:
    def __init__(__self__, *,
                 load_balancer_id: pulumi.Input[str],
                 port: pulumi.Input[int],
                 protocol: pulumi.Input[str],
                 server_group_id: pulumi.Input[str],
                 acl_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 acl_status: Optional[pulumi.Input[str]] = None,
                 acl_type: Optional[pulumi.Input[str]] = None,
                 bandwidth: Optional[pulumi.Input[int]] = None,
                 certificate_id: Optional[pulumi.Input[str]] = None,
                 connection_drain_enabled: Optional[pulumi.Input[str]] = None,
                 connection_drain_timeout: Optional[pulumi.Input[int]] = None,
                 cookie: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 enabled: Optional[pulumi.Input[str]] = None,
                 established_timeout: Optional[pulumi.Input[int]] = None,
                 health_check: Optional[pulumi.Input['ListenerHealthCheckArgs']] = None,
                 listener_name: Optional[pulumi.Input[str]] = None,
                 persistence_timeout: Optional[pulumi.Input[int]] = None,
                 persistence_type: Optional[pulumi.Input[str]] = None,
                 proxy_protocol_type: Optional[pulumi.Input[str]] = None,
                 scheduler: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Listener resource.
        :param pulumi.Input[str] load_balancer_id: The region of the request.
        :param pulumi.Input[int] port: The port receiving request of the Listener, the value range in 1~65535.
        :param pulumi.Input[str] protocol: The protocol of the Listener. Optional choice contains `TCP`, `UDP`, `HTTP`, `HTTPS`.
        :param pulumi.Input[str] server_group_id: The server group id associated with the listener.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] acl_ids: The id list of the Acl.
        :param pulumi.Input[str] acl_status: The enable status of Acl. Optional choice contains `on`, `off`.
        :param pulumi.Input[str] acl_type: The type of the Acl. Optional choice contains `white`, `black`.
        :param pulumi.Input[int] bandwidth: The bandwidth of the Listener. Unit: Mbps. Default is -1, indicating that the Listener does not specify a speed limit.
        :param pulumi.Input[str] certificate_id: The certificate id associated with the listener.
        :param pulumi.Input[str] connection_drain_enabled: Whether to enable connection drain of the Listener. Valid values: `off`, `on`. Default is `off`.
               This filed is valid only when the value of field `protocol` is `TCP` or `UDP`.
        :param pulumi.Input[int] connection_drain_timeout: The connection drain timeout of the Listener. Valid value range is `1-900`.
               This filed is required when the value of field `connection_drain_enabled` is `on`.
        :param pulumi.Input[str] cookie: The name of the cookie for session persistence configured on the backend server. When PersistenceType is configured as `server`, this parameter is required. When PersistenceType is configured as any other value, this parameter is not effective.
        :param pulumi.Input[str] description: The description of the Listener.
        :param pulumi.Input[str] enabled: The enable status of the Listener. Optional choice contains `on`, `off`.
        :param pulumi.Input[int] established_timeout: The connection timeout of the Listener.
        :param pulumi.Input['ListenerHealthCheckArgs'] health_check: The config of health check.
        :param pulumi.Input[str] listener_name: The name of the Listener.
        :param pulumi.Input[int] persistence_timeout: The persistence timeout of the Listener. Unit: second. Default is `1000`. When PersistenceType is configured as source_ip, the value range is 1-3600. When PersistenceType is configured as insert, the value range is 1-86400. This filed is valid only when the value of field `persistence_type` is `source_ip` or `insert`.
        :param pulumi.Input[str] persistence_type: The persistence type of the Listener. Valid values: `off`, `source_ip`, `insert`, `server`. Default is `off`.
               `source_ip`: Represents the source IP address, only effective for TCP/UDP protocols. `insert`: means implanting a cookie, only effective for HTTP/HTTPS protocol and when the scheduler is `wrr`. `server`: Indicates rewriting cookies, only effective for HTTP/HTTPS protocols and when the scheduler is `wrr`.
        :param pulumi.Input[str] proxy_protocol_type: Whether to enable proxy protocol. Valid values: `off`, `standard`. Default is `off`.
               This filed is valid only when the value of field `protocol` is `TCP` or `UDP`.
        :param pulumi.Input[str] scheduler: The scheduling algorithm of the Listener. Optional choice contains `wrr`, `wlc`, `sh`.
        """
        pulumi.set(__self__, "load_balancer_id", load_balancer_id)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "protocol", protocol)
        pulumi.set(__self__, "server_group_id", server_group_id)
        if acl_ids is not None:
            pulumi.set(__self__, "acl_ids", acl_ids)
        if acl_status is not None:
            pulumi.set(__self__, "acl_status", acl_status)
        if acl_type is not None:
            pulumi.set(__self__, "acl_type", acl_type)
        if bandwidth is not None:
            pulumi.set(__self__, "bandwidth", bandwidth)
        if certificate_id is not None:
            pulumi.set(__self__, "certificate_id", certificate_id)
        if connection_drain_enabled is not None:
            pulumi.set(__self__, "connection_drain_enabled", connection_drain_enabled)
        if connection_drain_timeout is not None:
            pulumi.set(__self__, "connection_drain_timeout", connection_drain_timeout)
        if cookie is not None:
            pulumi.set(__self__, "cookie", cookie)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if established_timeout is not None:
            pulumi.set(__self__, "established_timeout", established_timeout)
        if health_check is not None:
            pulumi.set(__self__, "health_check", health_check)
        if listener_name is not None:
            pulumi.set(__self__, "listener_name", listener_name)
        if persistence_timeout is not None:
            pulumi.set(__self__, "persistence_timeout", persistence_timeout)
        if persistence_type is not None:
            pulumi.set(__self__, "persistence_type", persistence_type)
        if proxy_protocol_type is not None:
            pulumi.set(__self__, "proxy_protocol_type", proxy_protocol_type)
        if scheduler is not None:
            pulumi.set(__self__, "scheduler", scheduler)

    @property
    @pulumi.getter(name="loadBalancerId")
    def load_balancer_id(self) -> pulumi.Input[str]:
        """
        The region of the request.
        """
        return pulumi.get(self, "load_balancer_id")

    @load_balancer_id.setter
    def load_balancer_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "load_balancer_id", value)

    @property
    @pulumi.getter
    def port(self) -> pulumi.Input[int]:
        """
        The port receiving request of the Listener, the value range in 1~65535.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: pulumi.Input[int]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter
    def protocol(self) -> pulumi.Input[str]:
        """
        The protocol of the Listener. Optional choice contains `TCP`, `UDP`, `HTTP`, `HTTPS`.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: pulumi.Input[str]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter(name="serverGroupId")
    def server_group_id(self) -> pulumi.Input[str]:
        """
        The server group id associated with the listener.
        """
        return pulumi.get(self, "server_group_id")

    @server_group_id.setter
    def server_group_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "server_group_id", value)

    @property
    @pulumi.getter(name="aclIds")
    def acl_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The id list of the Acl.
        """
        return pulumi.get(self, "acl_ids")

    @acl_ids.setter
    def acl_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "acl_ids", value)

    @property
    @pulumi.getter(name="aclStatus")
    def acl_status(self) -> Optional[pulumi.Input[str]]:
        """
        The enable status of Acl. Optional choice contains `on`, `off`.
        """
        return pulumi.get(self, "acl_status")

    @acl_status.setter
    def acl_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "acl_status", value)

    @property
    @pulumi.getter(name="aclType")
    def acl_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of the Acl. Optional choice contains `white`, `black`.
        """
        return pulumi.get(self, "acl_type")

    @acl_type.setter
    def acl_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "acl_type", value)

    @property
    @pulumi.getter
    def bandwidth(self) -> Optional[pulumi.Input[int]]:
        """
        The bandwidth of the Listener. Unit: Mbps. Default is -1, indicating that the Listener does not specify a speed limit.
        """
        return pulumi.get(self, "bandwidth")

    @bandwidth.setter
    def bandwidth(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "bandwidth", value)

    @property
    @pulumi.getter(name="certificateId")
    def certificate_id(self) -> Optional[pulumi.Input[str]]:
        """
        The certificate id associated with the listener.
        """
        return pulumi.get(self, "certificate_id")

    @certificate_id.setter
    def certificate_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "certificate_id", value)

    @property
    @pulumi.getter(name="connectionDrainEnabled")
    def connection_drain_enabled(self) -> Optional[pulumi.Input[str]]:
        """
        Whether to enable connection drain of the Listener. Valid values: `off`, `on`. Default is `off`.
        This filed is valid only when the value of field `protocol` is `TCP` or `UDP`.
        """
        return pulumi.get(self, "connection_drain_enabled")

    @connection_drain_enabled.setter
    def connection_drain_enabled(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "connection_drain_enabled", value)

    @property
    @pulumi.getter(name="connectionDrainTimeout")
    def connection_drain_timeout(self) -> Optional[pulumi.Input[int]]:
        """
        The connection drain timeout of the Listener. Valid value range is `1-900`.
        This filed is required when the value of field `connection_drain_enabled` is `on`.
        """
        return pulumi.get(self, "connection_drain_timeout")

    @connection_drain_timeout.setter
    def connection_drain_timeout(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "connection_drain_timeout", value)

    @property
    @pulumi.getter
    def cookie(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the cookie for session persistence configured on the backend server. When PersistenceType is configured as `server`, this parameter is required. When PersistenceType is configured as any other value, this parameter is not effective.
        """
        return pulumi.get(self, "cookie")

    @cookie.setter
    def cookie(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cookie", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the Listener.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[str]]:
        """
        The enable status of the Listener. Optional choice contains `on`, `off`.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="establishedTimeout")
    def established_timeout(self) -> Optional[pulumi.Input[int]]:
        """
        The connection timeout of the Listener.
        """
        return pulumi.get(self, "established_timeout")

    @established_timeout.setter
    def established_timeout(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "established_timeout", value)

    @property
    @pulumi.getter(name="healthCheck")
    def health_check(self) -> Optional[pulumi.Input['ListenerHealthCheckArgs']]:
        """
        The config of health check.
        """
        return pulumi.get(self, "health_check")

    @health_check.setter
    def health_check(self, value: Optional[pulumi.Input['ListenerHealthCheckArgs']]):
        pulumi.set(self, "health_check", value)

    @property
    @pulumi.getter(name="listenerName")
    def listener_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Listener.
        """
        return pulumi.get(self, "listener_name")

    @listener_name.setter
    def listener_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "listener_name", value)

    @property
    @pulumi.getter(name="persistenceTimeout")
    def persistence_timeout(self) -> Optional[pulumi.Input[int]]:
        """
        The persistence timeout of the Listener. Unit: second. Default is `1000`. When PersistenceType is configured as source_ip, the value range is 1-3600. When PersistenceType is configured as insert, the value range is 1-86400. This filed is valid only when the value of field `persistence_type` is `source_ip` or `insert`.
        """
        return pulumi.get(self, "persistence_timeout")

    @persistence_timeout.setter
    def persistence_timeout(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "persistence_timeout", value)

    @property
    @pulumi.getter(name="persistenceType")
    def persistence_type(self) -> Optional[pulumi.Input[str]]:
        """
        The persistence type of the Listener. Valid values: `off`, `source_ip`, `insert`, `server`. Default is `off`.
        `source_ip`: Represents the source IP address, only effective for TCP/UDP protocols. `insert`: means implanting a cookie, only effective for HTTP/HTTPS protocol and when the scheduler is `wrr`. `server`: Indicates rewriting cookies, only effective for HTTP/HTTPS protocols and when the scheduler is `wrr`.
        """
        return pulumi.get(self, "persistence_type")

    @persistence_type.setter
    def persistence_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "persistence_type", value)

    @property
    @pulumi.getter(name="proxyProtocolType")
    def proxy_protocol_type(self) -> Optional[pulumi.Input[str]]:
        """
        Whether to enable proxy protocol. Valid values: `off`, `standard`. Default is `off`.
        This filed is valid only when the value of field `protocol` is `TCP` or `UDP`.
        """
        return pulumi.get(self, "proxy_protocol_type")

    @proxy_protocol_type.setter
    def proxy_protocol_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "proxy_protocol_type", value)

    @property
    @pulumi.getter
    def scheduler(self) -> Optional[pulumi.Input[str]]:
        """
        The scheduling algorithm of the Listener. Optional choice contains `wrr`, `wlc`, `sh`.
        """
        return pulumi.get(self, "scheduler")

    @scheduler.setter
    def scheduler(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "scheduler", value)


@pulumi.input_type
class _ListenerState:
    def __init__(__self__, *,
                 acl_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 acl_status: Optional[pulumi.Input[str]] = None,
                 acl_type: Optional[pulumi.Input[str]] = None,
                 bandwidth: Optional[pulumi.Input[int]] = None,
                 certificate_id: Optional[pulumi.Input[str]] = None,
                 connection_drain_enabled: Optional[pulumi.Input[str]] = None,
                 connection_drain_timeout: Optional[pulumi.Input[int]] = None,
                 cookie: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 enabled: Optional[pulumi.Input[str]] = None,
                 established_timeout: Optional[pulumi.Input[int]] = None,
                 health_check: Optional[pulumi.Input['ListenerHealthCheckArgs']] = None,
                 listener_id: Optional[pulumi.Input[str]] = None,
                 listener_name: Optional[pulumi.Input[str]] = None,
                 load_balancer_id: Optional[pulumi.Input[str]] = None,
                 persistence_timeout: Optional[pulumi.Input[int]] = None,
                 persistence_type: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 protocol: Optional[pulumi.Input[str]] = None,
                 proxy_protocol_type: Optional[pulumi.Input[str]] = None,
                 scheduler: Optional[pulumi.Input[str]] = None,
                 server_group_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Listener resources.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] acl_ids: The id list of the Acl.
        :param pulumi.Input[str] acl_status: The enable status of Acl. Optional choice contains `on`, `off`.
        :param pulumi.Input[str] acl_type: The type of the Acl. Optional choice contains `white`, `black`.
        :param pulumi.Input[int] bandwidth: The bandwidth of the Listener. Unit: Mbps. Default is -1, indicating that the Listener does not specify a speed limit.
        :param pulumi.Input[str] certificate_id: The certificate id associated with the listener.
        :param pulumi.Input[str] connection_drain_enabled: Whether to enable connection drain of the Listener. Valid values: `off`, `on`. Default is `off`.
               This filed is valid only when the value of field `protocol` is `TCP` or `UDP`.
        :param pulumi.Input[int] connection_drain_timeout: The connection drain timeout of the Listener. Valid value range is `1-900`.
               This filed is required when the value of field `connection_drain_enabled` is `on`.
        :param pulumi.Input[str] cookie: The name of the cookie for session persistence configured on the backend server. When PersistenceType is configured as `server`, this parameter is required. When PersistenceType is configured as any other value, this parameter is not effective.
        :param pulumi.Input[str] description: The description of the Listener.
        :param pulumi.Input[str] enabled: The enable status of the Listener. Optional choice contains `on`, `off`.
        :param pulumi.Input[int] established_timeout: The connection timeout of the Listener.
        :param pulumi.Input['ListenerHealthCheckArgs'] health_check: The config of health check.
        :param pulumi.Input[str] listener_id: The ID of the Listener.
        :param pulumi.Input[str] listener_name: The name of the Listener.
        :param pulumi.Input[str] load_balancer_id: The region of the request.
        :param pulumi.Input[int] persistence_timeout: The persistence timeout of the Listener. Unit: second. Default is `1000`. When PersistenceType is configured as source_ip, the value range is 1-3600. When PersistenceType is configured as insert, the value range is 1-86400. This filed is valid only when the value of field `persistence_type` is `source_ip` or `insert`.
        :param pulumi.Input[str] persistence_type: The persistence type of the Listener. Valid values: `off`, `source_ip`, `insert`, `server`. Default is `off`.
               `source_ip`: Represents the source IP address, only effective for TCP/UDP protocols. `insert`: means implanting a cookie, only effective for HTTP/HTTPS protocol and when the scheduler is `wrr`. `server`: Indicates rewriting cookies, only effective for HTTP/HTTPS protocols and when the scheduler is `wrr`.
        :param pulumi.Input[int] port: The port receiving request of the Listener, the value range in 1~65535.
        :param pulumi.Input[str] protocol: The protocol of the Listener. Optional choice contains `TCP`, `UDP`, `HTTP`, `HTTPS`.
        :param pulumi.Input[str] proxy_protocol_type: Whether to enable proxy protocol. Valid values: `off`, `standard`. Default is `off`.
               This filed is valid only when the value of field `protocol` is `TCP` or `UDP`.
        :param pulumi.Input[str] scheduler: The scheduling algorithm of the Listener. Optional choice contains `wrr`, `wlc`, `sh`.
        :param pulumi.Input[str] server_group_id: The server group id associated with the listener.
        """
        if acl_ids is not None:
            pulumi.set(__self__, "acl_ids", acl_ids)
        if acl_status is not None:
            pulumi.set(__self__, "acl_status", acl_status)
        if acl_type is not None:
            pulumi.set(__self__, "acl_type", acl_type)
        if bandwidth is not None:
            pulumi.set(__self__, "bandwidth", bandwidth)
        if certificate_id is not None:
            pulumi.set(__self__, "certificate_id", certificate_id)
        if connection_drain_enabled is not None:
            pulumi.set(__self__, "connection_drain_enabled", connection_drain_enabled)
        if connection_drain_timeout is not None:
            pulumi.set(__self__, "connection_drain_timeout", connection_drain_timeout)
        if cookie is not None:
            pulumi.set(__self__, "cookie", cookie)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if established_timeout is not None:
            pulumi.set(__self__, "established_timeout", established_timeout)
        if health_check is not None:
            pulumi.set(__self__, "health_check", health_check)
        if listener_id is not None:
            pulumi.set(__self__, "listener_id", listener_id)
        if listener_name is not None:
            pulumi.set(__self__, "listener_name", listener_name)
        if load_balancer_id is not None:
            pulumi.set(__self__, "load_balancer_id", load_balancer_id)
        if persistence_timeout is not None:
            pulumi.set(__self__, "persistence_timeout", persistence_timeout)
        if persistence_type is not None:
            pulumi.set(__self__, "persistence_type", persistence_type)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if proxy_protocol_type is not None:
            pulumi.set(__self__, "proxy_protocol_type", proxy_protocol_type)
        if scheduler is not None:
            pulumi.set(__self__, "scheduler", scheduler)
        if server_group_id is not None:
            pulumi.set(__self__, "server_group_id", server_group_id)

    @property
    @pulumi.getter(name="aclIds")
    def acl_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The id list of the Acl.
        """
        return pulumi.get(self, "acl_ids")

    @acl_ids.setter
    def acl_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "acl_ids", value)

    @property
    @pulumi.getter(name="aclStatus")
    def acl_status(self) -> Optional[pulumi.Input[str]]:
        """
        The enable status of Acl. Optional choice contains `on`, `off`.
        """
        return pulumi.get(self, "acl_status")

    @acl_status.setter
    def acl_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "acl_status", value)

    @property
    @pulumi.getter(name="aclType")
    def acl_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of the Acl. Optional choice contains `white`, `black`.
        """
        return pulumi.get(self, "acl_type")

    @acl_type.setter
    def acl_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "acl_type", value)

    @property
    @pulumi.getter
    def bandwidth(self) -> Optional[pulumi.Input[int]]:
        """
        The bandwidth of the Listener. Unit: Mbps. Default is -1, indicating that the Listener does not specify a speed limit.
        """
        return pulumi.get(self, "bandwidth")

    @bandwidth.setter
    def bandwidth(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "bandwidth", value)

    @property
    @pulumi.getter(name="certificateId")
    def certificate_id(self) -> Optional[pulumi.Input[str]]:
        """
        The certificate id associated with the listener.
        """
        return pulumi.get(self, "certificate_id")

    @certificate_id.setter
    def certificate_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "certificate_id", value)

    @property
    @pulumi.getter(name="connectionDrainEnabled")
    def connection_drain_enabled(self) -> Optional[pulumi.Input[str]]:
        """
        Whether to enable connection drain of the Listener. Valid values: `off`, `on`. Default is `off`.
        This filed is valid only when the value of field `protocol` is `TCP` or `UDP`.
        """
        return pulumi.get(self, "connection_drain_enabled")

    @connection_drain_enabled.setter
    def connection_drain_enabled(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "connection_drain_enabled", value)

    @property
    @pulumi.getter(name="connectionDrainTimeout")
    def connection_drain_timeout(self) -> Optional[pulumi.Input[int]]:
        """
        The connection drain timeout of the Listener. Valid value range is `1-900`.
        This filed is required when the value of field `connection_drain_enabled` is `on`.
        """
        return pulumi.get(self, "connection_drain_timeout")

    @connection_drain_timeout.setter
    def connection_drain_timeout(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "connection_drain_timeout", value)

    @property
    @pulumi.getter
    def cookie(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the cookie for session persistence configured on the backend server. When PersistenceType is configured as `server`, this parameter is required. When PersistenceType is configured as any other value, this parameter is not effective.
        """
        return pulumi.get(self, "cookie")

    @cookie.setter
    def cookie(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cookie", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the Listener.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[str]]:
        """
        The enable status of the Listener. Optional choice contains `on`, `off`.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="establishedTimeout")
    def established_timeout(self) -> Optional[pulumi.Input[int]]:
        """
        The connection timeout of the Listener.
        """
        return pulumi.get(self, "established_timeout")

    @established_timeout.setter
    def established_timeout(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "established_timeout", value)

    @property
    @pulumi.getter(name="healthCheck")
    def health_check(self) -> Optional[pulumi.Input['ListenerHealthCheckArgs']]:
        """
        The config of health check.
        """
        return pulumi.get(self, "health_check")

    @health_check.setter
    def health_check(self, value: Optional[pulumi.Input['ListenerHealthCheckArgs']]):
        pulumi.set(self, "health_check", value)

    @property
    @pulumi.getter(name="listenerId")
    def listener_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the Listener.
        """
        return pulumi.get(self, "listener_id")

    @listener_id.setter
    def listener_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "listener_id", value)

    @property
    @pulumi.getter(name="listenerName")
    def listener_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Listener.
        """
        return pulumi.get(self, "listener_name")

    @listener_name.setter
    def listener_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "listener_name", value)

    @property
    @pulumi.getter(name="loadBalancerId")
    def load_balancer_id(self) -> Optional[pulumi.Input[str]]:
        """
        The region of the request.
        """
        return pulumi.get(self, "load_balancer_id")

    @load_balancer_id.setter
    def load_balancer_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "load_balancer_id", value)

    @property
    @pulumi.getter(name="persistenceTimeout")
    def persistence_timeout(self) -> Optional[pulumi.Input[int]]:
        """
        The persistence timeout of the Listener. Unit: second. Default is `1000`. When PersistenceType is configured as source_ip, the value range is 1-3600. When PersistenceType is configured as insert, the value range is 1-86400. This filed is valid only when the value of field `persistence_type` is `source_ip` or `insert`.
        """
        return pulumi.get(self, "persistence_timeout")

    @persistence_timeout.setter
    def persistence_timeout(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "persistence_timeout", value)

    @property
    @pulumi.getter(name="persistenceType")
    def persistence_type(self) -> Optional[pulumi.Input[str]]:
        """
        The persistence type of the Listener. Valid values: `off`, `source_ip`, `insert`, `server`. Default is `off`.
        `source_ip`: Represents the source IP address, only effective for TCP/UDP protocols. `insert`: means implanting a cookie, only effective for HTTP/HTTPS protocol and when the scheduler is `wrr`. `server`: Indicates rewriting cookies, only effective for HTTP/HTTPS protocols and when the scheduler is `wrr`.
        """
        return pulumi.get(self, "persistence_type")

    @persistence_type.setter
    def persistence_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "persistence_type", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        The port receiving request of the Listener, the value range in 1~65535.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[str]]:
        """
        The protocol of the Listener. Optional choice contains `TCP`, `UDP`, `HTTP`, `HTTPS`.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter(name="proxyProtocolType")
    def proxy_protocol_type(self) -> Optional[pulumi.Input[str]]:
        """
        Whether to enable proxy protocol. Valid values: `off`, `standard`. Default is `off`.
        This filed is valid only when the value of field `protocol` is `TCP` or `UDP`.
        """
        return pulumi.get(self, "proxy_protocol_type")

    @proxy_protocol_type.setter
    def proxy_protocol_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "proxy_protocol_type", value)

    @property
    @pulumi.getter
    def scheduler(self) -> Optional[pulumi.Input[str]]:
        """
        The scheduling algorithm of the Listener. Optional choice contains `wrr`, `wlc`, `sh`.
        """
        return pulumi.get(self, "scheduler")

    @scheduler.setter
    def scheduler(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "scheduler", value)

    @property
    @pulumi.getter(name="serverGroupId")
    def server_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        The server group id associated with the listener.
        """
        return pulumi.get(self, "server_group_id")

    @server_group_id.setter
    def server_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "server_group_id", value)


class Listener(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 acl_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 acl_status: Optional[pulumi.Input[str]] = None,
                 acl_type: Optional[pulumi.Input[str]] = None,
                 bandwidth: Optional[pulumi.Input[int]] = None,
                 certificate_id: Optional[pulumi.Input[str]] = None,
                 connection_drain_enabled: Optional[pulumi.Input[str]] = None,
                 connection_drain_timeout: Optional[pulumi.Input[int]] = None,
                 cookie: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 enabled: Optional[pulumi.Input[str]] = None,
                 established_timeout: Optional[pulumi.Input[int]] = None,
                 health_check: Optional[pulumi.Input[pulumi.InputType['ListenerHealthCheckArgs']]] = None,
                 listener_name: Optional[pulumi.Input[str]] = None,
                 load_balancer_id: Optional[pulumi.Input[str]] = None,
                 persistence_timeout: Optional[pulumi.Input[int]] = None,
                 persistence_type: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 protocol: Optional[pulumi.Input[str]] = None,
                 proxy_protocol_type: Optional[pulumi.Input[str]] = None,
                 scheduler: Optional[pulumi.Input[str]] = None,
                 server_group_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a resource to manage listener
        ## Example Usage

        ```python
        import pulumi
        import pulumi_volcengine as volcengine

        foo_zones = volcengine.ecs.zones()
        foo_vpc = volcengine.vpc.Vpc("fooVpc",
            vpc_name="acc-test-vpc",
            cidr_block="172.16.0.0/16")
        foo_subnet = volcengine.vpc.Subnet("fooSubnet",
            subnet_name="acc-test-subnet",
            cidr_block="172.16.0.0/24",
            zone_id=foo_zones.zones[0].id,
            vpc_id=foo_vpc.id)
        foo_clb = volcengine.clb.Clb("fooClb",
            type="public",
            subnet_id=foo_subnet.id,
            load_balancer_spec="small_1",
            description="acc0Demo",
            load_balancer_name="acc-test-create",
            eip_billing_config=volcengine.clb.ClbEipBillingConfigArgs(
                isp="BGP",
                eip_billing_type="PostPaidByBandwidth",
                bandwidth=1,
            ))
        foo_server_group = volcengine.clb.ServerGroup("fooServerGroup",
            load_balancer_id=foo_clb.id,
            server_group_name="acc-test-create",
            description="hello demo11")
        foo_listener = volcengine.clb.Listener("fooListener",
            load_balancer_id=foo_clb.id,
            listener_name="acc-test-listener",
            protocol="HTTP",
            port=90,
            server_group_id=foo_server_group.id,
            health_check=volcengine.clb.ListenerHealthCheckArgs(
                enabled="on",
                interval=10,
                timeout=3,
                healthy_threshold=5,
                un_healthy_threshold=2,
                domain="volcengine.com",
                http_code="http_2xx",
                method="GET",
                uri="/",
            ),
            enabled="on")
        foo_tcp = volcengine.clb.Listener("fooTcp",
            load_balancer_id=foo_clb.id,
            listener_name="acc-test-listener",
            protocol="TCP",
            port=90,
            server_group_id=foo_server_group.id,
            enabled="on",
            bandwidth=2,
            proxy_protocol_type="standard",
            persistence_type="source_ip",
            persistence_timeout=100,
            connection_drain_enabled="on",
            connection_drain_timeout=100)
        ```

        ## Import

        Listener can be imported using the id, e.g.

        ```sh
         $ pulumi import volcengine:clb/listener:Listener default lsn-273yv0mhs5xj47fap8sehiiso
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] acl_ids: The id list of the Acl.
        :param pulumi.Input[str] acl_status: The enable status of Acl. Optional choice contains `on`, `off`.
        :param pulumi.Input[str] acl_type: The type of the Acl. Optional choice contains `white`, `black`.
        :param pulumi.Input[int] bandwidth: The bandwidth of the Listener. Unit: Mbps. Default is -1, indicating that the Listener does not specify a speed limit.
        :param pulumi.Input[str] certificate_id: The certificate id associated with the listener.
        :param pulumi.Input[str] connection_drain_enabled: Whether to enable connection drain of the Listener. Valid values: `off`, `on`. Default is `off`.
               This filed is valid only when the value of field `protocol` is `TCP` or `UDP`.
        :param pulumi.Input[int] connection_drain_timeout: The connection drain timeout of the Listener. Valid value range is `1-900`.
               This filed is required when the value of field `connection_drain_enabled` is `on`.
        :param pulumi.Input[str] cookie: The name of the cookie for session persistence configured on the backend server. When PersistenceType is configured as `server`, this parameter is required. When PersistenceType is configured as any other value, this parameter is not effective.
        :param pulumi.Input[str] description: The description of the Listener.
        :param pulumi.Input[str] enabled: The enable status of the Listener. Optional choice contains `on`, `off`.
        :param pulumi.Input[int] established_timeout: The connection timeout of the Listener.
        :param pulumi.Input[pulumi.InputType['ListenerHealthCheckArgs']] health_check: The config of health check.
        :param pulumi.Input[str] listener_name: The name of the Listener.
        :param pulumi.Input[str] load_balancer_id: The region of the request.
        :param pulumi.Input[int] persistence_timeout: The persistence timeout of the Listener. Unit: second. Default is `1000`. When PersistenceType is configured as source_ip, the value range is 1-3600. When PersistenceType is configured as insert, the value range is 1-86400. This filed is valid only when the value of field `persistence_type` is `source_ip` or `insert`.
        :param pulumi.Input[str] persistence_type: The persistence type of the Listener. Valid values: `off`, `source_ip`, `insert`, `server`. Default is `off`.
               `source_ip`: Represents the source IP address, only effective for TCP/UDP protocols. `insert`: means implanting a cookie, only effective for HTTP/HTTPS protocol and when the scheduler is `wrr`. `server`: Indicates rewriting cookies, only effective for HTTP/HTTPS protocols and when the scheduler is `wrr`.
        :param pulumi.Input[int] port: The port receiving request of the Listener, the value range in 1~65535.
        :param pulumi.Input[str] protocol: The protocol of the Listener. Optional choice contains `TCP`, `UDP`, `HTTP`, `HTTPS`.
        :param pulumi.Input[str] proxy_protocol_type: Whether to enable proxy protocol. Valid values: `off`, `standard`. Default is `off`.
               This filed is valid only when the value of field `protocol` is `TCP` or `UDP`.
        :param pulumi.Input[str] scheduler: The scheduling algorithm of the Listener. Optional choice contains `wrr`, `wlc`, `sh`.
        :param pulumi.Input[str] server_group_id: The server group id associated with the listener.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ListenerArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a resource to manage listener
        ## Example Usage

        ```python
        import pulumi
        import pulumi_volcengine as volcengine

        foo_zones = volcengine.ecs.zones()
        foo_vpc = volcengine.vpc.Vpc("fooVpc",
            vpc_name="acc-test-vpc",
            cidr_block="172.16.0.0/16")
        foo_subnet = volcengine.vpc.Subnet("fooSubnet",
            subnet_name="acc-test-subnet",
            cidr_block="172.16.0.0/24",
            zone_id=foo_zones.zones[0].id,
            vpc_id=foo_vpc.id)
        foo_clb = volcengine.clb.Clb("fooClb",
            type="public",
            subnet_id=foo_subnet.id,
            load_balancer_spec="small_1",
            description="acc0Demo",
            load_balancer_name="acc-test-create",
            eip_billing_config=volcengine.clb.ClbEipBillingConfigArgs(
                isp="BGP",
                eip_billing_type="PostPaidByBandwidth",
                bandwidth=1,
            ))
        foo_server_group = volcengine.clb.ServerGroup("fooServerGroup",
            load_balancer_id=foo_clb.id,
            server_group_name="acc-test-create",
            description="hello demo11")
        foo_listener = volcengine.clb.Listener("fooListener",
            load_balancer_id=foo_clb.id,
            listener_name="acc-test-listener",
            protocol="HTTP",
            port=90,
            server_group_id=foo_server_group.id,
            health_check=volcengine.clb.ListenerHealthCheckArgs(
                enabled="on",
                interval=10,
                timeout=3,
                healthy_threshold=5,
                un_healthy_threshold=2,
                domain="volcengine.com",
                http_code="http_2xx",
                method="GET",
                uri="/",
            ),
            enabled="on")
        foo_tcp = volcengine.clb.Listener("fooTcp",
            load_balancer_id=foo_clb.id,
            listener_name="acc-test-listener",
            protocol="TCP",
            port=90,
            server_group_id=foo_server_group.id,
            enabled="on",
            bandwidth=2,
            proxy_protocol_type="standard",
            persistence_type="source_ip",
            persistence_timeout=100,
            connection_drain_enabled="on",
            connection_drain_timeout=100)
        ```

        ## Import

        Listener can be imported using the id, e.g.

        ```sh
         $ pulumi import volcengine:clb/listener:Listener default lsn-273yv0mhs5xj47fap8sehiiso
        ```

        :param str resource_name: The name of the resource.
        :param ListenerArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ListenerArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 acl_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 acl_status: Optional[pulumi.Input[str]] = None,
                 acl_type: Optional[pulumi.Input[str]] = None,
                 bandwidth: Optional[pulumi.Input[int]] = None,
                 certificate_id: Optional[pulumi.Input[str]] = None,
                 connection_drain_enabled: Optional[pulumi.Input[str]] = None,
                 connection_drain_timeout: Optional[pulumi.Input[int]] = None,
                 cookie: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 enabled: Optional[pulumi.Input[str]] = None,
                 established_timeout: Optional[pulumi.Input[int]] = None,
                 health_check: Optional[pulumi.Input[pulumi.InputType['ListenerHealthCheckArgs']]] = None,
                 listener_name: Optional[pulumi.Input[str]] = None,
                 load_balancer_id: Optional[pulumi.Input[str]] = None,
                 persistence_timeout: Optional[pulumi.Input[int]] = None,
                 persistence_type: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 protocol: Optional[pulumi.Input[str]] = None,
                 proxy_protocol_type: Optional[pulumi.Input[str]] = None,
                 scheduler: Optional[pulumi.Input[str]] = None,
                 server_group_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ListenerArgs.__new__(ListenerArgs)

            __props__.__dict__["acl_ids"] = acl_ids
            __props__.__dict__["acl_status"] = acl_status
            __props__.__dict__["acl_type"] = acl_type
            __props__.__dict__["bandwidth"] = bandwidth
            __props__.__dict__["certificate_id"] = certificate_id
            __props__.__dict__["connection_drain_enabled"] = connection_drain_enabled
            __props__.__dict__["connection_drain_timeout"] = connection_drain_timeout
            __props__.__dict__["cookie"] = cookie
            __props__.__dict__["description"] = description
            __props__.__dict__["enabled"] = enabled
            __props__.__dict__["established_timeout"] = established_timeout
            __props__.__dict__["health_check"] = health_check
            __props__.__dict__["listener_name"] = listener_name
            if load_balancer_id is None and not opts.urn:
                raise TypeError("Missing required property 'load_balancer_id'")
            __props__.__dict__["load_balancer_id"] = load_balancer_id
            __props__.__dict__["persistence_timeout"] = persistence_timeout
            __props__.__dict__["persistence_type"] = persistence_type
            if port is None and not opts.urn:
                raise TypeError("Missing required property 'port'")
            __props__.__dict__["port"] = port
            if protocol is None and not opts.urn:
                raise TypeError("Missing required property 'protocol'")
            __props__.__dict__["protocol"] = protocol
            __props__.__dict__["proxy_protocol_type"] = proxy_protocol_type
            __props__.__dict__["scheduler"] = scheduler
            if server_group_id is None and not opts.urn:
                raise TypeError("Missing required property 'server_group_id'")
            __props__.__dict__["server_group_id"] = server_group_id
            __props__.__dict__["listener_id"] = None
        super(Listener, __self__).__init__(
            'volcengine:clb/listener:Listener',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            acl_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            acl_status: Optional[pulumi.Input[str]] = None,
            acl_type: Optional[pulumi.Input[str]] = None,
            bandwidth: Optional[pulumi.Input[int]] = None,
            certificate_id: Optional[pulumi.Input[str]] = None,
            connection_drain_enabled: Optional[pulumi.Input[str]] = None,
            connection_drain_timeout: Optional[pulumi.Input[int]] = None,
            cookie: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            enabled: Optional[pulumi.Input[str]] = None,
            established_timeout: Optional[pulumi.Input[int]] = None,
            health_check: Optional[pulumi.Input[pulumi.InputType['ListenerHealthCheckArgs']]] = None,
            listener_id: Optional[pulumi.Input[str]] = None,
            listener_name: Optional[pulumi.Input[str]] = None,
            load_balancer_id: Optional[pulumi.Input[str]] = None,
            persistence_timeout: Optional[pulumi.Input[int]] = None,
            persistence_type: Optional[pulumi.Input[str]] = None,
            port: Optional[pulumi.Input[int]] = None,
            protocol: Optional[pulumi.Input[str]] = None,
            proxy_protocol_type: Optional[pulumi.Input[str]] = None,
            scheduler: Optional[pulumi.Input[str]] = None,
            server_group_id: Optional[pulumi.Input[str]] = None) -> 'Listener':
        """
        Get an existing Listener resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] acl_ids: The id list of the Acl.
        :param pulumi.Input[str] acl_status: The enable status of Acl. Optional choice contains `on`, `off`.
        :param pulumi.Input[str] acl_type: The type of the Acl. Optional choice contains `white`, `black`.
        :param pulumi.Input[int] bandwidth: The bandwidth of the Listener. Unit: Mbps. Default is -1, indicating that the Listener does not specify a speed limit.
        :param pulumi.Input[str] certificate_id: The certificate id associated with the listener.
        :param pulumi.Input[str] connection_drain_enabled: Whether to enable connection drain of the Listener. Valid values: `off`, `on`. Default is `off`.
               This filed is valid only when the value of field `protocol` is `TCP` or `UDP`.
        :param pulumi.Input[int] connection_drain_timeout: The connection drain timeout of the Listener. Valid value range is `1-900`.
               This filed is required when the value of field `connection_drain_enabled` is `on`.
        :param pulumi.Input[str] cookie: The name of the cookie for session persistence configured on the backend server. When PersistenceType is configured as `server`, this parameter is required. When PersistenceType is configured as any other value, this parameter is not effective.
        :param pulumi.Input[str] description: The description of the Listener.
        :param pulumi.Input[str] enabled: The enable status of the Listener. Optional choice contains `on`, `off`.
        :param pulumi.Input[int] established_timeout: The connection timeout of the Listener.
        :param pulumi.Input[pulumi.InputType['ListenerHealthCheckArgs']] health_check: The config of health check.
        :param pulumi.Input[str] listener_id: The ID of the Listener.
        :param pulumi.Input[str] listener_name: The name of the Listener.
        :param pulumi.Input[str] load_balancer_id: The region of the request.
        :param pulumi.Input[int] persistence_timeout: The persistence timeout of the Listener. Unit: second. Default is `1000`. When PersistenceType is configured as source_ip, the value range is 1-3600. When PersistenceType is configured as insert, the value range is 1-86400. This filed is valid only when the value of field `persistence_type` is `source_ip` or `insert`.
        :param pulumi.Input[str] persistence_type: The persistence type of the Listener. Valid values: `off`, `source_ip`, `insert`, `server`. Default is `off`.
               `source_ip`: Represents the source IP address, only effective for TCP/UDP protocols. `insert`: means implanting a cookie, only effective for HTTP/HTTPS protocol and when the scheduler is `wrr`. `server`: Indicates rewriting cookies, only effective for HTTP/HTTPS protocols and when the scheduler is `wrr`.
        :param pulumi.Input[int] port: The port receiving request of the Listener, the value range in 1~65535.
        :param pulumi.Input[str] protocol: The protocol of the Listener. Optional choice contains `TCP`, `UDP`, `HTTP`, `HTTPS`.
        :param pulumi.Input[str] proxy_protocol_type: Whether to enable proxy protocol. Valid values: `off`, `standard`. Default is `off`.
               This filed is valid only when the value of field `protocol` is `TCP` or `UDP`.
        :param pulumi.Input[str] scheduler: The scheduling algorithm of the Listener. Optional choice contains `wrr`, `wlc`, `sh`.
        :param pulumi.Input[str] server_group_id: The server group id associated with the listener.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ListenerState.__new__(_ListenerState)

        __props__.__dict__["acl_ids"] = acl_ids
        __props__.__dict__["acl_status"] = acl_status
        __props__.__dict__["acl_type"] = acl_type
        __props__.__dict__["bandwidth"] = bandwidth
        __props__.__dict__["certificate_id"] = certificate_id
        __props__.__dict__["connection_drain_enabled"] = connection_drain_enabled
        __props__.__dict__["connection_drain_timeout"] = connection_drain_timeout
        __props__.__dict__["cookie"] = cookie
        __props__.__dict__["description"] = description
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["established_timeout"] = established_timeout
        __props__.__dict__["health_check"] = health_check
        __props__.__dict__["listener_id"] = listener_id
        __props__.__dict__["listener_name"] = listener_name
        __props__.__dict__["load_balancer_id"] = load_balancer_id
        __props__.__dict__["persistence_timeout"] = persistence_timeout
        __props__.__dict__["persistence_type"] = persistence_type
        __props__.__dict__["port"] = port
        __props__.__dict__["protocol"] = protocol
        __props__.__dict__["proxy_protocol_type"] = proxy_protocol_type
        __props__.__dict__["scheduler"] = scheduler
        __props__.__dict__["server_group_id"] = server_group_id
        return Listener(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="aclIds")
    def acl_ids(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        The id list of the Acl.
        """
        return pulumi.get(self, "acl_ids")

    @property
    @pulumi.getter(name="aclStatus")
    def acl_status(self) -> pulumi.Output[str]:
        """
        The enable status of Acl. Optional choice contains `on`, `off`.
        """
        return pulumi.get(self, "acl_status")

    @property
    @pulumi.getter(name="aclType")
    def acl_type(self) -> pulumi.Output[str]:
        """
        The type of the Acl. Optional choice contains `white`, `black`.
        """
        return pulumi.get(self, "acl_type")

    @property
    @pulumi.getter
    def bandwidth(self) -> pulumi.Output[Optional[int]]:
        """
        The bandwidth of the Listener. Unit: Mbps. Default is -1, indicating that the Listener does not specify a speed limit.
        """
        return pulumi.get(self, "bandwidth")

    @property
    @pulumi.getter(name="certificateId")
    def certificate_id(self) -> pulumi.Output[Optional[str]]:
        """
        The certificate id associated with the listener.
        """
        return pulumi.get(self, "certificate_id")

    @property
    @pulumi.getter(name="connectionDrainEnabled")
    def connection_drain_enabled(self) -> pulumi.Output[Optional[str]]:
        """
        Whether to enable connection drain of the Listener. Valid values: `off`, `on`. Default is `off`.
        This filed is valid only when the value of field `protocol` is `TCP` or `UDP`.
        """
        return pulumi.get(self, "connection_drain_enabled")

    @property
    @pulumi.getter(name="connectionDrainTimeout")
    def connection_drain_timeout(self) -> pulumi.Output[int]:
        """
        The connection drain timeout of the Listener. Valid value range is `1-900`.
        This filed is required when the value of field `connection_drain_enabled` is `on`.
        """
        return pulumi.get(self, "connection_drain_timeout")

    @property
    @pulumi.getter
    def cookie(self) -> pulumi.Output[Optional[str]]:
        """
        The name of the cookie for session persistence configured on the backend server. When PersistenceType is configured as `server`, this parameter is required. When PersistenceType is configured as any other value, this parameter is not effective.
        """
        return pulumi.get(self, "cookie")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        The description of the Listener.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[str]:
        """
        The enable status of the Listener. Optional choice contains `on`, `off`.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="establishedTimeout")
    def established_timeout(self) -> pulumi.Output[int]:
        """
        The connection timeout of the Listener.
        """
        return pulumi.get(self, "established_timeout")

    @property
    @pulumi.getter(name="healthCheck")
    def health_check(self) -> pulumi.Output['outputs.ListenerHealthCheck']:
        """
        The config of health check.
        """
        return pulumi.get(self, "health_check")

    @property
    @pulumi.getter(name="listenerId")
    def listener_id(self) -> pulumi.Output[str]:
        """
        The ID of the Listener.
        """
        return pulumi.get(self, "listener_id")

    @property
    @pulumi.getter(name="listenerName")
    def listener_name(self) -> pulumi.Output[str]:
        """
        The name of the Listener.
        """
        return pulumi.get(self, "listener_name")

    @property
    @pulumi.getter(name="loadBalancerId")
    def load_balancer_id(self) -> pulumi.Output[str]:
        """
        The region of the request.
        """
        return pulumi.get(self, "load_balancer_id")

    @property
    @pulumi.getter(name="persistenceTimeout")
    def persistence_timeout(self) -> pulumi.Output[Optional[int]]:
        """
        The persistence timeout of the Listener. Unit: second. Default is `1000`. When PersistenceType is configured as source_ip, the value range is 1-3600. When PersistenceType is configured as insert, the value range is 1-86400. This filed is valid only when the value of field `persistence_type` is `source_ip` or `insert`.
        """
        return pulumi.get(self, "persistence_timeout")

    @property
    @pulumi.getter(name="persistenceType")
    def persistence_type(self) -> pulumi.Output[Optional[str]]:
        """
        The persistence type of the Listener. Valid values: `off`, `source_ip`, `insert`, `server`. Default is `off`.
        `source_ip`: Represents the source IP address, only effective for TCP/UDP protocols. `insert`: means implanting a cookie, only effective for HTTP/HTTPS protocol and when the scheduler is `wrr`. `server`: Indicates rewriting cookies, only effective for HTTP/HTTPS protocols and when the scheduler is `wrr`.
        """
        return pulumi.get(self, "persistence_type")

    @property
    @pulumi.getter
    def port(self) -> pulumi.Output[int]:
        """
        The port receiving request of the Listener, the value range in 1~65535.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def protocol(self) -> pulumi.Output[str]:
        """
        The protocol of the Listener. Optional choice contains `TCP`, `UDP`, `HTTP`, `HTTPS`.
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="proxyProtocolType")
    def proxy_protocol_type(self) -> pulumi.Output[Optional[str]]:
        """
        Whether to enable proxy protocol. Valid values: `off`, `standard`. Default is `off`.
        This filed is valid only when the value of field `protocol` is `TCP` or `UDP`.
        """
        return pulumi.get(self, "proxy_protocol_type")

    @property
    @pulumi.getter
    def scheduler(self) -> pulumi.Output[str]:
        """
        The scheduling algorithm of the Listener. Optional choice contains `wrr`, `wlc`, `sh`.
        """
        return pulumi.get(self, "scheduler")

    @property
    @pulumi.getter(name="serverGroupId")
    def server_group_id(self) -> pulumi.Output[str]:
        """
        The server group id associated with the listener.
        """
        return pulumi.get(self, "server_group_id")

