# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'RulesResult',
    'AwaitableRulesResult',
    'rules',
    'rules_output',
]

@pulumi.output_type
class RulesResult:
    """
    A collection of values returned by Rules.
    """
    def __init__(__self__, id=None, ids=None, listener_id=None, output_file=None, rules=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if listener_id and not isinstance(listener_id, str):
            raise TypeError("Expected argument 'listener_id' to be a str")
        pulumi.set(__self__, "listener_id", listener_id)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if rules and not isinstance(rules, list):
            raise TypeError("Expected argument 'rules' to be a list")
        pulumi.set(__self__, "rules", rules)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def ids(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "ids")

    @property
    @pulumi.getter(name="listenerId")
    def listener_id(self) -> str:
        return pulumi.get(self, "listener_id")

    @property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[str]:
        return pulumi.get(self, "output_file")

    @property
    @pulumi.getter
    def rules(self) -> Sequence['outputs.RulesRuleResult']:
        """
        The collection of Rule query.
        """
        return pulumi.get(self, "rules")


class AwaitableRulesResult(RulesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return RulesResult(
            id=self.id,
            ids=self.ids,
            listener_id=self.listener_id,
            output_file=self.output_file,
            rules=self.rules)


def rules(ids: Optional[Sequence[str]] = None,
          listener_id: Optional[str] = None,
          output_file: Optional[str] = None,
          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableRulesResult:
    """
    Use this data source to query detailed information of clb rules
    ## Example Usage

    ```python
    import pulumi
    import pulumi_volcengine as volcengine

    foo_zones = volcengine.ecs.zones()
    foo_vpc = volcengine.vpc.Vpc("fooVpc",
        vpc_name="acc-test-vpc",
        cidr_block="172.16.0.0/16")
    foo_subnet = volcengine.vpc.Subnet("fooSubnet",
        subnet_name="acc-test-subnet",
        cidr_block="172.16.0.0/24",
        zone_id=foo_zones.zones[0].id,
        vpc_id=foo_vpc.id)
    foo_clb = volcengine.clb.Clb("fooClb",
        type="public",
        subnet_id=foo_subnet.id,
        load_balancer_spec="small_1",
        description="acc0Demo",
        load_balancer_name="acc-test-create",
        eip_billing_config=volcengine.clb.ClbEipBillingConfigArgs(
            isp="BGP",
            eip_billing_type="PostPaidByBandwidth",
            bandwidth=1,
        ))
    foo_server_group = volcengine.clb.ServerGroup("fooServerGroup",
        load_balancer_id=foo_clb.id,
        server_group_name="acc-test-create",
        description="hello demo11")
    foo_listener = volcengine.clb.Listener("fooListener",
        load_balancer_id=foo_clb.id,
        listener_name="acc-test-listener",
        protocol="HTTP",
        port=90,
        server_group_id=foo_server_group.id,
        health_check=volcengine.clb.ListenerHealthCheckArgs(
            enabled="on",
            interval=10,
            timeout=3,
            healthy_threshold=5,
            un_healthy_threshold=2,
            domain="volcengine.com",
            http_code="http_2xx",
            method="GET",
            uri="/",
        ),
        enabled="on")
    foo_rule = volcengine.clb.Rule("fooRule",
        listener_id=foo_listener.id,
        server_group_id=foo_server_group.id,
        domain="test-volc123.com",
        url="/yyyy")
    foo_rules = volcengine.clb.rules_output(ids=[foo_rule.id],
        listener_id=foo_listener.id)
    ```


    :param Sequence[str] ids: A list of Rule IDs.
    :param str listener_id: The Id of listener.
    :param str output_file: File name where to save data source results.
    """
    __args__ = dict()
    __args__['ids'] = ids
    __args__['listenerId'] = listener_id
    __args__['outputFile'] = output_file
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('volcengine:clb/rules:Rules', __args__, opts=opts, typ=RulesResult).value

    return AwaitableRulesResult(
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        listener_id=pulumi.get(__ret__, 'listener_id'),
        output_file=pulumi.get(__ret__, 'output_file'),
        rules=pulumi.get(__ret__, 'rules'))


@_utilities.lift_output_func(rules)
def rules_output(ids: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                 listener_id: Optional[pulumi.Input[str]] = None,
                 output_file: Optional[pulumi.Input[Optional[str]]] = None,
                 opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[RulesResult]:
    """
    Use this data source to query detailed information of clb rules
    ## Example Usage

    ```python
    import pulumi
    import pulumi_volcengine as volcengine

    foo_zones = volcengine.ecs.zones()
    foo_vpc = volcengine.vpc.Vpc("fooVpc",
        vpc_name="acc-test-vpc",
        cidr_block="172.16.0.0/16")
    foo_subnet = volcengine.vpc.Subnet("fooSubnet",
        subnet_name="acc-test-subnet",
        cidr_block="172.16.0.0/24",
        zone_id=foo_zones.zones[0].id,
        vpc_id=foo_vpc.id)
    foo_clb = volcengine.clb.Clb("fooClb",
        type="public",
        subnet_id=foo_subnet.id,
        load_balancer_spec="small_1",
        description="acc0Demo",
        load_balancer_name="acc-test-create",
        eip_billing_config=volcengine.clb.ClbEipBillingConfigArgs(
            isp="BGP",
            eip_billing_type="PostPaidByBandwidth",
            bandwidth=1,
        ))
    foo_server_group = volcengine.clb.ServerGroup("fooServerGroup",
        load_balancer_id=foo_clb.id,
        server_group_name="acc-test-create",
        description="hello demo11")
    foo_listener = volcengine.clb.Listener("fooListener",
        load_balancer_id=foo_clb.id,
        listener_name="acc-test-listener",
        protocol="HTTP",
        port=90,
        server_group_id=foo_server_group.id,
        health_check=volcengine.clb.ListenerHealthCheckArgs(
            enabled="on",
            interval=10,
            timeout=3,
            healthy_threshold=5,
            un_healthy_threshold=2,
            domain="volcengine.com",
            http_code="http_2xx",
            method="GET",
            uri="/",
        ),
        enabled="on")
    foo_rule = volcengine.clb.Rule("fooRule",
        listener_id=foo_listener.id,
        server_group_id=foo_server_group.id,
        domain="test-volc123.com",
        url="/yyyy")
    foo_rules = volcengine.clb.rules_output(ids=[foo_rule.id],
        listener_id=foo_listener.id)
    ```


    :param Sequence[str] ids: A list of Rule IDs.
    :param str listener_id: The Id of listener.
    :param str output_file: File name where to save data source results.
    """
    ...
