# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['ServerGroupArgs', 'ServerGroup']

@pulumi.input_type
class ServerGroupArgs:
    def __init__(__self__, *,
                 load_balancer_id: pulumi.Input[str],
                 address_ip_version: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 server_group_id: Optional[pulumi.Input[str]] = None,
                 server_group_name: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a ServerGroup resource.
        :param pulumi.Input[str] load_balancer_id: The ID of the Clb.
        :param pulumi.Input[str] address_ip_version: The address ip version of the ServerGroup. Valid values: `ipv4`, `ipv6`. Default is `ipv4`.
        :param pulumi.Input[str] description: The description of ServerGroup.
        :param pulumi.Input[str] server_group_id: The ID of the ServerGroup.
        :param pulumi.Input[str] server_group_name: The name of the ServerGroup.
        """
        pulumi.set(__self__, "load_balancer_id", load_balancer_id)
        if address_ip_version is not None:
            pulumi.set(__self__, "address_ip_version", address_ip_version)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if server_group_id is not None:
            pulumi.set(__self__, "server_group_id", server_group_id)
        if server_group_name is not None:
            pulumi.set(__self__, "server_group_name", server_group_name)

    @property
    @pulumi.getter(name="loadBalancerId")
    def load_balancer_id(self) -> pulumi.Input[str]:
        """
        The ID of the Clb.
        """
        return pulumi.get(self, "load_balancer_id")

    @load_balancer_id.setter
    def load_balancer_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "load_balancer_id", value)

    @property
    @pulumi.getter(name="addressIpVersion")
    def address_ip_version(self) -> Optional[pulumi.Input[str]]:
        """
        The address ip version of the ServerGroup. Valid values: `ipv4`, `ipv6`. Default is `ipv4`.
        """
        return pulumi.get(self, "address_ip_version")

    @address_ip_version.setter
    def address_ip_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "address_ip_version", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of ServerGroup.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="serverGroupId")
    def server_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the ServerGroup.
        """
        return pulumi.get(self, "server_group_id")

    @server_group_id.setter
    def server_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "server_group_id", value)

    @property
    @pulumi.getter(name="serverGroupName")
    def server_group_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the ServerGroup.
        """
        return pulumi.get(self, "server_group_name")

    @server_group_name.setter
    def server_group_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "server_group_name", value)


@pulumi.input_type
class _ServerGroupState:
    def __init__(__self__, *,
                 address_ip_version: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 load_balancer_id: Optional[pulumi.Input[str]] = None,
                 server_group_id: Optional[pulumi.Input[str]] = None,
                 server_group_name: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering ServerGroup resources.
        :param pulumi.Input[str] address_ip_version: The address ip version of the ServerGroup. Valid values: `ipv4`, `ipv6`. Default is `ipv4`.
        :param pulumi.Input[str] description: The description of ServerGroup.
        :param pulumi.Input[str] load_balancer_id: The ID of the Clb.
        :param pulumi.Input[str] server_group_id: The ID of the ServerGroup.
        :param pulumi.Input[str] server_group_name: The name of the ServerGroup.
        """
        if address_ip_version is not None:
            pulumi.set(__self__, "address_ip_version", address_ip_version)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if load_balancer_id is not None:
            pulumi.set(__self__, "load_balancer_id", load_balancer_id)
        if server_group_id is not None:
            pulumi.set(__self__, "server_group_id", server_group_id)
        if server_group_name is not None:
            pulumi.set(__self__, "server_group_name", server_group_name)

    @property
    @pulumi.getter(name="addressIpVersion")
    def address_ip_version(self) -> Optional[pulumi.Input[str]]:
        """
        The address ip version of the ServerGroup. Valid values: `ipv4`, `ipv6`. Default is `ipv4`.
        """
        return pulumi.get(self, "address_ip_version")

    @address_ip_version.setter
    def address_ip_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "address_ip_version", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of ServerGroup.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="loadBalancerId")
    def load_balancer_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the Clb.
        """
        return pulumi.get(self, "load_balancer_id")

    @load_balancer_id.setter
    def load_balancer_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "load_balancer_id", value)

    @property
    @pulumi.getter(name="serverGroupId")
    def server_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the ServerGroup.
        """
        return pulumi.get(self, "server_group_id")

    @server_group_id.setter
    def server_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "server_group_id", value)

    @property
    @pulumi.getter(name="serverGroupName")
    def server_group_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the ServerGroup.
        """
        return pulumi.get(self, "server_group_name")

    @server_group_name.setter
    def server_group_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "server_group_name", value)


class ServerGroup(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 address_ip_version: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 load_balancer_id: Optional[pulumi.Input[str]] = None,
                 server_group_id: Optional[pulumi.Input[str]] = None,
                 server_group_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a resource to manage server group
        ## Example Usage

        ```python
        import pulumi
        import pulumi_volcengine as volcengine

        foo_zones = volcengine.ecs.zones()
        foo_vpc = volcengine.vpc.Vpc("fooVpc",
            vpc_name="acc-test-vpc",
            cidr_block="172.16.0.0/16")
        foo_subnet = volcengine.vpc.Subnet("fooSubnet",
            subnet_name="acc-test-subnet",
            cidr_block="172.16.0.0/24",
            zone_id=foo_zones.zones[0].id,
            vpc_id=foo_vpc.id)
        foo_clb = volcengine.clb.Clb("fooClb",
            type="public",
            subnet_id=foo_subnet.id,
            load_balancer_spec="small_1",
            description="acc0Demo",
            load_balancer_name="acc-test-create",
            eip_billing_config=volcengine.clb.ClbEipBillingConfigArgs(
                isp="BGP",
                eip_billing_type="PostPaidByBandwidth",
                bandwidth=1,
            ))
        foo_server_group = volcengine.clb.ServerGroup("fooServerGroup",
            load_balancer_id=foo_clb.id,
            server_group_name="acc-test-create",
            description="hello demo11")
        ```

        ## Import

        ServerGroup can be imported using the id, e.g.

        ```sh
         $ pulumi import volcengine:clb/serverGroup:ServerGroup default rsp-273yv0kir1vk07fap8tt9jtwg
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] address_ip_version: The address ip version of the ServerGroup. Valid values: `ipv4`, `ipv6`. Default is `ipv4`.
        :param pulumi.Input[str] description: The description of ServerGroup.
        :param pulumi.Input[str] load_balancer_id: The ID of the Clb.
        :param pulumi.Input[str] server_group_id: The ID of the ServerGroup.
        :param pulumi.Input[str] server_group_name: The name of the ServerGroup.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ServerGroupArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a resource to manage server group
        ## Example Usage

        ```python
        import pulumi
        import pulumi_volcengine as volcengine

        foo_zones = volcengine.ecs.zones()
        foo_vpc = volcengine.vpc.Vpc("fooVpc",
            vpc_name="acc-test-vpc",
            cidr_block="172.16.0.0/16")
        foo_subnet = volcengine.vpc.Subnet("fooSubnet",
            subnet_name="acc-test-subnet",
            cidr_block="172.16.0.0/24",
            zone_id=foo_zones.zones[0].id,
            vpc_id=foo_vpc.id)
        foo_clb = volcengine.clb.Clb("fooClb",
            type="public",
            subnet_id=foo_subnet.id,
            load_balancer_spec="small_1",
            description="acc0Demo",
            load_balancer_name="acc-test-create",
            eip_billing_config=volcengine.clb.ClbEipBillingConfigArgs(
                isp="BGP",
                eip_billing_type="PostPaidByBandwidth",
                bandwidth=1,
            ))
        foo_server_group = volcengine.clb.ServerGroup("fooServerGroup",
            load_balancer_id=foo_clb.id,
            server_group_name="acc-test-create",
            description="hello demo11")
        ```

        ## Import

        ServerGroup can be imported using the id, e.g.

        ```sh
         $ pulumi import volcengine:clb/serverGroup:ServerGroup default rsp-273yv0kir1vk07fap8tt9jtwg
        ```

        :param str resource_name: The name of the resource.
        :param ServerGroupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ServerGroupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 address_ip_version: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 load_balancer_id: Optional[pulumi.Input[str]] = None,
                 server_group_id: Optional[pulumi.Input[str]] = None,
                 server_group_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ServerGroupArgs.__new__(ServerGroupArgs)

            __props__.__dict__["address_ip_version"] = address_ip_version
            __props__.__dict__["description"] = description
            if load_balancer_id is None and not opts.urn:
                raise TypeError("Missing required property 'load_balancer_id'")
            __props__.__dict__["load_balancer_id"] = load_balancer_id
            __props__.__dict__["server_group_id"] = server_group_id
            __props__.__dict__["server_group_name"] = server_group_name
        super(ServerGroup, __self__).__init__(
            'volcengine:clb/serverGroup:ServerGroup',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            address_ip_version: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            load_balancer_id: Optional[pulumi.Input[str]] = None,
            server_group_id: Optional[pulumi.Input[str]] = None,
            server_group_name: Optional[pulumi.Input[str]] = None) -> 'ServerGroup':
        """
        Get an existing ServerGroup resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] address_ip_version: The address ip version of the ServerGroup. Valid values: `ipv4`, `ipv6`. Default is `ipv4`.
        :param pulumi.Input[str] description: The description of ServerGroup.
        :param pulumi.Input[str] load_balancer_id: The ID of the Clb.
        :param pulumi.Input[str] server_group_id: The ID of the ServerGroup.
        :param pulumi.Input[str] server_group_name: The name of the ServerGroup.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ServerGroupState.__new__(_ServerGroupState)

        __props__.__dict__["address_ip_version"] = address_ip_version
        __props__.__dict__["description"] = description
        __props__.__dict__["load_balancer_id"] = load_balancer_id
        __props__.__dict__["server_group_id"] = server_group_id
        __props__.__dict__["server_group_name"] = server_group_name
        return ServerGroup(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="addressIpVersion")
    def address_ip_version(self) -> pulumi.Output[Optional[str]]:
        """
        The address ip version of the ServerGroup. Valid values: `ipv4`, `ipv6`. Default is `ipv4`.
        """
        return pulumi.get(self, "address_ip_version")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        The description of ServerGroup.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="loadBalancerId")
    def load_balancer_id(self) -> pulumi.Output[str]:
        """
        The ID of the Clb.
        """
        return pulumi.get(self, "load_balancer_id")

    @property
    @pulumi.getter(name="serverGroupId")
    def server_group_id(self) -> pulumi.Output[str]:
        """
        The ID of the ServerGroup.
        """
        return pulumi.get(self, "server_group_id")

    @property
    @pulumi.getter(name="serverGroupName")
    def server_group_name(self) -> pulumi.Output[str]:
        """
        The name of the ServerGroup.
        """
        return pulumi.get(self, "server_group_name")

