# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['AccessArgs', 'Access']

@pulumi.input_type
class AccessArgs:
    def __init__(__self__, *,
                 fs_name: pulumi.Input[str],
                 security_group_id: pulumi.Input[str],
                 subnet_id: pulumi.Input[str],
                 access_account_id: Optional[pulumi.Input[int]] = None,
                 access_iam_role: Optional[pulumi.Input[str]] = None,
                 vpc_route_enabled: Optional[pulumi.Input[bool]] = None):
        """
        The set of arguments for constructing a Access resource.
        :param pulumi.Input[str] fs_name: The name of file system.
        :param pulumi.Input[str] security_group_id: The id of security group.
        :param pulumi.Input[str] subnet_id: The id of subnet.
        :param pulumi.Input[int] access_account_id: The account id of access.
        :param pulumi.Input[str] access_iam_role: The iam role of access. If the VPC of another account is attached, the other account needs to create a role with CFSCacheAccess permission, and enter the role name as a parameter.
        :param pulumi.Input[bool] vpc_route_enabled: Whether enable all vpc route.
        """
        pulumi.set(__self__, "fs_name", fs_name)
        pulumi.set(__self__, "security_group_id", security_group_id)
        pulumi.set(__self__, "subnet_id", subnet_id)
        if access_account_id is not None:
            pulumi.set(__self__, "access_account_id", access_account_id)
        if access_iam_role is not None:
            pulumi.set(__self__, "access_iam_role", access_iam_role)
        if vpc_route_enabled is not None:
            pulumi.set(__self__, "vpc_route_enabled", vpc_route_enabled)

    @property
    @pulumi.getter(name="fsName")
    def fs_name(self) -> pulumi.Input[str]:
        """
        The name of file system.
        """
        return pulumi.get(self, "fs_name")

    @fs_name.setter
    def fs_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "fs_name", value)

    @property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> pulumi.Input[str]:
        """
        The id of security group.
        """
        return pulumi.get(self, "security_group_id")

    @security_group_id.setter
    def security_group_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "security_group_id", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Input[str]:
        """
        The id of subnet.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "subnet_id", value)

    @property
    @pulumi.getter(name="accessAccountId")
    def access_account_id(self) -> Optional[pulumi.Input[int]]:
        """
        The account id of access.
        """
        return pulumi.get(self, "access_account_id")

    @access_account_id.setter
    def access_account_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "access_account_id", value)

    @property
    @pulumi.getter(name="accessIamRole")
    def access_iam_role(self) -> Optional[pulumi.Input[str]]:
        """
        The iam role of access. If the VPC of another account is attached, the other account needs to create a role with CFSCacheAccess permission, and enter the role name as a parameter.
        """
        return pulumi.get(self, "access_iam_role")

    @access_iam_role.setter
    def access_iam_role(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "access_iam_role", value)

    @property
    @pulumi.getter(name="vpcRouteEnabled")
    def vpc_route_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether enable all vpc route.
        """
        return pulumi.get(self, "vpc_route_enabled")

    @vpc_route_enabled.setter
    def vpc_route_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "vpc_route_enabled", value)


@pulumi.input_type
class _AccessState:
    def __init__(__self__, *,
                 access_account_id: Optional[pulumi.Input[int]] = None,
                 access_iam_role: Optional[pulumi.Input[str]] = None,
                 access_id: Optional[pulumi.Input[str]] = None,
                 access_service_name: Optional[pulumi.Input[str]] = None,
                 created_time: Optional[pulumi.Input[str]] = None,
                 fs_name: Optional[pulumi.Input[str]] = None,
                 is_default: Optional[pulumi.Input[bool]] = None,
                 security_group_id: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 vpc_route_enabled: Optional[pulumi.Input[bool]] = None):
        """
        Input properties used for looking up and filtering Access resources.
        :param pulumi.Input[int] access_account_id: The account id of access.
        :param pulumi.Input[str] access_iam_role: The iam role of access. If the VPC of another account is attached, the other account needs to create a role with CFSCacheAccess permission, and enter the role name as a parameter.
        :param pulumi.Input[str] access_id: The id of access.
        :param pulumi.Input[str] access_service_name: The service name of access.
        :param pulumi.Input[str] created_time: The creation time.
        :param pulumi.Input[str] fs_name: The name of file system.
        :param pulumi.Input[bool] is_default: Whether is default access.
        :param pulumi.Input[str] security_group_id: The id of security group.
        :param pulumi.Input[str] status: Status of access.
        :param pulumi.Input[str] subnet_id: The id of subnet.
        :param pulumi.Input[str] vpc_id: The id of vpc.
        :param pulumi.Input[bool] vpc_route_enabled: Whether enable all vpc route.
        """
        if access_account_id is not None:
            pulumi.set(__self__, "access_account_id", access_account_id)
        if access_iam_role is not None:
            pulumi.set(__self__, "access_iam_role", access_iam_role)
        if access_id is not None:
            pulumi.set(__self__, "access_id", access_id)
        if access_service_name is not None:
            pulumi.set(__self__, "access_service_name", access_service_name)
        if created_time is not None:
            pulumi.set(__self__, "created_time", created_time)
        if fs_name is not None:
            pulumi.set(__self__, "fs_name", fs_name)
        if is_default is not None:
            pulumi.set(__self__, "is_default", is_default)
        if security_group_id is not None:
            pulumi.set(__self__, "security_group_id", security_group_id)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)
        if vpc_route_enabled is not None:
            pulumi.set(__self__, "vpc_route_enabled", vpc_route_enabled)

    @property
    @pulumi.getter(name="accessAccountId")
    def access_account_id(self) -> Optional[pulumi.Input[int]]:
        """
        The account id of access.
        """
        return pulumi.get(self, "access_account_id")

    @access_account_id.setter
    def access_account_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "access_account_id", value)

    @property
    @pulumi.getter(name="accessIamRole")
    def access_iam_role(self) -> Optional[pulumi.Input[str]]:
        """
        The iam role of access. If the VPC of another account is attached, the other account needs to create a role with CFSCacheAccess permission, and enter the role name as a parameter.
        """
        return pulumi.get(self, "access_iam_role")

    @access_iam_role.setter
    def access_iam_role(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "access_iam_role", value)

    @property
    @pulumi.getter(name="accessId")
    def access_id(self) -> Optional[pulumi.Input[str]]:
        """
        The id of access.
        """
        return pulumi.get(self, "access_id")

    @access_id.setter
    def access_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "access_id", value)

    @property
    @pulumi.getter(name="accessServiceName")
    def access_service_name(self) -> Optional[pulumi.Input[str]]:
        """
        The service name of access.
        """
        return pulumi.get(self, "access_service_name")

    @access_service_name.setter
    def access_service_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "access_service_name", value)

    @property
    @pulumi.getter(name="createdTime")
    def created_time(self) -> Optional[pulumi.Input[str]]:
        """
        The creation time.
        """
        return pulumi.get(self, "created_time")

    @created_time.setter
    def created_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "created_time", value)

    @property
    @pulumi.getter(name="fsName")
    def fs_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of file system.
        """
        return pulumi.get(self, "fs_name")

    @fs_name.setter
    def fs_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fs_name", value)

    @property
    @pulumi.getter(name="isDefault")
    def is_default(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether is default access.
        """
        return pulumi.get(self, "is_default")

    @is_default.setter
    def is_default(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_default", value)

    @property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        The id of security group.
        """
        return pulumi.get(self, "security_group_id")

    @security_group_id.setter
    def security_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "security_group_id", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        Status of access.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[str]]:
        """
        The id of subnet.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subnet_id", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[str]]:
        """
        The id of vpc.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc_id", value)

    @property
    @pulumi.getter(name="vpcRouteEnabled")
    def vpc_route_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether enable all vpc route.
        """
        return pulumi.get(self, "vpc_route_enabled")

    @vpc_route_enabled.setter
    def vpc_route_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "vpc_route_enabled", value)


class Access(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_account_id: Optional[pulumi.Input[int]] = None,
                 access_iam_role: Optional[pulumi.Input[str]] = None,
                 fs_name: Optional[pulumi.Input[str]] = None,
                 security_group_id: Optional[pulumi.Input[str]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 vpc_route_enabled: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        """
        Provides a resource to manage cloudfs access
        ## Example Usage

        ```python
        import pulumi
        import pulumi_volcengine as volcengine

        foo1 = volcengine.cloudfs.Access("foo1",
            fs_name="tftest2",
            security_group_id="sg-rrv1klfg5s00v0x578mx14m",
            subnet_id="subnet-13fca1crr5d6o3n6nu46cyb5m",
            vpc_route_enabled=False)
        ```

        ## Import

        CloudFs Access can be imported using the FsName:AccessId, e.g.

        ```sh
         $ pulumi import volcengine:cloudfs/access:Access default tfname:access-**rdgmedx3fow
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] access_account_id: The account id of access.
        :param pulumi.Input[str] access_iam_role: The iam role of access. If the VPC of another account is attached, the other account needs to create a role with CFSCacheAccess permission, and enter the role name as a parameter.
        :param pulumi.Input[str] fs_name: The name of file system.
        :param pulumi.Input[str] security_group_id: The id of security group.
        :param pulumi.Input[str] subnet_id: The id of subnet.
        :param pulumi.Input[bool] vpc_route_enabled: Whether enable all vpc route.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AccessArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a resource to manage cloudfs access
        ## Example Usage

        ```python
        import pulumi
        import pulumi_volcengine as volcengine

        foo1 = volcengine.cloudfs.Access("foo1",
            fs_name="tftest2",
            security_group_id="sg-rrv1klfg5s00v0x578mx14m",
            subnet_id="subnet-13fca1crr5d6o3n6nu46cyb5m",
            vpc_route_enabled=False)
        ```

        ## Import

        CloudFs Access can be imported using the FsName:AccessId, e.g.

        ```sh
         $ pulumi import volcengine:cloudfs/access:Access default tfname:access-**rdgmedx3fow
        ```

        :param str resource_name: The name of the resource.
        :param AccessArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AccessArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_account_id: Optional[pulumi.Input[int]] = None,
                 access_iam_role: Optional[pulumi.Input[str]] = None,
                 fs_name: Optional[pulumi.Input[str]] = None,
                 security_group_id: Optional[pulumi.Input[str]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 vpc_route_enabled: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AccessArgs.__new__(AccessArgs)

            __props__.__dict__["access_account_id"] = access_account_id
            __props__.__dict__["access_iam_role"] = access_iam_role
            if fs_name is None and not opts.urn:
                raise TypeError("Missing required property 'fs_name'")
            __props__.__dict__["fs_name"] = fs_name
            if security_group_id is None and not opts.urn:
                raise TypeError("Missing required property 'security_group_id'")
            __props__.__dict__["security_group_id"] = security_group_id
            if subnet_id is None and not opts.urn:
                raise TypeError("Missing required property 'subnet_id'")
            __props__.__dict__["subnet_id"] = subnet_id
            __props__.__dict__["vpc_route_enabled"] = vpc_route_enabled
            __props__.__dict__["access_id"] = None
            __props__.__dict__["access_service_name"] = None
            __props__.__dict__["created_time"] = None
            __props__.__dict__["is_default"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["vpc_id"] = None
        super(Access, __self__).__init__(
            'volcengine:cloudfs/access:Access',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access_account_id: Optional[pulumi.Input[int]] = None,
            access_iam_role: Optional[pulumi.Input[str]] = None,
            access_id: Optional[pulumi.Input[str]] = None,
            access_service_name: Optional[pulumi.Input[str]] = None,
            created_time: Optional[pulumi.Input[str]] = None,
            fs_name: Optional[pulumi.Input[str]] = None,
            is_default: Optional[pulumi.Input[bool]] = None,
            security_group_id: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None,
            subnet_id: Optional[pulumi.Input[str]] = None,
            vpc_id: Optional[pulumi.Input[str]] = None,
            vpc_route_enabled: Optional[pulumi.Input[bool]] = None) -> 'Access':
        """
        Get an existing Access resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] access_account_id: The account id of access.
        :param pulumi.Input[str] access_iam_role: The iam role of access. If the VPC of another account is attached, the other account needs to create a role with CFSCacheAccess permission, and enter the role name as a parameter.
        :param pulumi.Input[str] access_id: The id of access.
        :param pulumi.Input[str] access_service_name: The service name of access.
        :param pulumi.Input[str] created_time: The creation time.
        :param pulumi.Input[str] fs_name: The name of file system.
        :param pulumi.Input[bool] is_default: Whether is default access.
        :param pulumi.Input[str] security_group_id: The id of security group.
        :param pulumi.Input[str] status: Status of access.
        :param pulumi.Input[str] subnet_id: The id of subnet.
        :param pulumi.Input[str] vpc_id: The id of vpc.
        :param pulumi.Input[bool] vpc_route_enabled: Whether enable all vpc route.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AccessState.__new__(_AccessState)

        __props__.__dict__["access_account_id"] = access_account_id
        __props__.__dict__["access_iam_role"] = access_iam_role
        __props__.__dict__["access_id"] = access_id
        __props__.__dict__["access_service_name"] = access_service_name
        __props__.__dict__["created_time"] = created_time
        __props__.__dict__["fs_name"] = fs_name
        __props__.__dict__["is_default"] = is_default
        __props__.__dict__["security_group_id"] = security_group_id
        __props__.__dict__["status"] = status
        __props__.__dict__["subnet_id"] = subnet_id
        __props__.__dict__["vpc_id"] = vpc_id
        __props__.__dict__["vpc_route_enabled"] = vpc_route_enabled
        return Access(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accessAccountId")
    def access_account_id(self) -> pulumi.Output[int]:
        """
        The account id of access.
        """
        return pulumi.get(self, "access_account_id")

    @property
    @pulumi.getter(name="accessIamRole")
    def access_iam_role(self) -> pulumi.Output[Optional[str]]:
        """
        The iam role of access. If the VPC of another account is attached, the other account needs to create a role with CFSCacheAccess permission, and enter the role name as a parameter.
        """
        return pulumi.get(self, "access_iam_role")

    @property
    @pulumi.getter(name="accessId")
    def access_id(self) -> pulumi.Output[str]:
        """
        The id of access.
        """
        return pulumi.get(self, "access_id")

    @property
    @pulumi.getter(name="accessServiceName")
    def access_service_name(self) -> pulumi.Output[str]:
        """
        The service name of access.
        """
        return pulumi.get(self, "access_service_name")

    @property
    @pulumi.getter(name="createdTime")
    def created_time(self) -> pulumi.Output[str]:
        """
        The creation time.
        """
        return pulumi.get(self, "created_time")

    @property
    @pulumi.getter(name="fsName")
    def fs_name(self) -> pulumi.Output[str]:
        """
        The name of file system.
        """
        return pulumi.get(self, "fs_name")

    @property
    @pulumi.getter(name="isDefault")
    def is_default(self) -> pulumi.Output[bool]:
        """
        Whether is default access.
        """
        return pulumi.get(self, "is_default")

    @property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> pulumi.Output[str]:
        """
        The id of security group.
        """
        return pulumi.get(self, "security_group_id")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        Status of access.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Output[str]:
        """
        The id of subnet.
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[str]:
        """
        The id of vpc.
        """
        return pulumi.get(self, "vpc_id")

    @property
    @pulumi.getter(name="vpcRouteEnabled")
    def vpc_route_enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether enable all vpc route.
        """
        return pulumi.get(self, "vpc_route_enabled")

