# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'AccessesResult',
    'AwaitableAccessesResult',
    'accesses',
    'accesses_output',
]

@pulumi.output_type
class AccessesResult:
    """
    A collection of values returned by Accesses.
    """
    def __init__(__self__, accesses=None, fs_name=None, id=None, output_file=None, total_count=None):
        if accesses and not isinstance(accesses, list):
            raise TypeError("Expected argument 'accesses' to be a list")
        pulumi.set(__self__, "accesses", accesses)
        if fs_name and not isinstance(fs_name, str):
            raise TypeError("Expected argument 'fs_name' to be a str")
        pulumi.set(__self__, "fs_name", fs_name)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if total_count and not isinstance(total_count, int):
            raise TypeError("Expected argument 'total_count' to be a int")
        pulumi.set(__self__, "total_count", total_count)

    @property
    @pulumi.getter
    def accesses(self) -> Sequence['outputs.AccessesAccessResult']:
        """
        The collection of query.
        """
        return pulumi.get(self, "accesses")

    @property
    @pulumi.getter(name="fsName")
    def fs_name(self) -> str:
        """
        The name of cloud fs.
        """
        return pulumi.get(self, "fs_name")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[str]:
        return pulumi.get(self, "output_file")

    @property
    @pulumi.getter(name="totalCount")
    def total_count(self) -> int:
        """
        The total count of query.
        """
        return pulumi.get(self, "total_count")


class AwaitableAccessesResult(AccessesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return AccessesResult(
            accesses=self.accesses,
            fs_name=self.fs_name,
            id=self.id,
            output_file=self.output_file,
            total_count=self.total_count)


def accesses(fs_name: Optional[str] = None,
             output_file: Optional[str] = None,
             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableAccessesResult:
    """
    Use this data source to query detailed information of cloudfs accesses
    ## Example Usage

    ```python
    import pulumi
    import pulumi_volcengine as volcengine

    default = volcengine.cloudfs.accesses(fs_name="tftest2")
    ```


    :param str fs_name: The name of file system.
    :param str output_file: File name where to save data source results.
    """
    __args__ = dict()
    __args__['fsName'] = fs_name
    __args__['outputFile'] = output_file
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('volcengine:cloudfs/accesses:Accesses', __args__, opts=opts, typ=AccessesResult).value

    return AwaitableAccessesResult(
        accesses=pulumi.get(__ret__, 'accesses'),
        fs_name=pulumi.get(__ret__, 'fs_name'),
        id=pulumi.get(__ret__, 'id'),
        output_file=pulumi.get(__ret__, 'output_file'),
        total_count=pulumi.get(__ret__, 'total_count'))


@_utilities.lift_output_func(accesses)
def accesses_output(fs_name: Optional[pulumi.Input[str]] = None,
                    output_file: Optional[pulumi.Input[Optional[str]]] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[AccessesResult]:
    """
    Use this data source to query detailed information of cloudfs accesses
    ## Example Usage

    ```python
    import pulumi
    import pulumi_volcengine as volcengine

    default = volcengine.cloudfs.accesses(fs_name="tftest2")
    ```


    :param str fs_name: The name of file system.
    :param str output_file: File name where to save data source results.
    """
    ...
