# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['FileSystemArgs', 'FileSystem']

@pulumi.input_type
class FileSystemArgs:
    def __init__(__self__, *,
                 cache_plan: pulumi.Input[str],
                 fs_name: pulumi.Input[str],
                 mode: pulumi.Input[str],
                 zone_id: pulumi.Input[str],
                 cache_capacity_tib: Optional[pulumi.Input[int]] = None,
                 read_only: Optional[pulumi.Input[bool]] = None,
                 security_group_id: Optional[pulumi.Input[str]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 tos_account_id: Optional[pulumi.Input[int]] = None,
                 tos_ak: Optional[pulumi.Input[str]] = None,
                 tos_bucket: Optional[pulumi.Input[str]] = None,
                 tos_prefix: Optional[pulumi.Input[str]] = None,
                 tos_sk: Optional[pulumi.Input[str]] = None,
                 vpc_route_enabled: Optional[pulumi.Input[bool]] = None):
        """
        The set of arguments for constructing a FileSystem resource.
        :param pulumi.Input[str] cache_plan: The cache plan. The value can be `DISABLED` or `T2` or `T4`. When expanding the cache size, the cache plan should remain the same. For data lakes, cache must be enabled.
        :param pulumi.Input[str] fs_name: The name of file system.
        :param pulumi.Input[str] mode: The mode of file system. The value can be `HDFS_MODE` or `ACC_MODE`.
        :param pulumi.Input[str] zone_id: The id of zone.
        :param pulumi.Input[int] cache_capacity_tib: The capacity of cache. This parameter is required when cache acceleration is enabled.
        :param pulumi.Input[bool] read_only: Whether the Namespace created automatically when mounting the TOS Bucket is read-only. When importing resources, this attribute will not be imported. If this attribute is set, please use lifecycle and ignore_changes ignore changes in fields.
        :param pulumi.Input[str] security_group_id: The id of security group. This parameter is required when cache acceleration is enabled.
        :param pulumi.Input[str] subnet_id: The id of subnet. This parameter is required when cache acceleration is enabled.
        :param pulumi.Input[int] tos_account_id: When a data lake scenario instance chooses to associate a bucket under another account, you need to set the ID of the account. When importing resources, this attribute will not be imported.
        :param pulumi.Input[str] tos_ak: The tos ak. When the data lake scenario chooses to associate buckets under other accounts, need to set the Access Key ID of the account. When importing resources, this attribute will not be imported.
        :param pulumi.Input[str] tos_bucket: The tos bucket. When importing ACC_MODE resources, this attribute will not be imported.
        :param pulumi.Input[str] tos_prefix: The tos prefix. Must not start with /, but must end with /, such as prefix/. When it is empty, it means the root path. When importing ACC_MODE resources, this attribute will not be imported.
        :param pulumi.Input[str] tos_sk: The tos sk. When the data lake scenario chooses to associate buckets under other accounts, need to set the Secret Access Key of the account. When importing resources, this attribute will not be imported.
        :param pulumi.Input[bool] vpc_route_enabled: Whether enable all vpc route.
        """
        pulumi.set(__self__, "cache_plan", cache_plan)
        pulumi.set(__self__, "fs_name", fs_name)
        pulumi.set(__self__, "mode", mode)
        pulumi.set(__self__, "zone_id", zone_id)
        if cache_capacity_tib is not None:
            pulumi.set(__self__, "cache_capacity_tib", cache_capacity_tib)
        if read_only is not None:
            pulumi.set(__self__, "read_only", read_only)
        if security_group_id is not None:
            pulumi.set(__self__, "security_group_id", security_group_id)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)
        if tos_account_id is not None:
            pulumi.set(__self__, "tos_account_id", tos_account_id)
        if tos_ak is not None:
            pulumi.set(__self__, "tos_ak", tos_ak)
        if tos_bucket is not None:
            pulumi.set(__self__, "tos_bucket", tos_bucket)
        if tos_prefix is not None:
            pulumi.set(__self__, "tos_prefix", tos_prefix)
        if tos_sk is not None:
            pulumi.set(__self__, "tos_sk", tos_sk)
        if vpc_route_enabled is not None:
            pulumi.set(__self__, "vpc_route_enabled", vpc_route_enabled)

    @property
    @pulumi.getter(name="cachePlan")
    def cache_plan(self) -> pulumi.Input[str]:
        """
        The cache plan. The value can be `DISABLED` or `T2` or `T4`. When expanding the cache size, the cache plan should remain the same. For data lakes, cache must be enabled.
        """
        return pulumi.get(self, "cache_plan")

    @cache_plan.setter
    def cache_plan(self, value: pulumi.Input[str]):
        pulumi.set(self, "cache_plan", value)

    @property
    @pulumi.getter(name="fsName")
    def fs_name(self) -> pulumi.Input[str]:
        """
        The name of file system.
        """
        return pulumi.get(self, "fs_name")

    @fs_name.setter
    def fs_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "fs_name", value)

    @property
    @pulumi.getter
    def mode(self) -> pulumi.Input[str]:
        """
        The mode of file system. The value can be `HDFS_MODE` or `ACC_MODE`.
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: pulumi.Input[str]):
        pulumi.set(self, "mode", value)

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Input[str]:
        """
        The id of zone.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "zone_id", value)

    @property
    @pulumi.getter(name="cacheCapacityTib")
    def cache_capacity_tib(self) -> Optional[pulumi.Input[int]]:
        """
        The capacity of cache. This parameter is required when cache acceleration is enabled.
        """
        return pulumi.get(self, "cache_capacity_tib")

    @cache_capacity_tib.setter
    def cache_capacity_tib(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "cache_capacity_tib", value)

    @property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the Namespace created automatically when mounting the TOS Bucket is read-only. When importing resources, this attribute will not be imported. If this attribute is set, please use lifecycle and ignore_changes ignore changes in fields.
        """
        return pulumi.get(self, "read_only")

    @read_only.setter
    def read_only(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "read_only", value)

    @property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        The id of security group. This parameter is required when cache acceleration is enabled.
        """
        return pulumi.get(self, "security_group_id")

    @security_group_id.setter
    def security_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "security_group_id", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[str]]:
        """
        The id of subnet. This parameter is required when cache acceleration is enabled.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subnet_id", value)

    @property
    @pulumi.getter(name="tosAccountId")
    def tos_account_id(self) -> Optional[pulumi.Input[int]]:
        """
        When a data lake scenario instance chooses to associate a bucket under another account, you need to set the ID of the account. When importing resources, this attribute will not be imported.
        """
        return pulumi.get(self, "tos_account_id")

    @tos_account_id.setter
    def tos_account_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "tos_account_id", value)

    @property
    @pulumi.getter(name="tosAk")
    def tos_ak(self) -> Optional[pulumi.Input[str]]:
        """
        The tos ak. When the data lake scenario chooses to associate buckets under other accounts, need to set the Access Key ID of the account. When importing resources, this attribute will not be imported.
        """
        return pulumi.get(self, "tos_ak")

    @tos_ak.setter
    def tos_ak(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tos_ak", value)

    @property
    @pulumi.getter(name="tosBucket")
    def tos_bucket(self) -> Optional[pulumi.Input[str]]:
        """
        The tos bucket. When importing ACC_MODE resources, this attribute will not be imported.
        """
        return pulumi.get(self, "tos_bucket")

    @tos_bucket.setter
    def tos_bucket(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tos_bucket", value)

    @property
    @pulumi.getter(name="tosPrefix")
    def tos_prefix(self) -> Optional[pulumi.Input[str]]:
        """
        The tos prefix. Must not start with /, but must end with /, such as prefix/. When it is empty, it means the root path. When importing ACC_MODE resources, this attribute will not be imported.
        """
        return pulumi.get(self, "tos_prefix")

    @tos_prefix.setter
    def tos_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tos_prefix", value)

    @property
    @pulumi.getter(name="tosSk")
    def tos_sk(self) -> Optional[pulumi.Input[str]]:
        """
        The tos sk. When the data lake scenario chooses to associate buckets under other accounts, need to set the Secret Access Key of the account. When importing resources, this attribute will not be imported.
        """
        return pulumi.get(self, "tos_sk")

    @tos_sk.setter
    def tos_sk(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tos_sk", value)

    @property
    @pulumi.getter(name="vpcRouteEnabled")
    def vpc_route_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether enable all vpc route.
        """
        return pulumi.get(self, "vpc_route_enabled")

    @vpc_route_enabled.setter
    def vpc_route_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "vpc_route_enabled", value)


@pulumi.input_type
class _FileSystemState:
    def __init__(__self__, *,
                 access_id: Optional[pulumi.Input[str]] = None,
                 cache_capacity_tib: Optional[pulumi.Input[int]] = None,
                 cache_plan: Optional[pulumi.Input[str]] = None,
                 created_time: Optional[pulumi.Input[str]] = None,
                 fs_name: Optional[pulumi.Input[str]] = None,
                 mode: Optional[pulumi.Input[str]] = None,
                 mount_point: Optional[pulumi.Input[str]] = None,
                 read_only: Optional[pulumi.Input[bool]] = None,
                 security_group_id: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 tos_account_id: Optional[pulumi.Input[int]] = None,
                 tos_ak: Optional[pulumi.Input[str]] = None,
                 tos_bucket: Optional[pulumi.Input[str]] = None,
                 tos_prefix: Optional[pulumi.Input[str]] = None,
                 tos_sk: Optional[pulumi.Input[str]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 vpc_route_enabled: Optional[pulumi.Input[bool]] = None,
                 zone_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering FileSystem resources.
        :param pulumi.Input[str] access_id: The default vpc access id.
        :param pulumi.Input[int] cache_capacity_tib: The capacity of cache. This parameter is required when cache acceleration is enabled.
        :param pulumi.Input[str] cache_plan: The cache plan. The value can be `DISABLED` or `T2` or `T4`. When expanding the cache size, the cache plan should remain the same. For data lakes, cache must be enabled.
        :param pulumi.Input[str] created_time: The creation time.
        :param pulumi.Input[str] fs_name: The name of file system.
        :param pulumi.Input[str] mode: The mode of file system. The value can be `HDFS_MODE` or `ACC_MODE`.
        :param pulumi.Input[str] mount_point: The point mount.
        :param pulumi.Input[bool] read_only: Whether the Namespace created automatically when mounting the TOS Bucket is read-only. When importing resources, this attribute will not be imported. If this attribute is set, please use lifecycle and ignore_changes ignore changes in fields.
        :param pulumi.Input[str] security_group_id: The id of security group. This parameter is required when cache acceleration is enabled.
        :param pulumi.Input[str] status: Status of file system.
        :param pulumi.Input[str] subnet_id: The id of subnet. This parameter is required when cache acceleration is enabled.
        :param pulumi.Input[int] tos_account_id: When a data lake scenario instance chooses to associate a bucket under another account, you need to set the ID of the account. When importing resources, this attribute will not be imported.
        :param pulumi.Input[str] tos_ak: The tos ak. When the data lake scenario chooses to associate buckets under other accounts, need to set the Access Key ID of the account. When importing resources, this attribute will not be imported.
        :param pulumi.Input[str] tos_bucket: The tos bucket. When importing ACC_MODE resources, this attribute will not be imported.
        :param pulumi.Input[str] tos_prefix: The tos prefix. Must not start with /, but must end with /, such as prefix/. When it is empty, it means the root path. When importing ACC_MODE resources, this attribute will not be imported.
        :param pulumi.Input[str] tos_sk: The tos sk. When the data lake scenario chooses to associate buckets under other accounts, need to set the Secret Access Key of the account. When importing resources, this attribute will not be imported.
        :param pulumi.Input[str] vpc_id: The id of vpc.
        :param pulumi.Input[bool] vpc_route_enabled: Whether enable all vpc route.
        :param pulumi.Input[str] zone_id: The id of zone.
        """
        if access_id is not None:
            pulumi.set(__self__, "access_id", access_id)
        if cache_capacity_tib is not None:
            pulumi.set(__self__, "cache_capacity_tib", cache_capacity_tib)
        if cache_plan is not None:
            pulumi.set(__self__, "cache_plan", cache_plan)
        if created_time is not None:
            pulumi.set(__self__, "created_time", created_time)
        if fs_name is not None:
            pulumi.set(__self__, "fs_name", fs_name)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if mount_point is not None:
            pulumi.set(__self__, "mount_point", mount_point)
        if read_only is not None:
            pulumi.set(__self__, "read_only", read_only)
        if security_group_id is not None:
            pulumi.set(__self__, "security_group_id", security_group_id)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)
        if tos_account_id is not None:
            pulumi.set(__self__, "tos_account_id", tos_account_id)
        if tos_ak is not None:
            pulumi.set(__self__, "tos_ak", tos_ak)
        if tos_bucket is not None:
            pulumi.set(__self__, "tos_bucket", tos_bucket)
        if tos_prefix is not None:
            pulumi.set(__self__, "tos_prefix", tos_prefix)
        if tos_sk is not None:
            pulumi.set(__self__, "tos_sk", tos_sk)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)
        if vpc_route_enabled is not None:
            pulumi.set(__self__, "vpc_route_enabled", vpc_route_enabled)
        if zone_id is not None:
            pulumi.set(__self__, "zone_id", zone_id)

    @property
    @pulumi.getter(name="accessId")
    def access_id(self) -> Optional[pulumi.Input[str]]:
        """
        The default vpc access id.
        """
        return pulumi.get(self, "access_id")

    @access_id.setter
    def access_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "access_id", value)

    @property
    @pulumi.getter(name="cacheCapacityTib")
    def cache_capacity_tib(self) -> Optional[pulumi.Input[int]]:
        """
        The capacity of cache. This parameter is required when cache acceleration is enabled.
        """
        return pulumi.get(self, "cache_capacity_tib")

    @cache_capacity_tib.setter
    def cache_capacity_tib(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "cache_capacity_tib", value)

    @property
    @pulumi.getter(name="cachePlan")
    def cache_plan(self) -> Optional[pulumi.Input[str]]:
        """
        The cache plan. The value can be `DISABLED` or `T2` or `T4`. When expanding the cache size, the cache plan should remain the same. For data lakes, cache must be enabled.
        """
        return pulumi.get(self, "cache_plan")

    @cache_plan.setter
    def cache_plan(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cache_plan", value)

    @property
    @pulumi.getter(name="createdTime")
    def created_time(self) -> Optional[pulumi.Input[str]]:
        """
        The creation time.
        """
        return pulumi.get(self, "created_time")

    @created_time.setter
    def created_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "created_time", value)

    @property
    @pulumi.getter(name="fsName")
    def fs_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of file system.
        """
        return pulumi.get(self, "fs_name")

    @fs_name.setter
    def fs_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fs_name", value)

    @property
    @pulumi.getter
    def mode(self) -> Optional[pulumi.Input[str]]:
        """
        The mode of file system. The value can be `HDFS_MODE` or `ACC_MODE`.
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mode", value)

    @property
    @pulumi.getter(name="mountPoint")
    def mount_point(self) -> Optional[pulumi.Input[str]]:
        """
        The point mount.
        """
        return pulumi.get(self, "mount_point")

    @mount_point.setter
    def mount_point(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mount_point", value)

    @property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the Namespace created automatically when mounting the TOS Bucket is read-only. When importing resources, this attribute will not be imported. If this attribute is set, please use lifecycle and ignore_changes ignore changes in fields.
        """
        return pulumi.get(self, "read_only")

    @read_only.setter
    def read_only(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "read_only", value)

    @property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        The id of security group. This parameter is required when cache acceleration is enabled.
        """
        return pulumi.get(self, "security_group_id")

    @security_group_id.setter
    def security_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "security_group_id", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        Status of file system.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[str]]:
        """
        The id of subnet. This parameter is required when cache acceleration is enabled.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subnet_id", value)

    @property
    @pulumi.getter(name="tosAccountId")
    def tos_account_id(self) -> Optional[pulumi.Input[int]]:
        """
        When a data lake scenario instance chooses to associate a bucket under another account, you need to set the ID of the account. When importing resources, this attribute will not be imported.
        """
        return pulumi.get(self, "tos_account_id")

    @tos_account_id.setter
    def tos_account_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "tos_account_id", value)

    @property
    @pulumi.getter(name="tosAk")
    def tos_ak(self) -> Optional[pulumi.Input[str]]:
        """
        The tos ak. When the data lake scenario chooses to associate buckets under other accounts, need to set the Access Key ID of the account. When importing resources, this attribute will not be imported.
        """
        return pulumi.get(self, "tos_ak")

    @tos_ak.setter
    def tos_ak(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tos_ak", value)

    @property
    @pulumi.getter(name="tosBucket")
    def tos_bucket(self) -> Optional[pulumi.Input[str]]:
        """
        The tos bucket. When importing ACC_MODE resources, this attribute will not be imported.
        """
        return pulumi.get(self, "tos_bucket")

    @tos_bucket.setter
    def tos_bucket(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tos_bucket", value)

    @property
    @pulumi.getter(name="tosPrefix")
    def tos_prefix(self) -> Optional[pulumi.Input[str]]:
        """
        The tos prefix. Must not start with /, but must end with /, such as prefix/. When it is empty, it means the root path. When importing ACC_MODE resources, this attribute will not be imported.
        """
        return pulumi.get(self, "tos_prefix")

    @tos_prefix.setter
    def tos_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tos_prefix", value)

    @property
    @pulumi.getter(name="tosSk")
    def tos_sk(self) -> Optional[pulumi.Input[str]]:
        """
        The tos sk. When the data lake scenario chooses to associate buckets under other accounts, need to set the Secret Access Key of the account. When importing resources, this attribute will not be imported.
        """
        return pulumi.get(self, "tos_sk")

    @tos_sk.setter
    def tos_sk(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tos_sk", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[str]]:
        """
        The id of vpc.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc_id", value)

    @property
    @pulumi.getter(name="vpcRouteEnabled")
    def vpc_route_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether enable all vpc route.
        """
        return pulumi.get(self, "vpc_route_enabled")

    @vpc_route_enabled.setter
    def vpc_route_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "vpc_route_enabled", value)

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[pulumi.Input[str]]:
        """
        The id of zone.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "zone_id", value)


class FileSystem(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cache_capacity_tib: Optional[pulumi.Input[int]] = None,
                 cache_plan: Optional[pulumi.Input[str]] = None,
                 fs_name: Optional[pulumi.Input[str]] = None,
                 mode: Optional[pulumi.Input[str]] = None,
                 read_only: Optional[pulumi.Input[bool]] = None,
                 security_group_id: Optional[pulumi.Input[str]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 tos_account_id: Optional[pulumi.Input[int]] = None,
                 tos_ak: Optional[pulumi.Input[str]] = None,
                 tos_bucket: Optional[pulumi.Input[str]] = None,
                 tos_prefix: Optional[pulumi.Input[str]] = None,
                 tos_sk: Optional[pulumi.Input[str]] = None,
                 vpc_route_enabled: Optional[pulumi.Input[bool]] = None,
                 zone_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a resource to manage cloudfs file system
        ## Example Usage

        ```python
        import pulumi
        import pulumi_volcengine as volcengine

        foo = volcengine.cloudfs.FileSystem("foo",
            cache_capacity_tib=10,
            cache_plan="T2",
            fs_name="tffile",
            mode="HDFS_MODE",
            read_only=True,
            security_group_id="sg-rrv1klfg5s00v0x578mx14m",
            subnet_id="subnet-13fca1crr5d6o3n6nu46cyb5m",
            tos_bucket="tfacc",
            tos_prefix="pre/",
            vpc_route_enabled=True,
            zone_id="cn-beijing-b")
        foo1 = volcengine.cloudfs.FileSystem("foo1",
            cache_capacity_tib=15,
            cache_plan="T2",
            fs_name="tffileu",
            mode="ACC_MODE",
            read_only=True,
            security_group_id="sg-rrv1klfg5s00v0x578mx14m",
            subnet_id="subnet-13fca1crr5d6o3n6nu46cyb5m",
            tos_bucket="tfacc",
            vpc_route_enabled=False,
            zone_id="cn-beijing-b")
        ```

        ## Import

        CloudFileSystem can be imported using the FsName, e.g.

        ```sh
         $ pulumi import volcengine:cloudfs/fileSystem:FileSystem default tfname
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] cache_capacity_tib: The capacity of cache. This parameter is required when cache acceleration is enabled.
        :param pulumi.Input[str] cache_plan: The cache plan. The value can be `DISABLED` or `T2` or `T4`. When expanding the cache size, the cache plan should remain the same. For data lakes, cache must be enabled.
        :param pulumi.Input[str] fs_name: The name of file system.
        :param pulumi.Input[str] mode: The mode of file system. The value can be `HDFS_MODE` or `ACC_MODE`.
        :param pulumi.Input[bool] read_only: Whether the Namespace created automatically when mounting the TOS Bucket is read-only. When importing resources, this attribute will not be imported. If this attribute is set, please use lifecycle and ignore_changes ignore changes in fields.
        :param pulumi.Input[str] security_group_id: The id of security group. This parameter is required when cache acceleration is enabled.
        :param pulumi.Input[str] subnet_id: The id of subnet. This parameter is required when cache acceleration is enabled.
        :param pulumi.Input[int] tos_account_id: When a data lake scenario instance chooses to associate a bucket under another account, you need to set the ID of the account. When importing resources, this attribute will not be imported.
        :param pulumi.Input[str] tos_ak: The tos ak. When the data lake scenario chooses to associate buckets under other accounts, need to set the Access Key ID of the account. When importing resources, this attribute will not be imported.
        :param pulumi.Input[str] tos_bucket: The tos bucket. When importing ACC_MODE resources, this attribute will not be imported.
        :param pulumi.Input[str] tos_prefix: The tos prefix. Must not start with /, but must end with /, such as prefix/. When it is empty, it means the root path. When importing ACC_MODE resources, this attribute will not be imported.
        :param pulumi.Input[str] tos_sk: The tos sk. When the data lake scenario chooses to associate buckets under other accounts, need to set the Secret Access Key of the account. When importing resources, this attribute will not be imported.
        :param pulumi.Input[bool] vpc_route_enabled: Whether enable all vpc route.
        :param pulumi.Input[str] zone_id: The id of zone.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FileSystemArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a resource to manage cloudfs file system
        ## Example Usage

        ```python
        import pulumi
        import pulumi_volcengine as volcengine

        foo = volcengine.cloudfs.FileSystem("foo",
            cache_capacity_tib=10,
            cache_plan="T2",
            fs_name="tffile",
            mode="HDFS_MODE",
            read_only=True,
            security_group_id="sg-rrv1klfg5s00v0x578mx14m",
            subnet_id="subnet-13fca1crr5d6o3n6nu46cyb5m",
            tos_bucket="tfacc",
            tos_prefix="pre/",
            vpc_route_enabled=True,
            zone_id="cn-beijing-b")
        foo1 = volcengine.cloudfs.FileSystem("foo1",
            cache_capacity_tib=15,
            cache_plan="T2",
            fs_name="tffileu",
            mode="ACC_MODE",
            read_only=True,
            security_group_id="sg-rrv1klfg5s00v0x578mx14m",
            subnet_id="subnet-13fca1crr5d6o3n6nu46cyb5m",
            tos_bucket="tfacc",
            vpc_route_enabled=False,
            zone_id="cn-beijing-b")
        ```

        ## Import

        CloudFileSystem can be imported using the FsName, e.g.

        ```sh
         $ pulumi import volcengine:cloudfs/fileSystem:FileSystem default tfname
        ```

        :param str resource_name: The name of the resource.
        :param FileSystemArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FileSystemArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cache_capacity_tib: Optional[pulumi.Input[int]] = None,
                 cache_plan: Optional[pulumi.Input[str]] = None,
                 fs_name: Optional[pulumi.Input[str]] = None,
                 mode: Optional[pulumi.Input[str]] = None,
                 read_only: Optional[pulumi.Input[bool]] = None,
                 security_group_id: Optional[pulumi.Input[str]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 tos_account_id: Optional[pulumi.Input[int]] = None,
                 tos_ak: Optional[pulumi.Input[str]] = None,
                 tos_bucket: Optional[pulumi.Input[str]] = None,
                 tos_prefix: Optional[pulumi.Input[str]] = None,
                 tos_sk: Optional[pulumi.Input[str]] = None,
                 vpc_route_enabled: Optional[pulumi.Input[bool]] = None,
                 zone_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FileSystemArgs.__new__(FileSystemArgs)

            __props__.__dict__["cache_capacity_tib"] = cache_capacity_tib
            if cache_plan is None and not opts.urn:
                raise TypeError("Missing required property 'cache_plan'")
            __props__.__dict__["cache_plan"] = cache_plan
            if fs_name is None and not opts.urn:
                raise TypeError("Missing required property 'fs_name'")
            __props__.__dict__["fs_name"] = fs_name
            if mode is None and not opts.urn:
                raise TypeError("Missing required property 'mode'")
            __props__.__dict__["mode"] = mode
            __props__.__dict__["read_only"] = read_only
            __props__.__dict__["security_group_id"] = security_group_id
            __props__.__dict__["subnet_id"] = subnet_id
            __props__.__dict__["tos_account_id"] = tos_account_id
            __props__.__dict__["tos_ak"] = tos_ak
            __props__.__dict__["tos_bucket"] = tos_bucket
            __props__.__dict__["tos_prefix"] = tos_prefix
            __props__.__dict__["tos_sk"] = tos_sk
            __props__.__dict__["vpc_route_enabled"] = vpc_route_enabled
            if zone_id is None and not opts.urn:
                raise TypeError("Missing required property 'zone_id'")
            __props__.__dict__["zone_id"] = zone_id
            __props__.__dict__["access_id"] = None
            __props__.__dict__["created_time"] = None
            __props__.__dict__["mount_point"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["vpc_id"] = None
        super(FileSystem, __self__).__init__(
            'volcengine:cloudfs/fileSystem:FileSystem',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access_id: Optional[pulumi.Input[str]] = None,
            cache_capacity_tib: Optional[pulumi.Input[int]] = None,
            cache_plan: Optional[pulumi.Input[str]] = None,
            created_time: Optional[pulumi.Input[str]] = None,
            fs_name: Optional[pulumi.Input[str]] = None,
            mode: Optional[pulumi.Input[str]] = None,
            mount_point: Optional[pulumi.Input[str]] = None,
            read_only: Optional[pulumi.Input[bool]] = None,
            security_group_id: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None,
            subnet_id: Optional[pulumi.Input[str]] = None,
            tos_account_id: Optional[pulumi.Input[int]] = None,
            tos_ak: Optional[pulumi.Input[str]] = None,
            tos_bucket: Optional[pulumi.Input[str]] = None,
            tos_prefix: Optional[pulumi.Input[str]] = None,
            tos_sk: Optional[pulumi.Input[str]] = None,
            vpc_id: Optional[pulumi.Input[str]] = None,
            vpc_route_enabled: Optional[pulumi.Input[bool]] = None,
            zone_id: Optional[pulumi.Input[str]] = None) -> 'FileSystem':
        """
        Get an existing FileSystem resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] access_id: The default vpc access id.
        :param pulumi.Input[int] cache_capacity_tib: The capacity of cache. This parameter is required when cache acceleration is enabled.
        :param pulumi.Input[str] cache_plan: The cache plan. The value can be `DISABLED` or `T2` or `T4`. When expanding the cache size, the cache plan should remain the same. For data lakes, cache must be enabled.
        :param pulumi.Input[str] created_time: The creation time.
        :param pulumi.Input[str] fs_name: The name of file system.
        :param pulumi.Input[str] mode: The mode of file system. The value can be `HDFS_MODE` or `ACC_MODE`.
        :param pulumi.Input[str] mount_point: The point mount.
        :param pulumi.Input[bool] read_only: Whether the Namespace created automatically when mounting the TOS Bucket is read-only. When importing resources, this attribute will not be imported. If this attribute is set, please use lifecycle and ignore_changes ignore changes in fields.
        :param pulumi.Input[str] security_group_id: The id of security group. This parameter is required when cache acceleration is enabled.
        :param pulumi.Input[str] status: Status of file system.
        :param pulumi.Input[str] subnet_id: The id of subnet. This parameter is required when cache acceleration is enabled.
        :param pulumi.Input[int] tos_account_id: When a data lake scenario instance chooses to associate a bucket under another account, you need to set the ID of the account. When importing resources, this attribute will not be imported.
        :param pulumi.Input[str] tos_ak: The tos ak. When the data lake scenario chooses to associate buckets under other accounts, need to set the Access Key ID of the account. When importing resources, this attribute will not be imported.
        :param pulumi.Input[str] tos_bucket: The tos bucket. When importing ACC_MODE resources, this attribute will not be imported.
        :param pulumi.Input[str] tos_prefix: The tos prefix. Must not start with /, but must end with /, such as prefix/. When it is empty, it means the root path. When importing ACC_MODE resources, this attribute will not be imported.
        :param pulumi.Input[str] tos_sk: The tos sk. When the data lake scenario chooses to associate buckets under other accounts, need to set the Secret Access Key of the account. When importing resources, this attribute will not be imported.
        :param pulumi.Input[str] vpc_id: The id of vpc.
        :param pulumi.Input[bool] vpc_route_enabled: Whether enable all vpc route.
        :param pulumi.Input[str] zone_id: The id of zone.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FileSystemState.__new__(_FileSystemState)

        __props__.__dict__["access_id"] = access_id
        __props__.__dict__["cache_capacity_tib"] = cache_capacity_tib
        __props__.__dict__["cache_plan"] = cache_plan
        __props__.__dict__["created_time"] = created_time
        __props__.__dict__["fs_name"] = fs_name
        __props__.__dict__["mode"] = mode
        __props__.__dict__["mount_point"] = mount_point
        __props__.__dict__["read_only"] = read_only
        __props__.__dict__["security_group_id"] = security_group_id
        __props__.__dict__["status"] = status
        __props__.__dict__["subnet_id"] = subnet_id
        __props__.__dict__["tos_account_id"] = tos_account_id
        __props__.__dict__["tos_ak"] = tos_ak
        __props__.__dict__["tos_bucket"] = tos_bucket
        __props__.__dict__["tos_prefix"] = tos_prefix
        __props__.__dict__["tos_sk"] = tos_sk
        __props__.__dict__["vpc_id"] = vpc_id
        __props__.__dict__["vpc_route_enabled"] = vpc_route_enabled
        __props__.__dict__["zone_id"] = zone_id
        return FileSystem(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accessId")
    def access_id(self) -> pulumi.Output[str]:
        """
        The default vpc access id.
        """
        return pulumi.get(self, "access_id")

    @property
    @pulumi.getter(name="cacheCapacityTib")
    def cache_capacity_tib(self) -> pulumi.Output[Optional[int]]:
        """
        The capacity of cache. This parameter is required when cache acceleration is enabled.
        """
        return pulumi.get(self, "cache_capacity_tib")

    @property
    @pulumi.getter(name="cachePlan")
    def cache_plan(self) -> pulumi.Output[str]:
        """
        The cache plan. The value can be `DISABLED` or `T2` or `T4`. When expanding the cache size, the cache plan should remain the same. For data lakes, cache must be enabled.
        """
        return pulumi.get(self, "cache_plan")

    @property
    @pulumi.getter(name="createdTime")
    def created_time(self) -> pulumi.Output[str]:
        """
        The creation time.
        """
        return pulumi.get(self, "created_time")

    @property
    @pulumi.getter(name="fsName")
    def fs_name(self) -> pulumi.Output[str]:
        """
        The name of file system.
        """
        return pulumi.get(self, "fs_name")

    @property
    @pulumi.getter
    def mode(self) -> pulumi.Output[str]:
        """
        The mode of file system. The value can be `HDFS_MODE` or `ACC_MODE`.
        """
        return pulumi.get(self, "mode")

    @property
    @pulumi.getter(name="mountPoint")
    def mount_point(self) -> pulumi.Output[str]:
        """
        The point mount.
        """
        return pulumi.get(self, "mount_point")

    @property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether the Namespace created automatically when mounting the TOS Bucket is read-only. When importing resources, this attribute will not be imported. If this attribute is set, please use lifecycle and ignore_changes ignore changes in fields.
        """
        return pulumi.get(self, "read_only")

    @property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> pulumi.Output[Optional[str]]:
        """
        The id of security group. This parameter is required when cache acceleration is enabled.
        """
        return pulumi.get(self, "security_group_id")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        Status of file system.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Output[Optional[str]]:
        """
        The id of subnet. This parameter is required when cache acceleration is enabled.
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter(name="tosAccountId")
    def tos_account_id(self) -> pulumi.Output[Optional[int]]:
        """
        When a data lake scenario instance chooses to associate a bucket under another account, you need to set the ID of the account. When importing resources, this attribute will not be imported.
        """
        return pulumi.get(self, "tos_account_id")

    @property
    @pulumi.getter(name="tosAk")
    def tos_ak(self) -> pulumi.Output[Optional[str]]:
        """
        The tos ak. When the data lake scenario chooses to associate buckets under other accounts, need to set the Access Key ID of the account. When importing resources, this attribute will not be imported.
        """
        return pulumi.get(self, "tos_ak")

    @property
    @pulumi.getter(name="tosBucket")
    def tos_bucket(self) -> pulumi.Output[Optional[str]]:
        """
        The tos bucket. When importing ACC_MODE resources, this attribute will not be imported.
        """
        return pulumi.get(self, "tos_bucket")

    @property
    @pulumi.getter(name="tosPrefix")
    def tos_prefix(self) -> pulumi.Output[Optional[str]]:
        """
        The tos prefix. Must not start with /, but must end with /, such as prefix/. When it is empty, it means the root path. When importing ACC_MODE resources, this attribute will not be imported.
        """
        return pulumi.get(self, "tos_prefix")

    @property
    @pulumi.getter(name="tosSk")
    def tos_sk(self) -> pulumi.Output[Optional[str]]:
        """
        The tos sk. When the data lake scenario chooses to associate buckets under other accounts, need to set the Secret Access Key of the account. When importing resources, this attribute will not be imported.
        """
        return pulumi.get(self, "tos_sk")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[str]:
        """
        The id of vpc.
        """
        return pulumi.get(self, "vpc_id")

    @property
    @pulumi.getter(name="vpcRouteEnabled")
    def vpc_route_enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether enable all vpc route.
        """
        return pulumi.get(self, "vpc_route_enabled")

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Output[str]:
        """
        The id of zone.
        """
        return pulumi.get(self, "zone_id")

