# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'FileSystemsResult',
    'AwaitableFileSystemsResult',
    'file_systems',
    'file_systems_output',
]

@pulumi.output_type
class FileSystemsResult:
    """
    A collection of values returned by FileSystems.
    """
    def __init__(__self__, file_systems=None, fs_name=None, id=None, meta_status=None, name_regex=None, output_file=None, total_count=None):
        if file_systems and not isinstance(file_systems, list):
            raise TypeError("Expected argument 'file_systems' to be a list")
        pulumi.set(__self__, "file_systems", file_systems)
        if fs_name and not isinstance(fs_name, str):
            raise TypeError("Expected argument 'fs_name' to be a str")
        pulumi.set(__self__, "fs_name", fs_name)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if meta_status and not isinstance(meta_status, str):
            raise TypeError("Expected argument 'meta_status' to be a str")
        pulumi.set(__self__, "meta_status", meta_status)
        if name_regex and not isinstance(name_regex, str):
            raise TypeError("Expected argument 'name_regex' to be a str")
        pulumi.set(__self__, "name_regex", name_regex)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if total_count and not isinstance(total_count, int):
            raise TypeError("Expected argument 'total_count' to be a int")
        pulumi.set(__self__, "total_count", total_count)

    @property
    @pulumi.getter(name="fileSystems")
    def file_systems(self) -> Sequence['outputs.FileSystemsFileSystemResult']:
        """
        The collection of query.
        """
        return pulumi.get(self, "file_systems")

    @property
    @pulumi.getter(name="fsName")
    def fs_name(self) -> Optional[str]:
        return pulumi.get(self, "fs_name")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="metaStatus")
    def meta_status(self) -> Optional[str]:
        return pulumi.get(self, "meta_status")

    @property
    @pulumi.getter(name="nameRegex")
    def name_regex(self) -> Optional[str]:
        return pulumi.get(self, "name_regex")

    @property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[str]:
        return pulumi.get(self, "output_file")

    @property
    @pulumi.getter(name="totalCount")
    def total_count(self) -> int:
        """
        The total count of query.
        """
        return pulumi.get(self, "total_count")


class AwaitableFileSystemsResult(FileSystemsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return FileSystemsResult(
            file_systems=self.file_systems,
            fs_name=self.fs_name,
            id=self.id,
            meta_status=self.meta_status,
            name_regex=self.name_regex,
            output_file=self.output_file,
            total_count=self.total_count)


def file_systems(fs_name: Optional[str] = None,
                 meta_status: Optional[str] = None,
                 name_regex: Optional[str] = None,
                 output_file: Optional[str] = None,
                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableFileSystemsResult:
    """
    Use this data source to query detailed information of cloudfs file systems
    ## Example Usage

    ```python
    import pulumi
    import pulumi_volcengine as volcengine

    default = volcengine.cloudfs.file_systems(fs_name="tftest2")
    ```


    :param str fs_name: The name of file system.
    :param str meta_status: The status of file system.
    :param str name_regex: A Name Regex of cloudfs.
    :param str output_file: File name where to save data source results.
    """
    __args__ = dict()
    __args__['fsName'] = fs_name
    __args__['metaStatus'] = meta_status
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('volcengine:cloudfs/fileSystems:FileSystems', __args__, opts=opts, typ=FileSystemsResult).value

    return AwaitableFileSystemsResult(
        file_systems=pulumi.get(__ret__, 'file_systems'),
        fs_name=pulumi.get(__ret__, 'fs_name'),
        id=pulumi.get(__ret__, 'id'),
        meta_status=pulumi.get(__ret__, 'meta_status'),
        name_regex=pulumi.get(__ret__, 'name_regex'),
        output_file=pulumi.get(__ret__, 'output_file'),
        total_count=pulumi.get(__ret__, 'total_count'))


@_utilities.lift_output_func(file_systems)
def file_systems_output(fs_name: Optional[pulumi.Input[Optional[str]]] = None,
                        meta_status: Optional[pulumi.Input[Optional[str]]] = None,
                        name_regex: Optional[pulumi.Input[Optional[str]]] = None,
                        output_file: Optional[pulumi.Input[Optional[str]]] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[FileSystemsResult]:
    """
    Use this data source to query detailed information of cloudfs file systems
    ## Example Usage

    ```python
    import pulumi
    import pulumi_volcengine as volcengine

    default = volcengine.cloudfs.file_systems(fs_name="tftest2")
    ```


    :param str fs_name: The name of file system.
    :param str meta_status: The status of file system.
    :param str name_regex: A Name Regex of cloudfs.
    :param str output_file: File name where to save data source results.
    """
    ...
