# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['NamespaceArgs', 'Namespace']

@pulumi.input_type
class NamespaceArgs:
    def __init__(__self__, *,
                 fs_name: pulumi.Input[str],
                 tos_bucket: pulumi.Input[str],
                 read_only: Optional[pulumi.Input[bool]] = None,
                 tos_account_id: Optional[pulumi.Input[int]] = None,
                 tos_ak: Optional[pulumi.Input[str]] = None,
                 tos_prefix: Optional[pulumi.Input[str]] = None,
                 tos_sk: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Namespace resource.
        :param pulumi.Input[str] fs_name: The name of file system.
        :param pulumi.Input[str] tos_bucket: The name of tos bucket.
        :param pulumi.Input[bool] read_only: Whether the namespace is read-only.
        :param pulumi.Input[int] tos_account_id: When a data lake scenario instance chooses to associate a bucket under another account, you need to set the ID of the account. When importing resources, this attribute will not be imported. If this attribute is set, please use lifecycle and ignore_changes ignore changes in fields.
        :param pulumi.Input[str] tos_ak: The tos ak. When the data lake scenario chooses to associate buckets under other accounts, need to set the Access Key ID of the account. When importing resources, this attribute will not be imported. If this attribute is set, please use lifecycle and ignore_changes ignore changes in fields.
        :param pulumi.Input[str] tos_prefix: The tos prefix. Must not start with /, but must end with /, such as prefix/. When it is empty, it means the root path.
        :param pulumi.Input[str] tos_sk: The tos sk. When the data lake scenario chooses to associate buckets under other accounts, need to set the Secret Access Key of the account. When importing resources, this attribute will not be imported. If this attribute is set, please use lifecycle and ignore_changes ignore changes in fields.
        """
        pulumi.set(__self__, "fs_name", fs_name)
        pulumi.set(__self__, "tos_bucket", tos_bucket)
        if read_only is not None:
            pulumi.set(__self__, "read_only", read_only)
        if tos_account_id is not None:
            pulumi.set(__self__, "tos_account_id", tos_account_id)
        if tos_ak is not None:
            pulumi.set(__self__, "tos_ak", tos_ak)
        if tos_prefix is not None:
            pulumi.set(__self__, "tos_prefix", tos_prefix)
        if tos_sk is not None:
            pulumi.set(__self__, "tos_sk", tos_sk)

    @property
    @pulumi.getter(name="fsName")
    def fs_name(self) -> pulumi.Input[str]:
        """
        The name of file system.
        """
        return pulumi.get(self, "fs_name")

    @fs_name.setter
    def fs_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "fs_name", value)

    @property
    @pulumi.getter(name="tosBucket")
    def tos_bucket(self) -> pulumi.Input[str]:
        """
        The name of tos bucket.
        """
        return pulumi.get(self, "tos_bucket")

    @tos_bucket.setter
    def tos_bucket(self, value: pulumi.Input[str]):
        pulumi.set(self, "tos_bucket", value)

    @property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the namespace is read-only.
        """
        return pulumi.get(self, "read_only")

    @read_only.setter
    def read_only(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "read_only", value)

    @property
    @pulumi.getter(name="tosAccountId")
    def tos_account_id(self) -> Optional[pulumi.Input[int]]:
        """
        When a data lake scenario instance chooses to associate a bucket under another account, you need to set the ID of the account. When importing resources, this attribute will not be imported. If this attribute is set, please use lifecycle and ignore_changes ignore changes in fields.
        """
        return pulumi.get(self, "tos_account_id")

    @tos_account_id.setter
    def tos_account_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "tos_account_id", value)

    @property
    @pulumi.getter(name="tosAk")
    def tos_ak(self) -> Optional[pulumi.Input[str]]:
        """
        The tos ak. When the data lake scenario chooses to associate buckets under other accounts, need to set the Access Key ID of the account. When importing resources, this attribute will not be imported. If this attribute is set, please use lifecycle and ignore_changes ignore changes in fields.
        """
        return pulumi.get(self, "tos_ak")

    @tos_ak.setter
    def tos_ak(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tos_ak", value)

    @property
    @pulumi.getter(name="tosPrefix")
    def tos_prefix(self) -> Optional[pulumi.Input[str]]:
        """
        The tos prefix. Must not start with /, but must end with /, such as prefix/. When it is empty, it means the root path.
        """
        return pulumi.get(self, "tos_prefix")

    @tos_prefix.setter
    def tos_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tos_prefix", value)

    @property
    @pulumi.getter(name="tosSk")
    def tos_sk(self) -> Optional[pulumi.Input[str]]:
        """
        The tos sk. When the data lake scenario chooses to associate buckets under other accounts, need to set the Secret Access Key of the account. When importing resources, this attribute will not be imported. If this attribute is set, please use lifecycle and ignore_changes ignore changes in fields.
        """
        return pulumi.get(self, "tos_sk")

    @tos_sk.setter
    def tos_sk(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tos_sk", value)


@pulumi.input_type
class _NamespaceState:
    def __init__(__self__, *,
                 created_time: Optional[pulumi.Input[str]] = None,
                 fs_name: Optional[pulumi.Input[str]] = None,
                 is_my_bucket: Optional[pulumi.Input[bool]] = None,
                 ns_id: Optional[pulumi.Input[str]] = None,
                 read_only: Optional[pulumi.Input[bool]] = None,
                 service_managed: Optional[pulumi.Input[bool]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 tos_account_id: Optional[pulumi.Input[int]] = None,
                 tos_ak: Optional[pulumi.Input[str]] = None,
                 tos_bucket: Optional[pulumi.Input[str]] = None,
                 tos_prefix: Optional[pulumi.Input[str]] = None,
                 tos_sk: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Namespace resources.
        :param pulumi.Input[str] created_time: The creation time of the namespace.
        :param pulumi.Input[str] fs_name: The name of file system.
        :param pulumi.Input[bool] is_my_bucket: Whether the tos bucket is your own bucket.
        :param pulumi.Input[str] ns_id: The id of namespace.
        :param pulumi.Input[bool] read_only: Whether the namespace is read-only.
        :param pulumi.Input[bool] service_managed: Whether the namespace is the official service for volcengine.
        :param pulumi.Input[str] status: The status of the namespace.
        :param pulumi.Input[int] tos_account_id: When a data lake scenario instance chooses to associate a bucket under another account, you need to set the ID of the account. When importing resources, this attribute will not be imported. If this attribute is set, please use lifecycle and ignore_changes ignore changes in fields.
        :param pulumi.Input[str] tos_ak: The tos ak. When the data lake scenario chooses to associate buckets under other accounts, need to set the Access Key ID of the account. When importing resources, this attribute will not be imported. If this attribute is set, please use lifecycle and ignore_changes ignore changes in fields.
        :param pulumi.Input[str] tos_bucket: The name of tos bucket.
        :param pulumi.Input[str] tos_prefix: The tos prefix. Must not start with /, but must end with /, such as prefix/. When it is empty, it means the root path.
        :param pulumi.Input[str] tos_sk: The tos sk. When the data lake scenario chooses to associate buckets under other accounts, need to set the Secret Access Key of the account. When importing resources, this attribute will not be imported. If this attribute is set, please use lifecycle and ignore_changes ignore changes in fields.
        """
        if created_time is not None:
            pulumi.set(__self__, "created_time", created_time)
        if fs_name is not None:
            pulumi.set(__self__, "fs_name", fs_name)
        if is_my_bucket is not None:
            pulumi.set(__self__, "is_my_bucket", is_my_bucket)
        if ns_id is not None:
            pulumi.set(__self__, "ns_id", ns_id)
        if read_only is not None:
            pulumi.set(__self__, "read_only", read_only)
        if service_managed is not None:
            pulumi.set(__self__, "service_managed", service_managed)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tos_account_id is not None:
            pulumi.set(__self__, "tos_account_id", tos_account_id)
        if tos_ak is not None:
            pulumi.set(__self__, "tos_ak", tos_ak)
        if tos_bucket is not None:
            pulumi.set(__self__, "tos_bucket", tos_bucket)
        if tos_prefix is not None:
            pulumi.set(__self__, "tos_prefix", tos_prefix)
        if tos_sk is not None:
            pulumi.set(__self__, "tos_sk", tos_sk)

    @property
    @pulumi.getter(name="createdTime")
    def created_time(self) -> Optional[pulumi.Input[str]]:
        """
        The creation time of the namespace.
        """
        return pulumi.get(self, "created_time")

    @created_time.setter
    def created_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "created_time", value)

    @property
    @pulumi.getter(name="fsName")
    def fs_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of file system.
        """
        return pulumi.get(self, "fs_name")

    @fs_name.setter
    def fs_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fs_name", value)

    @property
    @pulumi.getter(name="isMyBucket")
    def is_my_bucket(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the tos bucket is your own bucket.
        """
        return pulumi.get(self, "is_my_bucket")

    @is_my_bucket.setter
    def is_my_bucket(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_my_bucket", value)

    @property
    @pulumi.getter(name="nsId")
    def ns_id(self) -> Optional[pulumi.Input[str]]:
        """
        The id of namespace.
        """
        return pulumi.get(self, "ns_id")

    @ns_id.setter
    def ns_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ns_id", value)

    @property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the namespace is read-only.
        """
        return pulumi.get(self, "read_only")

    @read_only.setter
    def read_only(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "read_only", value)

    @property
    @pulumi.getter(name="serviceManaged")
    def service_managed(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the namespace is the official service for volcengine.
        """
        return pulumi.get(self, "service_managed")

    @service_managed.setter
    def service_managed(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "service_managed", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The status of the namespace.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="tosAccountId")
    def tos_account_id(self) -> Optional[pulumi.Input[int]]:
        """
        When a data lake scenario instance chooses to associate a bucket under another account, you need to set the ID of the account. When importing resources, this attribute will not be imported. If this attribute is set, please use lifecycle and ignore_changes ignore changes in fields.
        """
        return pulumi.get(self, "tos_account_id")

    @tos_account_id.setter
    def tos_account_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "tos_account_id", value)

    @property
    @pulumi.getter(name="tosAk")
    def tos_ak(self) -> Optional[pulumi.Input[str]]:
        """
        The tos ak. When the data lake scenario chooses to associate buckets under other accounts, need to set the Access Key ID of the account. When importing resources, this attribute will not be imported. If this attribute is set, please use lifecycle and ignore_changes ignore changes in fields.
        """
        return pulumi.get(self, "tos_ak")

    @tos_ak.setter
    def tos_ak(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tos_ak", value)

    @property
    @pulumi.getter(name="tosBucket")
    def tos_bucket(self) -> Optional[pulumi.Input[str]]:
        """
        The name of tos bucket.
        """
        return pulumi.get(self, "tos_bucket")

    @tos_bucket.setter
    def tos_bucket(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tos_bucket", value)

    @property
    @pulumi.getter(name="tosPrefix")
    def tos_prefix(self) -> Optional[pulumi.Input[str]]:
        """
        The tos prefix. Must not start with /, but must end with /, such as prefix/. When it is empty, it means the root path.
        """
        return pulumi.get(self, "tos_prefix")

    @tos_prefix.setter
    def tos_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tos_prefix", value)

    @property
    @pulumi.getter(name="tosSk")
    def tos_sk(self) -> Optional[pulumi.Input[str]]:
        """
        The tos sk. When the data lake scenario chooses to associate buckets under other accounts, need to set the Secret Access Key of the account. When importing resources, this attribute will not be imported. If this attribute is set, please use lifecycle and ignore_changes ignore changes in fields.
        """
        return pulumi.get(self, "tos_sk")

    @tos_sk.setter
    def tos_sk(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tos_sk", value)


class Namespace(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 fs_name: Optional[pulumi.Input[str]] = None,
                 read_only: Optional[pulumi.Input[bool]] = None,
                 tos_account_id: Optional[pulumi.Input[int]] = None,
                 tos_ak: Optional[pulumi.Input[str]] = None,
                 tos_bucket: Optional[pulumi.Input[str]] = None,
                 tos_prefix: Optional[pulumi.Input[str]] = None,
                 tos_sk: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a resource to manage cloudfs namespace
        ## Example Usage

        ```python
        import pulumi
        import pulumi_volcengine as volcengine

        foo = volcengine.cloudfs.Namespace("foo",
            fs_name="tf-test-fs",
            read_only=True,
            tos_bucket="tf-test")
        ```

        ## Import

        CloudfsNamespace can be imported using the FsName:NsId, e.g.

        ```sh
         $ pulumi import volcengine:cloudfs/namespace:Namespace default tfname:1801439850948****
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] fs_name: The name of file system.
        :param pulumi.Input[bool] read_only: Whether the namespace is read-only.
        :param pulumi.Input[int] tos_account_id: When a data lake scenario instance chooses to associate a bucket under another account, you need to set the ID of the account. When importing resources, this attribute will not be imported. If this attribute is set, please use lifecycle and ignore_changes ignore changes in fields.
        :param pulumi.Input[str] tos_ak: The tos ak. When the data lake scenario chooses to associate buckets under other accounts, need to set the Access Key ID of the account. When importing resources, this attribute will not be imported. If this attribute is set, please use lifecycle and ignore_changes ignore changes in fields.
        :param pulumi.Input[str] tos_bucket: The name of tos bucket.
        :param pulumi.Input[str] tos_prefix: The tos prefix. Must not start with /, but must end with /, such as prefix/. When it is empty, it means the root path.
        :param pulumi.Input[str] tos_sk: The tos sk. When the data lake scenario chooses to associate buckets under other accounts, need to set the Secret Access Key of the account. When importing resources, this attribute will not be imported. If this attribute is set, please use lifecycle and ignore_changes ignore changes in fields.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NamespaceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a resource to manage cloudfs namespace
        ## Example Usage

        ```python
        import pulumi
        import pulumi_volcengine as volcengine

        foo = volcengine.cloudfs.Namespace("foo",
            fs_name="tf-test-fs",
            read_only=True,
            tos_bucket="tf-test")
        ```

        ## Import

        CloudfsNamespace can be imported using the FsName:NsId, e.g.

        ```sh
         $ pulumi import volcengine:cloudfs/namespace:Namespace default tfname:1801439850948****
        ```

        :param str resource_name: The name of the resource.
        :param NamespaceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NamespaceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 fs_name: Optional[pulumi.Input[str]] = None,
                 read_only: Optional[pulumi.Input[bool]] = None,
                 tos_account_id: Optional[pulumi.Input[int]] = None,
                 tos_ak: Optional[pulumi.Input[str]] = None,
                 tos_bucket: Optional[pulumi.Input[str]] = None,
                 tos_prefix: Optional[pulumi.Input[str]] = None,
                 tos_sk: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NamespaceArgs.__new__(NamespaceArgs)

            if fs_name is None and not opts.urn:
                raise TypeError("Missing required property 'fs_name'")
            __props__.__dict__["fs_name"] = fs_name
            __props__.__dict__["read_only"] = read_only
            __props__.__dict__["tos_account_id"] = tos_account_id
            __props__.__dict__["tos_ak"] = tos_ak
            if tos_bucket is None and not opts.urn:
                raise TypeError("Missing required property 'tos_bucket'")
            __props__.__dict__["tos_bucket"] = tos_bucket
            __props__.__dict__["tos_prefix"] = tos_prefix
            __props__.__dict__["tos_sk"] = tos_sk
            __props__.__dict__["created_time"] = None
            __props__.__dict__["is_my_bucket"] = None
            __props__.__dict__["ns_id"] = None
            __props__.__dict__["service_managed"] = None
            __props__.__dict__["status"] = None
        super(Namespace, __self__).__init__(
            'volcengine:cloudfs/namespace:Namespace',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            created_time: Optional[pulumi.Input[str]] = None,
            fs_name: Optional[pulumi.Input[str]] = None,
            is_my_bucket: Optional[pulumi.Input[bool]] = None,
            ns_id: Optional[pulumi.Input[str]] = None,
            read_only: Optional[pulumi.Input[bool]] = None,
            service_managed: Optional[pulumi.Input[bool]] = None,
            status: Optional[pulumi.Input[str]] = None,
            tos_account_id: Optional[pulumi.Input[int]] = None,
            tos_ak: Optional[pulumi.Input[str]] = None,
            tos_bucket: Optional[pulumi.Input[str]] = None,
            tos_prefix: Optional[pulumi.Input[str]] = None,
            tos_sk: Optional[pulumi.Input[str]] = None) -> 'Namespace':
        """
        Get an existing Namespace resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] created_time: The creation time of the namespace.
        :param pulumi.Input[str] fs_name: The name of file system.
        :param pulumi.Input[bool] is_my_bucket: Whether the tos bucket is your own bucket.
        :param pulumi.Input[str] ns_id: The id of namespace.
        :param pulumi.Input[bool] read_only: Whether the namespace is read-only.
        :param pulumi.Input[bool] service_managed: Whether the namespace is the official service for volcengine.
        :param pulumi.Input[str] status: The status of the namespace.
        :param pulumi.Input[int] tos_account_id: When a data lake scenario instance chooses to associate a bucket under another account, you need to set the ID of the account. When importing resources, this attribute will not be imported. If this attribute is set, please use lifecycle and ignore_changes ignore changes in fields.
        :param pulumi.Input[str] tos_ak: The tos ak. When the data lake scenario chooses to associate buckets under other accounts, need to set the Access Key ID of the account. When importing resources, this attribute will not be imported. If this attribute is set, please use lifecycle and ignore_changes ignore changes in fields.
        :param pulumi.Input[str] tos_bucket: The name of tos bucket.
        :param pulumi.Input[str] tos_prefix: The tos prefix. Must not start with /, but must end with /, such as prefix/. When it is empty, it means the root path.
        :param pulumi.Input[str] tos_sk: The tos sk. When the data lake scenario chooses to associate buckets under other accounts, need to set the Secret Access Key of the account. When importing resources, this attribute will not be imported. If this attribute is set, please use lifecycle and ignore_changes ignore changes in fields.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NamespaceState.__new__(_NamespaceState)

        __props__.__dict__["created_time"] = created_time
        __props__.__dict__["fs_name"] = fs_name
        __props__.__dict__["is_my_bucket"] = is_my_bucket
        __props__.__dict__["ns_id"] = ns_id
        __props__.__dict__["read_only"] = read_only
        __props__.__dict__["service_managed"] = service_managed
        __props__.__dict__["status"] = status
        __props__.__dict__["tos_account_id"] = tos_account_id
        __props__.__dict__["tos_ak"] = tos_ak
        __props__.__dict__["tos_bucket"] = tos_bucket
        __props__.__dict__["tos_prefix"] = tos_prefix
        __props__.__dict__["tos_sk"] = tos_sk
        return Namespace(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="createdTime")
    def created_time(self) -> pulumi.Output[str]:
        """
        The creation time of the namespace.
        """
        return pulumi.get(self, "created_time")

    @property
    @pulumi.getter(name="fsName")
    def fs_name(self) -> pulumi.Output[str]:
        """
        The name of file system.
        """
        return pulumi.get(self, "fs_name")

    @property
    @pulumi.getter(name="isMyBucket")
    def is_my_bucket(self) -> pulumi.Output[bool]:
        """
        Whether the tos bucket is your own bucket.
        """
        return pulumi.get(self, "is_my_bucket")

    @property
    @pulumi.getter(name="nsId")
    def ns_id(self) -> pulumi.Output[str]:
        """
        The id of namespace.
        """
        return pulumi.get(self, "ns_id")

    @property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether the namespace is read-only.
        """
        return pulumi.get(self, "read_only")

    @property
    @pulumi.getter(name="serviceManaged")
    def service_managed(self) -> pulumi.Output[bool]:
        """
        Whether the namespace is the official service for volcengine.
        """
        return pulumi.get(self, "service_managed")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        The status of the namespace.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="tosAccountId")
    def tos_account_id(self) -> pulumi.Output[Optional[int]]:
        """
        When a data lake scenario instance chooses to associate a bucket under another account, you need to set the ID of the account. When importing resources, this attribute will not be imported. If this attribute is set, please use lifecycle and ignore_changes ignore changes in fields.
        """
        return pulumi.get(self, "tos_account_id")

    @property
    @pulumi.getter(name="tosAk")
    def tos_ak(self) -> pulumi.Output[Optional[str]]:
        """
        The tos ak. When the data lake scenario chooses to associate buckets under other accounts, need to set the Access Key ID of the account. When importing resources, this attribute will not be imported. If this attribute is set, please use lifecycle and ignore_changes ignore changes in fields.
        """
        return pulumi.get(self, "tos_ak")

    @property
    @pulumi.getter(name="tosBucket")
    def tos_bucket(self) -> pulumi.Output[str]:
        """
        The name of tos bucket.
        """
        return pulumi.get(self, "tos_bucket")

    @property
    @pulumi.getter(name="tosPrefix")
    def tos_prefix(self) -> pulumi.Output[Optional[str]]:
        """
        The tos prefix. Must not start with /, but must end with /, such as prefix/. When it is empty, it means the root path.
        """
        return pulumi.get(self, "tos_prefix")

    @property
    @pulumi.getter(name="tosSk")
    def tos_sk(self) -> pulumi.Output[Optional[str]]:
        """
        The tos sk. When the data lake scenario chooses to associate buckets under other accounts, need to set the Secret Access Key of the account. When importing resources, this attribute will not be imported. If this attribute is set, please use lifecycle and ignore_changes ignore changes in fields.
        """
        return pulumi.get(self, "tos_sk")

