# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'NamespacesResult',
    'AwaitableNamespacesResult',
    'namespaces',
    'namespaces_output',
]

@pulumi.output_type
class NamespacesResult:
    """
    A collection of values returned by Namespaces.
    """
    def __init__(__self__, fs_name=None, id=None, namespaces=None, ns_id=None, output_file=None, tos_bucket=None, total_count=None):
        if fs_name and not isinstance(fs_name, str):
            raise TypeError("Expected argument 'fs_name' to be a str")
        pulumi.set(__self__, "fs_name", fs_name)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if namespaces and not isinstance(namespaces, list):
            raise TypeError("Expected argument 'namespaces' to be a list")
        pulumi.set(__self__, "namespaces", namespaces)
        if ns_id and not isinstance(ns_id, str):
            raise TypeError("Expected argument 'ns_id' to be a str")
        pulumi.set(__self__, "ns_id", ns_id)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if tos_bucket and not isinstance(tos_bucket, str):
            raise TypeError("Expected argument 'tos_bucket' to be a str")
        pulumi.set(__self__, "tos_bucket", tos_bucket)
        if total_count and not isinstance(total_count, int):
            raise TypeError("Expected argument 'total_count' to be a int")
        pulumi.set(__self__, "total_count", total_count)

    @property
    @pulumi.getter(name="fsName")
    def fs_name(self) -> str:
        return pulumi.get(self, "fs_name")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def namespaces(self) -> Sequence['outputs.NamespacesNamespaceResult']:
        """
        The collection of query.
        """
        return pulumi.get(self, "namespaces")

    @property
    @pulumi.getter(name="nsId")
    def ns_id(self) -> Optional[str]:
        return pulumi.get(self, "ns_id")

    @property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[str]:
        return pulumi.get(self, "output_file")

    @property
    @pulumi.getter(name="tosBucket")
    def tos_bucket(self) -> Optional[str]:
        """
        The name of the tos bucket.
        """
        return pulumi.get(self, "tos_bucket")

    @property
    @pulumi.getter(name="totalCount")
    def total_count(self) -> int:
        """
        The total count of query.
        """
        return pulumi.get(self, "total_count")


class AwaitableNamespacesResult(NamespacesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return NamespacesResult(
            fs_name=self.fs_name,
            id=self.id,
            namespaces=self.namespaces,
            ns_id=self.ns_id,
            output_file=self.output_file,
            tos_bucket=self.tos_bucket,
            total_count=self.total_count)


def namespaces(fs_name: Optional[str] = None,
               ns_id: Optional[str] = None,
               output_file: Optional[str] = None,
               tos_bucket: Optional[str] = None,
               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableNamespacesResult:
    """
    Use this data source to query detailed information of cloudfs namespaces
    ## Example Usage

    ```python
    import pulumi
    import pulumi_volcengine as volcengine

    default = volcengine.cloudfs.namespaces(fs_name="tf-test-fs",
        ns_id="1801439850948****")
    ```


    :param str fs_name: The name of file system.
    :param str ns_id: The id of namespace.
    :param str output_file: File name where to save data source results.
    :param str tos_bucket: The name of tos bucket.
    """
    __args__ = dict()
    __args__['fsName'] = fs_name
    __args__['nsId'] = ns_id
    __args__['outputFile'] = output_file
    __args__['tosBucket'] = tos_bucket
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('volcengine:cloudfs/namespaces:Namespaces', __args__, opts=opts, typ=NamespacesResult).value

    return AwaitableNamespacesResult(
        fs_name=pulumi.get(__ret__, 'fs_name'),
        id=pulumi.get(__ret__, 'id'),
        namespaces=pulumi.get(__ret__, 'namespaces'),
        ns_id=pulumi.get(__ret__, 'ns_id'),
        output_file=pulumi.get(__ret__, 'output_file'),
        tos_bucket=pulumi.get(__ret__, 'tos_bucket'),
        total_count=pulumi.get(__ret__, 'total_count'))


@_utilities.lift_output_func(namespaces)
def namespaces_output(fs_name: Optional[pulumi.Input[str]] = None,
                      ns_id: Optional[pulumi.Input[Optional[str]]] = None,
                      output_file: Optional[pulumi.Input[Optional[str]]] = None,
                      tos_bucket: Optional[pulumi.Input[Optional[str]]] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[NamespacesResult]:
    """
    Use this data source to query detailed information of cloudfs namespaces
    ## Example Usage

    ```python
    import pulumi
    import pulumi_volcengine as volcengine

    default = volcengine.cloudfs.namespaces(fs_name="tf-test-fs",
        ns_id="1801439850948****")
    ```


    :param str fs_name: The name of file system.
    :param str ns_id: The id of namespace.
    :param str output_file: File name where to save data source results.
    :param str tos_bucket: The name of tos bucket.
    """
    ...
