# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'NsQuotasResult',
    'AwaitableNsQuotasResult',
    'ns_quotas',
    'ns_quotas_output',
]

@pulumi.output_type
class NsQuotasResult:
    """
    A collection of values returned by NsQuotas.
    """
    def __init__(__self__, fs_names=None, id=None, output_file=None, quotas=None, total_count=None):
        if fs_names and not isinstance(fs_names, list):
            raise TypeError("Expected argument 'fs_names' to be a list")
        pulumi.set(__self__, "fs_names", fs_names)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if quotas and not isinstance(quotas, list):
            raise TypeError("Expected argument 'quotas' to be a list")
        pulumi.set(__self__, "quotas", quotas)
        if total_count and not isinstance(total_count, int):
            raise TypeError("Expected argument 'total_count' to be a int")
        pulumi.set(__self__, "total_count", total_count)

    @property
    @pulumi.getter(name="fsNames")
    def fs_names(self) -> Sequence[str]:
        return pulumi.get(self, "fs_names")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[str]:
        return pulumi.get(self, "output_file")

    @property
    @pulumi.getter
    def quotas(self) -> Sequence['outputs.NsQuotasQuotaResult']:
        """
        The collection of query.
        """
        return pulumi.get(self, "quotas")

    @property
    @pulumi.getter(name="totalCount")
    def total_count(self) -> int:
        """
        The total count of cloud fs quota query.
        """
        return pulumi.get(self, "total_count")


class AwaitableNsQuotasResult(NsQuotasResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return NsQuotasResult(
            fs_names=self.fs_names,
            id=self.id,
            output_file=self.output_file,
            quotas=self.quotas,
            total_count=self.total_count)


def ns_quotas(fs_names: Optional[Sequence[str]] = None,
              output_file: Optional[str] = None,
              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableNsQuotasResult:
    """
    Use this data source to query detailed information of cloudfs ns quotas
    ## Example Usage

    ```python
    import pulumi
    import pulumi_volcengine as volcengine

    default = volcengine.cloudfs.ns_quotas(fs_names=[
        "tffile",
        "tftest2",
    ])
    ```


    :param Sequence[str] fs_names: A list of fs name.
    :param str output_file: File name where to save data source results.
    """
    __args__ = dict()
    __args__['fsNames'] = fs_names
    __args__['outputFile'] = output_file
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('volcengine:cloudfs/nsQuotas:NsQuotas', __args__, opts=opts, typ=NsQuotasResult).value

    return AwaitableNsQuotasResult(
        fs_names=pulumi.get(__ret__, 'fs_names'),
        id=pulumi.get(__ret__, 'id'),
        output_file=pulumi.get(__ret__, 'output_file'),
        quotas=pulumi.get(__ret__, 'quotas'),
        total_count=pulumi.get(__ret__, 'total_count'))


@_utilities.lift_output_func(ns_quotas)
def ns_quotas_output(fs_names: Optional[pulumi.Input[Sequence[str]]] = None,
                     output_file: Optional[pulumi.Input[Optional[str]]] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[NsQuotasResult]:
    """
    Use this data source to query detailed information of cloudfs ns quotas
    ## Example Usage

    ```python
    import pulumi
    import pulumi_volcengine as volcengine

    default = volcengine.cloudfs.ns_quotas(fs_names=[
        "tffile",
        "tftest2",
    ])
    ```


    :param Sequence[str] fs_names: A list of fs name.
    :param str output_file: File name where to save data source results.
    """
    ...
