# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['EndpointArgs', 'Endpoint']

@pulumi.input_type
class EndpointArgs:
    def __init__(__self__, *,
                 registry: pulumi.Input[str],
                 enabled: Optional[pulumi.Input[bool]] = None):
        """
        The set of arguments for constructing a Endpoint resource.
        :param pulumi.Input[str] registry: The CrRegistry name.
        :param pulumi.Input[bool] enabled: Whether enable public endpoint.
        """
        pulumi.set(__self__, "registry", registry)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def registry(self) -> pulumi.Input[str]:
        """
        The CrRegistry name.
        """
        return pulumi.get(self, "registry")

    @registry.setter
    def registry(self, value: pulumi.Input[str]):
        pulumi.set(self, "registry", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether enable public endpoint.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)


@pulumi.input_type
class _EndpointState:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 registry: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Endpoint resources.
        :param pulumi.Input[bool] enabled: Whether enable public endpoint.
        :param pulumi.Input[str] registry: The CrRegistry name.
        :param pulumi.Input[str] status: The status of public endpoint.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if registry is not None:
            pulumi.set(__self__, "registry", registry)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether enable public endpoint.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter
    def registry(self) -> Optional[pulumi.Input[str]]:
        """
        The CrRegistry name.
        """
        return pulumi.get(self, "registry")

    @registry.setter
    def registry(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "registry", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The status of public endpoint.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)


class Endpoint(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 registry: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a resource to manage cr endpoint
        ## Example Usage

        ```python
        import pulumi
        import pulumi_volcengine as volcengine

        default = volcengine.cr.Endpoint("default",
            enabled=True,
            registry="acc-test-cr")
        ```

        ## Import

        CR endpoints can be imported using the endpoint:registryName, e.g.

        ```sh
         $ pulumi import volcengine:cr/endpoint:Endpoint default endpoint:cr-basic
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] enabled: Whether enable public endpoint.
        :param pulumi.Input[str] registry: The CrRegistry name.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: EndpointArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a resource to manage cr endpoint
        ## Example Usage

        ```python
        import pulumi
        import pulumi_volcengine as volcengine

        default = volcengine.cr.Endpoint("default",
            enabled=True,
            registry="acc-test-cr")
        ```

        ## Import

        CR endpoints can be imported using the endpoint:registryName, e.g.

        ```sh
         $ pulumi import volcengine:cr/endpoint:Endpoint default endpoint:cr-basic
        ```

        :param str resource_name: The name of the resource.
        :param EndpointArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EndpointArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 registry: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EndpointArgs.__new__(EndpointArgs)

            __props__.__dict__["enabled"] = enabled
            if registry is None and not opts.urn:
                raise TypeError("Missing required property 'registry'")
            __props__.__dict__["registry"] = registry
            __props__.__dict__["status"] = None
        super(Endpoint, __self__).__init__(
            'volcengine:cr/endpoint:Endpoint',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            enabled: Optional[pulumi.Input[bool]] = None,
            registry: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None) -> 'Endpoint':
        """
        Get an existing Endpoint resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] enabled: Whether enable public endpoint.
        :param pulumi.Input[str] registry: The CrRegistry name.
        :param pulumi.Input[str] status: The status of public endpoint.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _EndpointState.__new__(_EndpointState)

        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["registry"] = registry
        __props__.__dict__["status"] = status
        return Endpoint(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether enable public endpoint.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def registry(self) -> pulumi.Output[str]:
        """
        The CrRegistry name.
        """
        return pulumi.get(self, "registry")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        The status of public endpoint.
        """
        return pulumi.get(self, "status")

