# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['RegistryArgs', 'Registry']

@pulumi.input_type
class RegistryArgs:
    def __init__(__self__, *,
                 delete_immediately: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Registry resource.
        :param pulumi.Input[bool] delete_immediately: Whether delete registry immediately. Only effected in delete action.
        :param pulumi.Input[str] name: The name of registry.
        :param pulumi.Input[str] password: The password of registry user.
        """
        if delete_immediately is not None:
            pulumi.set(__self__, "delete_immediately", delete_immediately)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if password is not None:
            pulumi.set(__self__, "password", password)

    @property
    @pulumi.getter(name="deleteImmediately")
    def delete_immediately(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether delete registry immediately. Only effected in delete action.
        """
        return pulumi.get(self, "delete_immediately")

    @delete_immediately.setter
    def delete_immediately(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "delete_immediately", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of registry.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        The password of registry user.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)


@pulumi.input_type
class _RegistryState:
    def __init__(__self__, *,
                 charge_type: Optional[pulumi.Input[str]] = None,
                 create_time: Optional[pulumi.Input[str]] = None,
                 delete_immediately: Optional[pulumi.Input[bool]] = None,
                 domains: Optional[pulumi.Input[Sequence[pulumi.Input['RegistryDomainArgs']]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 statuses: Optional[pulumi.Input[Sequence[pulumi.Input['RegistryStatusArgs']]]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 user_status: Optional[pulumi.Input[str]] = None,
                 username: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Registry resources.
        :param pulumi.Input[str] charge_type: The charge type of registry.
        :param pulumi.Input[str] create_time: The creation time of registry.
        :param pulumi.Input[bool] delete_immediately: Whether delete registry immediately. Only effected in delete action.
        :param pulumi.Input[Sequence[pulumi.Input['RegistryDomainArgs']]] domains: The domain of registry.
        :param pulumi.Input[str] name: The name of registry.
        :param pulumi.Input[str] password: The password of registry user.
        :param pulumi.Input[Sequence[pulumi.Input['RegistryStatusArgs']]] statuses: The status of registry.
        :param pulumi.Input[str] type: The type of registry.
        :param pulumi.Input[str] user_status: The status of user.
        :param pulumi.Input[str] username: The username of cr instance.
        """
        if charge_type is not None:
            pulumi.set(__self__, "charge_type", charge_type)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if delete_immediately is not None:
            pulumi.set(__self__, "delete_immediately", delete_immediately)
        if domains is not None:
            pulumi.set(__self__, "domains", domains)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if statuses is not None:
            pulumi.set(__self__, "statuses", statuses)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if user_status is not None:
            pulumi.set(__self__, "user_status", user_status)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter(name="chargeType")
    def charge_type(self) -> Optional[pulumi.Input[str]]:
        """
        The charge type of registry.
        """
        return pulumi.get(self, "charge_type")

    @charge_type.setter
    def charge_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "charge_type", value)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[str]]:
        """
        The creation time of registry.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter(name="deleteImmediately")
    def delete_immediately(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether delete registry immediately. Only effected in delete action.
        """
        return pulumi.get(self, "delete_immediately")

    @delete_immediately.setter
    def delete_immediately(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "delete_immediately", value)

    @property
    @pulumi.getter
    def domains(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RegistryDomainArgs']]]]:
        """
        The domain of registry.
        """
        return pulumi.get(self, "domains")

    @domains.setter
    def domains(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RegistryDomainArgs']]]]):
        pulumi.set(self, "domains", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of registry.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        The password of registry user.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def statuses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RegistryStatusArgs']]]]:
        """
        The status of registry.
        """
        return pulumi.get(self, "statuses")

    @statuses.setter
    def statuses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RegistryStatusArgs']]]]):
        pulumi.set(self, "statuses", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of registry.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="userStatus")
    def user_status(self) -> Optional[pulumi.Input[str]]:
        """
        The status of user.
        """
        return pulumi.get(self, "user_status")

    @user_status.setter
    def user_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_status", value)

    @property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[str]]:
        """
        The username of cr instance.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "username", value)


class Registry(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 delete_immediately: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a resource to manage cr registry
        ## Example Usage

        ```python
        import pulumi
        import pulumi_volcengine as volcengine

        foo = volcengine.cr.Registry("foo",
            delete_immediately=False,
            password="1qaz!QAZ")
        ```

        ## Import

        CR Registry can be imported using the name, e.g.

        ```sh
         $ pulumi import volcengine:cr/registry:Registry default enterprise-x
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] delete_immediately: Whether delete registry immediately. Only effected in delete action.
        :param pulumi.Input[str] name: The name of registry.
        :param pulumi.Input[str] password: The password of registry user.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[RegistryArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a resource to manage cr registry
        ## Example Usage

        ```python
        import pulumi
        import pulumi_volcengine as volcengine

        foo = volcengine.cr.Registry("foo",
            delete_immediately=False,
            password="1qaz!QAZ")
        ```

        ## Import

        CR Registry can be imported using the name, e.g.

        ```sh
         $ pulumi import volcengine:cr/registry:Registry default enterprise-x
        ```

        :param str resource_name: The name of the resource.
        :param RegistryArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RegistryArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 delete_immediately: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RegistryArgs.__new__(RegistryArgs)

            __props__.__dict__["delete_immediately"] = delete_immediately
            __props__.__dict__["name"] = name
            __props__.__dict__["password"] = None if password is None else pulumi.Output.secret(password)
            __props__.__dict__["charge_type"] = None
            __props__.__dict__["create_time"] = None
            __props__.__dict__["domains"] = None
            __props__.__dict__["statuses"] = None
            __props__.__dict__["type"] = None
            __props__.__dict__["user_status"] = None
            __props__.__dict__["username"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["password"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Registry, __self__).__init__(
            'volcengine:cr/registry:Registry',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            charge_type: Optional[pulumi.Input[str]] = None,
            create_time: Optional[pulumi.Input[str]] = None,
            delete_immediately: Optional[pulumi.Input[bool]] = None,
            domains: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['RegistryDomainArgs']]]]] = None,
            name: Optional[pulumi.Input[str]] = None,
            password: Optional[pulumi.Input[str]] = None,
            statuses: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['RegistryStatusArgs']]]]] = None,
            type: Optional[pulumi.Input[str]] = None,
            user_status: Optional[pulumi.Input[str]] = None,
            username: Optional[pulumi.Input[str]] = None) -> 'Registry':
        """
        Get an existing Registry resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] charge_type: The charge type of registry.
        :param pulumi.Input[str] create_time: The creation time of registry.
        :param pulumi.Input[bool] delete_immediately: Whether delete registry immediately. Only effected in delete action.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['RegistryDomainArgs']]]] domains: The domain of registry.
        :param pulumi.Input[str] name: The name of registry.
        :param pulumi.Input[str] password: The password of registry user.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['RegistryStatusArgs']]]] statuses: The status of registry.
        :param pulumi.Input[str] type: The type of registry.
        :param pulumi.Input[str] user_status: The status of user.
        :param pulumi.Input[str] username: The username of cr instance.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RegistryState.__new__(_RegistryState)

        __props__.__dict__["charge_type"] = charge_type
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["delete_immediately"] = delete_immediately
        __props__.__dict__["domains"] = domains
        __props__.__dict__["name"] = name
        __props__.__dict__["password"] = password
        __props__.__dict__["statuses"] = statuses
        __props__.__dict__["type"] = type
        __props__.__dict__["user_status"] = user_status
        __props__.__dict__["username"] = username
        return Registry(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="chargeType")
    def charge_type(self) -> pulumi.Output[str]:
        """
        The charge type of registry.
        """
        return pulumi.get(self, "charge_type")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[str]:
        """
        The creation time of registry.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="deleteImmediately")
    def delete_immediately(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether delete registry immediately. Only effected in delete action.
        """
        return pulumi.get(self, "delete_immediately")

    @property
    @pulumi.getter
    def domains(self) -> pulumi.Output[Sequence['outputs.RegistryDomain']]:
        """
        The domain of registry.
        """
        return pulumi.get(self, "domains")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of registry.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def password(self) -> pulumi.Output[Optional[str]]:
        """
        The password of registry user.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def statuses(self) -> pulumi.Output[Sequence['outputs.RegistryStatus']]:
        """
        The status of registry.
        """
        return pulumi.get(self, "statuses")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        The type of registry.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="userStatus")
    def user_status(self) -> pulumi.Output[str]:
        """
        The status of user.
        """
        return pulumi.get(self, "user_status")

    @property
    @pulumi.getter
    def username(self) -> pulumi.Output[str]:
        """
        The username of cr instance.
        """
        return pulumi.get(self, "username")

