# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['TagArgs', 'Tag']

@pulumi.input_type
class TagArgs:
    def __init__(__self__, *,
                 namespace: pulumi.Input[str],
                 registry: pulumi.Input[str],
                 repository: pulumi.Input[str],
                 name: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Tag resource.
        :param pulumi.Input[str] namespace: The target namespace name.
        :param pulumi.Input[str] registry: The CrRegistry name.
        :param pulumi.Input[str] repository: The name of repository.
        :param pulumi.Input[str] name: The name of OCI product.
        """
        pulumi.set(__self__, "namespace", namespace)
        pulumi.set(__self__, "registry", registry)
        pulumi.set(__self__, "repository", repository)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def namespace(self) -> pulumi.Input[str]:
        """
        The target namespace name.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: pulumi.Input[str]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter
    def registry(self) -> pulumi.Input[str]:
        """
        The CrRegistry name.
        """
        return pulumi.get(self, "registry")

    @registry.setter
    def registry(self, value: pulumi.Input[str]):
        pulumi.set(self, "registry", value)

    @property
    @pulumi.getter
    def repository(self) -> pulumi.Input[str]:
        """
        The name of repository.
        """
        return pulumi.get(self, "repository")

    @repository.setter
    def repository(self, value: pulumi.Input[str]):
        pulumi.set(self, "repository", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of OCI product.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _TagState:
    def __init__(__self__, *,
                 chart_attributes: Optional[pulumi.Input[Sequence[pulumi.Input['TagChartAttributeArgs']]]] = None,
                 digest: Optional[pulumi.Input[str]] = None,
                 image_attributes: Optional[pulumi.Input[Sequence[pulumi.Input['TagImageAttributeArgs']]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 push_time: Optional[pulumi.Input[str]] = None,
                 registry: Optional[pulumi.Input[str]] = None,
                 repository: Optional[pulumi.Input[str]] = None,
                 size: Optional[pulumi.Input[int]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Tag resources.
        :param pulumi.Input[Sequence[pulumi.Input['TagChartAttributeArgs']]] chart_attributes: The chart attribute,valid when tag type is Chart.
        :param pulumi.Input[str] digest: The digest of image.
        :param pulumi.Input[Sequence[pulumi.Input['TagImageAttributeArgs']]] image_attributes: The list of image attributes,valid when tag type is Image.
        :param pulumi.Input[str] name: The name of OCI product.
        :param pulumi.Input[str] namespace: The target namespace name.
        :param pulumi.Input[str] push_time: The last push time of OCI product.
        :param pulumi.Input[str] registry: The CrRegistry name.
        :param pulumi.Input[str] repository: The name of repository.
        :param pulumi.Input[int] size: The size of OCI product.
        :param pulumi.Input[str] type: The type of OCI product tag.
        """
        if chart_attributes is not None:
            pulumi.set(__self__, "chart_attributes", chart_attributes)
        if digest is not None:
            pulumi.set(__self__, "digest", digest)
        if image_attributes is not None:
            pulumi.set(__self__, "image_attributes", image_attributes)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if push_time is not None:
            pulumi.set(__self__, "push_time", push_time)
        if registry is not None:
            pulumi.set(__self__, "registry", registry)
        if repository is not None:
            pulumi.set(__self__, "repository", repository)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="chartAttributes")
    def chart_attributes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TagChartAttributeArgs']]]]:
        """
        The chart attribute,valid when tag type is Chart.
        """
        return pulumi.get(self, "chart_attributes")

    @chart_attributes.setter
    def chart_attributes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TagChartAttributeArgs']]]]):
        pulumi.set(self, "chart_attributes", value)

    @property
    @pulumi.getter
    def digest(self) -> Optional[pulumi.Input[str]]:
        """
        The digest of image.
        """
        return pulumi.get(self, "digest")

    @digest.setter
    def digest(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "digest", value)

    @property
    @pulumi.getter(name="imageAttributes")
    def image_attributes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TagImageAttributeArgs']]]]:
        """
        The list of image attributes,valid when tag type is Image.
        """
        return pulumi.get(self, "image_attributes")

    @image_attributes.setter
    def image_attributes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TagImageAttributeArgs']]]]):
        pulumi.set(self, "image_attributes", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of OCI product.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[str]]:
        """
        The target namespace name.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter(name="pushTime")
    def push_time(self) -> Optional[pulumi.Input[str]]:
        """
        The last push time of OCI product.
        """
        return pulumi.get(self, "push_time")

    @push_time.setter
    def push_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "push_time", value)

    @property
    @pulumi.getter
    def registry(self) -> Optional[pulumi.Input[str]]:
        """
        The CrRegistry name.
        """
        return pulumi.get(self, "registry")

    @registry.setter
    def registry(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "registry", value)

    @property
    @pulumi.getter
    def repository(self) -> Optional[pulumi.Input[str]]:
        """
        The name of repository.
        """
        return pulumi.get(self, "repository")

    @repository.setter
    def repository(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "repository", value)

    @property
    @pulumi.getter
    def size(self) -> Optional[pulumi.Input[int]]:
        """
        The size of OCI product.
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "size", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of OCI product tag.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


class Tag(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 registry: Optional[pulumi.Input[str]] = None,
                 repository: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a resource to manage cr tag
        ## Example Usage

        ```python
        import pulumi
        import pulumi_volcengine as volcengine

        # Tag cannot be created,please import by command `terraform import volcengine_cr_tag.default registry:namespace:repository:tag`
        default = volcengine.cr.Tag("default",
            namespace="langyu",
            registry="enterprise-1",
            repository="repo")
        ```

        ## Import

        CR tags can be imported using the registry:namespace:repository:tag, e.g.

        ```sh
         $ pulumi import volcengine:cr/tag:Tag default cr-basic:namespace-1:repo-1:v1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] name: The name of OCI product.
        :param pulumi.Input[str] namespace: The target namespace name.
        :param pulumi.Input[str] registry: The CrRegistry name.
        :param pulumi.Input[str] repository: The name of repository.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: TagArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a resource to manage cr tag
        ## Example Usage

        ```python
        import pulumi
        import pulumi_volcengine as volcengine

        # Tag cannot be created,please import by command `terraform import volcengine_cr_tag.default registry:namespace:repository:tag`
        default = volcengine.cr.Tag("default",
            namespace="langyu",
            registry="enterprise-1",
            repository="repo")
        ```

        ## Import

        CR tags can be imported using the registry:namespace:repository:tag, e.g.

        ```sh
         $ pulumi import volcengine:cr/tag:Tag default cr-basic:namespace-1:repo-1:v1
        ```

        :param str resource_name: The name of the resource.
        :param TagArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TagArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 registry: Optional[pulumi.Input[str]] = None,
                 repository: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TagArgs.__new__(TagArgs)

            __props__.__dict__["name"] = name
            if namespace is None and not opts.urn:
                raise TypeError("Missing required property 'namespace'")
            __props__.__dict__["namespace"] = namespace
            if registry is None and not opts.urn:
                raise TypeError("Missing required property 'registry'")
            __props__.__dict__["registry"] = registry
            if repository is None and not opts.urn:
                raise TypeError("Missing required property 'repository'")
            __props__.__dict__["repository"] = repository
            __props__.__dict__["chart_attributes"] = None
            __props__.__dict__["digest"] = None
            __props__.__dict__["image_attributes"] = None
            __props__.__dict__["push_time"] = None
            __props__.__dict__["size"] = None
            __props__.__dict__["type"] = None
        super(Tag, __self__).__init__(
            'volcengine:cr/tag:Tag',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            chart_attributes: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['TagChartAttributeArgs']]]]] = None,
            digest: Optional[pulumi.Input[str]] = None,
            image_attributes: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['TagImageAttributeArgs']]]]] = None,
            name: Optional[pulumi.Input[str]] = None,
            namespace: Optional[pulumi.Input[str]] = None,
            push_time: Optional[pulumi.Input[str]] = None,
            registry: Optional[pulumi.Input[str]] = None,
            repository: Optional[pulumi.Input[str]] = None,
            size: Optional[pulumi.Input[int]] = None,
            type: Optional[pulumi.Input[str]] = None) -> 'Tag':
        """
        Get an existing Tag resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['TagChartAttributeArgs']]]] chart_attributes: The chart attribute,valid when tag type is Chart.
        :param pulumi.Input[str] digest: The digest of image.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['TagImageAttributeArgs']]]] image_attributes: The list of image attributes,valid when tag type is Image.
        :param pulumi.Input[str] name: The name of OCI product.
        :param pulumi.Input[str] namespace: The target namespace name.
        :param pulumi.Input[str] push_time: The last push time of OCI product.
        :param pulumi.Input[str] registry: The CrRegistry name.
        :param pulumi.Input[str] repository: The name of repository.
        :param pulumi.Input[int] size: The size of OCI product.
        :param pulumi.Input[str] type: The type of OCI product tag.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _TagState.__new__(_TagState)

        __props__.__dict__["chart_attributes"] = chart_attributes
        __props__.__dict__["digest"] = digest
        __props__.__dict__["image_attributes"] = image_attributes
        __props__.__dict__["name"] = name
        __props__.__dict__["namespace"] = namespace
        __props__.__dict__["push_time"] = push_time
        __props__.__dict__["registry"] = registry
        __props__.__dict__["repository"] = repository
        __props__.__dict__["size"] = size
        __props__.__dict__["type"] = type
        return Tag(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="chartAttributes")
    def chart_attributes(self) -> pulumi.Output[Sequence['outputs.TagChartAttribute']]:
        """
        The chart attribute,valid when tag type is Chart.
        """
        return pulumi.get(self, "chart_attributes")

    @property
    @pulumi.getter
    def digest(self) -> pulumi.Output[str]:
        """
        The digest of image.
        """
        return pulumi.get(self, "digest")

    @property
    @pulumi.getter(name="imageAttributes")
    def image_attributes(self) -> pulumi.Output[Sequence['outputs.TagImageAttribute']]:
        """
        The list of image attributes,valid when tag type is Image.
        """
        return pulumi.get(self, "image_attributes")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of OCI product.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def namespace(self) -> pulumi.Output[str]:
        """
        The target namespace name.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter(name="pushTime")
    def push_time(self) -> pulumi.Output[str]:
        """
        The last push time of OCI product.
        """
        return pulumi.get(self, "push_time")

    @property
    @pulumi.getter
    def registry(self) -> pulumi.Output[str]:
        """
        The CrRegistry name.
        """
        return pulumi.get(self, "registry")

    @property
    @pulumi.getter
    def repository(self) -> pulumi.Output[str]:
        """
        The name of repository.
        """
        return pulumi.get(self, "repository")

    @property
    @pulumi.getter
    def size(self) -> pulumi.Output[int]:
        """
        The size of OCI product.
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        The type of OCI product tag.
        """
        return pulumi.get(self, "type")

