# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['VpcEndpointArgs', 'VpcEndpoint']

@pulumi.input_type
class VpcEndpointArgs:
    def __init__(__self__, *,
                 registry: pulumi.Input[str],
                 vpcs: pulumi.Input[Sequence[pulumi.Input['VpcEndpointVpcArgs']]]):
        """
        The set of arguments for constructing a VpcEndpoint resource.
        :param pulumi.Input[str] registry: The Cr Registry name.
        :param pulumi.Input[Sequence[pulumi.Input['VpcEndpointVpcArgs']]] vpcs: List of vpc meta. When apply is executed for the first time, the vpcs in the tf file will be added to the existing vpcs, and subsequent apply will overwrite the existing vpcs with the vpcs in the tf file.
        """
        pulumi.set(__self__, "registry", registry)
        pulumi.set(__self__, "vpcs", vpcs)

    @property
    @pulumi.getter
    def registry(self) -> pulumi.Input[str]:
        """
        The Cr Registry name.
        """
        return pulumi.get(self, "registry")

    @registry.setter
    def registry(self, value: pulumi.Input[str]):
        pulumi.set(self, "registry", value)

    @property
    @pulumi.getter
    def vpcs(self) -> pulumi.Input[Sequence[pulumi.Input['VpcEndpointVpcArgs']]]:
        """
        List of vpc meta. When apply is executed for the first time, the vpcs in the tf file will be added to the existing vpcs, and subsequent apply will overwrite the existing vpcs with the vpcs in the tf file.
        """
        return pulumi.get(self, "vpcs")

    @vpcs.setter
    def vpcs(self, value: pulumi.Input[Sequence[pulumi.Input['VpcEndpointVpcArgs']]]):
        pulumi.set(self, "vpcs", value)


@pulumi.input_type
class _VpcEndpointState:
    def __init__(__self__, *,
                 registry: Optional[pulumi.Input[str]] = None,
                 vpcs: Optional[pulumi.Input[Sequence[pulumi.Input['VpcEndpointVpcArgs']]]] = None):
        """
        Input properties used for looking up and filtering VpcEndpoint resources.
        :param pulumi.Input[str] registry: The Cr Registry name.
        :param pulumi.Input[Sequence[pulumi.Input['VpcEndpointVpcArgs']]] vpcs: List of vpc meta. When apply is executed for the first time, the vpcs in the tf file will be added to the existing vpcs, and subsequent apply will overwrite the existing vpcs with the vpcs in the tf file.
        """
        if registry is not None:
            pulumi.set(__self__, "registry", registry)
        if vpcs is not None:
            pulumi.set(__self__, "vpcs", vpcs)

    @property
    @pulumi.getter
    def registry(self) -> Optional[pulumi.Input[str]]:
        """
        The Cr Registry name.
        """
        return pulumi.get(self, "registry")

    @registry.setter
    def registry(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "registry", value)

    @property
    @pulumi.getter
    def vpcs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VpcEndpointVpcArgs']]]]:
        """
        List of vpc meta. When apply is executed for the first time, the vpcs in the tf file will be added to the existing vpcs, and subsequent apply will overwrite the existing vpcs with the vpcs in the tf file.
        """
        return pulumi.get(self, "vpcs")

    @vpcs.setter
    def vpcs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VpcEndpointVpcArgs']]]]):
        pulumi.set(self, "vpcs", value)


class VpcEndpoint(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 registry: Optional[pulumi.Input[str]] = None,
                 vpcs: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['VpcEndpointVpcArgs']]]]] = None,
                 __props__=None):
        """
        Provides a resource to manage cr vpc endpoint
        ## Example Usage

        ```python
        import pulumi
        import pulumi_volcengine as volcengine

        foo = volcengine.cr.VpcEndpoint("foo",
            registry="enterprise-1",
            vpcs=[
                volcengine.cr.VpcEndpointVpcArgs(
                    account_id=0,
                    vpc_id="vpc-3resbfzl3xgjk5zsk2iuq3vhk",
                ),
                volcengine.cr.VpcEndpointVpcArgs(
                    subnet_id="subnet-2d62do4697i8058ozfdszxl30",
                    vpc_id="vpc-3red9li8dd8g05zsk2iadytvy",
                ),
            ])
        ```

        ## Import

        CR Vpc endpoint can be imported using the crVpcEndpoint:registry, e.g.

        ```sh
         $ pulumi import volcengine:cr/vpcEndpoint:VpcEndpoint default crVpcEndpoint:cr-basic
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] registry: The Cr Registry name.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['VpcEndpointVpcArgs']]]] vpcs: List of vpc meta. When apply is executed for the first time, the vpcs in the tf file will be added to the existing vpcs, and subsequent apply will overwrite the existing vpcs with the vpcs in the tf file.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: VpcEndpointArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a resource to manage cr vpc endpoint
        ## Example Usage

        ```python
        import pulumi
        import pulumi_volcengine as volcengine

        foo = volcengine.cr.VpcEndpoint("foo",
            registry="enterprise-1",
            vpcs=[
                volcengine.cr.VpcEndpointVpcArgs(
                    account_id=0,
                    vpc_id="vpc-3resbfzl3xgjk5zsk2iuq3vhk",
                ),
                volcengine.cr.VpcEndpointVpcArgs(
                    subnet_id="subnet-2d62do4697i8058ozfdszxl30",
                    vpc_id="vpc-3red9li8dd8g05zsk2iadytvy",
                ),
            ])
        ```

        ## Import

        CR Vpc endpoint can be imported using the crVpcEndpoint:registry, e.g.

        ```sh
         $ pulumi import volcengine:cr/vpcEndpoint:VpcEndpoint default crVpcEndpoint:cr-basic
        ```

        :param str resource_name: The name of the resource.
        :param VpcEndpointArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(VpcEndpointArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 registry: Optional[pulumi.Input[str]] = None,
                 vpcs: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['VpcEndpointVpcArgs']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = VpcEndpointArgs.__new__(VpcEndpointArgs)

            if registry is None and not opts.urn:
                raise TypeError("Missing required property 'registry'")
            __props__.__dict__["registry"] = registry
            if vpcs is None and not opts.urn:
                raise TypeError("Missing required property 'vpcs'")
            __props__.__dict__["vpcs"] = vpcs
        super(VpcEndpoint, __self__).__init__(
            'volcengine:cr/vpcEndpoint:VpcEndpoint',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            registry: Optional[pulumi.Input[str]] = None,
            vpcs: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['VpcEndpointVpcArgs']]]]] = None) -> 'VpcEndpoint':
        """
        Get an existing VpcEndpoint resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] registry: The Cr Registry name.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['VpcEndpointVpcArgs']]]] vpcs: List of vpc meta. When apply is executed for the first time, the vpcs in the tf file will be added to the existing vpcs, and subsequent apply will overwrite the existing vpcs with the vpcs in the tf file.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _VpcEndpointState.__new__(_VpcEndpointState)

        __props__.__dict__["registry"] = registry
        __props__.__dict__["vpcs"] = vpcs
        return VpcEndpoint(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def registry(self) -> pulumi.Output[str]:
        """
        The Cr Registry name.
        """
        return pulumi.get(self, "registry")

    @property
    @pulumi.getter
    def vpcs(self) -> pulumi.Output[Sequence['outputs.VpcEndpointVpc']]:
        """
        List of vpc meta. When apply is executed for the first time, the vpcs in the tf file will be added to the existing vpcs, and subsequent apply will overwrite the existing vpcs with the vpcs in the tf file.
        """
        return pulumi.get(self, "vpcs")

