# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'VpcEndpointsResult',
    'AwaitableVpcEndpointsResult',
    'vpc_endpoints',
    'vpc_endpoints_output',
]

@pulumi.output_type
class VpcEndpointsResult:
    """
    A collection of values returned by VpcEndpoints.
    """
    def __init__(__self__, endpoints=None, id=None, output_file=None, registry=None, statuses=None, total_count=None):
        if endpoints and not isinstance(endpoints, list):
            raise TypeError("Expected argument 'endpoints' to be a list")
        pulumi.set(__self__, "endpoints", endpoints)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if registry and not isinstance(registry, str):
            raise TypeError("Expected argument 'registry' to be a str")
        pulumi.set(__self__, "registry", registry)
        if statuses and not isinstance(statuses, list):
            raise TypeError("Expected argument 'statuses' to be a list")
        pulumi.set(__self__, "statuses", statuses)
        if total_count and not isinstance(total_count, int):
            raise TypeError("Expected argument 'total_count' to be a int")
        pulumi.set(__self__, "total_count", total_count)

    @property
    @pulumi.getter
    def endpoints(self) -> Sequence['outputs.VpcEndpointsEndpointResult']:
        """
        List of CR vpc endpoints.
        """
        return pulumi.get(self, "endpoints")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[str]:
        return pulumi.get(self, "output_file")

    @property
    @pulumi.getter
    def registry(self) -> str:
        """
        The name of CR registry.
        """
        return pulumi.get(self, "registry")

    @property
    @pulumi.getter
    def statuses(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "statuses")

    @property
    @pulumi.getter(name="totalCount")
    def total_count(self) -> int:
        """
        The total count of CR vpc endpoints query.
        """
        return pulumi.get(self, "total_count")


class AwaitableVpcEndpointsResult(VpcEndpointsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return VpcEndpointsResult(
            endpoints=self.endpoints,
            id=self.id,
            output_file=self.output_file,
            registry=self.registry,
            statuses=self.statuses,
            total_count=self.total_count)


def vpc_endpoints(output_file: Optional[str] = None,
                  registry: Optional[str] = None,
                  statuses: Optional[Sequence[str]] = None,
                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableVpcEndpointsResult:
    """
    Use this data source to query detailed information of cr vpc endpoints
    ## Example Usage

    ```python
    import pulumi
    import pulumi_volcengine as volcengine

    default = volcengine.cr.vpc_endpoints(registry="enterprise-1",
        statuses=[
            "Enabled",
            "Enabling",
            "Disabling",
            "Failed",
        ])
    ```


    :param str output_file: File name where to save data source results.
    :param str registry: The CR registry name.
    :param Sequence[str] statuses: VPC access entry state array, used to filter out VPC access entries in the specified state. Available values are Enabling, Enabled, Disabling, Failed.
    """
    __args__ = dict()
    __args__['outputFile'] = output_file
    __args__['registry'] = registry
    __args__['statuses'] = statuses
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('volcengine:cr/vpcEndpoints:VpcEndpoints', __args__, opts=opts, typ=VpcEndpointsResult).value

    return AwaitableVpcEndpointsResult(
        endpoints=pulumi.get(__ret__, 'endpoints'),
        id=pulumi.get(__ret__, 'id'),
        output_file=pulumi.get(__ret__, 'output_file'),
        registry=pulumi.get(__ret__, 'registry'),
        statuses=pulumi.get(__ret__, 'statuses'),
        total_count=pulumi.get(__ret__, 'total_count'))


@_utilities.lift_output_func(vpc_endpoints)
def vpc_endpoints_output(output_file: Optional[pulumi.Input[Optional[str]]] = None,
                         registry: Optional[pulumi.Input[str]] = None,
                         statuses: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[VpcEndpointsResult]:
    """
    Use this data source to query detailed information of cr vpc endpoints
    ## Example Usage

    ```python
    import pulumi
    import pulumi_volcengine as volcengine

    default = volcengine.cr.vpc_endpoints(registry="enterprise-1",
        statuses=[
            "Enabled",
            "Enabling",
            "Disabling",
            "Failed",
        ])
    ```


    :param str output_file: File name where to save data source results.
    :param str registry: The CR registry name.
    :param Sequence[str] statuses: VPC access entry state array, used to filter out VPC access entries in the specified state. Available values are Enabling, Enabled, Disabling, Failed.
    """
    ...
