# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'BgpPeersResult',
    'AwaitableBgpPeersResult',
    'bgp_peers',
    'bgp_peers_output',
]

@pulumi.output_type
class BgpPeersResult:
    """
    A collection of values returned by BgpPeers.
    """
    def __init__(__self__, bgp_peer_name=None, bgp_peers=None, direct_connect_gateway_id=None, id=None, ids=None, name_regex=None, output_file=None, remote_asn=None, total_count=None, virtual_interface_id=None):
        if bgp_peer_name and not isinstance(bgp_peer_name, str):
            raise TypeError("Expected argument 'bgp_peer_name' to be a str")
        pulumi.set(__self__, "bgp_peer_name", bgp_peer_name)
        if bgp_peers and not isinstance(bgp_peers, list):
            raise TypeError("Expected argument 'bgp_peers' to be a list")
        pulumi.set(__self__, "bgp_peers", bgp_peers)
        if direct_connect_gateway_id and not isinstance(direct_connect_gateway_id, str):
            raise TypeError("Expected argument 'direct_connect_gateway_id' to be a str")
        pulumi.set(__self__, "direct_connect_gateway_id", direct_connect_gateway_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if name_regex and not isinstance(name_regex, str):
            raise TypeError("Expected argument 'name_regex' to be a str")
        pulumi.set(__self__, "name_regex", name_regex)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if remote_asn and not isinstance(remote_asn, int):
            raise TypeError("Expected argument 'remote_asn' to be a int")
        pulumi.set(__self__, "remote_asn", remote_asn)
        if total_count and not isinstance(total_count, int):
            raise TypeError("Expected argument 'total_count' to be a int")
        pulumi.set(__self__, "total_count", total_count)
        if virtual_interface_id and not isinstance(virtual_interface_id, str):
            raise TypeError("Expected argument 'virtual_interface_id' to be a str")
        pulumi.set(__self__, "virtual_interface_id", virtual_interface_id)

    @property
    @pulumi.getter(name="bgpPeerName")
    def bgp_peer_name(self) -> Optional[str]:
        """
        The name of bgp peer.
        """
        return pulumi.get(self, "bgp_peer_name")

    @property
    @pulumi.getter(name="bgpPeers")
    def bgp_peers(self) -> Sequence['outputs.BgpPeersBgpPeerResult']:
        """
        The collection of query.
        """
        return pulumi.get(self, "bgp_peers")

    @property
    @pulumi.getter(name="directConnectGatewayId")
    def direct_connect_gateway_id(self) -> Optional[str]:
        return pulumi.get(self, "direct_connect_gateway_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def ids(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "ids")

    @property
    @pulumi.getter(name="nameRegex")
    def name_regex(self) -> Optional[str]:
        return pulumi.get(self, "name_regex")

    @property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[str]:
        return pulumi.get(self, "output_file")

    @property
    @pulumi.getter(name="remoteAsn")
    def remote_asn(self) -> Optional[int]:
        """
        The remote asn of bgp peer.
        """
        return pulumi.get(self, "remote_asn")

    @property
    @pulumi.getter(name="totalCount")
    def total_count(self) -> int:
        """
        The total count of query.
        """
        return pulumi.get(self, "total_count")

    @property
    @pulumi.getter(name="virtualInterfaceId")
    def virtual_interface_id(self) -> Optional[str]:
        """
        The id of virtual interface.
        """
        return pulumi.get(self, "virtual_interface_id")


class AwaitableBgpPeersResult(BgpPeersResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return BgpPeersResult(
            bgp_peer_name=self.bgp_peer_name,
            bgp_peers=self.bgp_peers,
            direct_connect_gateway_id=self.direct_connect_gateway_id,
            id=self.id,
            ids=self.ids,
            name_regex=self.name_regex,
            output_file=self.output_file,
            remote_asn=self.remote_asn,
            total_count=self.total_count,
            virtual_interface_id=self.virtual_interface_id)


def bgp_peers(bgp_peer_name: Optional[str] = None,
              direct_connect_gateway_id: Optional[str] = None,
              ids: Optional[Sequence[str]] = None,
              name_regex: Optional[str] = None,
              output_file: Optional[str] = None,
              remote_asn: Optional[int] = None,
              virtual_interface_id: Optional[str] = None,
              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableBgpPeersResult:
    """
    Use this data source to query detailed information of direct connect bgp peers
    ## Example Usage

    ```python
    import pulumi
    import pulumi_volcengine as volcengine

    foo = volcengine.direct_connect.bgp_peers(ids=["bgp-171w6pn39ruo04d1w33iq****"])
    ```


    :param str bgp_peer_name: The name of bgp peer.
    :param str direct_connect_gateway_id: The id of direct connect gateway.
    :param Sequence[str] ids: A list of IDs.
    :param str name_regex: A Name Regex of Resource.
    :param str output_file: File name where to save data source results.
    :param int remote_asn: The remote asn of bgp peer.
    :param str virtual_interface_id: The id of virtual interface.
    """
    __args__ = dict()
    __args__['bgpPeerName'] = bgp_peer_name
    __args__['directConnectGatewayId'] = direct_connect_gateway_id
    __args__['ids'] = ids
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    __args__['remoteAsn'] = remote_asn
    __args__['virtualInterfaceId'] = virtual_interface_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('volcengine:direct_connect/bgpPeers:BgpPeers', __args__, opts=opts, typ=BgpPeersResult).value

    return AwaitableBgpPeersResult(
        bgp_peer_name=pulumi.get(__ret__, 'bgp_peer_name'),
        bgp_peers=pulumi.get(__ret__, 'bgp_peers'),
        direct_connect_gateway_id=pulumi.get(__ret__, 'direct_connect_gateway_id'),
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        name_regex=pulumi.get(__ret__, 'name_regex'),
        output_file=pulumi.get(__ret__, 'output_file'),
        remote_asn=pulumi.get(__ret__, 'remote_asn'),
        total_count=pulumi.get(__ret__, 'total_count'),
        virtual_interface_id=pulumi.get(__ret__, 'virtual_interface_id'))


@_utilities.lift_output_func(bgp_peers)
def bgp_peers_output(bgp_peer_name: Optional[pulumi.Input[Optional[str]]] = None,
                     direct_connect_gateway_id: Optional[pulumi.Input[Optional[str]]] = None,
                     ids: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                     name_regex: Optional[pulumi.Input[Optional[str]]] = None,
                     output_file: Optional[pulumi.Input[Optional[str]]] = None,
                     remote_asn: Optional[pulumi.Input[Optional[int]]] = None,
                     virtual_interface_id: Optional[pulumi.Input[Optional[str]]] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[BgpPeersResult]:
    """
    Use this data source to query detailed information of direct connect bgp peers
    ## Example Usage

    ```python
    import pulumi
    import pulumi_volcengine as volcengine

    foo = volcengine.direct_connect.bgp_peers(ids=["bgp-171w6pn39ruo04d1w33iq****"])
    ```


    :param str bgp_peer_name: The name of bgp peer.
    :param str direct_connect_gateway_id: The id of direct connect gateway.
    :param Sequence[str] ids: A list of IDs.
    :param str name_regex: A Name Regex of Resource.
    :param str output_file: File name where to save data source results.
    :param int remote_asn: The remote asn of bgp peer.
    :param str virtual_interface_id: The id of virtual interface.
    """
    ...
