# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ConnectionArgs', 'Connection']

@pulumi.input_type
class ConnectionArgs:
    def __init__(__self__, *,
                 bandwidth: pulumi.Input[int],
                 customer_contact_email: pulumi.Input[str],
                 customer_contact_phone: pulumi.Input[str],
                 customer_name: pulumi.Input[str],
                 direct_connect_access_point_id: pulumi.Input[str],
                 line_operator: pulumi.Input[str],
                 peer_location: pulumi.Input[str],
                 port_spec: pulumi.Input[str],
                 port_type: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None,
                 direct_connect_connection_name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['ConnectionTagArgs']]]] = None):
        """
        The set of arguments for constructing a Connection resource.
        :param pulumi.Input[int] bandwidth: The line band width,unit:Mbps.
        :param pulumi.Input[str] customer_contact_email: The dedicated line contact email.
        :param pulumi.Input[str] customer_contact_phone: The dedicated line contact phone.
        :param pulumi.Input[str] customer_name: The dedicated line contact name.
        :param pulumi.Input[str] direct_connect_access_point_id: The direct connect access point id.
        :param pulumi.Input[str] line_operator: The physical leased line operator.valid value contains `ChinaTelecom`,`ChinaMobile`,`ChinaUnicom`,`ChinaOther`.
        :param pulumi.Input[str] peer_location: The local IDC address.
        :param pulumi.Input[str] port_spec: The physical leased line port spec.valid value contains `1G`,`10G`.
        :param pulumi.Input[str] port_type: The physical leased line port type and spec.valid value contains `1000Base-T`,`10GBase-T`,`1000Base`,`10GBase`,`40GBase`,`100GBase`.
        :param pulumi.Input[str] description: The description of direct connect.
        :param pulumi.Input[str] direct_connect_connection_name: The name of direct connect.
        :param pulumi.Input[Sequence[pulumi.Input['ConnectionTagArgs']]] tags: The physical leased line tags.
        """
        pulumi.set(__self__, "bandwidth", bandwidth)
        pulumi.set(__self__, "customer_contact_email", customer_contact_email)
        pulumi.set(__self__, "customer_contact_phone", customer_contact_phone)
        pulumi.set(__self__, "customer_name", customer_name)
        pulumi.set(__self__, "direct_connect_access_point_id", direct_connect_access_point_id)
        pulumi.set(__self__, "line_operator", line_operator)
        pulumi.set(__self__, "peer_location", peer_location)
        pulumi.set(__self__, "port_spec", port_spec)
        pulumi.set(__self__, "port_type", port_type)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if direct_connect_connection_name is not None:
            pulumi.set(__self__, "direct_connect_connection_name", direct_connect_connection_name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def bandwidth(self) -> pulumi.Input[int]:
        """
        The line band width,unit:Mbps.
        """
        return pulumi.get(self, "bandwidth")

    @bandwidth.setter
    def bandwidth(self, value: pulumi.Input[int]):
        pulumi.set(self, "bandwidth", value)

    @property
    @pulumi.getter(name="customerContactEmail")
    def customer_contact_email(self) -> pulumi.Input[str]:
        """
        The dedicated line contact email.
        """
        return pulumi.get(self, "customer_contact_email")

    @customer_contact_email.setter
    def customer_contact_email(self, value: pulumi.Input[str]):
        pulumi.set(self, "customer_contact_email", value)

    @property
    @pulumi.getter(name="customerContactPhone")
    def customer_contact_phone(self) -> pulumi.Input[str]:
        """
        The dedicated line contact phone.
        """
        return pulumi.get(self, "customer_contact_phone")

    @customer_contact_phone.setter
    def customer_contact_phone(self, value: pulumi.Input[str]):
        pulumi.set(self, "customer_contact_phone", value)

    @property
    @pulumi.getter(name="customerName")
    def customer_name(self) -> pulumi.Input[str]:
        """
        The dedicated line contact name.
        """
        return pulumi.get(self, "customer_name")

    @customer_name.setter
    def customer_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "customer_name", value)

    @property
    @pulumi.getter(name="directConnectAccessPointId")
    def direct_connect_access_point_id(self) -> pulumi.Input[str]:
        """
        The direct connect access point id.
        """
        return pulumi.get(self, "direct_connect_access_point_id")

    @direct_connect_access_point_id.setter
    def direct_connect_access_point_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "direct_connect_access_point_id", value)

    @property
    @pulumi.getter(name="lineOperator")
    def line_operator(self) -> pulumi.Input[str]:
        """
        The physical leased line operator.valid value contains `ChinaTelecom`,`ChinaMobile`,`ChinaUnicom`,`ChinaOther`.
        """
        return pulumi.get(self, "line_operator")

    @line_operator.setter
    def line_operator(self, value: pulumi.Input[str]):
        pulumi.set(self, "line_operator", value)

    @property
    @pulumi.getter(name="peerLocation")
    def peer_location(self) -> pulumi.Input[str]:
        """
        The local IDC address.
        """
        return pulumi.get(self, "peer_location")

    @peer_location.setter
    def peer_location(self, value: pulumi.Input[str]):
        pulumi.set(self, "peer_location", value)

    @property
    @pulumi.getter(name="portSpec")
    def port_spec(self) -> pulumi.Input[str]:
        """
        The physical leased line port spec.valid value contains `1G`,`10G`.
        """
        return pulumi.get(self, "port_spec")

    @port_spec.setter
    def port_spec(self, value: pulumi.Input[str]):
        pulumi.set(self, "port_spec", value)

    @property
    @pulumi.getter(name="portType")
    def port_type(self) -> pulumi.Input[str]:
        """
        The physical leased line port type and spec.valid value contains `1000Base-T`,`10GBase-T`,`1000Base`,`10GBase`,`40GBase`,`100GBase`.
        """
        return pulumi.get(self, "port_type")

    @port_type.setter
    def port_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "port_type", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of direct connect.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="directConnectConnectionName")
    def direct_connect_connection_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of direct connect.
        """
        return pulumi.get(self, "direct_connect_connection_name")

    @direct_connect_connection_name.setter
    def direct_connect_connection_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "direct_connect_connection_name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ConnectionTagArgs']]]]:
        """
        The physical leased line tags.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ConnectionTagArgs']]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _ConnectionState:
    def __init__(__self__, *,
                 bandwidth: Optional[pulumi.Input[int]] = None,
                 customer_contact_email: Optional[pulumi.Input[str]] = None,
                 customer_contact_phone: Optional[pulumi.Input[str]] = None,
                 customer_name: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 direct_connect_access_point_id: Optional[pulumi.Input[str]] = None,
                 direct_connect_connection_name: Optional[pulumi.Input[str]] = None,
                 line_operator: Optional[pulumi.Input[str]] = None,
                 peer_location: Optional[pulumi.Input[str]] = None,
                 port_spec: Optional[pulumi.Input[str]] = None,
                 port_type: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['ConnectionTagArgs']]]] = None):
        """
        Input properties used for looking up and filtering Connection resources.
        :param pulumi.Input[int] bandwidth: The line band width,unit:Mbps.
        :param pulumi.Input[str] customer_contact_email: The dedicated line contact email.
        :param pulumi.Input[str] customer_contact_phone: The dedicated line contact phone.
        :param pulumi.Input[str] customer_name: The dedicated line contact name.
        :param pulumi.Input[str] description: The description of direct connect.
        :param pulumi.Input[str] direct_connect_access_point_id: The direct connect access point id.
        :param pulumi.Input[str] direct_connect_connection_name: The name of direct connect.
        :param pulumi.Input[str] line_operator: The physical leased line operator.valid value contains `ChinaTelecom`,`ChinaMobile`,`ChinaUnicom`,`ChinaOther`.
        :param pulumi.Input[str] peer_location: The local IDC address.
        :param pulumi.Input[str] port_spec: The physical leased line port spec.valid value contains `1G`,`10G`.
        :param pulumi.Input[str] port_type: The physical leased line port type and spec.valid value contains `1000Base-T`,`10GBase-T`,`1000Base`,`10GBase`,`40GBase`,`100GBase`.
        :param pulumi.Input[Sequence[pulumi.Input['ConnectionTagArgs']]] tags: The physical leased line tags.
        """
        if bandwidth is not None:
            pulumi.set(__self__, "bandwidth", bandwidth)
        if customer_contact_email is not None:
            pulumi.set(__self__, "customer_contact_email", customer_contact_email)
        if customer_contact_phone is not None:
            pulumi.set(__self__, "customer_contact_phone", customer_contact_phone)
        if customer_name is not None:
            pulumi.set(__self__, "customer_name", customer_name)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if direct_connect_access_point_id is not None:
            pulumi.set(__self__, "direct_connect_access_point_id", direct_connect_access_point_id)
        if direct_connect_connection_name is not None:
            pulumi.set(__self__, "direct_connect_connection_name", direct_connect_connection_name)
        if line_operator is not None:
            pulumi.set(__self__, "line_operator", line_operator)
        if peer_location is not None:
            pulumi.set(__self__, "peer_location", peer_location)
        if port_spec is not None:
            pulumi.set(__self__, "port_spec", port_spec)
        if port_type is not None:
            pulumi.set(__self__, "port_type", port_type)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def bandwidth(self) -> Optional[pulumi.Input[int]]:
        """
        The line band width,unit:Mbps.
        """
        return pulumi.get(self, "bandwidth")

    @bandwidth.setter
    def bandwidth(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "bandwidth", value)

    @property
    @pulumi.getter(name="customerContactEmail")
    def customer_contact_email(self) -> Optional[pulumi.Input[str]]:
        """
        The dedicated line contact email.
        """
        return pulumi.get(self, "customer_contact_email")

    @customer_contact_email.setter
    def customer_contact_email(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "customer_contact_email", value)

    @property
    @pulumi.getter(name="customerContactPhone")
    def customer_contact_phone(self) -> Optional[pulumi.Input[str]]:
        """
        The dedicated line contact phone.
        """
        return pulumi.get(self, "customer_contact_phone")

    @customer_contact_phone.setter
    def customer_contact_phone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "customer_contact_phone", value)

    @property
    @pulumi.getter(name="customerName")
    def customer_name(self) -> Optional[pulumi.Input[str]]:
        """
        The dedicated line contact name.
        """
        return pulumi.get(self, "customer_name")

    @customer_name.setter
    def customer_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "customer_name", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of direct connect.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="directConnectAccessPointId")
    def direct_connect_access_point_id(self) -> Optional[pulumi.Input[str]]:
        """
        The direct connect access point id.
        """
        return pulumi.get(self, "direct_connect_access_point_id")

    @direct_connect_access_point_id.setter
    def direct_connect_access_point_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "direct_connect_access_point_id", value)

    @property
    @pulumi.getter(name="directConnectConnectionName")
    def direct_connect_connection_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of direct connect.
        """
        return pulumi.get(self, "direct_connect_connection_name")

    @direct_connect_connection_name.setter
    def direct_connect_connection_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "direct_connect_connection_name", value)

    @property
    @pulumi.getter(name="lineOperator")
    def line_operator(self) -> Optional[pulumi.Input[str]]:
        """
        The physical leased line operator.valid value contains `ChinaTelecom`,`ChinaMobile`,`ChinaUnicom`,`ChinaOther`.
        """
        return pulumi.get(self, "line_operator")

    @line_operator.setter
    def line_operator(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "line_operator", value)

    @property
    @pulumi.getter(name="peerLocation")
    def peer_location(self) -> Optional[pulumi.Input[str]]:
        """
        The local IDC address.
        """
        return pulumi.get(self, "peer_location")

    @peer_location.setter
    def peer_location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "peer_location", value)

    @property
    @pulumi.getter(name="portSpec")
    def port_spec(self) -> Optional[pulumi.Input[str]]:
        """
        The physical leased line port spec.valid value contains `1G`,`10G`.
        """
        return pulumi.get(self, "port_spec")

    @port_spec.setter
    def port_spec(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "port_spec", value)

    @property
    @pulumi.getter(name="portType")
    def port_type(self) -> Optional[pulumi.Input[str]]:
        """
        The physical leased line port type and spec.valid value contains `1000Base-T`,`10GBase-T`,`1000Base`,`10GBase`,`40GBase`,`100GBase`.
        """
        return pulumi.get(self, "port_type")

    @port_type.setter
    def port_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "port_type", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ConnectionTagArgs']]]]:
        """
        The physical leased line tags.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ConnectionTagArgs']]]]):
        pulumi.set(self, "tags", value)


class Connection(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bandwidth: Optional[pulumi.Input[int]] = None,
                 customer_contact_email: Optional[pulumi.Input[str]] = None,
                 customer_contact_phone: Optional[pulumi.Input[str]] = None,
                 customer_name: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 direct_connect_access_point_id: Optional[pulumi.Input[str]] = None,
                 direct_connect_connection_name: Optional[pulumi.Input[str]] = None,
                 line_operator: Optional[pulumi.Input[str]] = None,
                 peer_location: Optional[pulumi.Input[str]] = None,
                 port_spec: Optional[pulumi.Input[str]] = None,
                 port_type: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ConnectionTagArgs']]]]] = None,
                 __props__=None):
        """
        Provides a resource to manage direct connect connection
        ## Example Usage

        ```python
        import pulumi
        import pulumi_volcengine as volcengine

        foo = volcengine.direct_connect.Connection("foo",
            bandwidth=1000,
            customer_contact_email="email@aaa.com",
            customer_contact_phone="12345678911",
            customer_name="tf-a",
            description="tf-test",
            direct_connect_access_point_id="ap-cn-beijing-a",
            direct_connect_connection_name="tf-test-connection",
            line_operator="ChinaOther",
            peer_location="XX路XX号XX楼XX机房",
            port_spec="10G",
            port_type="10GBase",
            tags=[volcengine.direct_connect.ConnectionTagArgs(
                key="k1",
                value="v1",
            )])
        ```

        ## Import

        DirectConnectConnection can be imported using the id, e.g.

        ```sh
         $ pulumi import volcengine:direct_connect/connection:Connection default dcc-7qthudw0ll6jmc****
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] bandwidth: The line band width,unit:Mbps.
        :param pulumi.Input[str] customer_contact_email: The dedicated line contact email.
        :param pulumi.Input[str] customer_contact_phone: The dedicated line contact phone.
        :param pulumi.Input[str] customer_name: The dedicated line contact name.
        :param pulumi.Input[str] description: The description of direct connect.
        :param pulumi.Input[str] direct_connect_access_point_id: The direct connect access point id.
        :param pulumi.Input[str] direct_connect_connection_name: The name of direct connect.
        :param pulumi.Input[str] line_operator: The physical leased line operator.valid value contains `ChinaTelecom`,`ChinaMobile`,`ChinaUnicom`,`ChinaOther`.
        :param pulumi.Input[str] peer_location: The local IDC address.
        :param pulumi.Input[str] port_spec: The physical leased line port spec.valid value contains `1G`,`10G`.
        :param pulumi.Input[str] port_type: The physical leased line port type and spec.valid value contains `1000Base-T`,`10GBase-T`,`1000Base`,`10GBase`,`40GBase`,`100GBase`.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ConnectionTagArgs']]]] tags: The physical leased line tags.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ConnectionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a resource to manage direct connect connection
        ## Example Usage

        ```python
        import pulumi
        import pulumi_volcengine as volcengine

        foo = volcengine.direct_connect.Connection("foo",
            bandwidth=1000,
            customer_contact_email="email@aaa.com",
            customer_contact_phone="12345678911",
            customer_name="tf-a",
            description="tf-test",
            direct_connect_access_point_id="ap-cn-beijing-a",
            direct_connect_connection_name="tf-test-connection",
            line_operator="ChinaOther",
            peer_location="XX路XX号XX楼XX机房",
            port_spec="10G",
            port_type="10GBase",
            tags=[volcengine.direct_connect.ConnectionTagArgs(
                key="k1",
                value="v1",
            )])
        ```

        ## Import

        DirectConnectConnection can be imported using the id, e.g.

        ```sh
         $ pulumi import volcengine:direct_connect/connection:Connection default dcc-7qthudw0ll6jmc****
        ```

        :param str resource_name: The name of the resource.
        :param ConnectionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ConnectionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bandwidth: Optional[pulumi.Input[int]] = None,
                 customer_contact_email: Optional[pulumi.Input[str]] = None,
                 customer_contact_phone: Optional[pulumi.Input[str]] = None,
                 customer_name: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 direct_connect_access_point_id: Optional[pulumi.Input[str]] = None,
                 direct_connect_connection_name: Optional[pulumi.Input[str]] = None,
                 line_operator: Optional[pulumi.Input[str]] = None,
                 peer_location: Optional[pulumi.Input[str]] = None,
                 port_spec: Optional[pulumi.Input[str]] = None,
                 port_type: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ConnectionTagArgs']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ConnectionArgs.__new__(ConnectionArgs)

            if bandwidth is None and not opts.urn:
                raise TypeError("Missing required property 'bandwidth'")
            __props__.__dict__["bandwidth"] = bandwidth
            if customer_contact_email is None and not opts.urn:
                raise TypeError("Missing required property 'customer_contact_email'")
            __props__.__dict__["customer_contact_email"] = customer_contact_email
            if customer_contact_phone is None and not opts.urn:
                raise TypeError("Missing required property 'customer_contact_phone'")
            __props__.__dict__["customer_contact_phone"] = customer_contact_phone
            if customer_name is None and not opts.urn:
                raise TypeError("Missing required property 'customer_name'")
            __props__.__dict__["customer_name"] = customer_name
            __props__.__dict__["description"] = description
            if direct_connect_access_point_id is None and not opts.urn:
                raise TypeError("Missing required property 'direct_connect_access_point_id'")
            __props__.__dict__["direct_connect_access_point_id"] = direct_connect_access_point_id
            __props__.__dict__["direct_connect_connection_name"] = direct_connect_connection_name
            if line_operator is None and not opts.urn:
                raise TypeError("Missing required property 'line_operator'")
            __props__.__dict__["line_operator"] = line_operator
            if peer_location is None and not opts.urn:
                raise TypeError("Missing required property 'peer_location'")
            __props__.__dict__["peer_location"] = peer_location
            if port_spec is None and not opts.urn:
                raise TypeError("Missing required property 'port_spec'")
            __props__.__dict__["port_spec"] = port_spec
            if port_type is None and not opts.urn:
                raise TypeError("Missing required property 'port_type'")
            __props__.__dict__["port_type"] = port_type
            __props__.__dict__["tags"] = tags
        super(Connection, __self__).__init__(
            'volcengine:direct_connect/connection:Connection',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            bandwidth: Optional[pulumi.Input[int]] = None,
            customer_contact_email: Optional[pulumi.Input[str]] = None,
            customer_contact_phone: Optional[pulumi.Input[str]] = None,
            customer_name: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            direct_connect_access_point_id: Optional[pulumi.Input[str]] = None,
            direct_connect_connection_name: Optional[pulumi.Input[str]] = None,
            line_operator: Optional[pulumi.Input[str]] = None,
            peer_location: Optional[pulumi.Input[str]] = None,
            port_spec: Optional[pulumi.Input[str]] = None,
            port_type: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ConnectionTagArgs']]]]] = None) -> 'Connection':
        """
        Get an existing Connection resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] bandwidth: The line band width,unit:Mbps.
        :param pulumi.Input[str] customer_contact_email: The dedicated line contact email.
        :param pulumi.Input[str] customer_contact_phone: The dedicated line contact phone.
        :param pulumi.Input[str] customer_name: The dedicated line contact name.
        :param pulumi.Input[str] description: The description of direct connect.
        :param pulumi.Input[str] direct_connect_access_point_id: The direct connect access point id.
        :param pulumi.Input[str] direct_connect_connection_name: The name of direct connect.
        :param pulumi.Input[str] line_operator: The physical leased line operator.valid value contains `ChinaTelecom`,`ChinaMobile`,`ChinaUnicom`,`ChinaOther`.
        :param pulumi.Input[str] peer_location: The local IDC address.
        :param pulumi.Input[str] port_spec: The physical leased line port spec.valid value contains `1G`,`10G`.
        :param pulumi.Input[str] port_type: The physical leased line port type and spec.valid value contains `1000Base-T`,`10GBase-T`,`1000Base`,`10GBase`,`40GBase`,`100GBase`.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ConnectionTagArgs']]]] tags: The physical leased line tags.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ConnectionState.__new__(_ConnectionState)

        __props__.__dict__["bandwidth"] = bandwidth
        __props__.__dict__["customer_contact_email"] = customer_contact_email
        __props__.__dict__["customer_contact_phone"] = customer_contact_phone
        __props__.__dict__["customer_name"] = customer_name
        __props__.__dict__["description"] = description
        __props__.__dict__["direct_connect_access_point_id"] = direct_connect_access_point_id
        __props__.__dict__["direct_connect_connection_name"] = direct_connect_connection_name
        __props__.__dict__["line_operator"] = line_operator
        __props__.__dict__["peer_location"] = peer_location
        __props__.__dict__["port_spec"] = port_spec
        __props__.__dict__["port_type"] = port_type
        __props__.__dict__["tags"] = tags
        return Connection(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def bandwidth(self) -> pulumi.Output[int]:
        """
        The line band width,unit:Mbps.
        """
        return pulumi.get(self, "bandwidth")

    @property
    @pulumi.getter(name="customerContactEmail")
    def customer_contact_email(self) -> pulumi.Output[str]:
        """
        The dedicated line contact email.
        """
        return pulumi.get(self, "customer_contact_email")

    @property
    @pulumi.getter(name="customerContactPhone")
    def customer_contact_phone(self) -> pulumi.Output[str]:
        """
        The dedicated line contact phone.
        """
        return pulumi.get(self, "customer_contact_phone")

    @property
    @pulumi.getter(name="customerName")
    def customer_name(self) -> pulumi.Output[str]:
        """
        The dedicated line contact name.
        """
        return pulumi.get(self, "customer_name")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        The description of direct connect.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="directConnectAccessPointId")
    def direct_connect_access_point_id(self) -> pulumi.Output[str]:
        """
        The direct connect access point id.
        """
        return pulumi.get(self, "direct_connect_access_point_id")

    @property
    @pulumi.getter(name="directConnectConnectionName")
    def direct_connect_connection_name(self) -> pulumi.Output[str]:
        """
        The name of direct connect.
        """
        return pulumi.get(self, "direct_connect_connection_name")

    @property
    @pulumi.getter(name="lineOperator")
    def line_operator(self) -> pulumi.Output[str]:
        """
        The physical leased line operator.valid value contains `ChinaTelecom`,`ChinaMobile`,`ChinaUnicom`,`ChinaOther`.
        """
        return pulumi.get(self, "line_operator")

    @property
    @pulumi.getter(name="peerLocation")
    def peer_location(self) -> pulumi.Output[str]:
        """
        The local IDC address.
        """
        return pulumi.get(self, "peer_location")

    @property
    @pulumi.getter(name="portSpec")
    def port_spec(self) -> pulumi.Output[str]:
        """
        The physical leased line port spec.valid value contains `1G`,`10G`.
        """
        return pulumi.get(self, "port_spec")

    @property
    @pulumi.getter(name="portType")
    def port_type(self) -> pulumi.Output[str]:
        """
        The physical leased line port type and spec.valid value contains `1000Base-T`,`10GBase-T`,`1000Base`,`10GBase`,`40GBase`,`100GBase`.
        """
        return pulumi.get(self, "port_type")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['outputs.ConnectionTag']]]:
        """
        The physical leased line tags.
        """
        return pulumi.get(self, "tags")

