# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'ConnectionsResult',
    'AwaitableConnectionsResult',
    'connections',
    'connections_output',
]

@pulumi.output_type
class ConnectionsResult:
    """
    A collection of values returned by Connections.
    """
    def __init__(__self__, connection_type=None, direct_connect_access_point_id=None, direct_connect_connection_name=None, direct_connect_connections=None, id=None, ids=None, line_operator=None, name_regex=None, output_file=None, peer_location=None, tag_filters=None, total_count=None):
        if connection_type and not isinstance(connection_type, str):
            raise TypeError("Expected argument 'connection_type' to be a str")
        pulumi.set(__self__, "connection_type", connection_type)
        if direct_connect_access_point_id and not isinstance(direct_connect_access_point_id, str):
            raise TypeError("Expected argument 'direct_connect_access_point_id' to be a str")
        pulumi.set(__self__, "direct_connect_access_point_id", direct_connect_access_point_id)
        if direct_connect_connection_name and not isinstance(direct_connect_connection_name, str):
            raise TypeError("Expected argument 'direct_connect_connection_name' to be a str")
        pulumi.set(__self__, "direct_connect_connection_name", direct_connect_connection_name)
        if direct_connect_connections and not isinstance(direct_connect_connections, list):
            raise TypeError("Expected argument 'direct_connect_connections' to be a list")
        pulumi.set(__self__, "direct_connect_connections", direct_connect_connections)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if line_operator and not isinstance(line_operator, str):
            raise TypeError("Expected argument 'line_operator' to be a str")
        pulumi.set(__self__, "line_operator", line_operator)
        if name_regex and not isinstance(name_regex, str):
            raise TypeError("Expected argument 'name_regex' to be a str")
        pulumi.set(__self__, "name_regex", name_regex)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if peer_location and not isinstance(peer_location, str):
            raise TypeError("Expected argument 'peer_location' to be a str")
        pulumi.set(__self__, "peer_location", peer_location)
        if tag_filters and not isinstance(tag_filters, list):
            raise TypeError("Expected argument 'tag_filters' to be a list")
        pulumi.set(__self__, "tag_filters", tag_filters)
        if total_count and not isinstance(total_count, int):
            raise TypeError("Expected argument 'total_count' to be a int")
        pulumi.set(__self__, "total_count", total_count)

    @property
    @pulumi.getter(name="connectionType")
    def connection_type(self) -> Optional[str]:
        """
        The connection type of direct connect.
        """
        return pulumi.get(self, "connection_type")

    @property
    @pulumi.getter(name="directConnectAccessPointId")
    def direct_connect_access_point_id(self) -> Optional[str]:
        """
        The access point id of direct connect.
        """
        return pulumi.get(self, "direct_connect_access_point_id")

    @property
    @pulumi.getter(name="directConnectConnectionName")
    def direct_connect_connection_name(self) -> Optional[str]:
        """
        The name of direct connect connection.
        """
        return pulumi.get(self, "direct_connect_connection_name")

    @property
    @pulumi.getter(name="directConnectConnections")
    def direct_connect_connections(self) -> Sequence['outputs.ConnectionsDirectConnectConnectionResult']:
        """
        The collection of query.
        """
        return pulumi.get(self, "direct_connect_connections")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def ids(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "ids")

    @property
    @pulumi.getter(name="lineOperator")
    def line_operator(self) -> Optional[str]:
        """
        The operator of physical leased line.
        """
        return pulumi.get(self, "line_operator")

    @property
    @pulumi.getter(name="nameRegex")
    def name_regex(self) -> Optional[str]:
        return pulumi.get(self, "name_regex")

    @property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[str]:
        return pulumi.get(self, "output_file")

    @property
    @pulumi.getter(name="peerLocation")
    def peer_location(self) -> Optional[str]:
        """
        The peer access point of the physical leased line.
        """
        return pulumi.get(self, "peer_location")

    @property
    @pulumi.getter(name="tagFilters")
    def tag_filters(self) -> Optional[Sequence['outputs.ConnectionsTagFilterResult']]:
        return pulumi.get(self, "tag_filters")

    @property
    @pulumi.getter(name="totalCount")
    def total_count(self) -> int:
        """
        The total count of query.
        """
        return pulumi.get(self, "total_count")


class AwaitableConnectionsResult(ConnectionsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return ConnectionsResult(
            connection_type=self.connection_type,
            direct_connect_access_point_id=self.direct_connect_access_point_id,
            direct_connect_connection_name=self.direct_connect_connection_name,
            direct_connect_connections=self.direct_connect_connections,
            id=self.id,
            ids=self.ids,
            line_operator=self.line_operator,
            name_regex=self.name_regex,
            output_file=self.output_file,
            peer_location=self.peer_location,
            tag_filters=self.tag_filters,
            total_count=self.total_count)


def connections(connection_type: Optional[str] = None,
                direct_connect_access_point_id: Optional[str] = None,
                direct_connect_connection_name: Optional[str] = None,
                ids: Optional[Sequence[str]] = None,
                line_operator: Optional[str] = None,
                name_regex: Optional[str] = None,
                output_file: Optional[str] = None,
                peer_location: Optional[str] = None,
                tag_filters: Optional[Sequence[pulumi.InputType['ConnectionsTagFilterArgs']]] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableConnectionsResult:
    """
    Use this data source to query detailed information of direct connect connections
    ## Example Usage

    ```python
    import pulumi
    import pulumi_volcengine as volcengine

    foo = volcengine.direct_connect.connections(direct_connect_connection_name="tf_test")
    ```


    :param str connection_type: The connection type of physical leased line,valid value contains `SharedConnection`,`DedicatedConnection`.
    :param str direct_connect_access_point_id: The ID of the physical leased line access point.
    :param str direct_connect_connection_name: The name of directi connect connection.
    :param Sequence[str] ids: A list of IDs.
    :param str line_operator: The operator of the physical leased line,valid value contains `ChinaTelecom`,`ChinaMobile`,`ChinaUnicom`,`ChinaOther`.
    :param str name_regex: A Name Regex of Resource.
    :param str output_file: File name where to save data source results.
    :param str peer_location: The peer access point of the physical leased line.
    :param Sequence[pulumi.InputType['ConnectionsTagFilterArgs']] tag_filters: The filter tag of direct connect.
    """
    __args__ = dict()
    __args__['connectionType'] = connection_type
    __args__['directConnectAccessPointId'] = direct_connect_access_point_id
    __args__['directConnectConnectionName'] = direct_connect_connection_name
    __args__['ids'] = ids
    __args__['lineOperator'] = line_operator
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    __args__['peerLocation'] = peer_location
    __args__['tagFilters'] = tag_filters
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('volcengine:direct_connect/connections:Connections', __args__, opts=opts, typ=ConnectionsResult).value

    return AwaitableConnectionsResult(
        connection_type=pulumi.get(__ret__, 'connection_type'),
        direct_connect_access_point_id=pulumi.get(__ret__, 'direct_connect_access_point_id'),
        direct_connect_connection_name=pulumi.get(__ret__, 'direct_connect_connection_name'),
        direct_connect_connections=pulumi.get(__ret__, 'direct_connect_connections'),
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        line_operator=pulumi.get(__ret__, 'line_operator'),
        name_regex=pulumi.get(__ret__, 'name_regex'),
        output_file=pulumi.get(__ret__, 'output_file'),
        peer_location=pulumi.get(__ret__, 'peer_location'),
        tag_filters=pulumi.get(__ret__, 'tag_filters'),
        total_count=pulumi.get(__ret__, 'total_count'))


@_utilities.lift_output_func(connections)
def connections_output(connection_type: Optional[pulumi.Input[Optional[str]]] = None,
                       direct_connect_access_point_id: Optional[pulumi.Input[Optional[str]]] = None,
                       direct_connect_connection_name: Optional[pulumi.Input[Optional[str]]] = None,
                       ids: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                       line_operator: Optional[pulumi.Input[Optional[str]]] = None,
                       name_regex: Optional[pulumi.Input[Optional[str]]] = None,
                       output_file: Optional[pulumi.Input[Optional[str]]] = None,
                       peer_location: Optional[pulumi.Input[Optional[str]]] = None,
                       tag_filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['ConnectionsTagFilterArgs']]]]] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[ConnectionsResult]:
    """
    Use this data source to query detailed information of direct connect connections
    ## Example Usage

    ```python
    import pulumi
    import pulumi_volcengine as volcengine

    foo = volcengine.direct_connect.connections(direct_connect_connection_name="tf_test")
    ```


    :param str connection_type: The connection type of physical leased line,valid value contains `SharedConnection`,`DedicatedConnection`.
    :param str direct_connect_access_point_id: The ID of the physical leased line access point.
    :param str direct_connect_connection_name: The name of directi connect connection.
    :param Sequence[str] ids: A list of IDs.
    :param str line_operator: The operator of the physical leased line,valid value contains `ChinaTelecom`,`ChinaMobile`,`ChinaUnicom`,`ChinaOther`.
    :param str name_regex: A Name Regex of Resource.
    :param str output_file: File name where to save data source results.
    :param str peer_location: The peer access point of the physical leased line.
    :param Sequence[pulumi.InputType['ConnectionsTagFilterArgs']] tag_filters: The filter tag of direct connect.
    """
    ...
