# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['GatewayArgs', 'Gateway']

@pulumi.input_type
class GatewayArgs:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 direct_connect_gateway_name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['GatewayTagArgs']]]] = None):
        """
        The set of arguments for constructing a Gateway resource.
        :param pulumi.Input[str] description: The description of direct connect gateway.
        :param pulumi.Input[str] direct_connect_gateway_name: The name of direct connect gateway.
        :param pulumi.Input[Sequence[pulumi.Input['GatewayTagArgs']]] tags: The direct connect gateway tags.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if direct_connect_gateway_name is not None:
            pulumi.set(__self__, "direct_connect_gateway_name", direct_connect_gateway_name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of direct connect gateway.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="directConnectGatewayName")
    def direct_connect_gateway_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of direct connect gateway.
        """
        return pulumi.get(self, "direct_connect_gateway_name")

    @direct_connect_gateway_name.setter
    def direct_connect_gateway_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "direct_connect_gateway_name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GatewayTagArgs']]]]:
        """
        The direct connect gateway tags.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GatewayTagArgs']]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _GatewayState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 direct_connect_gateway_name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['GatewayTagArgs']]]] = None):
        """
        Input properties used for looking up and filtering Gateway resources.
        :param pulumi.Input[str] description: The description of direct connect gateway.
        :param pulumi.Input[str] direct_connect_gateway_name: The name of direct connect gateway.
        :param pulumi.Input[Sequence[pulumi.Input['GatewayTagArgs']]] tags: The direct connect gateway tags.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if direct_connect_gateway_name is not None:
            pulumi.set(__self__, "direct_connect_gateway_name", direct_connect_gateway_name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of direct connect gateway.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="directConnectGatewayName")
    def direct_connect_gateway_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of direct connect gateway.
        """
        return pulumi.get(self, "direct_connect_gateway_name")

    @direct_connect_gateway_name.setter
    def direct_connect_gateway_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "direct_connect_gateway_name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GatewayTagArgs']]]]:
        """
        The direct connect gateway tags.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GatewayTagArgs']]]]):
        pulumi.set(self, "tags", value)


class Gateway(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 direct_connect_gateway_name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['GatewayTagArgs']]]]] = None,
                 __props__=None):
        """
        Provides a resource to manage direct connect gateway
        ## Example Usage

        ```python
        import pulumi
        import pulumi_volcengine as volcengine

        foo = volcengine.direct_connect.Gateway("foo",
            description="tf-test",
            direct_connect_gateway_name="tf-test-gateway",
            tags=[volcengine.direct_connect.GatewayTagArgs(
                key="k1",
                value="v1",
            )])
        ```

        ## Import

        DirectConnectGateway can be imported using the id, e.g.

        ```sh
         $ pulumi import volcengine:direct_connect/gateway:Gateway default resource_id
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: The description of direct connect gateway.
        :param pulumi.Input[str] direct_connect_gateway_name: The name of direct connect gateway.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['GatewayTagArgs']]]] tags: The direct connect gateway tags.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[GatewayArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a resource to manage direct connect gateway
        ## Example Usage

        ```python
        import pulumi
        import pulumi_volcengine as volcengine

        foo = volcengine.direct_connect.Gateway("foo",
            description="tf-test",
            direct_connect_gateway_name="tf-test-gateway",
            tags=[volcengine.direct_connect.GatewayTagArgs(
                key="k1",
                value="v1",
            )])
        ```

        ## Import

        DirectConnectGateway can be imported using the id, e.g.

        ```sh
         $ pulumi import volcengine:direct_connect/gateway:Gateway default resource_id
        ```

        :param str resource_name: The name of the resource.
        :param GatewayArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(GatewayArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 direct_connect_gateway_name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['GatewayTagArgs']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = GatewayArgs.__new__(GatewayArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["direct_connect_gateway_name"] = direct_connect_gateway_name
            __props__.__dict__["tags"] = tags
        super(Gateway, __self__).__init__(
            'volcengine:direct_connect/gateway:Gateway',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[str]] = None,
            direct_connect_gateway_name: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['GatewayTagArgs']]]]] = None) -> 'Gateway':
        """
        Get an existing Gateway resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: The description of direct connect gateway.
        :param pulumi.Input[str] direct_connect_gateway_name: The name of direct connect gateway.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['GatewayTagArgs']]]] tags: The direct connect gateway tags.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _GatewayState.__new__(_GatewayState)

        __props__.__dict__["description"] = description
        __props__.__dict__["direct_connect_gateway_name"] = direct_connect_gateway_name
        __props__.__dict__["tags"] = tags
        return Gateway(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        The description of direct connect gateway.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="directConnectGatewayName")
    def direct_connect_gateway_name(self) -> pulumi.Output[Optional[str]]:
        """
        The name of direct connect gateway.
        """
        return pulumi.get(self, "direct_connect_gateway_name")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['outputs.GatewayTag']]]:
        """
        The direct connect gateway tags.
        """
        return pulumi.get(self, "tags")

