# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GatewayRoutesResult',
    'AwaitableGatewayRoutesResult',
    'gateway_routes',
    'gateway_routes_output',
]

@pulumi.output_type
class GatewayRoutesResult:
    """
    A collection of values returned by GatewayRoutes.
    """
    def __init__(__self__, destination_cidr_block=None, direct_connect_gateway_id=None, direct_connect_gateway_routes=None, id=None, ids=None, next_hop_id=None, next_hop_type=None, output_file=None, route_type=None, total_count=None):
        if destination_cidr_block and not isinstance(destination_cidr_block, str):
            raise TypeError("Expected argument 'destination_cidr_block' to be a str")
        pulumi.set(__self__, "destination_cidr_block", destination_cidr_block)
        if direct_connect_gateway_id and not isinstance(direct_connect_gateway_id, str):
            raise TypeError("Expected argument 'direct_connect_gateway_id' to be a str")
        pulumi.set(__self__, "direct_connect_gateway_id", direct_connect_gateway_id)
        if direct_connect_gateway_routes and not isinstance(direct_connect_gateway_routes, list):
            raise TypeError("Expected argument 'direct_connect_gateway_routes' to be a list")
        pulumi.set(__self__, "direct_connect_gateway_routes", direct_connect_gateway_routes)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if next_hop_id and not isinstance(next_hop_id, str):
            raise TypeError("Expected argument 'next_hop_id' to be a str")
        pulumi.set(__self__, "next_hop_id", next_hop_id)
        if next_hop_type and not isinstance(next_hop_type, str):
            raise TypeError("Expected argument 'next_hop_type' to be a str")
        pulumi.set(__self__, "next_hop_type", next_hop_type)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if route_type and not isinstance(route_type, str):
            raise TypeError("Expected argument 'route_type' to be a str")
        pulumi.set(__self__, "route_type", route_type)
        if total_count and not isinstance(total_count, int):
            raise TypeError("Expected argument 'total_count' to be a int")
        pulumi.set(__self__, "total_count", total_count)

    @property
    @pulumi.getter(name="destinationCidrBlock")
    def destination_cidr_block(self) -> Optional[str]:
        """
        The cidr block.
        """
        return pulumi.get(self, "destination_cidr_block")

    @property
    @pulumi.getter(name="directConnectGatewayId")
    def direct_connect_gateway_id(self) -> Optional[str]:
        """
        The id of direct connect gateway.
        """
        return pulumi.get(self, "direct_connect_gateway_id")

    @property
    @pulumi.getter(name="directConnectGatewayRoutes")
    def direct_connect_gateway_routes(self) -> Sequence['outputs.GatewayRoutesDirectConnectGatewayRouteResult']:
        """
        The collection of query.
        """
        return pulumi.get(self, "direct_connect_gateway_routes")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def ids(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "ids")

    @property
    @pulumi.getter(name="nextHopId")
    def next_hop_id(self) -> Optional[str]:
        """
        The id of next hop.
        """
        return pulumi.get(self, "next_hop_id")

    @property
    @pulumi.getter(name="nextHopType")
    def next_hop_type(self) -> Optional[str]:
        """
        The type of next hop.
        """
        return pulumi.get(self, "next_hop_type")

    @property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[str]:
        return pulumi.get(self, "output_file")

    @property
    @pulumi.getter(name="routeType")
    def route_type(self) -> Optional[str]:
        """
        The type of route.
        """
        return pulumi.get(self, "route_type")

    @property
    @pulumi.getter(name="totalCount")
    def total_count(self) -> int:
        """
        The total count of query.
        """
        return pulumi.get(self, "total_count")


class AwaitableGatewayRoutesResult(GatewayRoutesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GatewayRoutesResult(
            destination_cidr_block=self.destination_cidr_block,
            direct_connect_gateway_id=self.direct_connect_gateway_id,
            direct_connect_gateway_routes=self.direct_connect_gateway_routes,
            id=self.id,
            ids=self.ids,
            next_hop_id=self.next_hop_id,
            next_hop_type=self.next_hop_type,
            output_file=self.output_file,
            route_type=self.route_type,
            total_count=self.total_count)


def gateway_routes(destination_cidr_block: Optional[str] = None,
                   direct_connect_gateway_id: Optional[str] = None,
                   ids: Optional[Sequence[str]] = None,
                   next_hop_id: Optional[str] = None,
                   next_hop_type: Optional[str] = None,
                   output_file: Optional[str] = None,
                   route_type: Optional[str] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGatewayRoutesResult:
    """
    Use this data source to query detailed information of direct connect gateway routes
    ## Example Usage

    ```python
    import pulumi
    import pulumi_volcengine as volcengine

    foo = volcengine.direct_connect.gateway_routes(ids=[
        "dcr-638ry33wmzggn3gd6gv****",
        "dcr-20d6tkadi2k8w65sqhgbj****",
    ])
    ```


    :param str destination_cidr_block: The cidr block.
    :param str direct_connect_gateway_id: The id of direct connect gateway.
    :param Sequence[str] ids: A list of IDs.
    :param str next_hop_id: The id of next hop.
    :param str next_hop_type: The type of next hop.
    :param str output_file: File name where to save data source results.
    :param str route_type: The type of route. The value can be BGP or CEN or Static.
    """
    __args__ = dict()
    __args__['destinationCidrBlock'] = destination_cidr_block
    __args__['directConnectGatewayId'] = direct_connect_gateway_id
    __args__['ids'] = ids
    __args__['nextHopId'] = next_hop_id
    __args__['nextHopType'] = next_hop_type
    __args__['outputFile'] = output_file
    __args__['routeType'] = route_type
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('volcengine:direct_connect/gatewayRoutes:GatewayRoutes', __args__, opts=opts, typ=GatewayRoutesResult).value

    return AwaitableGatewayRoutesResult(
        destination_cidr_block=pulumi.get(__ret__, 'destination_cidr_block'),
        direct_connect_gateway_id=pulumi.get(__ret__, 'direct_connect_gateway_id'),
        direct_connect_gateway_routes=pulumi.get(__ret__, 'direct_connect_gateway_routes'),
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        next_hop_id=pulumi.get(__ret__, 'next_hop_id'),
        next_hop_type=pulumi.get(__ret__, 'next_hop_type'),
        output_file=pulumi.get(__ret__, 'output_file'),
        route_type=pulumi.get(__ret__, 'route_type'),
        total_count=pulumi.get(__ret__, 'total_count'))


@_utilities.lift_output_func(gateway_routes)
def gateway_routes_output(destination_cidr_block: Optional[pulumi.Input[Optional[str]]] = None,
                          direct_connect_gateway_id: Optional[pulumi.Input[Optional[str]]] = None,
                          ids: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                          next_hop_id: Optional[pulumi.Input[Optional[str]]] = None,
                          next_hop_type: Optional[pulumi.Input[Optional[str]]] = None,
                          output_file: Optional[pulumi.Input[Optional[str]]] = None,
                          route_type: Optional[pulumi.Input[Optional[str]]] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GatewayRoutesResult]:
    """
    Use this data source to query detailed information of direct connect gateway routes
    ## Example Usage

    ```python
    import pulumi
    import pulumi_volcengine as volcengine

    foo = volcengine.direct_connect.gateway_routes(ids=[
        "dcr-638ry33wmzggn3gd6gv****",
        "dcr-20d6tkadi2k8w65sqhgbj****",
    ])
    ```


    :param str destination_cidr_block: The cidr block.
    :param str direct_connect_gateway_id: The id of direct connect gateway.
    :param Sequence[str] ids: A list of IDs.
    :param str next_hop_id: The id of next hop.
    :param str next_hop_type: The type of next hop.
    :param str output_file: File name where to save data source results.
    :param str route_type: The type of route. The value can be BGP or CEN or Static.
    """
    ...
