# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GatewaysResult',
    'AwaitableGatewaysResult',
    'gateways',
    'gateways_output',
]

@pulumi.output_type
class GatewaysResult:
    """
    A collection of values returned by Gateways.
    """
    def __init__(__self__, cen_id=None, direct_connect_gateway_name=None, direct_connect_gateways=None, id=None, ids=None, name_regex=None, output_file=None, tag_filters=None, total_count=None):
        if cen_id and not isinstance(cen_id, str):
            raise TypeError("Expected argument 'cen_id' to be a str")
        pulumi.set(__self__, "cen_id", cen_id)
        if direct_connect_gateway_name and not isinstance(direct_connect_gateway_name, str):
            raise TypeError("Expected argument 'direct_connect_gateway_name' to be a str")
        pulumi.set(__self__, "direct_connect_gateway_name", direct_connect_gateway_name)
        if direct_connect_gateways and not isinstance(direct_connect_gateways, list):
            raise TypeError("Expected argument 'direct_connect_gateways' to be a list")
        pulumi.set(__self__, "direct_connect_gateways", direct_connect_gateways)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if name_regex and not isinstance(name_regex, str):
            raise TypeError("Expected argument 'name_regex' to be a str")
        pulumi.set(__self__, "name_regex", name_regex)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if tag_filters and not isinstance(tag_filters, list):
            raise TypeError("Expected argument 'tag_filters' to be a list")
        pulumi.set(__self__, "tag_filters", tag_filters)
        if total_count and not isinstance(total_count, int):
            raise TypeError("Expected argument 'total_count' to be a int")
        pulumi.set(__self__, "total_count", total_count)

    @property
    @pulumi.getter(name="cenId")
    def cen_id(self) -> Optional[str]:
        """
        The cen ID.
        """
        return pulumi.get(self, "cen_id")

    @property
    @pulumi.getter(name="directConnectGatewayName")
    def direct_connect_gateway_name(self) -> Optional[str]:
        """
        The direct connect gateway name.
        """
        return pulumi.get(self, "direct_connect_gateway_name")

    @property
    @pulumi.getter(name="directConnectGateways")
    def direct_connect_gateways(self) -> Sequence['outputs.GatewaysDirectConnectGatewayResult']:
        """
        The collection of query.
        """
        return pulumi.get(self, "direct_connect_gateways")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def ids(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "ids")

    @property
    @pulumi.getter(name="nameRegex")
    def name_regex(self) -> Optional[str]:
        return pulumi.get(self, "name_regex")

    @property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[str]:
        return pulumi.get(self, "output_file")

    @property
    @pulumi.getter(name="tagFilters")
    def tag_filters(self) -> Optional[Sequence['outputs.GatewaysTagFilterResult']]:
        return pulumi.get(self, "tag_filters")

    @property
    @pulumi.getter(name="totalCount")
    def total_count(self) -> int:
        """
        The total count of query.
        """
        return pulumi.get(self, "total_count")


class AwaitableGatewaysResult(GatewaysResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GatewaysResult(
            cen_id=self.cen_id,
            direct_connect_gateway_name=self.direct_connect_gateway_name,
            direct_connect_gateways=self.direct_connect_gateways,
            id=self.id,
            ids=self.ids,
            name_regex=self.name_regex,
            output_file=self.output_file,
            tag_filters=self.tag_filters,
            total_count=self.total_count)


def gateways(cen_id: Optional[str] = None,
             direct_connect_gateway_name: Optional[str] = None,
             ids: Optional[Sequence[str]] = None,
             name_regex: Optional[str] = None,
             output_file: Optional[str] = None,
             tag_filters: Optional[Sequence[pulumi.InputType['GatewaysTagFilterArgs']]] = None,
             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGatewaysResult:
    """
    Use this data source to query detailed information of direct connect gateways
    ## Example Usage

    ```python
    import pulumi
    import pulumi_volcengine as volcengine

    foo = volcengine.direct_connect.gateways(direct_connect_gateway_name="tf-test")
    ```


    :param str cen_id: The CEN ID which direct connect gateway belongs.
    :param str direct_connect_gateway_name: The direst connect gateway name.
    :param Sequence[str] ids: A list of IDs.
    :param str name_regex: A Name Regex of Resource.
    :param str output_file: File name where to save data source results.
    :param Sequence[pulumi.InputType['GatewaysTagFilterArgs']] tag_filters: The filter tag of direct connect.
    """
    __args__ = dict()
    __args__['cenId'] = cen_id
    __args__['directConnectGatewayName'] = direct_connect_gateway_name
    __args__['ids'] = ids
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    __args__['tagFilters'] = tag_filters
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('volcengine:direct_connect/gateways:Gateways', __args__, opts=opts, typ=GatewaysResult).value

    return AwaitableGatewaysResult(
        cen_id=pulumi.get(__ret__, 'cen_id'),
        direct_connect_gateway_name=pulumi.get(__ret__, 'direct_connect_gateway_name'),
        direct_connect_gateways=pulumi.get(__ret__, 'direct_connect_gateways'),
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        name_regex=pulumi.get(__ret__, 'name_regex'),
        output_file=pulumi.get(__ret__, 'output_file'),
        tag_filters=pulumi.get(__ret__, 'tag_filters'),
        total_count=pulumi.get(__ret__, 'total_count'))


@_utilities.lift_output_func(gateways)
def gateways_output(cen_id: Optional[pulumi.Input[Optional[str]]] = None,
                    direct_connect_gateway_name: Optional[pulumi.Input[Optional[str]]] = None,
                    ids: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                    name_regex: Optional[pulumi.Input[Optional[str]]] = None,
                    output_file: Optional[pulumi.Input[Optional[str]]] = None,
                    tag_filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GatewaysTagFilterArgs']]]]] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GatewaysResult]:
    """
    Use this data source to query detailed information of direct connect gateways
    ## Example Usage

    ```python
    import pulumi
    import pulumi_volcengine as volcengine

    foo = volcengine.direct_connect.gateways(direct_connect_gateway_name="tf-test")
    ```


    :param str cen_id: The CEN ID which direct connect gateway belongs.
    :param str direct_connect_gateway_name: The direst connect gateway name.
    :param Sequence[str] ids: A list of IDs.
    :param str name_regex: A Name Regex of Resource.
    :param str output_file: File name where to save data source results.
    :param Sequence[pulumi.InputType['GatewaysTagFilterArgs']] tag_filters: The filter tag of direct connect.
    """
    ...
